; Sentinel NSLMS emulation library by MeteO
; contact address: meteo@null.net
;
;
include dllhdr.inc
include netinel.inc
;
DongleHdr struc
_type		dw	?
_flags		dw	?
_id		dd	?
_unique_id	dd	?
_memoffset	dd	?
_counter	dd	?
DongleHdr ends
;
;
DATASEG
@@szCrLf	db	0dh, 0ah,0
szName		db	'NSLms324: ',0
;
; set_info_key (short int handle, KEY_INFO_BLOCK far *info);
;----------------------------------------------------------------------
set_info_key proc
PUBLICDLL set_info_key
ARG handle:DWORD, info:DWORD
		push	offset szset_info_key
		call	DbgPrint

		xor	eax, eax
		ret
DATASEG
szset_info_key	db	'set_info_key',0
CODESEG
set_info_key endp
;
; short int far _cdecl _open_first_key (char dev_type, long dev_id);
;----------------------------------------------------------------------
open_first_key proc
PUBLICDLL open_first_key
ARG dev_type:BYTE, dev_id:WORD
USES edi, ebx, ecx, esi
IFDEF DEBUG
int 3
ENDIF
		mov	ax, dev_id
		lea	edi, patch_devid
		call	Hex2Ascii

		push	offset szopen_first_key
		call	DbgPrint

		movzx	ax, dev_id
		lea	ebx, (dongleMemory-size DongleHdr)
		mov	ecx, t_Total
	@@1:				; Find dongle loop
		add	ebx, size DongleHdr
		cmp	[ebx.DongleHdr._id], eax
		je	@@found
		loop	@@1
		or	ecx, ecx
		je	@@failed	; No such key
		
	@@found:	
		mov	eax, [ebx.DongleHdr._counter] ; Get actual dongleID

		ret
		

	@@failed:
		mov	eax, CL_NO_MORE_KEYS
		ret
DATASEG
szopen_first_key	db	'open_first_key, DevID: 0000'
patch_devid	equ	$-4
			db	0
CODESEG
open_first_key endp
;
;short int far _cdecl _open_next_key (short int handle);
;----------------------------------------------------------------------
open_next_key proc
PUBLICDLL open_next_key
ARG handle:WORD
		push	offset szopen_next_key
		call	DbgPrint

		mov	eax, 05030h	; next handle
		ret
DATASEG
szopen_next_key	db	'open_next_key',0
CODESEG
open_next_key endp
;
;short int far _cdecl
;_query_key (short int handle, QUERY_DATA far *data);
;----------------------------------------------------------------------
query_key proc
PUBLICDLL query_key
ARG handle:WORD, query_data:DWORD
USES esi, edi, ebx, ecx

		mov	esi, query_data
		mov	ax, [esi.QUERY_DATA.qData.CELL_ADDRESS]
		and	eax, 0ffffh	; clr
		push	eax
		lea	edi, patch_cell
		call	Hex2Ascii

		push	offset szquery_key
		call	DbgPrint
IFDEF DEBUG
int 3
ENDIF

		movzx	eax, handle	; Fake handle

		lea	ebx, (dongleMemory-size DongleHdr)
		mov	ecx, t_Total
	@@loop:						; Find dongle loop
		add	ebx, size DongleHdr
		cmp	[ebx.DongleHdr._counter], eax
		je	@@founded

		loop	@@loop
		or	ecx, ecx
		jz	@@fail
	@@founded:
		mov	ebx, [ebx.DongleHdr._memoffset]
		pop	eax		; Cell address
		mov	ax, [ebx][eax*2]
		mov	[esi.QUERY_DATA.qData.CELL_DATA], ax

		xor	eax, eax
		ret
	@@fail:
		mov	eax, CL_NO_MORE_KEYS			
		ret
DATASEG
szquery_key	db	'query_key, cell: 0000'
patch_cell	equ	$-4
		db	0
CODESEG
query_key endp
;
;----------------------------------------------------------------------
close_key proc
PUBLICDLL close_key
ARG handle:WORD

		push	offset szclose_key
		call	DbgPrint


		xor	eax, eax
		ret
DATASEG
szclose_key	db	'close_key',0
CODESEG
close_key endp
;
;----------------------------------------------------------------------
set_rnbo_lib_parameters proc
PUBLICDLL set_rnbo_lib_parameters
ARG params:DWORD

		push	offset szset_rnbo_lib_parameters
		call	DbgPrint


		xor	eax, eax
		ret
DATASEG
szset_rnbo_lib_parameters	db	'set_rnbo_lib_parameters',0
CODESEG
set_rnbo_lib_parameters endp
;
;----------------------------------------------------------------------
lock_key proc
PUBLICDLL lock_key
		push	offset szlock_key
		call	DbgPrint


		xor	eax, eax
		ret
DATASEG
szlock_key	db	'lock_key',0
CODESEG
lock_key endp
;
;----------------------------------------------------------------------
unlock_key proc
PUBLICDLL unlock_key
		push	offset szunlock_key
		call	DbgPrint


		xor	eax, eax
		ret
DATASEG
szunlock_key	db	'unlock_key',0
CODESEG
unlock_key endp
;
;----------------------------------------------------------------------
cancel_lock_key proc
PUBLICDLL cancel_lock_key
		push	offset szcancel_lock_key
		call	DbgPrint


		xor	eax, eax
		ret
DATASEG
szcancel_lock_key	db	'cancel_lock_key',0
CODESEG
cancel_lock_key endp
;
;----------------------------------------------------------------------
get_info_key proc
PUBLICDLL get_info_key
		push	offset szget_info_key
		call	DbgPrint


		xor	eax, eax
		ret
DATASEG
szget_info_key	db	'get_info_key',0
CODESEG
get_info_key endp
;
;----------------------------------------------------------------------
;
nbLibVersion proc
PUBLICDLL nbLibVersion
		push	offset sznbLibVersion
		call	DbgPrint


		xor	eax, eax
		ret
DATASEG
sznbLibVersion	db	'nbLibVersion',0
CODESEG
nbLibVersion endp
;
;----------------------------------------------------------------------
MonitorFunction proc
PUBLICDLL MonitorFunction
		push	offset szMonitorFunction
		call	DbgPrint


		xor	eax, eax
		ret
DATASEG
szMonitorFunction               db	'MonitorFunction',0
CODESEG
MonitorFunction endp

;
;----------------------------------------------------------------------
set_blocking_mode proc
PUBLICDLL set_blocking_mode
		push	offset szset_blocking_mode
		call	DbgPrint


		xor	eax, eax
		ret
DATASEG
szset_blocking_mode	db	'set_blocking_mode',0
CODESEG
set_blocking_mode endp
;
;----------------------------------------------------------------------
detach_from_dll proc
PUBLICDLL detach_from_dll
		push	offset szdetach_from_dll
		call	DbgPrint


		xor	eax, eax
		ret
DATASEG
szdetach_from_dll	db	'detach_from_dll',0
CODESEG
detach_from_dll endp
;
;----------------------------------------------------------------------
set_rnbo_windows_parms proc
PUBLICDLL set_rnbo_windows_parms
		push	offset szset_rnbo_windows_parms
		call	DbgPrint


		xor	eax, eax
		ret
DATASEG
szset_rnbo_windows_parms	db	'set_rnbo_windows_parms',0
CODESEG
set_rnbo_windows_parms endp
;
;----------------------------------------------------------------------
get_statistics proc
PUBLICDLL get_statistics
		push	offset szget_statistics
		call	DbgPrint


		xor	eax, eax
		ret
DATASEG
szget_statistics	db	'get_statistics',0
CODESEG
get_statistics endp
;
;----------------------------------------------------------------------
detach_from_dll_II proc
PUBLICDLL detach_from_dll_II
		push	offset szdetach_from_dll_II
		call	DbgPrint


		xor	eax, eax
		ret
DATASEG
szdetach_from_dll_II	db	'detach_from_dll_II',0
CODESEG
detach_from_dll_II endp
; short int access_sub_licence (short int handle, ASL_PARAMS *params, ASL_RESPONCE *responce)
;----------------------------------------------------------------------
access_sub_license proc
PUBLICDLL access_sub_license
ARG handle:WORD, params:DWORD, responce:DWORD
USES esi,edi,ebx,ecx
IFDEF DEBUG
int 3
ENDIF
		mov	esi, params
		mov	ebx, responce
		mov	ax, [esi.ASL_PARAMS.asl_sublicense]
		and	eax, 0ffffh	; clr

		lea	edi, patch_access_sub_license0001
		call	Hex2Ascii

		mov	ax, [esi.ASL_PARAMS.asl_command]
		cmp	ax, ASL_OPEN
		je	@@ASL_OPEN
		cmp	ax, ASL_GET_INFO
		je	@@ASL_INFO
		cmp	ax, ASL_CLOSE
		je	@@ASL_CLOSE
		

	@@ASL_OPEN:
		mov	dword ptr patch_access_sub_license0000, 'NEPO'	; OPEN
		jmp	@@done

	@@ASL_INFO:
IFDEF DEBUG
int 3
ENDIF

		mov	dword ptr patch_access_sub_license0000, 'OFNI'	; INFO
		mov	ax, [esi.ASL_PARAMS.asl_sublicense]		

		mov	[ebx.ASL_RESPONSE.asr_sublicense], ax
		mov	[ebx.ASL_RESPONSE.asr_present_total], 087h
		mov	[ebx.ASL_RESPONSE.asr_present_inuse_by_all], 1
		mov	[ebx.ASL_RESPONSE.asr_present_inuse_by_you], 1
		mov	[ebx.ASL_RESPONSE.asr_missing_inuse_by_all], 013a6h
		mov	[ebx.ASL_RESPONSE.asr_missing_inuse_by_you], 088h
		

		jmp	@@done

	@@ASL_CLOSE:
		mov	dword ptr patch_access_sub_license0000, 'ESLC'	; CLOSE


	@@done:

		push	offset szaccess_sub_license
		call	DbgPrint

		xor	eax, eax
		ret
DATASEG
szaccess_sub_license	db	'access_sub_license: xxxx'
	patch_access_sub_license0000	equ	$-4
		db	' : 0000'
	patch_access_sub_license0001	equ	$-4
		db	0
CODESEG
access_sub_license endp
;
;----------------------------------------------------------------------
get_server_info proc
PUBLICDLL get_server_info
		push	offset szget_server_info
		call	DbgPrint


		xor	eax, eax
		ret
DATASEG
szget_server_info	db	'get_server_info',0
CODESEG
get_server_info endp
;
;----------------------------------------------------------------------
ns_nk proc
PUBLICDLL ns_nk
		push	offset szns_nk
		call	DbgPrint


		xor	eax, eax
		ret
DATASEG
szns_nk	db	'ns_nk',0
CODESEG
ns_nk endp
;
;----------------------------------------------------------------------
kill_server proc
PUBLICDLL kill_server
		push	offset szkill_server
		call	DbgPrint


		xor	eax, eax
		ret
DATASEG
szkill_server	db	'kill_server',0
CODESEG
kill_server endp

;
;----------------------------------------------------------------------
get_rnbo_lib_parameters proc
PUBLICDLL get_rnbo_lib_parameters
		push	offset szget_rnbo_lib_parameters
		call	DbgPrint


		xor	eax, eax
		ret
DATASEG
szget_rnbo_lib_parameters	db	'get_rnbo_lib_parameters',0
CODESEG
get_rnbo_lib_parameters endp
;
;----------------------------------------------------------------------
;
Hex2Ascii:
		push	cx
		mov	cx,0404h;For AF clear can use   "mov  CX,0504"
			     	;Clear AF		"dec  CH"
	$$c:    rol	ax, cl	;Doesnt change AF
		push	ax
        	mov	ah, 30h
        	and	al, 0fh	;For 0Fxh case,   AH ਡ  1
        	aaa
		db	0d5h, 11h
		stosb
        	pop	ax
		dec	ch	;clear AF
		jnz	$$c
		pop	cx
	ret
;
;----------------------------------------------------------------------
;
DATASEG
dongleMemory	label	word
;RB_DONGLE_HEADER               type, flags, id, unique_id, size
dongleHdr_6BF7	DongleHdr	<3, 0, 06BF7h, 040FAh, offset mem_6BF7, 0136h>
dongleHdr_C7ED	DongleHdr	<3, 0, 0c7edh, 040FAh, offset mem_C7ED, 0137h>
t_Total		equ	($-dongleMemory)/size DongleHdr

;
;RB_SP_DONGLE ShipConstructor Local
mem_6BF7	label	word
;			0      1      2	     3      4	   5	  6		7
		dw	040FAh,06bf7h,0FFFFh,0FFFFh,0FFFFh,0FFFFh,0FFFFh,0FFFFh
;
		dw	00008h,0fff2h,00023h xor 0ffffh,0000bh,0000ch,0000dh,0000eh,0000fh
		dw	00010h,00011h,00012h,00013h,00014h,00015h,00016h,00017h
		dw	00018h,00019h,0001ah,0001bh,0001ch,0001dh,0001eh,0001fh
		dw	00020h,00023h,00022h,00023h,00024h,00025h,00026h,00027h
		dw	00028h,00029h,0002ah,0002bh,0002ch,0002dh,0002eh,00941h xor 0ffffh

		db	'(' xor 0ffh
		db	'x' xor 0ffh
		db	')' xor 0ffh
		db	' ' xor 0ffh
		db	'M' xor 0ffh
		db	'e' xor 0ffh
		db	't' xor 0ffh
		db	'e' xor 0ffh
		db	'O' xor 0ffh
		db	' ' xor 0ffh
		db	'/' xor 0ffh
		db	'/' xor 0ffh
		db	'U' xor 0ffh
		db	'C' xor 0ffh
		db	'L' xor 0ffh
		db	'a' xor 0ffh
		db	'b' xor 0ffh
		db	's' xor 0ffh

		dw	00039h,0003ah,0003bh,0003ch,0003dh,0003eh,0003fh
		db	000h,000h,000h,000h,000h,000h,000h,000h
		db	000h,000h,000h,000h,000h,000h,000h,000h
		db	000h,000h,000h,000h,000h,000h,000h,000h
		db	000h,000h,000h,000h,000h,000h,000h,000h
		db	000h,000h,000h,000h,000h,000h,000h,000h
		db	000h,000h,000h,000h,000h,000h,000h,000h
		db	000h,000h,000h,000h,000h,000h,000h,000h
		db	000h,000h,000h,000h,000h,000h,000h,000h
		dd	0

;RB_SP_DONGLE ShipConstructor Net
mem_C7ED	label	word
comment #
dw	00008h,00009h,0000ah,0000bh,0000ch,0000dh,0000eh,0000fh
dw	00010h,00011h,00012h,00013h,00014h,00015h,00016h,00017h
dw	00018h,00019h,0001ah,0001bh,0001ch,0001dh,0001eh,0001fh
dw	00020h,00023h,00022h,00023h,00024h,00025h,00026h,0ffffh
#

;			0      1      2	     3      4	   5	  6	 7
		dw	0ffffh,0ffffh,0ffffh,0ffffh,0ffffh,0ffffh,0ffffh,0ffffh
		dw	0ffffh,0ffffh,0ffffh,0ffffh,0ffffh,0ffffh,0ffffh,0ffffh		
		dw	0ffffh,0ffffh,0ffffh,0ffffh,0ffffh,0ffffh,0ffffh,0ffffh		
		dw	0ffffh,0ffffh,0ffffh,0ffffh,0ffffh,0ffffh,0ffffh,0ffffh		
		dw	0ffffh,0ffffh,0ffffh,0ffffh,0ffffh,0ffffh,0ffffh,0ffffh	
		dw	0ffffh,0ffffh
 		db	'MeteO //UCLabs'                                ; CRC
		dw	       00000h,0003ah,0003bh,0003ch,0003dh,0ffffh,0a2a3h ; 
		dw	00040h,00041h,00042h,00043h,00044h,00045h,00046h,00047h	; 40-47
		dw	00048h,00049h,0004ah,0004bh,0004ch,0004dh,0004eh,0004fh	; 48-4F
		dw	00050h,00051h,00052h,00053h,00054h,00055h,00056h,00057h	; 40-47
		dw	00058h,00059h,0005ah,0005bh,0005ch,0005dh,0005eh,0005fh	; 48-4F


comment #
dw	00000h,00001h,00002h,00003h,00004h,00005h,00006h,00007h	; 00-07
dw	00008h,0CECAh,0C9CEh,0ffffh,0ffffh,0ffffh,0ffffh,0ffffh	; 08-0F
dw	0ffffh,0ffffh,0ffffh,0ffffh,0ffffh,0ffffh,0ffffh,00000h	; 10-17
dw	0ffffh,0ffffh,0ffffh,0ffffh,00000h,0ffffh,0ffffh,0ffffh	; 18-1F
dw	0ffffh,0ffffh,0ffffh,0ffffh,0ffffh,0ffffh,0ffffh,0ffffh	; 20-27
dw	0ffffh,0ffffh,0ffffh,0ffffh,0ffffh,0ffffh,0ffffh,0ffffh	; 28-2F
dw	0ffffh,0ffffh,0ffffh,0ffffh,0ffffh,0ffffh,0ffffh,0ffffh	; 30-37
dw	00038h,00039h,0003ah,0003bh,0003ch,0003dh,0003eh,0003fh	; 38-3F
dw	00040h,00041h,00042h,00043h,00044h,00045h,00046h,00047h	; 40-47
dw	00048h,00049h,0004ah,0004bh,0004ch,0004dh,0004eh,0004fh	; 48-4F
;
query_answer	label word
	db	'LEN64'	; 10..12
	db	012h
	dw	1313h	;
	dw	1414h	;
	db	007h,000h	; 15
	dw	000h,000h	; 16
	db	3eh*2 dup (-1)
;
#
END LibMain

