; SKEYEM VERSION 1.0
; EUTRON SMARKEY NET SKEYLINK.DLL EMU!
; Specific target: Virtual Radio V4.61
; COMPILE WITH MASM32 /c /coff options

.386
.model flat, stdcall

code            segment use32 at 0
                assume cs:code  , ds:code


                org     1000h

.code

                public start
start           proc    near

        mov     eax, 1
        mov     [ebp+0Ch], eax
        retn    0Ch

start           endp


                public SMARTLINK
SMARTLINK       proc near

        push    esi

        mov     esi, dword ptr [esp+08]
        mov     dx, word ptr [esi]

        cmp     dx, 004Fh                               ; Open Net Command      == " O "
        je      OpenMode
AfterOpen:
        cmp     dx, 0043h                               ; Close Net Command     == " C "
        je      CloseMode
AfterClose:
        cmp     dx, 0041h                               ; Access Dongle Command == " A "
        je      AccessMode
OtherMode:

        xor     eax, eax

AllDone:

        pop     esi
        retn    4

; ------------------[NEW FUNCTION]------------------

OpenMode:
        ; ################################################################################################
        ; The OPEN mode is used by the user to activate communication (LOGIN request) with SmartKey.
        ; The OPEN command must be given before any access operation to the memory of the protection
        ; device and possibly upon startup of the protected application..
        ; The OPEN command 6 generates a special password called NET-Password, to be used in
        ; subsequent commands (ACCESS, CLOSE). This is a further increment of protection procedures
        ; aimed at avoiding possible attempts at breaching the interrogation procedure of the network
        ; protection device.
        ;
        ; The logic sequence of key interrogation is the following:
        ;    OUTPUT Open Net Command    :       Cmd (" O ")
        ;    OUTPUT Label               :       Label (16 bytes)
        ;    OUTPUT Password            :       Password (16 bytes)
        ;    INPUT Status               :       Status
        ;    INPUT Net Password         :       NET-Password (4 bytes)
        ;
        ; The status indicates whether the operation was successful and has the following meanings:
        ;     0 = Successful operation.
        ;    -1 = No key with the defined label is present.
        ;    -2 = Syntax Error.
        ;    -4 = Wrong Data or Password.
        ;    -5 = Problems connected with the network (check the installation procedure)
        ;    -8 = Problems connected with the network (check the installation procedure)
        ;   -10 = The NSKEYSRV.NLM (Novell Netware) has not been loaded.
        ;   -11 = Insufficient memory on client.
        ;   -12 = Syntax error in the path string or SKEYSRV.EXE (ANP) not activated.
        ;   -13 = SKEYTSR.EXE not installed.
        ;   -14 = More than 4 different applications running in a multitasking environment (e.g. Windows)
        ;         open a communication with SmartKey at the same time
        ;   -16 = Maximum number of executions already reached
        ; ################################################################################################

        xor     eax, eax                                ; return 0 = Successful operation
        jmp     AllDone                                 ; All done, back to caller...

; ------------------[NEW FUNCTION]------------------

AccessMode:
        ; ################################################################################################
        ; The ACCESS mode allows actual access to the protection device, selected via the label which
        ; must always be passed before effecting any standard interrogation operation with the protection
        ; device. This mode requires the NET-Password which identifies the client who requests access and
        ; the label which identifies the protection device to which access is requested.
        ;
        ; The ACCESS mode allows one to implement a set of sub-commands:
        ;
        ;  NET subcommand identifier (2 bytes hex)
        ;    53 00 = SCRAMBLING mode    ( ASCII "S"  )
        ;    52 00 = READING mode       ( ASCII "R"  )
        ;    52 42 = BLOCK READING mode ( ASCII "BR" )
        ;    57 00 = WRITING mode       ( ASCII "W"  )
        ;    52 42 = BLOCK WRITING mode ( ASCII "BW" )
        ;    45 00 = ENCRYPTING mode    ( ASCII "E"  )
        ;    4D 00 = MODEL READ. mode   ( ASCII "M"  )
        ;    55 00 = USERS' number mode ( ASCII "U"  )
        ;
        ; E.g., when SCRAMBLING, the protection device interrogation logic is the following:
        ;    OUTPUT Access Net Command  :       Cmd (" A ")
        ;    OUTPUT Label               :       Label (16 bytes)
        ;    OUTPUT Net Password        :       NET-Password (4 bytes)
        ;    OUTPUT Scrambling Command  :       Cmd (" S ")
        ;    OUTPUT Original Data       :       Data (8 bytes)
        ;    INPUT Scrambled Data       :       Data (8 bytes)
        ;    INPUT Status               :       Status
        ;
        ; The status indicates whether the operation was successful and has the following meanings:
        ;     0 = Successful operation.
        ;    -1 = No key with the defined label is present.
        ;    -2 = Syntax Error.
        ;    -4 = No key with the defined label is present.
        ;    -5 = Problems connected with the network (check the installation procedure)
        ;    -7 = Access error to the protection device without a prior OPEN command..
        ;    -9 = NET-Password error during remote access
        ;   -10 = NSKEYSRV.NLM (Novell Netware) has not been loaded.
        ;   -12 = Syntax error in the path string or SKEYSRV.EXE (ANP) not activated.
        ;   -15 = NET-Password invalid.
        ;   -20 = Write operation not effected.
        ; ################################################################################################

scramble_mode:

        push    edx
        push    ecx
        push    edi
        push    esi

        mov     eax, dword ptr [esi+2Ah]                ; Original Data Input
        mov     edi, esi
        add     edi, 2Ah                                ; Scrambled Data Return Address
        mov     ecx, 08h                                ; Scrambled Data Byte Length 8

        mov     edx, dword ptr [_dongle_request1]       ; Sniffed Original Data
        cmp     eax, edx
        je      do_dongle_response1
        mov     edx, dword ptr [_dongle_request2]       ; Sniffed Original Data
        cmp     eax, edx
        je      do_dongle_response2
        mov     edx, dword ptr [_dongle_request3]       ; Sniffed Original Data
        cmp     eax, edx
        je      do_dongle_response3
        jmp     return_from_access_mode

    ; --- INSERT SNIFFED DONGLE DATA HERE ---

_dongle_response1:
        db      0D0h, 0DAh, 072h, 0D2h                  ; Scrambled Data "@BDFHJLN"
        db      0EDh, 099h, 0C2h, 083h                  ; Sniffed from Mot32A.exe
        db      000h, 000h, 000h, 000h
_dongle_request1:
        db      '@BDFHJLN',0,0,0,0                      ; Original Data "@BDFHJLN"
_dongle_response2:
        db      0DDh, 0E8h, 0ECh, 020h                  ; Scrambled Data "9:;<=>?."
        db      077h, 0FCh, 04Ah, 035h                  ; Sniffed from Mot32A.exe
        db      000h, 000h, 000h, 000h
_dongle_request2:
        db      '9:;<=>?.',0,0,0,0                      ; Original Data "9:;<=>?."
_dongle_response3:
        db      0A6h, 087h, 019h, 0EDh                  ; Scrambled Data "12345678"
        db      0F1h, 088h, 035h, 0E5h                  ; Sniffed from Mot32A.exe
        db      000h, 000h, 000h, 000h
_dongle_request3:
        db      '12345678',0,0,0,0                      ; Original Data "12345678"


do_dongle_response1:
        lea     esi, [_dongle_response1]
        jmp     return_response
do_dongle_response2:
        lea     esi, [_dongle_response2]
        jmp     return_response
do_dongle_response3:
        lea     esi, [_dongle_response3]
return_response:
        rep     movsb

return_from_access_mode:

        pop     esi
        pop     edi
        pop     ecx
        pop     edx

        xor     eax, eax                                ; return 0 = Successful operation
        jmp     AllDone                                 ; All done, back to caller...

; ------------------[NEW FUNCTION]------------------

CloseMode:
        ; ################################################################################################
        ; The CLOSE mode enables 'closing' (LOGOUT request) of communication with SmartKey of the program
        ; connected via an earlier OPEN command. If owing to an error in the application software the
        ; program should terminate without first carrying out CLOSE of the open protection device,
        ; problems with the client's timeout management may occur and may at time involve rebooting.
        ; It is essential to carry out the login and logout procedures carefully to avoid uselessly
        ; inhibiting other users from using the key.
        ;
        ;    OUTPUT Close Net Command   :       Cmd (" C ")
        ;    OUTPUT Label               :       Label (16 bytes)
        ;    OUTPUT Net Password        :       NET-Password (4 bytes)
        ;    INPUT Status               :       Status
        ;
        ; The status indicates whether the operation was successful and has the following meanings:
        ;     0 = Successful operation.
        ;    -2 = Syntax Error.
        ;    -5 = Problems connected with the network.
        ;    -6 = Attempt to CLOSE without a prior OPEN command
        ;    -9 = NET-Password error during remote access.
        ;   -10 = NSKEYSRV.NLM (Novell Netware) has not been loaded
        ;   -12 = Syntax error in the path string or SKEYSRV.EXE (ANP) not activated
        ;   -15 = NET-Password invalid.
        ; ################################################################################################

        xor     eax, eax                                ; return 0 = Successful operation
        jmp     AllDone                                 ; All done, back to caller...

SMARTLINK       endp

end     start
