#include<stdio.h>
#include<ctype.h>
#include<stdlib.h>
/* from lm_code.h */
typedef struct mvendorcode4 {
			    unsigned long  type;	   /* Type of structure */
			    unsigned long data[2]; /* 64-bit code */
			    unsigned long keys[4]; /*- [0]: Product features */
					   	   /*- [1]: platforms */
					   	   /*- [2]: platforms */
					   	   /*- [3]: Expiration date/ */
						   /*-      Key check */
			    short flexlm_version;
			    short flexlm_revision;
			  } MVENDORCODE4;

unsigned long nbl_svk(char *instr, MVENDORCODE4 *inv);
unsigned long getattr_init(char *instr, MVENDORCODE4 *inv);
unsigned long glkey[4]; /* output of nbl_key */
unsigned long *nbl_key(char *instr, unsigned long *inv);
unsigned long nbl_br(unsigned long inval);
unsigned long nbl_icf(unsigned long inval);
unsigned long rl_icf(unsigned long inval);
unsigned long nbl_c(unsigned long *inval);
unsigned long nbl_rev(char *instr,unsigned long *decvals, unsigned long *okeys);
unsigned long nbl_validate_vendor(char *instr, unsigned long *inv);
int nbl_interpret_decvals(unsigned long *decvals);
int nbl_read_date (char *inday, unsigned long *outtime);
int nb_nzsum(char *instr, unsigned long *outval);
int z_init(char *instr, unsigned long *outval);
int fix_checksum(unsigned long *inarr);

void nbl_mtuc(char *instr);
void nbl_mtlc(char *instr);


unsigned long glseed; /* Global state of decoding */

char *montharr[12] = {"JAN", "FEB", "MAR", "APR", "MAY", "JUN",
                      "JUL", "AUG", "SEP", "OCT", "NOV", "DEC"}; 
int daysinmonth[12] = {31, 28, 31, 30, 31, 30,
                        31, 31, 30, 31, 30, 31};
int daysleapmonth[12] = {31, 29, 31, 30, 31, 30,
                        31, 31, 30, 31, 30, 31};

void main(int argc, char *argv)
{
	int i;
	int curver;
	int rcode;

	char myvname[1024];
	char rstr[1024];

	unsigned long *decvals;
	unsigned long decval1[4];
	unsigned long tmpdata1;
	unsigned long tmpdata2;
	unsigned long okeys[5]; /* where output keys go */
	unsigned long ndate;

	MVENDORCODE4 tstvendor;

	printf ("lmrecode 1.2: analyse/recode vendor data for lm_code.h file\n");
	printf ("Takes data from vendorcode4 and creates keys for use in lm_code.h file.\n");
	printf ("UI sucks, so enter everything correctly.\n");
	printf ("Y to enter VENDORCODE data, N to just generate keys.\n");
	scanf("%s", rstr);
	if (rstr[0] == 'y' || rstr[0] == 'Y') {
		printf ("data[0] (really ENCRYPTION_SEED1 ^ VENDOR_CODE5) in hex:\n");
		if (scanf("%08x", &tmpdata1) != 1) {
			fprintf (stderr, "Bad read of data[0].\n");
			exit(1);
		}
		printf ("data[1] (really ENCRYPTION_SEED2 ^ VENDOR_CODE5) in hex:\n");
		if (scanf("%08x", &tmpdata2) != 1) {
			fprintf (stderr, "Bad read of data[1].\n");
			exit(1);
		}
		printf ("keys[0] in hex:\n");
		if (scanf("%08x", &(tstvendor.keys[0])) != 1) {
			fprintf (stderr, "Bad read of keys[0].\n");
			exit(1);
		}
		printf ("keys[1] in hex:\n");
		if (scanf("%08x", &(tstvendor.keys[1])) != 1) {
			fprintf (stderr, "Bad read of keys[1].\n");
			exit(1);
		}
		printf ("keys[2] in hex:\n");
		if (scanf("%08x", &(tstvendor.keys[2])) != 1) {
			fprintf (stderr, "Bad read of keys[2].\n");
			exit(1);
		}
		printf ("keys[3] in hex:\n");
		if (scanf("%08x", &(tstvendor.keys[3])) != 1) {
			fprintf (stderr, "Bad read of keys[3].\n");
			exit(1);
		}
		printf ("Input vendor name (Actually daemon name):\n");
		if (scanf("%s", myvname) != 1) {
			fprintf (stderr, "Bad read of vendor name.\n");
			exit(1);
		}
		printf ("Version of input data (3, 4, 5, 6, or 7):\n");
		if (scanf("%08x", &(curver)) != 1) {
			fprintf (stderr, "Bad read of structure version.\n");
			exit(1);
		}
		/* Global glseed set, - should be passed as param, but this is a define in 
		 * the official sdk
		 */
		switch(curver) {
			/* 3 and 4 use same seed */
		case(3):
		case(4):
			glseed = 0xcf53fa74;
			break;
		case(5): /* version 5, 5.12 */
			glseed = 0x58A340F2;
			break;
		case(6): /* version 6.0, 6.1 */
			glseed = 0x1504C935;
			break;
		case(7): /* version 7.0 */
			glseed = 0x788f71d2;
			break;
		default:
			printf ("Unknown version.\n");
			exit(1);
		}
		/* Verification that key extraction was indeed correct */
		if ((rcode = nbl_validate_vendor(myvname,tstvendor.keys)) != 0) {
			printf ("******* WARNING ******** Input data failed checksum test.\n");
			printf ("Either you've got the wrong version, or your data is no good.\n");
		}
		decvals = nbl_key(myvname, tstvendor.keys);
		for (i = 0; i < 4; i++) {
			printf ("Input decvals[%d] = %08x\n", i, decvals[i]);
			decval1[i] = decvals[i];
		}
		/* Decoded values were OK, tell info to user */
		if (rcode == 0) {
			nbl_interpret_decvals(decvals);
		}
		/* Derive valid keys from the decoded structure and vendor name */
		nbl_rev(myvname,decvals, okeys);
		printf ("Encryption seed1: %08x\n", tmpdata1 ^ okeys[4]);
		printf ("Encryption seed2: %08x\n", tmpdata2 ^ okeys[4]);
		/* Show user values */
		for (i = 0; i < 5; i++) {
			printf ("VENDOR_KEY%d 0x%08x\n", i+1, okeys[i]);
		}
	}
	else {
		/* "Default" enabling keys for flexLM incase we don't have a license already */
		decval1[0] = 0xbffffffe;
		decval1[1] = 0xffffffe2;
		decval1[2] = 0xffffffff;
		decval1[3] = 0x03eea001;
	}
	/* Expiration date code if desired */
	printf ("Y to enter date info, N to just generate keys.\n");
	scanf("%s", rstr);
	if (rstr[0] == 'y' || rstr[0] == 'Y') {
		printf ("Enter new expiry date:\n");
		fflush(stdin);
		if (scanf("%s", rstr) == 1) {
			if (nbl_read_date (rstr, &ndate) < 0) {
				printf ("Couldn't interpret date.\n");
			}
			else {
				/* Have to fix cksum if structure has changed. */
				decval1[3] = ndate;
				fix_checksum(decval1);
				printf ("Reset date.\n");
			}
			nbl_interpret_decvals(decval1);
		}
		else {
			printf ("Bad read of date.\n");
		}
	}


	printf ("Output vendor name (Actually daemon name):\n");
	if (scanf("%s", myvname) != 1) {
		fprintf (stderr, "Bad read of vendor name.\n");
		exit(1);
	}
	printf ("Version of output data (3, 4, 5, 6, or 7):\n");
	if (scanf("%08x", &(curver)) != 1) {
		fprintf (stderr, "Bad read of structure version.\n");
		exit(1);
	}

	switch(curver) {
	case(3):
	case(4):
		glseed = 0xcf53fa74;
		break;
	case(5): /* version 5, 5.12 */
		glseed = 0x58A340F2;
		break;
	case(6): /* version 6.0, 6.1 */
		glseed = 0x1504C935;
		break;
	case(7): /* version 7.0 */
		glseed = 0x788f71d2;
		break;
	default:
		printf ("Unknown version.\n");
		exit(1);
	}
	/* Convert the structure to vendorcode, and send to output */
	nbl_rev(myvname,decval1, okeys);
	for (i = 0; i < 5; i++) {
		printf ("VENDOR_KEY%d 0x%08x\n", i+1, okeys[i]);
	}
	exit(0);

}
/*--------------------------------------------------------*
 *
 * testbytes
 *
 * this isn't used, but contains a partial reversing of the
 * validation code for the vendor keys.   The multiple tests
 * are for checking whether certain features and platforms
 * are enabled. I haven't determined exactly which bits
 * do what though, but for our purposes this isn't 
 * required.
 * instr(input) vendor name
 * inv(input) pointer to array of decoded vendor keys.
 *--------------------------------------------------------*/
unsigned long testbytes(char *instr, unsigned long *inv)
{
	unsigned long tmpval0;
	unsigned long tmpval1;
	long tmpval2;
	long tmpval3;
	unsigned long tmpval4;
	unsigned long tmpval5;
	unsigned long tmpval6;
	unsigned long tmpval7;
	unsigned long *outkeys;
	int i;
	outkeys = nbl_key(instr, inv);
	for (i = 0; i < 4; i++) {
		printf ("outkeys[%d] = %08x\n", i, outkeys[i]);
	}
	tmpval0 = 0xa3ef0000;
	tmpval1 = outkeys[3] ^ tmpval0;
	printf ("tmpval1: %08x\n", tmpval1);
	tmpval2 = (tmpval1 >> 16) & 0x0000FFFF; /* low bytes? XXXX */
	tmpval3 = outkeys[3] & 0x0000FFFF;
	tmpval2 = tmpval3 - tmpval2;
	tmpval4 = outkeys[1] & 0x0000007f;
	tmpval5 = outkeys[1] & 0xffffff80;
	outkeys[1] = tmpval5;
	if (tmpval2 != 0) {
		printf ("Bad tmpval2.\n");
	}
	tmpval6 = nbl_c(outkeys);
	printf("tmpval6: %08x\n", tmpval6);
	if (tmpval6 != tmpval4) {
		printf ("Bitcount sum does not match\n");
	}
	tmpval7 = outkeys[1];
	if (tmpval7 & 0x00008000) {
		printf ("outkeys[1] Test against 0x00008000 true.\n");
	}
	if (outkeys[0] & 0x00100000) {
		printf ("outkeys[0] Test against 0x00100000 true.\n");
	}
	if (outkeys[0] & 0x00000002) {
		printf ("outkeys[0] Test against 0x00000002 true.\n");
	}
	if (outkeys[0] & 0x00000004) {
		printf ("outkeys[0] Test against 0x00000004 true.\n");
	}
	if (outkeys[0] & 0x00000008) {
		printf ("outkeys[0] Test against 0x00000008 true.\n");
	}
	if (outkeys[0] & 0x00000010) {
		printf ("outkeys[0] Test against 0x00000010 true.\n");
	}
	if (outkeys[0] & 0x00000020) {
		printf ("outkeys[0] Test against 0x00000020 true.\n");
	}
	if (outkeys[0] & 0x00000040) {
		printf ("outkeys[0] Test against 0x00000040 true.\n");
	}
	if (outkeys[0] & 0x00000080) {
		printf ("outkeys[0] Test against 0x00000080 true.\n");
	}
	if (outkeys[0] & 0x00004000) {
		printf ("outkeys[0] Test against 0x00004000 true.\n");
	}
	if (outkeys[0] & 0x00008000) {
		printf ("outkeys[0] Test against 0x00008000 true.\n");
	}
	if (outkeys[0] & 0x00000100) {
		printf ("outkeys[0] Test against 0x00000100 true.\n");
	}
	if (outkeys[0] & 0x00000200) {
		printf ("outkeys[0] Test against 0x00000200 true.\n");
	}
	if (outkeys[0] & 0x00000400) {
		printf ("outkeys[0] Test against 0x00000400 true.\n");
	}
	if (outkeys[0] & 0x00000800) {
		printf ("outkeys[0] Test against 0x00000800 true.\n");
	}
	if (outkeys[0] & 0x00001000) {
		printf ("outkeys[0] Test against 0x00001000 true.\n");
	}
	if (outkeys[0] & 0x00002000) {
		printf ("outkeys[0] Test against 0x00002000 true.\n");
	}
	return(0);
}
/*---------------------------------------------------------------*
 *
 * nbl_svk; Extract VENDOR_KEY5 from other 4 vendor keys.
 *
 *---------------------------------------------------------------*/

unsigned long nbl_svk(char *instr, MVENDORCODE4 *inv)
{
	unsigned long *rptr;
	unsigned long incval;
	unsigned long incval1;
	unsigned long seedval;
	int i;
	int tmpval1;
	int tmpnum2;
	int tmpnum3;
	int tmpnum4;

	
	/* Returns array of crypto'd values */
	rptr = nbl_key(instr, inv->keys);
	nb_nzsum(instr, &incval);
	incval1 = 0;

	/* swap byte order */
	for (i = 0; i < 4; i++)
	{
		incval1 = incval1 << 8;
		tmpval1 = (incval >> (i * 8)) & 0x000000ff;
		incval1 |= tmpval1;
	}
	seedval = 0xa8f38730;
	/* PATCH for version 7 - uses different value here. */
	if (glseed == 0x788f71d2)
	{
		seedval = 0x7648b98e;
	}
	tmpnum2 = seedval ^ incval1;
	tmpnum3 = tmpnum2 ^ rptr[1];
	tmpnum4 = tmpnum3 ^ rptr[2];
	return(tmpnum4);
}
/*---------------------------------------------------------------*
 *
 * nbl_key: extract unencrypted data from first 4 vendor codes.
 *---------------------------------------------------------------*/
unsigned long *nbl_key(char *instr, unsigned long *inv)
{
	unsigned long cksum1;
	unsigned long cksum2;
	unsigned long cksum3;
	unsigned long cksum4;
	unsigned long cksum5;
	unsigned long *outval;
	unsigned long res1;
	unsigned long res2;
	unsigned long res3;
	unsigned long res4;
	unsigned long res5;
	unsigned long res6;
	unsigned long res7;

	outval = glkey; /* Use global for now */


	z_init(instr, &cksum1);

	cksum2 = nbl_icf(inv[0]);
	res1 = cksum1 ^ cksum2;
	res2 = res1 ^ inv[0];
	cksum3 = nbl_icf(inv[1]);
	res3 = res2 ^ cksum3;
	res4 = res3 ^ inv[1];
	cksum4 = nbl_icf(inv[2]);
	res5 = cksum4 ^ res4;
	res6 = res5 ^ inv[2];
	cksum5 = nbl_icf(inv[3]);
	res7 = cksum5 ^ res6;

	outval[0] = res1;
	outval[1] = res3;
	outval[2] = res5;
	outval[3] = res7;
	return(outval);

}
/*---------------------------------------------------------------*
 *
 * nbl_br:
 * reverse bit order
 * X == nbl_br(nbl_br(X))
 *---------------------------------------------------------------*/
 unsigned long nbl_br(unsigned long inval)
 {
	unsigned long outval = 0;
	int i;

	for (i = 0; i < 8; i++) {
		outval = outval << 1;
		outval = outval | (inval & 0x00000001);
		inval = inval >> 1;
	}
	return(outval);
}
/*---------------------------------------------------------------*
 *
 * nbl_hbs:
 * swap nybbles around
 * X == nbl_hbs(nbl_hbs(X))
 *---------------------------------------------------------------*/
 unsigned long nbl_hbs(unsigned long inval)
 {
	unsigned long outval;
	int tmpval;
	int tmpval1;

	tmpval = inval & 0x000000f0;
	tmpval = tmpval >> 4;
	tmpval1 = inval & 0x0000000f;
	tmpval1 = tmpval1 <<4;
	outval = tmpval1 | tmpval;
	return(outval);
}

/*---------------------------------------------------------------*
 *
 * nbl_icf: scramble a long value to another long value.
 * called from nbl_key.
 * X == (rl_icf(nbl_icf(X))
 *---------------------------------------------------------------*/
 unsigned long nbl_icf(unsigned long inval)
 {
	unsigned long outval = 0;
	unsigned long tmp0;
	unsigned long tmp1;
	unsigned long tmp2;
	unsigned long tmp3;
	unsigned long outtmp0;
	unsigned long outtmp1;
	unsigned long outtmp2;
	unsigned long outtmp3;
	unsigned long htmp0;
	unsigned long htmp2;
	unsigned long htmp3;
	unsigned long mhtmp0;
	unsigned long result0;
	unsigned long result1;
	unsigned long result2;
	unsigned long out0;

	tmp0 = inval & 0x000000ff;
	tmp1 = inval & 0x0000ff00;
	tmp1 = tmp1 >>8;
	tmp2 = inval & 0x00ff0000;
	tmp2 = tmp2 >>16;
	tmp3 = inval & 0xff000000;
	tmp3 = tmp3 >>24;
	outtmp0 = nbl_br(tmp0);
	outtmp1 = nbl_br(tmp1);
	outtmp2 = nbl_br(tmp2);
	outtmp3 = nbl_br(tmp3);
	htmp2 = nbl_hbs(outtmp2);
	htmp3 = nbl_hbs(tmp3);
	result0 = htmp2 ^ htmp3;
	result1 = outtmp1 ^ htmp2;
	htmp0 = nbl_hbs(tmp0);
	mhtmp0 = nbl_br(htmp0);
	result2 = result1 ^ mhtmp0;
	out0 = result1 << 8;
	out0 |= result2;
	out0 |= result0 << 16;
	out0 |= htmp2 << 24;
	return(out0);
}

/*---------------------------------------------------------------*
 *
 * z_init; generate checksum from key string 
 *---------------------------------------------------------------*/
int z_init(char *instr, unsigned long *outval)
{
	int i = 0;
	unsigned long cksum;
	unsigned long addval;
	unsigned long offset;

	char *p;
	/* cryptoseed */
	/* cksum = 0x1504C935; */
	cksum = glseed;

	/* successively XOR bytes of seed with bytes of input string */
	for (p = instr; *p != '\0'; *p++) {
		offset = i%4;
		addval = (unsigned long) (*p & 0x000000ff);
		addval = addval << (offset*8);
		cksum = cksum ^ addval;
		i++;
	}
	*outval = cksum;
	return(0);
}

/*---------------------------------------------------------------*
 *
 * nb_nzsum; generate other checksum from key string 
 *---------------------------------------------------------------*/
int nb_nzsum(char *instr, unsigned long *outval)
{
	int i = 0;
	unsigned long cksum;
	unsigned long addval;
	unsigned long offset;

	char *p;
	/* cryptoseed */
	cksum = 0x0;

	/* successively XOR bytes of seed with bytes of input string */
	for (p = instr; *p != '\0'; *p++) {
		offset = i%4;
		addval = (unsigned long) (*p & 0x000000ff);
		addval = addval << (offset*8);
		cksum = cksum ^ addval;
		i++;
	}
	*outval = cksum;
	return(0);
}
/*-------------------------------------------------------------*
 *
 * nbl_c: 
 * count "true" bits inside structure.
 *-------------------------------------------------------------*/
unsigned long nbl_c(unsigned long *inval)
{
	unsigned long curval;
	int val1;
	unsigned long *val3;
	unsigned long sumval;
	unsigned long i;
	unsigned long r0 = 0;
	val3 = inval;
	sumval = r0;
	for (val1 = 3; val1 >= 0; val1--) {
		curval = *val3;
		for (i = 93; i >= 31; i-=2) {
			if (curval & 0x00000001) { 
				sumval += 1;
			}
			curval = curval >> 1;
		}
		val3++;
	}
	return(sumval);
}
/*-------------------------------------------------------------*
 *
 * nbl_rev 
 * essentially, inverse of nbl_key.
 *-------------------------------------------------------------*/
unsigned long nbl_rev(char *instr,unsigned long *decvals, unsigned long *okeys)
{
	int i;
	unsigned long cksum1;
	unsigned long res1;
	unsigned long res3;
	unsigned long res5;
	unsigned long res7;
	unsigned long cksum2;
	unsigned long key0;
	unsigned long res2;
	unsigned long cksum3;
	unsigned long key1;
	unsigned long res4;
	unsigned long cksum4;
	unsigned long key2;
	unsigned long res6;
	unsigned long cksum5;
	unsigned long key3;
	MVENDORCODE4 tmpvendor;

	for (i = 0; i < 5; i++) {
		okeys[i] = 0;
	}
	z_init(instr, &cksum1);

	res1 = decvals[0];
	res3 = decvals[1];
	res5 = decvals[2];
	res7 = decvals[3];

	cksum2 = res1 ^ cksum1;
	key0 = rl_icf(cksum2);
	res2 = res1 ^ key0;
	cksum3 = res2 ^ res3;
	key1 = rl_icf(cksum3);
	res4 = res3 ^ key1;
	cksum4 = res5 ^ res4;
	key2 = rl_icf(cksum4);
	res6 = res5 ^ key2;
	cksum5 = res7 ^ res6;
	key3 = rl_icf(cksum5);

	okeys[0] = key0;
	okeys[1] = key1;
	okeys[2] = key2;
	okeys[3] = key3;
	tmpvendor.type = 0x00040000; /* vendorcode 4 type of structure */
	tmpvendor.data[0] = 0; /* UNUSED */
	tmpvendor.data[1] = 0; /* UNUSED */
	tmpvendor.keys[0] = okeys[0];
	tmpvendor.keys[1] = okeys[1];
	tmpvendor.keys[2] = okeys[2];
	tmpvendor.keys[3] = okeys[3];
	tmpvendor.flexlm_version = 6;
	tmpvendor.flexlm_revision = 1;
	okeys[4] = nbl_svk(instr, &tmpvendor);
	return(0);
}
/*---------------------------------------------------------------*
 *
 * rl_icf: inverse of nbl_icf function.
 *---------------------------------------------------------------*/
 unsigned long rl_icf(unsigned long inval)
 {
	 unsigned long htmp2;
	 unsigned long result0;
	 unsigned long result1;
	 unsigned long outtmp1;
	 unsigned long tmp1;
	 unsigned long outtmp2;
	 unsigned long tmp2;
	 unsigned long htmp3;
	 unsigned long tmp3;
	 unsigned long result2;
	 unsigned long mhtmp0;
	 unsigned long htmp0;
	 unsigned long tmp0;
	 unsigned long outval;

	 htmp2 = inval >> 24;
	 result0 = inval >> 16;
	 result0 &= 0x000000ff;
	 result1 = inval >> 8;
	 result1 &= 0x000000ff;
	 outtmp1 = result1 ^ htmp2;
	 tmp1 = nbl_br(outtmp1);
	 outtmp2 = nbl_hbs(htmp2);
	 tmp2 = nbl_br(outtmp2);
	 htmp3 = result0 ^ htmp2;
	 tmp3 = nbl_hbs(htmp3);
	 result2 = inval & 0x000000ff;
	 mhtmp0 = result2 ^ result1;
	 htmp0 = nbl_br(mhtmp0);
	 tmp0 = nbl_hbs(htmp0);
	 outval = tmp0;
	 outval |= tmp1 << 8;
	 outval |= tmp2 << 16;
	 outval |= tmp3 << 24;
	 return(outval);
 }
/*---------------------------------------------------------------*
 *
 * fix_checksum:
 * fix checksum of a decoded structure.
 * call this before calling nbl_rev..
 *---------------------------------------------------------------*/
 int fix_checksum(unsigned long *inarr)
 {
	 unsigned long tmpval0;
	 unsigned long tmpval2;
	 unsigned long tmpval3;
	 unsigned long tmpval4;
	 unsigned long tmpval6;

	 tmpval0 = 0xa3ef0000;	 
	 tmpval4 = inarr[1] & 0xffffff80;
	 tmpval3 = inarr[3] & 0x0000ffff;
	 tmpval2 = tmpval3 << 16;
	 tmpval2 = tmpval2 ^ tmpval0;
	 tmpval2 |= tmpval3;
	 printf ("outmpval2: %08x\n", tmpval2);
	 inarr[3] = tmpval2;
	 inarr[1] = tmpval4;
	 tmpval6 = nbl_c(inarr);
	 inarr[1] = inarr[1] | tmpval6;
	 return(0);
 }
 /*--------------------------------------------------------*
 *
 * nbl_validate_vendor
 *--------------------------------------------------------*/
unsigned long nbl_validate_vendor(char *instr, unsigned long *inv)
{
	unsigned long tmpval0;
	unsigned long tmpval1;
	long tmpval2;
	long tmpval3;
	unsigned long tmpval4;
	unsigned long tmpval5;
	unsigned long tmpval6;
	unsigned long *outkeys;

	
	outkeys = nbl_key(instr, inv);
	tmpval0 = 0xa3ef0000;
	tmpval1 = outkeys[3] ^ tmpval0;
	tmpval2 = (tmpval1 >> 16) & 0x0000FFFF; /* low bytes? XXXX */
	tmpval3 = outkeys[3] & 0x0000FFFF;
	tmpval2 = tmpval3 - tmpval2;
	tmpval4 = outkeys[1] & 0x0000007f;
	tmpval5 = outkeys[1] & 0xffffff80;
	outkeys[1] = tmpval5;
	if (tmpval2 != 0) {
		return(1);
	}
	tmpval6 = nbl_c(outkeys);
	if (tmpval6 != tmpval4) {
		return(2);
	}

	return(0);
}

 
/*-----------------------------------------------------------*
 *
 * FC nbl_read_date: Convert date into time.
 *
 * format: DD-MON-YYYY
 *-----------------------------------------------------------*/

int nbl_read_date (char *inday, unsigned long *outtime)
{
    int year;
	unsigned long syear;
	unsigned long smonth;
	unsigned long sday;

    int month;
    int day;
    int i;
    int monthdays = 0;
    char *month_ptr;
    char read_month[132];

    if (sscanf(inday, "%02d%5s%04d", &day,read_month, &year) != 3) {
        return(-1);
    }
	if (year < 1900) { /* fully qualified year required here */
        return(-1);
    }

   nbl_mtuc(read_month);
/*
 * Convert -MAR- to MAR
 */
 
    month_ptr = read_month;
    if (*month_ptr == '-') {
        month_ptr++;
    }
    else { 
        return(-1);
    }
    if (month_ptr[strlen(month_ptr) - 1] != '-') {
        return(-1);
    }
    month_ptr[strlen(month_ptr) - 1] = '\0';

    month = 0;
    for (i = 0; i < 12; i++) {
        if (strcmp (montharr[i], month_ptr) == 0) { 
            month = i+1;
            break;
        }
    }
    if (month == 0) return(-1); /* Invalid month string. */
/*
 * basic sanity checks.
 */
    if (year < 1900 || year > 2027) return(-1);
    if (month < 1 || month > 12) return(-1);
    if (day < 1 || day > 31) return(-1);
    if ((year%4) == 0 && (year%100 != 0 || year % 400  == 0)) {   /* leap year */
       if (day > daysleapmonth[month - 1]) {    /* too many days. . . */
            return(-1);
       }
       for (i = 0; i < month - 1; i++){
            monthdays += daysleapmonth[i];
       }
    }
    else {
        if (day > daysinmonth[month - 1]) {    /* too many days. . . */
            return(-1);
        }
    }
	syear = year-1900;
	smonth = month-1;
	sday = day;
	*outtime = sday | smonth << 5 | syear << 9;
    return(0);
}
/*-----------------------------------------------------------*
 *
 * FC nbl_interpret_date: Convert time to date.
 *
 * format: DD-MON-YYYY
 *-----------------------------------------------------------*/

int nbl_interpret_date ( unsigned long intime, char *outday)
{
	unsigned long sday;
	unsigned long smonth;
	unsigned long syear;

	sday = intime & 0x0000001f;
	smonth = (intime >> 5) & 0x0000000f;
	syear = (intime >> 9) & 0x0000007f;
	if (smonth > 11) {
		return(-1);
	}
	sprintf(outday,"%d-%s-%d", sday, montharr[smonth], syear+1900);
	nbl_mtlc(outday);
	return(0);
}


/*----------------------------------------------*
 *
 * FC  nbl_mtuc: map to upper case 
 *----------------------------------------------*/
void nbl_mtuc(char *instr)
{
    char *srch_ptr;
    char mapper;
    srch_ptr = instr;

    while (*srch_ptr != '\0') {
        mapper=toupper(*srch_ptr);
        *srch_ptr=mapper;
        srch_ptr++;
    }
}
/*----------------------------------------------*
 *
 * FC  nbl_mtlc: map to lower case 
 *----------------------------------------------*/
void nbl_mtlc(char *instr)
{
    char *srch_ptr;
    char mapper;
    srch_ptr = instr;

    while (*srch_ptr != '\0') {
        mapper=tolower(*srch_ptr);
        *srch_ptr=mapper;
        srch_ptr++;
    }
}
/*------------------------------------------------------------*
 *
 * nbl_interpret_decvals: Decode information in vendor  structure
 *------------------------------------------------------------*/
int nbl_interpret_decvals(unsigned long *decvals)
{
	char datestr[1024];

	unsigned long datenum;

	datenum = decvals[3] & 0x0000ffff; /* expiry date of key */

	nbl_interpret_date(datenum, datestr);
	printf ("Expiry date: %s\n", datestr);
	if (datenum == 0x0000a001) {
		printf ("This date indicates no expiry.\n");
	}
	return(0);
}

