;============================================================================
; FPHELP.ASM
;============================================================================
;
;   +Frog's Print, 1999
;
;   Title:      FPHELP.ASM
;
;   Version:    1.00
;
;   Date:       12-Aug-1999
;
;   Author:     +Frog's Print
;
;
; Description:
;             Help file describing anti-SoftICE tricks (hooked by FrogsICE)
;             which can be invoked from within SoftICE Command window.
; Installation:
;             Copy FPHelp.vxd inside your Windows/system/iosubsys directory and
;             reboot so that windowz load the driver.
; Usage:
;             Type ".fphelp" at SoftICE prompt and follow the menu.
;
;============================================================================
    .486p

    .xlist

    include       vmm.inc
    include       debug.inc

    .list

;============================================================================
;             D E V I C E   D E C L A R A T I O N
;============================================================================

Declare_Virtual_Device    FPHELP,1,00,FPHELP_CONTROL,Undefined_Device_ID, \
                          Undefined_Init_Order,,

VXD_LOCKED_CODE_SEG

;============================================================================
;           D E V I C E   I N I T I A L I Z A T I O N   C O D E
;============================================================================

BeginProc         FPHELP_INIT
      clc
      ret
EndProc           FPHELP_INIT

;============================================================================
;               D E V I C E   C O N T R O L   P R O C E D U R E
;============================================================================

BeginProc         FPHELP_CONTROL
      cmp         eax,02h                             ; INIT_COMPLETE
      jz          FPHELP_INIT
      cmp         eax, 14h                            ; DEBUG_QUERY
      jz          TRICKSHELP
      clc
      ret
EndProc           FPHELP_CONTROL

;----------------------------------------------------------------------------
; Display anti-SoftICE tricks help in SoftICE command window.
; Usage: Type '.fphelp' at SoftICE prompt to get menu & help
;----------------------------------------------------------------------------

BeginProc         TRICKSHELP
      jmp         ShowMenu
GetKey:
      Trace_Out   " "
      Trace_Out   "press any key to go back to MAIN MENU or [ECS] to QUIT"
      VmmCall     In_Debug_Chr                     ; get keypressed
      jz          Cancel
ShowMenu:
      Trace_Out   " "
      Trace_Out   "=============== FROG'S PRINT ANTI-SOFTICE TRICKS HELP ==============="
      Trace_Out   "[1]=int 03h    [2]=int 2fh     [3]=int 41h     [4]=int 68h"
      Trace_Out   "[5]=Get_DDB    [6]=dr0-7       [7]=MeltICE     [8]=VWIN32_Int41Dispatch"
      Trace_Out   "Select menu option [1] to [8] or [ECS] to quit:"
      VmmCall     In_Debug_Chr                     ; get keypressed
      jz          Cancel                           ; ESC key                             
      Trace_Out   " "
      cmp         al, '1'
      jz          ShowMenu1
      cmp         al, '2'
      jz          ShowMenu2
      cmp         al, '3'
      jz          ShowMenu3
      cmp         al, '4'
      jz          ShowMenu4
      cmp         al, '5'
      jz          ShowMenu5
      cmp         al, '6'
      jz          ShowMenu6
      cmp         al, '7'
      jz          ShowMenu7
      cmp         al, '8'
      jz          ShowMenu8
      jmp         ShowMenu
ShowMenu1:
      Trace_Out   "============================  INT 03h  =============================="
      Trace_Out   "-BoundsChecker signature         | -SoftICE Backdoor commands"
      Trace_Out   "  mov  ebp, 04243484Bh ;'BCHK'   |  mov  ax,0911 ; execute command"
      Trace_Out   "  mov  ax, 04h                   |  mov  dx,[bx] ; ds:dx=Sice command"
      Trace_Out   "  int  3                         |  mov  si,4647 ; 1st magic value"
      Trace_Out   "  cmp  al,4                      |  mov  di,4A4D ; 2nd magic value"
      Trace_Out   "  jnz  SoftICE_Detected          |  int  3"
      jmp         GetKey
ShowMenu2:
      Trace_Out   "============================  INT 2fh  =============================="
      Trace_Out   "-Seeking SoftICE VxD's ID"
      Trace_Out   "  xor   di,di"
      Trace_Out   "  mov   es,di"
      Trace_Out   "  mov   ax, 1684h"
      Trace_Out   "  mov   bx, 0202h   ; SICE ID (could be 7a5Fh for SIWVID)"
      Trace_Out   "  int   2Fh"
      Trace_Out   "  mov   ax, es      ; es:di -> VxD API entry point"
      Trace_Out   "  add   ax, di"
      Trace_Out   "  test  ax,ax"
      Trace_Out   "  jnz   SoftICE_Detected"
      jmp         GetKey
ShowMenu3:      
      Trace_Out   "============================  INT 41h  =============================="
      Trace_Out   "-Debugger installation check"
      Trace_Out   "  mov   ax,4fh"
      Trace_Out   "  int   41h"
MagicNumber:
      Trace_Out   "  cmp   ax, 0f386h        ; magic number returned by system debuggers"
      Trace_Out   "  jz    SoftICE_detected"
      jmp         GetKey
ShowMenu4:
      Trace_Out   "============================  INT 68h  =============================="
      Trace_Out   "-WinICE V86 interrupt handler"
      Trace_Out   "  mov   ah,43h"
      Trace_Out   "  int   68h"
      jmp         MagicNumber
ShowMenu5:
      Trace_Out   "============================  GET_DDB  =============================="
      Trace_Out   "-Determines whether or not a VxD is installed (ring0):"
      Trace_Out   "  mov     eax, Device_ID   ; 202h for SICE (or 7a5Fh for SIWVID)"
      Trace_Out   "  mov     edi, Device_Name ; only used if no VxD ID (useless for Sice)"
      Trace_Out   "  VMMCall Get_DDB"
      Trace_Out   "  mov     [DDB], ecx       ; ecx=DDB or 0 if the VxD is not installed"
      jmp         GetKey
ShowMenu6:
      Trace_Out   "=====================  DEBUG REGISTERS (dr0-7) ======================"
      Trace_Out   "-Access to debug registers ('mov drX, reg' or 'mov reg, drX'):"
      Trace_Out   "  dr0, dr1, dr2, dr3 : store physical break addresses (linear address)"
      Trace_Out   "  dr7 = 0x700 if soft loaded with Symbol Loader (0x400 otherwise)"
      jmp         GetKey
ShowMenu7:
      Trace_Out   "============================  MELTICE  =============================="
      Trace_Out   "-Opens SoftICE driver(s) handle(s):"
      Trace_Out   "  SICE  db  '\\.\SICE',0        ; (or SIWVID, NTICE)"
      Trace_Out   "  ..."
      Trace_Out   "  push  offset SICE"
      Trace_Out   "  call  CreateFileA"
      Trace_Out   "  cmp   eax, 0ffffffffh"
      Trace_Out   "  jz    NOT_Loaded"
      jmp         GetKey
ShowMenu8:
      Trace_Out   "======================= VWIN32_INT41DISPATCH ========================"
      Trace_Out   "-Calls VWIN32_Int41Dispatch to check debugger installation (ring0)"
      Trace_Out   "  push  0000004fh         ; function 4fh"
      Trace_Out   "  push  002a002ah         ; VWIN32_Int41Dispatch"
      Trace_Out   "  call  Kernel32!ORD_001  ; VxdCall"
      jmp         MagicNumber
Cancel:
      Trace_Out  "Have a nice day... ;-)"
      clc 
      ret
EndProc           TRICKSHELP


VXD_LOCKED_CODE_ENDS

end
;---------------------------------  T H A T ' S  A L L ----------------------