;============================================================================
;Title FROGSICE.ASM
;============================================================================
;
;   +Frog's Print, 1999
;
;   Title:      FROGSICE.ASM
;
;   Version:    0.43
;
;   Date:       27-Nov-1999
;
;   Author:     +Frog's Print
;
;
; Description:
;      Simple VxD to intercept and fool a DOS, Win16 or Win32 app
;      trying to detect SoftICE. Dispatch and save infos to log file.
;
;============================================================================
;
;   Change log:
;
;      DATE       REV                 DESCRIPTION
;   -----------  -----  -------------------------------------------------------
;   16-Jan-1999  0.10   1st release
;   23-Feb-1999  0.12   Few stuffs added
;   17-Mar-1999  0.13   Creates log file
;   03-Jul-1999  0.14   Hooks Get_DDB service
;   16-Jul-1999  0.15   Hides SoftICE drivers
;   24-Jul-1999  0.20b  New GUI, selectionnable options, hooks Debug Registers
;                       access (beta). Few code changed.
;   12-Aug-1999  0.30   Hooks *all* access to drX, MeltICE & Bleem detections added.
;                       Detection location fixed for hooked services. Anti-FrogsICE
;                       detection routines added.
;   22-Aug-1999  0.31   MeltICE detection fixed for Win95 users
;   20-Nov-1999  0.40   Hooks access to SoftICE registry keys and FrogsICE detection.
;                       Protects SoftICE files from deletion. Diasable BSOD from within
;                       BSOD. Optional int03h hook and logfile. Installer/patcher to hide
;                       FrogsICE and FPLoader from detection. Creates logfile in the current
;                       drive. Offset/segment of the detection fixed for 32Bit apps calling
;                       int68h. View/Delete logfile options. Few changes.
;   22-Nov-1999 0.41    Taskname for hooked interrupts fixed. Anti-CodeCrypt routine and
;                       Run command from menu added.
;   24-Nov-1999 0.42    Force call to int03h exception filter function (VBox, Armadillo...).
;   27-Nov-1999 0.43    Improved anti-MeltICE routine to fool programs checking
;                       against modifications (PCGuard32...).
;
;============================================================================
;                                 I N C L U D E S
;============================================================================

    .486p                              ; for 486+ CPU due to the use of 
                                       ; the "bswap" instruction and 
                                       ; the GD bit of the dr7 register.
    .xlist

    include    vmm.inc
    include    vwin32.inc
    include    shell.inc
    include    ifsmgr.inc
    include    ifs.inc
    include    vxdldr.inc

    .list

;============================================================================
;     D E V I C E   I N I T I A L I Z A T I O N   C O D E
;============================================================================
;
; Hooks interrupts:
; - 01h, 21h ,2fh, 41h and 68h in V86
; - 01h, 21h, 2fh and 41h in PMode
; - 01h (VMM)
; Hooks Get_DDB service
; Hooks VMM_GetDDBList
; Hooks Exec_PM_Int
; Hooks _regopenkey
; and redirect them to our own routines.
; Get Windows version (95 or 98) from the registry for later use.
;----------------------------------------------------------------------------

VXD_Icode_Seg

BeginProc      FROGSICE_Device_Init

      mov      eax, 01h
      mov      esi, OFFSET32 HookInt01
      VMMCall  Hook_V86_Int_Chain
      mov      eax, 01h
      mov      esi, OFFSET32 HookInt01
      VMMCall  Hook_PM_Fault
      mov      eax, 01
      mov      esi, OFFSET32 HookInt01
      VMMCall  Hook_VMM_Fault
      mov      esi, OFFSET32 HookMeltICE
      mov      eax, @@VMM_GetDDBList
      VMMCall  Hook_Device_Service      
      mov      esi, OFFSET32 VWIN32_Int41
      mov      eax, @@Exec_PM_Int
      VMMCall  Hook_Device_Service      
      mov      eax, 21h
      mov      esi, OFFSET32 HookInt21
      VMMCall  Hook_V86_Int_Chain
      mov      eax, 2fh
      mov      esi, OFFSET32 HookInt2F
      VMMCall  Hook_V86_Int_Chain
      mov      eax, 41h
      mov      esi, OFFSET32 HookInt41
      VMMCall  Hook_V86_Int_Chain
      mov      eax, 68h
      mov      esi, OFFSET32 HookInt68
      VMMCall  Hook_V86_Int_Chain
      mov      eax,21h
      mov      esi, OFFSET32 HookInt21
      VMMCall  Hook_PM_Fault
      mov      eax, 2fh
      mov      esi, OFFSET32 HookInt2F
      VMMCall  Hook_PM_Fault
      mov      eax, 41h
      mov      esi, OFFSET32 HookInt41
      VMMCall  Hook_PM_Fault
      mov      esi, OFFSET32 HookGetDDBService
      mov      eax, @@Get_DDB
      VMMCall  Hook_Device_Service
      mov      esi, OFFSET32 UnloadDevice
      mov      eax, @@VXDLDR_UnloadDevice
      VMMCall  Hook_Device_Service    
      mov      esi, OFFSET32 SiceRegKey
      mov      eax, @@_regopenkey
      VMMCall  Hook_Device_Service    
      ; -----------------------------------------
      ; fetch windows version (95 or 98) from the
      ; registry (needed for MeltICE detection)
      ; -----------------------------------------
      lea      eax,[KeyHandle]
      push     eax                                 ; handle of opened key
      push     OFFSET32 SubKey                     ; lpszSubKey
      push     HKEY_LOCAL_MACHINE                  ; hkey
      VmmCall  _RegOpenKey
      add      esp,0ch
      mov      eax,10
      push     eax
      lea      eax, OFFSET32 VersionBuffer         ; buffer to path
      push     eax
      push     REG_SZ                              ; look for null-terminated UNICODE or ANSI string
      push     0
      push     OFFSET32 WindowzKey
      mov      eax, [KeyHandle]
      push     eax
      VMMCall  _RegQueryValueEx                    ; fetch key value
      add      esp,18h
      mov      eax, [KeyHandle]
      push     eax
      VmmCall  _RegCloseKey                        ; close registry
      add      esp,4
      cmp      word ptr [VersionBuffer+8], '89'    ; "Windows 9x"
      jnz      Win95
Win98:
      mov      WindowzVersion, 98
      jmp      ClearCarry
Win95:
      mov      WindowzVersion, 95
ClearCarry:      
      clc
      ret

EndProc     FROGSICE_Device_Init

VXD_Icode_Ends

;============================================================================
;             D E V I C E   D E C L A R A T I O N
;============================================================================

VXD_Locked_Code_Seg

Declare_Virtual_Device    FROGSICE,0,43,FROGSICE_Control,Undefined_Device_ID, \
                          Undefined_Init_Order,,

;----------------------------------------------------------------------------
;
; Device control procedure for the VxD.
;
;----------------------------------------------------------------------------

BeginProc   FROGSICE_Control

      cmp      eax, 1bh                            ; SYS_DYNAMIC_DEVICE_INIT
      jz       FROGSICE_Device_Init
      cmp      eax, 1ch                            ; SYS_DYNAMIC_DEVICE_EXIT
      jz       FROGSICE_Device_Exit
      cmp      eax, 23h                            ; W32_DEVICEIOCONTROL
      jz       FROGSICE_ioctl
      clc
      ret

FROGSICE_Control  ENDP

;----------------------------------------------------------------------------
;
; Get IOcontrol code :
; -un/install an IFS hook
; -hide/restore SoftICE drivers
; -display/hide screen message
; -hook/unhook drX
; -creates log file for debug registers access
; -hook/unhook int03h
;
;- Entry: dwIoControlCode
;
; Bitfields for FrogsICE IOControle code:
;                                
;                              32109876543210 bit
;
;  -Force ExceptionFilterInt3  10000000000000= 2000h
;  -No ExceptionFilterInt3     01000000000000= 1000h
;  -Install IFS hook           00100000000000=  800h
;  -Uninstall IFS hook         00010000000000=  400h
;  -Log to file                00001000000000=  200h
;  -Don't log to file          00000100000000=  100h
;  -Hook int03h                00000010000000=   80h
;  -Unhook int03h              00000001000000=   40h
;  -hook drX                   00000000100000=   20h
;  -UnHook drX                 00000000010000=   10h
;  -hide Sice drivers          00000000001000=   08h
;  -don't hide/restore them    00000000000100=   04h
;  -display info on screen     00000000000010=   02h
;  -don't display on screen    00000000000001=   01h
;                              --------------  -----
;  -default                    01101010011010= 1a9ah
;
;- Exit : -clear eax if OK
;----------------------------------------------------------------------------

BeginProc      FROGSICE_ioctl

      mov      eax, dword ptr[esi].dwIoControlCode ; Get FrogsICE IOControlCode. Note that
                                                   ; 'mov eax,ecx' does the same in Win98.

      cmp      eax, 0ffffffffh                     ; DIOC_CLOSEHANDLE
      jnz      Is_DiocOpen
      cmp      IFSHook, 1
      jnz      Int3CloseHnd
      call     RemoveHook                          ; Remove existing IFS and
Int3CloseHnd:                                      ; Int03h hooks upon exit
      cmp      Int3Hook, 1
      jnz      IoClose
      call     UninstallInt3Hook
      jmp      IoClose                             ; Restore drivers' names upon exit.
Is_DiocOpen:
      cmp      eax, 0                              ; DIOC_OPEN
      jz       @ret                                                  
      mov      edi, [esi+10h]                      ; Get window$ drive from our buffer
      mov      bl, [edi+1]                         ; and store it
      mov      [FileName], bl
CheckInt3Filter:
      test     eax,2000h                           ; int3 Exception filter
      jnz      ForceException
      mov      Int3Exception, 0
      jmp      CheckIFSHook
ForceException:
      mov      Int3Exception, 1
CheckIFSHook:
      test     eax,800h                            ; IFS hook
      jnz      InstallIFSHook
      call     RemoveHook
      jmp      CheckInt3
InstallIFSHook:
      call     InstallHook
CheckInt3:
      test     eax, 80h                            ; hook int 3
      jnz      Hook
      call     UninstallInt3Hook
      jmp      CheckLog
Hook:
      call     InstallInt3Hook
CheckLog:                                          ; log to file?
      test     eax, 200h
      jnz      LogInfos
      mov      LogToFile, 0
      jmp      CheckdrX
LogInfos:
      mov       LogToFile, 1
CheckdrX:      
      push     eax                                 ; OK now look for drX hook:
      test     eax, 20h
      jnz      HookDrX
      mov      DrXFlag, 0                          ; Don't hook int01h.
      mov      eax, dr7                            ; clear GD bit of dr7.
      and      eax, 0ffffDfffh                     ; Seems (??) to help Sice not
      mov      dr7, eax                            ; to crash after using the drX option.
      ; --------------------------------------------
      ; check if there's something in the buffer,
      ; write it to log file and inform fploader.exe
      ; --------------------------------------------
      cmp      BytesReturned, 0
      jz       CheckDisplay                        ; BufferEmpty
      mov      ecx, BytesReturned                  ; Size of buffer data
      mov      eax, dword ptr[esi].lpcbBytesReturned
      mov      dword ptr[eax], ecx
      push     esi
      push     offset32 OutBuffer
      push     BytesReturned
      call     Write2Log                           ; Creates log file
      pop      esi
      jmp      CheckDisplay
HookDrX:
      mov      BytesReturned, 0
      mov      eax, dr7                            ; Set GD to enable breakpoint
      or       eax, 2000h                          ; (int01h) on access
      mov      dr7, eax
      mov      DrXFlag, 1
CheckDisplay:                                      ; look for display:
      pop      eax
      test     eax, 02h                            ; Display on ?
      jnz      DisplayOn
      mov      DisplayFlag, 0                      ; Display off => clear flag
      jmp      CheckVxD
DisplayOn:
      mov      DisplayFlag, 1                      ; Set flag
CheckVxD:                                          ; look for Sice drivers:
      test     eax, 08h                            ; Hide drivers ?
      jnz      HideVxDNames
      jmp      RestoreVxDNames
IoClose:
      mov      DrXFlag, 0                          ; need to clear it again upon exit
                                                   ; don't ask me why, I don't know...
RestoreVxDNames:
      mov      bl, 'S'                             ; Restore the first 'S' char
      jmp      _GetDDBList
HideVxDNames:
      mov      edi, [esi+10h]                      ; Fetch random char from our buffer
      mov      bl, [edi]                           ; Store it
      ; ----------------------------
      ; Browse through the DDB List
      ; and look for SoftICE drivers
      ; ----------------------------
_GetDDBList:
      VMMCall  VMM_GetDDBList                      ; Get Device Description Block list
      xor      ecx,ecx
      jmp      FirstTry                            ; Let's go:
Retry:
      mov      eax, [eax]
      cmp      eax,0
      jz       NoMore
FirstTry:
      cmp      ecx,0
      jnz      @Siwdeb
      mov      esi, offset32 SICE
      jmp      Check_DDB
@Siwdeb:
      cmp      ecx,1
      jnz      @Siwv
      mov      esi, offset32 SIWDEBUG
      jmp      Check_DDB
@Siwv:
      mov      esi, offset32 SIWVID
Check_DDB:                                         ; Browse through the DDB list
      mov      edi, eax
      add      edi, 0ch
      cmpsd                                        ; Check if it's the right driver
      jnz      Retry
      mov      byte ptr [eax+0ch],bl               ; patch or restore fisrt char with random char
      inc      ecx
      jmp      Retry
NoMore:
      mov      SICE, bl                            ; Saves patched named to restore
      mov      SIWVID, bl                          ; them upon exit
      mov      SIWDEBUG, bl
@ret:
      xor      eax, eax
      clc
      ret

EndProc        FROGSICE_ioctl

;----------------------------------------------------------------------------
;
; InstallHook  : Install an IFS hook
;
; Entry        : nothing
; Exit         : Set IFSHook flag if no error
;----------------------------------------------------------------------------

BeginProc   InstallHook

      cmp      IFSHook, 1
      jz       Installed
      push     eax
      mov      eax, OFFSET32 DeleteFileHook
      push     eax
      VxDcall  IFSMgr_InstallFileSystemApiHook
      add      esp, 4
      or       eax,eax
      jz       Install_Error
      mov      [IFSPrevHook], eax
      mov      IFSHook,1
      jmp      Install_OK
Install_Error:
      mov      IFSHook, 0
Install_OK:
      pop      eax
Installed:
      ret
EndProc     InstallHook

;----------------------------------------------------------------------------
;
; RemoveHook  : Uninstall the IFS hook
;
; Entry        : nothing
; Exit         : Clear IFSHook flag
;----------------------------------------------------------------------------

BeginProc   RemoveHook

      cmp      IFSHook,0
      jz       Uninstalled
      push     eax
      mov      eax, OFFSET32 DeleteFileHook
      push     eax
      VxDcall  IFSMgr_RemoveFileSystemApiHook
      add      esp, 4
      pop      eax
      mov      IFSHook, 0
Uninstalled:
      ret
EndProc     RemoveHook

;----------------------------------------------------------------------------
;
; InstallInt3Hook  : Install an int03h hook
;
; Entry        : nothing
; Exit         : Set Int03Hook flag if no error
;----------------------------------------------------------------------------

BeginProc   InstallInt3Hook
      cmp      Int3Hook, 1
      jz       Installed_2
      push     eax
      push     esi
      mov      eax, 03h
      mov      esi, OFFSET32 HookInt3
      VMMCall  Hook_V86_Int_Chain
      mov      eax, 03h
      mov      esi, OFFSET32 HookInt3
      VMMCall  Hook_PM_Fault
      pop      esi
      pop      eax
      mov      Int3Hook, 1
Installed_2:
      ret
EndProc     InstallInt3Hook

;----------------------------------------------------------------------------
;
; UninstallInt3Hook  : Uninstall the int03h hook
;
; Entry        : nothing
; Exit         : Clear Int03Hook flag
;----------------------------------------------------------------------------

BeginProc   UninstallInt3Hook
      cmp      Int3Hook, 0
      jz       Uninstalled_2
      push     eax
      push     esi
      mov      eax, 03h
      mov      esi, OFFSET32 HookInt3
      VMMCall  UnHook_V86_Int_Chain
      mov      eax, 03h
      mov      esi, OFFSET32 HookInt3
      VMMCall  UnHook_PM_Fault
      pop      esi
      pop      eax      
      mov      Int3Hook, 0
Uninstalled_2:
      ret
EndProc     UninstallInt3Hook

;----------------------------------------------------------------------------
;
; UnHooks all interrupts and services hooked
;
;----------------------------------------------------------------------------

BeginProc      FROGSICE_Device_Exit

      mov      eax, 01h
      mov      esi, OFFSET32 HookInt01
      VMMCall  UnHook_V86_Int_Chain
      mov      eax, 01h
      mov      esi, OFFSET32 HookInt01
      VMMCall  UnHook_PM_Fault
      mov      eax, 01
      mov      esi, OFFSET32 HookInt01
      VMMCall  UnHook_VMM_Fault
      mov      esi, OFFSET32 HookMeltICE
      mov      eax, @@VMM_GetDDBList
      VMMCall  UnHook_Device_Service      
      mov      esi, OFFSET32 VWIN32_Int41
      mov      eax, @@Exec_PM_Int
      VMMCall  UnHook_Device_Service      
      mov      eax,  21h
      mov      esi, OFFSET32 HookInt21
      VMMCall  UnHook_V86_Int_Chain
      mov      eax, 2fh
      mov      esi, OFFSET32 HookInt2F
      VMMCall  UnHook_V86_Int_Chain
      mov      eax, 41h
      mov      esi, OFFSET32 HookInt41
      VMMCall  UnHook_V86_Int_Chain
      mov      eax, 68h
      mov      esi, OFFSET32 HookInt68
      VMMCall  UnHook_V86_Int_Chain
      mov      eax,  21h
      mov      esi, OFFSET32 HookInt21
      VMMCall  UnHook_PM_Fault
      mov      eax, 2fh
      mov      esi, OFFSET32 HookInt2F
      VMMCall  UnHook_PM_Fault
      mov      eax, 41h
      mov      esi, OFFSET32 HookInt41
      VMMCall  UnHook_PM_Fault
      mov      esi, OFFSET32 HookGetDDBService
      mov      eax, @@Get_DDB
      VMMCall  UnHook_Device_Service
      mov      esi, OFFSET32 UnloadDevice
      mov      eax, @@VXDLDR_UnloadDevice
      VMMCall  UnHook_Device_Service
      mov      esi, OFFSET32 SiceRegKey
      mov      eax, @@_regopenkey
      VMMCall  UnHook_Device_Service
      clc
      ret

EndProc     FROGSICE_Device_Exit

;============================================================================
;                            V A R I A B L E S
;============================================================================

      IntMsg               db    '=> ?           ',13,10
                           db    '**                   **  code 0 , at                    ', 13,10
                           db    'Interrupt:     eax=        h  ebx=        h  ecx=        h',13,10
                           db    '               edx=        h  esi=        h  edi=        h  ebp=        h',13,10,13,10
                           db    'Choice:   YES = fool it | NO = let it run | ESCAPE = disable BSOD.',0

      MeltICEMsg           db    '=> ?           ',13,10
                           db    '** SOFTICE DETECTION **  code 0 , at cs:             ', 13,10
                           db    'Attempting to load:       ',13,10,13,10
                           db    'Choice:   YES = fool it | NO = let it run | ESCAPE = disable BSOD.',0

      FrogsICEMsg          db    '=> ?           ',13,10
                           db    '** FrogsICE DETECTION ** code 0 , at cs:             ', 13,10
                           db    'Attempt to load: FROGSICE ',13,10,13,10
                           db    'Choice:   YES = fool it | ESCAPE = disable BSOD.',0

      RegKeyMsg            db    '=> ?           ',13,10
                           db    '** SOFTICE DETECTION ** code 0 , at cs:             ', 13,10
                           db    'SoftICE Registry keys access: # ',13,10,13,10
                           db    'Choice:   YES = fool it | NO = let it run | ESCAPE = disable BSOD.',0

      OutBuffer            db    4480 DUP (0),'===== BUFFER FULL ====='
      BytesReturned        dd    0

      DrXMsg               db    '=> ?           ',13,10
                           db    '** Debug Regs Access **  code 0 , at      :             ', 13,10
                           db    'Opcodes : 0x?????? (mov ???, ???)',13,10,13,10,0

      VWin32Int41Msg       db    '=> ?           ',13,10
                           db    '** SOFTICE DETECTION ** code 0 , at                    ', 13,10
                           db    'Interrupt: 41h Function: 4fh (VWIN32_Int41Dispatch)',13,10,13,10
                           db    'Choice:   YES = fool it | NO = let it run | ESCAPE = disable BSOD.',0

      DeleteMsg            db    '=> ?           ',13,10
                           db    "** WARNING ** This soft is trying to delete a file from SoftICE directory :",13,10
                           db    "(                                                                           ",13,10,13,10
                           db    'Choice:   YES = fool it | NO = let it run | ESCAPE = disable BSOD.',0

      FileName             db    '?:\FrogsICE.log',0
      TitleMsg             db    'FrogsICE warning!!',0
      IOErrorMsg           db    '**ERROR** : Cant'' open/create log file!',0
      IntID                db    0
      Abort                db    0
      RedirectInt          db    0
      Selector             dd    0
      Flags                dd    0
      VM                   dd    0
      DDBPrevHook          dd    0
      VxDLdrPrevHook       dd    0    
      MeltICEPrevHook      dd    0
      VWin32Int41PrevHook  dd    0
      IFSPrevHook          dd    0
      _32Bit               db    0
      RegKeyHook           dd    0
      LogToFile            db    1
      IFSHook              db    ?
      Int3Hook             db    ?
      SICE                 db    'SICE',20h,20h,20h,20h,0
      SIWVID               db    'SIWVID',20h,20h,0
      SIWDEBUG             db    'SIWDEBUG',0
      DisplayFlag          db    1
      DrXFlag              db    0
      SubKey               db    'Software\Microsoft\Windows\CurrentVersion',0
      WindowzKey           db    'Version',0
      KeyHandle            dd    0
      VersionBuffer        db    10 dup (0)
      WindowzVersion       db    0
      SiceKey_1            db    'Software\Microsoft\Windows\CurrentVersion\Uninstall\SoftICE',0
      SiceKey_2            db    'Software\NuMega\SoftICE',0
      SoftICEKey           db    'InstallDir',0
      String_Length        db    0
      File_Name            db    50h dup (0)      
      SoftICE_Path         db    50h dup (0)      
      Int3Exception        db    0
      Int68Buffer          dd    ?

;==============================================================================
;                          M A I N   C O D E
;==============================================================================
;
;           - Check the hooked int/service and its parameters to see if
;             it contains anti-SoftICE code.
;           - Displays infos and writes/creates log file.
;
; Exit   :  - Execute (Abort==0) or simulate (Abort==1) the int call or service
;
;==============================================================================

;---------------------------------------------------------------------------
;                          
; DeleteFileHook  : Avoid SoftICE files deletion
;                          
; Entry:    
;           ebp+1Ch  : pir 
;           ebp+18h  : CodePage
;           ebp+14h  : ResourceFlags
;           ebp+10h  : Drive
;           ebp+0Ch  : FunctionNum
;           ebp+8    : FSDFnAddr
;
; Exit:     If the caller tries to delete a file
;           from SoftICE directory/subdirectories:
;             - Return an 'access denied' ir_error
;              and doesn't chain to previous hook
;           Otherwise:
;             - Restore the previous hook in chain
;
;---------------------------------------------------------------------------

BeginProc      DeleteFileHook

      push     ebp
      mov      ebp,esp
      sub      esp,20h
      cmp      dword ptr [ebp+0Ch], IFSFN_DELETE   ; File deletion?
      jne      NoDeletion
      pushad
      ; -------------------
      ; Get ASCII file name
      ; -------------------
      mov      ebx, offset32 File_Name
      mov      eax, [ebp+10h]                      ; get current drive (A=1, B=2, C=3..)
      cmp      al, 0FFh
      jz       NoDriveSpec
      add      al, 40h
      mov      [ebx], al
      inc      ebx
      mov      byte ptr [ebx], 3Ah
      inc      ebx
  NodriveSpec:
      push     0                                   ; charSet (BCS_WANSI)
      push     0ffh                                ; maxLength
      mov      eax, [ebp+1Ch]
      mov      eax, [eax+0Ch]
      add      eax, 4
      push     eax                                 ; pUniPath
      push     ebx                                 ; pBCSPath
      VxDcall  UniToBCSPath
      add      esp, 10h
      add      ebx, eax
      mov      byte ptr [ebx], 0                   ; Make file name an ASCIIZ string
      ; ------------------------
      ; open the registry to get 
      ; SoftICE directory
      ; ------------------------
      lea      eax,[KeyHandle]
      push     eax                                 ; handle of opened key
      push     OFFSET32 SiceKey_2                  ; lpszSubKey
      push     HKEY_LOCAL_MACHINE                  ; hkey
      VmmCall  _RegOpenKey
      add      esp,0ch
      test     eax, eax                            ; everything OK?
      jnz      Error_Opening_regKey
      mov      eax,50h
      push     eax
      lea      eax, OFFSET32 SoftICE_Path          ; buffer to store SoftICE path
      push     eax
      push     REG_SZ                              ; null-terminated UNICODE or ANSI string
      push     0
      push     OFFSET32 SoftICEKey
      mov      eax, [KeyHandle]
      push     eax
      VMMCall  _RegQueryValueEx                    ; fetch key value
      add      esp,18h
      test     eax, eax
      jz       OK
Error_Opening_regKey:
      mov      [SoftICE_Path], 1                   ; too bad :((
OK:
      mov      eax, [KeyHandle]
      push     eax
      VmmCall  _RegCloseKey                        ; close registry
      add      esp,4
      cmp      [SoftICE_Path], 1
      jz       Error
      ; -------------------------------------------
      ; check if the file beeing deleted is located
      ; inside SoftICE directory/subdirectories
      ; -------------------------------------------
      push     offset32 SoftICE_Path
      VMMCall  _lstrlen
      add      esp,4
      mov      String_Length, al
      mov      byte ptr [File_Name+eax],0
      push     offset32 SoftICE_Path
      push     offset32 File_Name
      VMMCall  _lstrcmpi
      add      esp,8
      cmp      eax, 0
      jnz      Error
      mov      al, String_Length
      mov      byte ptr [File_Name+eax],'\'
      cld
      mov      edi, offset32 [DeleteMsg+95]
      mov      esi, offset32 [File_Name]
Tryagain:      
      cmp      byte ptr [esi],0
      jz       EndOfFile
      cmp      byte ptr [edi], 20h
      jnz      EndOfLine
      movsb
      inc      ebx
      jmp      Tryagain
EndOfLine:
      dec      edi
EndOfFile:
      mov byte ptr [edi], ')'
      call     _GetTaskName
      mov      edx, offset32 DeleteMsg
      call     Task2Msg      
      push     offset32 DeleteMsg
      push     174
      call     Write2Log
      mov      ecx, offset32 DeleteMsg
      call     BlueScreenOfDeath
      cmp      Abort, 0
      jz       Error

      mov      ecx, 75
fillit:      
      mov      byte ptr [DeleteMsg+94+ecx],20h
      loop     fillit
      mov      dword ptr [DeleteMsg+3],20202020h
      mov      dword ptr [DeleteMsg+7],20202020h
      popad      
      jmp      SendErrorCode                       ; don't chain :-p

Error:
      popad
NoDeletion:
      push     dword ptr [ebp+1Ch]                 ; chain to previous hook
      push     dword ptr [ebp+18h]                 ; if OK
      push     dword ptr [ebp+14h]
      push     dword ptr [ebp+10h]
      push     dword ptr [ebp+0Ch]
      push     dword ptr [ebp+8]
      mov      eax,dword ptr [IFSPrevHook]
      call     dword ptr [eax]
      add      esp,00000018h
      jmp      WeDunnIt
 
SendErrorCode:
      mov      eax, [ebp+1ch]                      ; Get IOREQ pointer
      mov      byte ptr [eax+1Ah],5                ; send ir_error code#5 (access denied)
      mov      eax,5                               ; Should be stored in eax as well.
WeDunnIt:
      leave
      ret
     
EndProc        DeleteFileHook

;----------------------------------------------------------------
;
; Hook _regopenkey service to catch SoftICE registry keys access
; and ensure we don't hook FrogsICE.
;
;----------------------------------------------------------------

BeginProc SiceRegKey, HOOK_PROC, RegKeyHook, LOCKED

      pushfd
      pushad
      cld
Key1:                                              ; Check 1st registry key
      mov      ecx, 50
      mov      edi, dword ptr [esp+2ch]
      add      edi, 9                              ; Bypass 'Software\' string
      mov      esi, offset32 SiceKey_1+9           ; as Win95 uses uppercases.
      cmp      esi,edi                             ; Just ensure we don't hook frogsice ;-)
      je       WrongKey   
      repe     cmpsb
      jnz      Key2
      mov      byte ptr [RegKeyMsg+102], '1'
      jmp       LetsGo
Key2:                                              ; Check 2nd registry key
      mov      ecx, 14
      mov      edi, dword ptr [esp+2ch]
      add      edi, 9
      mov      esi, offset32 SiceKey_2+9
      cmp      esi,edi                             ; FrogsICE?
      je       WrongKey   
      repe     cmpsb
      jnz      WrongKey
      mov      byte ptr [RegKeyMsg+102], '2'
LetsGo:
      call     _GetTaskName
      mov      edx, offset32 RegKeyMsg
      call     Task2Msg      
      mov      byte ptr [RegKeyMsg+47], 'D'

      mov      eax, dword ptr [esp+2Ch]
      mov      ebx, offset32 RegKeyMsg+60
      call     HexASCII
      bswap    eax
      xchg     al,ah
      mov      ebx, offset32 RegKeyMsg+56
      call     HexASCII

      push     offset32 RegKeyMsg
      push     107
      call     Write2Log
      mov      ecx, offset32 RegKeyMsg
      call     BlueScreenOfDeath
      mov      eax, 5
      call     CleanupMsg
      cmp      Abort, 0
      jz       WrongKey
      popad
      popfd
      clc                                          ; Don't chain and
      ret                                          ; fool the caller
WrongKey:
      popad
      popfd
      jmp      [RegKeyHook]                        ; chain to previous hook
      
EndProc SiceRegKey

;==============================================================================
;
; Hook Exec_PM_Int service to catch VWIN32_Int41Dispatch.
;
;----------------------------------------------------------------------------

BeginProc VWIN32_Int41, HOOK_PROC, VWin32Int41PrevHook, LOCKED
  
      pushfd
      pushad
      cmp      eax, 41h                            ; int 41h ?
      jnz      Quit_p2
      cmp      dword ptr [edx+1Ch], 4Fh            ; function 4fh ?
      jnz      Quit_p2
      cmp      dword ptr [edx+10h],002A002Ah       ; VWIN32_Int41Dispatch ?
      jnz      Quit_p2
      call     _GetTaskName
      mov      edx, offset32 VWin32Int41Msg
      call     Task2Msg
      mov      byte ptr [VWin32Int41Msg+47], 'C'
      mov      eax, [ebp.Client_EIP]
      sub      eax, 2
      mov      ebx, offset32 VWin32Int41Msg+61
      call     HexASCII
      bswap    eax
      xchg     al,ah
      mov      ebx, offset32 VWin32Int41Msg+58
      call     HexASCII
      mov      ax, [ebp.Client_CS]
      mov      ebx, offset32 VWin32Int41Msg+53
      call     HexASCII
      mov      byte ptr [VWin32Int41Msg+57], ':'
      push     offset32 VWin32Int41Msg
      push     129
      call     Write2Log
      mov      ecx, offset32 VWin32Int41Msg
      call     BlueScreenOfDeath
      mov      eax, 4
      call     CleanupMsg
      cmp      Abort, 0
      jz       Quit_p2
      popad
      popfd
      clc                                          ; Don't chain and
      ret                                          ; fool the caller
Quit_p2:
      popad
      popfd
      jmp      [VWin32Int41PrevHook]               ; chain to previous hook

EndProc VWIN32_Int41

;----------------------------------------------------------------------------
;
; Hook VMM_GetDDBList service to catch MeltICE trick and FrogsICE detection:
; Check if it is:
; - Loader32 (=> let it detect SoftICE)
; - FrogsICE (=> let it access the VMM_GetDDBList)
; Get Windowz version (95 or 98)
; In case of FrogsICE detection, always fool the caller to avoid crash :-(
;
;----------------------------------------------------------------------------

BeginProc HookMeltICE, HOOK_PROC, MeltICEPrevHook, LOCKED

      pushfd
      pushad
      call     _GetTaskName                         ; Is it Fploader.exe?
      cmp      dword ptr[eax], 'olpF'
      jnz      NotFrogsICE
      cmp      dword ptr[eax+4], 'reda'
      jz       Quit_p
NotFrogsICE:      
      cmp      dword ptr[eax], 'daoL'              ; Is it Loader32.exe?
      jnz      NotLoader32
      cmp      dword ptr[eax+4], '23re'
      jz       Quit_p
NotLoader32:
      ; -------------------------------------
      ; Need to know Windowz version to fetch
      ; driver's name saved on the stack:
      ; -Win98: [esp+3ch]
      ; -Win95: [esp+48h]
      ; -------------------------------------
      cmp      WindowzVersion, 98
      jnz      @Win95
      mov      edx, [esp+3ch]
      jmp      @Ok
@Win95:
      mov      edx, [esp+48h]
@Ok:
      cmp      dword ptr [edx], 'ECIS'             ; SICE ?
      jz       SiceID
      cmp      dword ptr [edx],'VWIS'              ; SIWVID ?
      jnz      IsNTICE
      cmp      word ptr [edx+4], 'DI'
      jz       SiwvidID
IsNTICE:
      cmp      dword ptr [edx], 'CITN'             ; NTICE ?
      jnz      Fice
      cmp      byte ptr [edx+4], 'E'
      jz       NTice
Fice:
      cmp      dword ptr [edx], 'GORF'             ; FROGSICE ?
      jnz      Quit_p
      cmp      dword ptr [edx+4], 'ECIS'
      jnz      Quit_p
      push     edx                                 ; saves w95 or 98 flag
      mov      edx, offset32 FrogsICEMsg
      call     Task2Msg
      mov      byte ptr [FrogsICEMsg+48], 'E'
      pop      edx
      mov      eax, edx
      push     edx
      mov      ebx, offset32 FrogsICEMsg+61
      call     HexASCII
      bswap    eax
      xchg     al,ah
      mov      ebx, offset32 FrogsICEMsg+57
      call     HexASCII
      push     offset32 FrogsICEMsg
      push     102
      call     Write2Log
      mov      ecx, offset32 FrogsICEMsg
      call     BlueScreenOfDeath
      mov      eax, 6
      call     CleanupMsg
      pop      eax       
      jmp      AlwaysFool      
NTice:
      mov      dword ptr [MeltICEMsg+92], 'CITN'
      mov      byte ptr [MeltICEMsg+96], 'E'
      jmp      MeltICE      
SiceID:
      mov      dword ptr [MeltICEMsg+92], 'ECIS'
      jmp      MeltICE
SiwvidID:
      mov      dword ptr [MeltICEMsg+92], 'VWIS'
      mov      word ptr [MeltICEMsg+96], 'DI'
MeltICE:
      push     edx
      mov      edx, offset32 MeltICEMsg
      call     Task2Msg
      mov      byte ptr [MeltICEMsg+48], 'B'
      pop      edx
      mov      eax, edx
      push     edx                                 ; saves w95 or 98 flag
      mov      ebx, offset32 MeltICEMsg+61
      call     HexASCII
      bswap    eax
      xchg     al,ah
      mov      ebx, offset32 MeltICEMsg+57
      call     HexASCII
      push     offset32 MeltICEMsg
      push     102
      call     Write2Log
      mov      ecx, offset32 MeltICEMsg
      call     BlueScreenOfDeath
      mov      eax, 2
      call     CleanupMsg
      pop      eax                                 ; restores edx (w95 or 98 flag) into eax
      cmp      Abort, 0
      jz       Quit_p
AlwaysFool:
      popad
      popfd
      xor      eax,eax                             ; clear address of the Device Description Block
      ret                                          ; and don't chain ;-)

Quit_p:
      popad
      popfd
      jmp      [MeltICEPrevHook]                   ; chain to previous hook

EndProc HookMeltICE


;----------------------------------------------------------------------------
;
; Hook VMM fault 01h to catch debug registers access
;
;----------------------------------------------------------------------------

BeginProc HookInt01

      pushfd
      pushad                    
      cmp      DrXFlag, 0
      jz       Quit
      mov      eax, dr6
      test     eax, 2000h                          ; test dr6 bit 13 (BD)
      jz       Quit
      mov      eax, dr7                            ; Set again GD
      or       eax, 2000h
      mov      dr7, eax
      mov      byte ptr [DrXMsg+48], 'A'
      call     _GetTaskName

      ; ensure it's not KERNEL32
      cmp      dword ptr [eax], 'NREK'
      jnz      GetName
      cmp      dword ptr [eax+4], '23LE'
      jz       Quit   
GetName:      
      mov      edx, offset32 DrXMsg
      call     Task2Msg
      ; ------------------------------
      ; fetch address of the dr access
      ; and insert it into msg
      ; ------------------------------
      mov      eax, [ebp.Client_EIP]
      mov      ebx, offset32 DrXMsg+64
      call     HexASCII
      bswap    eax
      xchg     al,ah
      mov      ebx, offset32 DrXMsg+60
      call     HexASCII
      mov      ax, [ebp.Client_CS]
      mov      ebx, offset32 DrXMsg+55
      call     HexASCII
      mov      ecx, [ebp.Client_EIP]
      mov      eax, [ecx+2]
      xchg     al,ah
      mov      ebx, offset32 DrXMsg+91
      call     HexASCII
      mov      word ptr [DrXMsg+93], 2820h
      ; ---------------------------------
      ; check if it's a "mov reg, drX" or 
      ; "mov drX, reg" instruction
      ; ---------------------------------
      mov      ebx, [ebp.Client_EIP]
      cmp      word ptr [ebx], 210fh               ; mov reg,drX ?
      jnz      CheckIfReg
      mov      dword ptr DrXMsg+87, '12fO'
      mov      ecx,5
      jmp      FetchDrX
CheckIfReg:
      cmp      word ptr [ebx], 230fh               ; is it a "mov drX, reg" ?
      jz       Reg2dr
      ; --------------------------------------
      ; don't know what it is :-(( 
      ; a decryption routine? => show opcodes
      ; --------------------------------------
      mov      ax, word ptr [ebx]
      xchg     al,ah
      mov      ebx, offset DrXMsg+87
      call     HexASCII
      mov      dword ptr [DrXMsg+95], ' ???'
      jmp      FillBuffer
Reg2dr:
      mov      dword ptr DrXMsg+87, '32f0'
      xor      ecx,ecx
      ; -------------------------------------------
      ; check which drX the soft tries to read from
      ; -------------------------------------------
FetchDrX:
      xor      eax, eax
      mov      al, byte ptr [ebx+2]
      mov      ah, al
      and      al, 0f8h
      cmp      al, 0f8h                            ; dr7 (11111xxxb) ?
      jnz       _dr6
      mov      ebx, 400h                           ; no Sice !
      mov      dword ptr [DrXMsg+98+ecx], '7rd '
      jmp      ChangeReg
_dr6:
      cmp      al,0f0h                             ; dr6 (11110xxxb) ?
      jnz       _dr0_3
      mov      ebx, 0ffff4ff0h
      mov      dword ptr [DrXMsg+98+ecx], '6rd '
      jmp      ChangeReg
_dr0_3:      
      xor      ebx, ebx                            ; no breakpoints in dr0-3
      cmp      al,0d8h                             ; dr3 (11011xxxb) ?
      jnz      _dr2
      mov      dword ptr [DrXMsg+98+ecx], '3rd '
      jmp      ChangeReg
_dr2:
      cmp      al,0d0h                             ; dr2 (11010xxxb) ?
      jnz      _dr1
      mov      dword ptr [DrXMsg+98+ecx], '2rd '
      jmp      ChangeReg
_dr1:
      cmp      al,0c8h                             ; dr1 (11001xxxb) ?
      jnz      _dr0
      mov      dword ptr [DrXMsg+98+ecx], '1rd '
      jmp      ChangeReg
_dr0:
      mov      dword ptr [DrXMsg+98+ecx], '0rd '   ; dr0 (11000xxxb)
      ; ----------------------------------------------------
      ; now, check opcode to see wich register should
      ; receive the drX value (usually eax, but who knows..)
      ; and fill it with our false values
      ; ----------------------------------------------------
ChangeReg:
      cmp      ecx,0
      jz       Add5
      xor      ecx,ecx
      jmp      _Opcodes
Add5:
      mov ecx,5
_Opcodes:
      and      ah, 7
      cmp      ah,7                                ; edi = xxxxx111b
      jnz       _esi
      mov      [ebp.Client_EDI], ebx
      mov      dword ptr [DrXMsg+98+ecx], 'ide '
      jmp      FillBuffer
_esi:
      cmp      ah, 6                               ; esi = xxxxx110b
      jnz       _ebx
      mov      [ebp.Client_ESI], ebx
      mov      dword ptr [DrXMsg+98+ecx], 'ise '
      jmp      FillBuffer
_ebx:
      cmp      ah, 3                               ; ebx = xxxxx011b
      jnz       _edx
      mov      [ebp.Client_EBX], ebx
      mov      dword ptr [DrXMsg+98+ecx], 'xbe '
      jmp      FillBuffer
_edx:
      cmp      ah, 2                               ; edx = xxxxx010b
      jnz       _ecx
      mov      [ebp.Client_EDX], ebx
      mov      dword ptr [DrXMsg+98+ecx], 'xde '
      jmp      FillBuffer
_ecx:
      cmp      ah,1                                ; ecx = xxxxx001b
      jnz       _eax
      mov      [ebp.Client_ECX], ebx
      mov      dword ptr [DrXMsg+98+ecx], 'xce '
      jmp      FillBuffer
_eax:      
      mov      [ebp.Client_EAX], ebx
      mov      dword ptr [DrXMsg+98+ecx], 'xae '
FillBuffer:
      cmp      BytesReturned, 4480
      je       BufferFull
      ja       ChangeEIP                           ; no more space in buffer
      mov      edi, offset32 OutBuffer
      add      edi, BytesReturned
      mov      esi, offset32 DrXMsg
      mov      ecx,28                              ; fill OutBuffer with 112 bytes from DrXMsg
      rep      movsd
      add      BytesReturned, 112
      jmp      ChangeEIP
BufferFull:
      add      BytesReturned, 23                   ; add the 'buffer full' message
      mov      DrXFlag, 0                          ; stop hook to avoid hangs up

ChangeEIP:
      add      [ebp.Client_EIP],3                  ; Add 3 bytes to Client_EIP so that EIP points
                                                   ; to the next instruction following the drX access.
      mov      eax, 3
      call     CleanupMsg                          ; cleanup msg
      popad
      popfd
      clc
      ret
Quit:
      popad
      popfd
      stc
      ret

EndProc HookInt01

;----------------------------------------------------------------------------
;
; Hook int21h procedure
;
;----------------------------------------------------------------------------
BeginProc      HookInt21

      pushad
      cmp      [ebp.Client_AX], 2503h
      jnz      TryNextInt
      mov      RedirectInt, 03h
      mov      IntID, 3
      jmp      DispatchIt_1
TryNextInt:
      cmp      [ebp.Client_AX], 2501h
      jnz      Quit_1
      mov      RedirectInt, 01h
      mov      IntID, 1
DispatchIt_1:
      mov      byte ptr [IntMsg+149],'>'
      mov      byte ptr [IntMsg+89],'>'
      mov      byte ptr [IntMsg+48], '8'
      call     DisplayAndLogIntInfos
      mov      RedirectInt,0
Quit_1:
      popad
      stc
      ret
EndProc        HookInt21

;----------------------------------------------------------------------------
;
; Hook int03h procedure
;
; check if we must force the exception filter (useful for VBoxed apps...)
;----------------------------------------------------------------------------

BeginProc HookInt3

      pushad
;     cmp      [ebp.Client_AL], 04h                ; removed because some encryptors
;     jnz      Quit_2                              ; don't use 'mov al,04h'.
      cmp      [ebp.Client_EBP], 'BCHK'
      jnz      GetNext
      mov      byte ptr [IntMsg+48], '1'
      mov      byte ptr [IntMsg+89],'>'
      mov      byte ptr [IntMsg+194],'>'
      jmp      DispatchIt_2
GetNext:
      cmp      [ebp.Client_SI],4647h
      jnz      Quit_2
      cmp      [ebp.Client_DI],4A4Dh
      jnz      Quit_2
      mov      byte ptr [IntMsg+48], '2'
      mov      byte ptr [IntMsg+164],'>'
      mov      byte ptr [IntMsg+179],'>'
DispatchIt_2:
      mov      IntID, 3
      call     DisplayAndLogIntInfos
      cmp      [Abort], 0
      jz       Quit_2
      cmp      Int3Exception, 1
      jnz      NoException
      mov      [ebp.Client_EAX], 0                 ; xor client eax
      sub      [ebp.Client_EIP],3                  ; back to caller eip-3 bytes
      mov      eax, [ebp.Client_EIP]               ; Patch client EIP
      mov      word ptr [eax],0f766h               ; with div eax opcodes (divide error)
      mov      byte ptr [eax+2], 0f0h              ; to force eventual (?) exception
NoException:
      popad
      clc
      ret
Quit_2:
      popad
      stc
      ret
EndProc        HookInt3

;----------------------------------------------------------------------------
;
; Hook int2fh procedure
;
;----------------------------------------------------------------------------

BeginProc      HookInt2F

      pushad
      cmp      [ebp.Client_AX], 1684h
      jnz      Quit_3
      mov      byte ptr [IntMsg+89],'>'
      cmp      [ebp.Client_BX], 0202h
      jnz      TryNext
      mov      byte ptr [IntMsg+48], '3'
      mov      byte ptr [IntMsg+104],'>'
      jmp      DispatchIt_3
TryNext:
      cmp      [ebp.Client_BX], 7a5fh
      jnz      Quit_3
      mov      byte ptr [IntMsg+104],'>'
      mov      byte ptr [IntMsg+48], '4'
DispatchIt_3:    
      mov      IntID, 2fh
      call     DisplayAndLogIntInfos
      cmp      [Abort], 0
      jz       Quit_3
      popad
      clc
      ret
Quit_3:
      popad
      stc
      ret
EndProc        HookInt2F

;----------------------------------------------------------------------------
;
; Hook int41h procedure
;
;----------------------------------------------------------------------------

BeginProc      HookInt41

      pushfd
      pushad
      cmp      [ebp.Client_AX], 4Fh
      jz       _@Next
      mov      bx, cs
      lea      dx, int41hdl
      xchg     dx, es:[41h*4]     
      xchg     bx, es:[41h*4+2]
      cmp      bx, [ebp.Client_CS]
      jnz      _Next
      mov      byte ptr [IntMsg+149],'>'
      mov      byte ptr [IntMsg+104],'>'
      mov      [Abort],1
_Next:
      xchg     dx, es:[41h*4]     
      xchg     bx, es:[41h*4+2]
      cmp      [Abort],0
      jz       Quit_4
      cmp      [ebp.Client_AX], 4Fh
      jnz      NextTrick
_@Next:
      mov      byte ptr [IntMsg+89],'>'
      mov      byte ptr [IntMsg+48], '5'
      jmp      DispatchIt_4
NextTrick:
      cmp      [ebp.Client_CX],0
      mov      byte ptr [IntMsg+119],'>'
      jnz      Quit_4
      mov      byte ptr [IntMsg+48], '6'
DispatchIt_4:
      mov      IntID, 41h
      call     DisplayAndLogIntInfos
      cmp      [Abort], 0
      jz       Quit_4
      popad
      popfd
      clc
      ret
Quit_4:
      popad
      popfd
      stc
      ret

EndProc        HookInt41


int41hdl       Proc
      iret
int41hdl       Endp

;----------------------------------------------------------------------------
;
; Hook int68h procedure
;
; Check if it is a 16 or 32Bit app to get the right
; cs:eip location of the detection (EBP.Client_EIP just
; doesn't work for 32bit apps calling int68h:-(
;
;----------------------------------------------------------------------------

BeginProc      HookInt68
 
      pushfd
      pushad
      cmp      [ebp.Client_AH], 43h
      jnz      Quit_5
      mov      byte ptr [IntMsg+89],'>'
      mov      byte ptr [IntMsg+48], '7'
      mov      IntID, 68h
      ; ---------------------------------------------------
      ; When hooking exec_int, [ebp+48h]=EIP of a 32Bit app
      ; otherwise [ebp+48h]=0 if it is a 16Bit one
      ; ---------------------------------------------------
      cmp      dword ptr [ebp+48h],0               ; works on both W95/98
      jz       Not32Bit
      mov      eax, [ebp+48h]
      mov      _32Bit,1
      jmp      DisplayStuff
Not32Bit:
      mov      eax, [ebp.Client_EIP]
      mov      _32Bit,0
DisplayStuff:      
      ; ---------------------------------------------------------
      ; Check if we already hooked this call to bypass
      ; CodeCrypt anti-FrogsICE look-alike routines.
      ; (note that this is useless if you disable
      ; the 'Log to file' option! ;-)
      ; ---------------------------------------------------------
      cmp      eax, dword ptr [Int68Buffer]
      je       FoolInt68                           ; already hooked => fool it, don't log
FillInt68Buff:
      mov      dword ptr [Int68Buffer], eax
      call     DisplayAndLogIntInfos
      cmp      [Abort], 0
      jz       Quit_5
FoolInt68:
      popad
      popfd
      clc
      ret
Quit_5:
      popad
      popfd
      stc
      ret

EndProc        HookInt68

;----------------------------------------------------------------------------
;
; Hook Get_DDB service 
;
;----------------------------------------------------------------------------

BeginProc HookGetDDBService, HOOK_PROC, DDBPrevHook, LOCKED

      pushfd
      cmp      ax,0202h                            ; SICE Vxd ID
      jz       Sice_
      cmp      ax,7a5Fh                            ; SIWVID VxD ID
      jnz      Quit_6
Sice_:
      pushad
      mov      byte ptr [IntMsg+48], '9'
      mov      IntID, 0
      call     FetchClientRegs
      mov      edx, offset32 IntMsg
      call     Task2Msg
      push     offset32 IntMsg
      push     212
      call     Write2Log
      mov      ecx, offset32 IntMsg
      call     BlueScreenOfDeath
      mov      eax, 1
      call     CleanupMsg      
      popad
      cmp      [Abort], 0
      jz       Quit_6
      xor      ecx, ecx                            ; not installed ;)
      popfd
      ret                                          ; don't chain
Quit_6:
      popfd
      jmp      [DDBPrevHook]                       ; chain to previous hook

EndProc HookGetDDBService

;----------------------------------------------------------------------------
;
; Hook VXDLDR_UnloadDevice service 
;
; The only purpose of this proc is to avoid any program
; to force frogsice.vxd to get unloaded.
;
; Note that it is useless if you patched FPLoader and FrogsICE with FPInstall
;----------------------------------------------------------------------------

BeginProc UnloadDevice, HOOK_PROC, VxDLdrPrevHook, LOCKED
  
      pushfd
      pushad
      cmp      dword ptr[edx], 'GORF'               ; check name of VxD
      jnz      FpLoader                             ; the soft wants to close
      cmp      dword ptr[edx+4],'ECIS'              ; FROGSICE?
      jnz      FpLoader
      call     _GetTaskName                         ; Is it Fploader.exe?
      cmp      dword ptr[eax], 'olpF'
      jnz      StopIt                               ; no: stop it
      cmp      dword ptr[eax+4], 'reda'
      jz       FpLoader                             ; yes: ok let it go
StopIt:
      popad
      popfd
      mov      eax,8                                ; error code : 'no such device'
      stc                                           ; operation failed, set carry
      ret
FpLoader:
      popad
      popfd
      jmp      [VxDLdrPrevHook]                     ; go ahead

EndProc UnloadDevice

;----------------------------------------------------------------------------
;                          
; HexASCII - Converts word to hex ASCII
;
; Entry: ax    -> Value
;        ds:bx -> address for the string
;
; Exit: Nothing
;
;----------------------------------------------------------------------------

BeginProc HexASCII

         push     cx
         push     dx
         mov      dx,4
HexASCII_1:
         mov      cx,4
         rol      ax,cl
         mov      cx,ax
         and      cx,0fh
         add      cx, 30h
         cmp      cx, 39h
         jbe      HexASCII_2
         add      cx, 0007h
HexASCII_2:
         mov      [ebx],cl
         inc      bx
         dec      dx
         jnz      HexASCII_1
         pop      dx
         pop      cx
         ret

EndProc HexASCII

;----------------------------------------------------------------------------
;
; DisplayAndLogInfos : prepare message to display and to log
;
;----------------------------------------------------------------------------

BeginProc      DisplayAndLogIntInfos

      call     FetchClientRegs
      call     _GetTaskName
      mov      edx, offset32 IntMsg
      call     Task2Msg
      push     offset32 IntMsg
      push     212
      call     Write2Log
      mov      ecx, offset32 IntMsg
      call     BlueScreenOfDeath
      mov      eax, 1
      call     CleanupMsg
      ret
      
EndProc      DisplayAndLogIntInfos

;----------------------------------------------------------------------------
;                          
; _GetTaskName : Fetch ring3 task name (up to 8 chars)
;                          
; Entry: none
;
; Exit : [eax] points to the first char
;
;----------------------------------------------------------------------------
BeginProc   _GetTaskName

      VxDCall  VWIN32_GetCurrentProcessHandle
      mov      eax,[eax+38h]
      or       al,7
      mov      Selector,eax    
      VmmCall  Get_Sys_VM_Handle
      mov      VM, ebx                                   ; System VM handle
      push     Flags
      push     Selector
      push     ebx
      VMMcall  _SelectorMapFlat
      add      esp, 0Ch                                  ; clean up stack
      add      eax, 0F2h
      ret
EndProc     _GetTaskName

;----------------------------------------------------------------------------
;                          
; Task2Msg : Insert task name into message buffer
;                          
; Entry: edx = message offset
;
; Exit : none
;
;----------------------------------------------------------------------------

BeginProc Task2Msg

      mov      ecx, 3
@Loop:
      cmp      byte ptr[eax],0
      jz       @Next
      mov      bl, byte ptr[eax]
      mov      byte ptr [edx+ecx], bl
      cmp      ecx,0ah
      jz       @Next
      inc      ecx
      inc      eax
      jmp      @Loop
@Next:
      ret
EndProc Task2Msg

;----------------------------------------------------------------------------
;                          
; CleanMsg : Erase buffer infos added by previous hook(s)
;                          
; Entry: eax :  1=IntMsg / 2=MelticeMsg / 3=DrXMsg / 4=VWin32Int41Msg 
;               5=RegKeyMsg / 6=FrogsICEMsg
;
; Exit : none
;
;----------------------------------------------------------------------------

BeginProc CleanupMsg

      cmp      eax, 1
      jnz      CleanMeltICEMsg
      mov      dword ptr [IntMsg+3], '   ?'
      mov      dword ptr [IntMsg+7], '    '
      mov      byte ptr [IntMsg+85], ' '
      mov      byte ptr [IntMsg+89], ' '      ; delete the '>' signs
      mov      byte ptr [IntMsg+104],' '      ;
      mov      byte ptr [IntMsg+119],' '      ;
      mov      byte ptr [IntMsg+149],' '      ;
      mov      byte ptr [IntMsg+164],' '      ;
      mov      byte ptr [IntMsg+179],' '      ;
      mov      byte ptr [IntMsg+194],' '      ;
      jmp      AllClean
CleanMeltICEMsg:
      cmp      eax,2
      jnz      CleanDrXMsg
      mov      dword ptr [MeltICEMsg+3], '   ?'
      mov      dword ptr [MeltICEMsg+7], '    '
      mov      dword ptr [MeltICEMsg+92], '    '
      mov      word ptr [MeltICEMsg+96], '  '
      jmp      AllClean
CleanDrXMsg:
      cmp      eax,3
      jnz      CleanVWin32Msg
      mov      dword ptr [DrXMsg+3],'   ?'
      mov      dword ptr [DrXMsg+7], '    '
      mov      dword ptr [DrXMsg+95], ' vom'
      mov      dword ptr [DrXMsg+98], '    '
      mov      dword ptr [DrXMsg+98], '    '     
      jmp      AllClean
CleanVWin32Msg:
      cmp      eax, 4
      jnz      CleanRegKeyMsg
      mov      dword ptr [VWin32Int41Msg+3], '   ?'
      mov      dword ptr [VWin32Int41Msg+7], '    '
      jmp      AllClean
CleanRegKeyMsg:
      cmp      eax, 5
      jnz      CleanFrogsICEMsg
      mov      dword ptr [RegKeyMsg+3],'   ?'
      mov      dword ptr [RegKeyMsg+7], '    '
      jmp      AllClean
CleanFrogsICEMsg:
      mov      dword ptr [FrogsICEMsg+3], '   ?'
      mov      dword ptr [FrogsICEMsg+7], '    '
AllClean:
      ret

EndProc  CleanupMsg

;----------------------------------------------------------------------------
;                          
; FetchClientRegs : Fetch registers values and insert into message
;                          
; Entry: none
;
; Exit : none
;
;----------------------------------------------------------------------------

BeginProc   FetchClientRegs

      mov      [Abort],0
      cmp      RedirectInt,0                    ; Anti-SIce trick or Int redirection?
      jz       NoRedir
      mov      dword ptr [IntMsg+19], "NI  "
      mov      dword ptr [IntMsg+23], "ER T"
      mov      dword ptr [IntMsg+27], "ERID"
      mov      dword ptr [IntMsg+31], "OITC"
      mov      word ptr  [IntMsg+35], " N"
      jmp      Redir
NoRedir:
      mov      dword ptr [IntMsg+20], "tfoS"
      mov      dword ptr [IntMsg+24], " ECI"
      mov      dword ptr [IntMsg+28], "eted"
      mov      dword ptr [IntMsg+32], "oitc"
      mov      byte ptr [IntMsg+36],"n"
Redir:
      cmp      _32Bit, 1
      jnz      Fetch16BitEIP
      mov      eax, dword ptr [ebp+48h]
      jmp      DecrementEip
Fetch16BitEIP:
      mov      eax, [ebp.Client_EIP]
      cmp      IntID,0
      jz       NoSub
DecrementEip:
      sub      ax,2
NoSub:
      mov      ax, [ebp.Client_CS]
      mov      ebx, offset32 IntMsg+55
      call     HexASCII
      mov      byte ptr [IntMsg+59], ':'
      mov      ebx, offset32 IntMsg+64
      call     HexASCII
      bswap    eax
      xchg     al,ah
      mov      ebx, offset32 IntMsg+60
      call     HexASCII
      mov      eax, [ebp.Client_EAX]
      bswap    eax
      xchg     al,ah
      mov      ebx, offset32 IntMsg+94
      call     HexASCII
      mov      eax, [ebp.Client_EBX]
      bswap    eax
      xchg     al,ah
      mov      ebx, offset32 IntMsg+109
      call     HexASCII
      mov      eax, [ebp.Client_ECX]
      bswap    eax
      xchg     al,ah
      mov      ebx, offset32 IntMsg+124
      call     HexASCII
      mov      eax, [ebp.Client_EDX]
      bswap    eax
      xchg     al,ah
      mov      ebx, offset32 IntMsg+154
      call     HexASCII
      mov      eax, [ebp.Client_ESI]
      bswap    eax
      xchg     al,ah
      mov      ebx, offset32 IntMsg+169
      call     HexASCII
      mov      eax, [ebp.Client_EDI]
      bswap    eax
      xchg     al,ah
      mov      ebx, offset32 IntMsg+184
      call     HexASCII
      mov      eax, [ebp.Client_EBP]
      bswap    eax
      xchg     al,ah
      mov      ebx, offset32 IntMsg+199
      call     HexASCII        
      xor      eax,eax
      cmp      IntID, 0
      jz       NoInt
      mov      ah, [IntID]
      mov      ebx, offset32 IntMsg+85
      call     HexASCII
      mov      word ptr [IntMsg+87],2068h
      jmp      JmpOver
NoInt:
      mov      word ptr [IntMsg+86], 'xx'
JmpOver:      
      mov      ax, [ebp.Client_AX]
      mov      ebx, offset32 IntMsg+98
      call     HexASCII
      mov      ax, [ebp.Client_BX]
      mov      ebx, offset32 IntMsg+113
      call     HexASCII
      mov      ax, [ebp.Client_CX]
      mov      ebx, offset32 IntMsg+128
      call     HexASCII
      mov      ax, [ebp.Client_DX]
      mov      ebx, offset32 IntMsg+158
      call     HexASCII
      mov      ax, [ebp.Client_SI]
      mov      ebx, offset32 IntMsg+173
      call     HexASCII
      mov      ax, [ebp.Client_DI]
      mov      ebx, offset32 IntMsg+188
      call     HexASCII
      mov      ax, [ebp.Client_BP]
      mov      ebx, offset32 IntMsg+203
      call     HexASCII    

      ret
EndProc     FetchClientRegs

;----------------------------------------------------------------------------
;                          
; BlueScreenOfDeath : Display infos on screen if required
;                          
; Entry: ecx= offset of message to display
;
; Exit : none
;
;----------------------------------------------------------------------------

BeginProc   BlueScreenOfDeath

      cmp      DisplayFlag, 1                   ; Display sysmodal_message ?
      jz       DisplayInfos
      mov      eax, IDYES                       ; force it to fool app
      jmp      NoDisplay
DisplayInfos:
      mov      ebx, VM                          ; System VM handle in ebx
      mov      eax, MB_YESNOCANCEL
      mov      edi, OFFSET32 TitleMsg           ; Prepare title
      VxDcall  SHELL_SYSMODAL_Message           ; Dispatch it all
NoDisplay:
      cmp      eax, IDNO
      jz       LetItRun
      cmp      eax, IDCANCEL
      jnz      FoolIt
      mov      DisplayFlag,0                    ; Disable BSOD
FoolIt:
      mov      [Abort], 1                       ; Don't execute int
      ret
LetItRun:
      mov      [Abort], 0                       ; Execute int
      ret

EndProc     BlueScreenOfDeath

;----------------------------------------------------------------------------
;                          
; Write2Log : Creates/writes to log file
;                          
; Entry: - ebp+08h= nb of bytes to write
;        - ebp+0ch= offset of message to write
;
; Exit : none
;
;----------------------------------------------------------------------------

BeginProc   Write2Log

      push     ebp
      mov      ebp, esp
      cmp      LogToFile, 1                     ; log infos?
      jnz      @GoAhead
      ;------------------------
      ; Open or Create log file
      ;------------------------
      mov      eax, R0_OPENCREATFILE
      mov      ebx, 2
      mov      cx,20h                           ; Bitfields for file create attribute: bit 5 = archive
      mov      edx, 11h                         ; Bitfields for action: bit 0 and 4 to open if it exists
                                                ; or create if it doesn't
      mov      esi, offset32 FileName
      VxDCall  IFSMgr_Ring0_FileIO
      jc       @IOError
      mov      ebx, eax                         ; stores handle in ebx
      ;--------------
      ; get file size
      ;--------------
      mov      eax, R0_GETFILESIZE
      VxDCall  IFSMgr_Ring0_FileIO
      mov      edx, eax                         ; file size in byte(s)
      ;------------------
      ; Write to log File
      ;------------------
      mov      eax, R0_WRITEFILE
      mov      esi, [ebp+0ch]                   ; msg to write to
      mov      ecx, [ebp+08h]                   ; number of byte to write
      VxDCall  IFSMgr_Ring0_FileIO
      ;---------------
      ; close log file
      ;---------------
      mov      eax, R0_CLOSEFILE
      VxDCall  IFSMgr_Ring0_FileIO
      jmp      @GoAhead
@IOError:
      mov      ebx, VM
      mov      eax, MB_OK
      mov      ecx, OFFSET32 IOErrorMsg
      mov      edi, OFFSET32 TitleMsg
      VxDcall  SHELL_SYSMODAL_Message           ; Dispatch log file error message
@GoAhead:
      pop      ebp
      retn     08h

EndProc     Write2Log

VXD_LOCKED_CODE_ENDS

end
;---------------------------------  T H A T ' S  A L L ------------------------------------