// PEDUMP Plugs for TRW2000 for Windows 9x
// Copyright (C) , 1999-2000 ,
//
// History :
//	2000.2.24	Liutaotao write origin code, 
//				Zhunanhao move it from TRW2000 main code to plug-ins.
//
// Note:
//	This is source of PEDUMP! Please modify it to improve!
//

#include <wdm.h>
#include "..\INCLUDE\PLUGS.H"

// prototypes

EXC NTSTATUS
DriverEntry(IN PDRIVER_OBJECT DriverObject, IN PUNICODE_STRING RegistryPath);

VOID
PLUGS_Unload(IN PDRIVER_OBJECT DriverObject);


NTSTATUS
DriverEntry(IN PDRIVER_OBJECT DriverObject, IN PUNICODE_STRING RegistryPath)
{
	NTSTATUS	ntStatus = STATUS_SUCCESS;

	DriverObject->DriverUnload = PLUGS_Unload;

	return ntStatus;
}

VOID
PLUGS_Unload(IN PDRIVER_OBJECT DriverObject)
{
}

/****************** WDM Rountine End ****************/

// prototype

BOOL	cmd_PEdump(int argc,PSTR* argv);

// end

PLUGS_API* api = 0 ;
// Call TRW2000 API must like this:
//      api->Add_Command ( ) ;

EXC EXPORT BOOL Plugs_Init ( PLUGS_API* plugsapi)
{
	api=plugsapi;	

	api->Add_Command(	"PEDUMP", "[filename]",
						"Dump PE image to 'dump1.exe',or specify file", 
						0,
						cmd_PEdump );

	api->dprintf ( "PEDUMP Plugs Ver 0.01 Initialized..." ) ;

	return TRUE ;
}

EXC EXPORT BOOL Plugs_Exit ( )
{
	return TRUE ;
}

/***************** Command ***************/


// Command : PEDUMP

#include "MYPE.H"

#define	MTEindex_in_Pdb_2a	0x2a
#define PM					((PIMTE *)pd(api->GetMTElist()))

DWORD		fpos;
PSTR		savMakePEFilename;
EXC	BYTE	DOSEXE;

EXC	VOID	R3_read(PVOID p,DWORD len);

VOID	cmd_PEdump_();
VOID	R3_PEdump_Read();

BOOL	cmd_PEdump(int argc,PSTR* argv)
{
	if( *(api->pfPM)==0 || *(api->pfUserVM)!=0 ) {
		api->dprintf( "Can not run PEDUMP now" );
		return TRUE;
	}
	
	if( argc>0 )
		savMakePEFilename = api->new_STRING(argv[0]);
	else
		savMakePEFilename = 0;
	
	api->Ring3_CallBack( R3_PEdump_Read,cmd_PEdump_ );
	//**************************************************
	// About the technic of PEDUMP 
	// First, we need to force that the memory is not page out, so
	// we must return to ring3 and read the memory there----
	// if we read it from ring0, Win95 will crash--- so, it's 
	// very important. 
	// Second, how can we return to ring3 then go to ring0
	// and enter TRW2000 again? OK, we must use "Ring3_CallBack",
	// the first parameter is ring3 callback, the second is	
	// ring0 callback.
	// When you call Ring3_CallBack, you can return to ring3 and 
	// go to the callback you pass to Ring3_CallBack, then, the
	// routine in ring3 completed, the control will be return to
	// TRW2000 kernel, the kernel will pass it to ring0 callback
	// again.
	// You can use this function to do some very-difficult things. :)
	//**************************************************
	
	api->Set_Leave_Kernel();
	return TRUE;		
}

VOID	writeOBJ(HANDLE h,PBYTE p,DWORD size)
{
	api->dprintf("Writing %x len %x",p,size);
	if( size==0 )
		return;
	while(size> 0x1000){
		if( api->ifReadable_flat((DWORD)p)==FALSE )	
			return;
		api->fwrite(h,p,0x1000);
		size -= 0x1000;
		p += 0x1000;
	}
	if( api->ifReadable_flat((DWORD)p)==FALSE )	
		return;
	api->fwrite(h,p,size);
}

VOID	cmd_PEdump_()
{
	fpos=0;
	api->dprintf("PE dump\n");

	DWORD d=0,Drva=0,psh,headlen;
	d=pw(*(api->pCur_Process_DB) + MTEindex_in_Pdb_2a);
	PIMTE pimte= PM[d];
	d= pd(pimte);

	PmyPE oPE = (PmyPE)pimte->pNTHdr;

#define base oPE->ImageBase
#define nsec oPE->NumberOfSections
#define align oPE->SectionAlignment

// ------------------------------------------

	headlen = oPE->SizeOfOptionalHeader + 24;
	if( headlen!= 0xf8 ){
		api->dprintf("Curious!");
	}
	psh = (DWORD)oPE+headlen;
	api->dprintf("VirtualSize RVA PhysicalSize PhysicalOffset");

//			27aa 1000 2800  400
//			0069 4000 0200 2c00
//			2264 5000 1000 2e00
//			02b0 8000 0400 3e00
//			0384 9000 0400 4200

    api->dprintf("----------");
    for(int i=0;i<nsec;i++ ) {
		PObject_Table p;
		(DWORD &)p=psh+i*40;
		api->dprintf("%8x %8x %8x %8x",
				p->VirtualSize,
				p->RVA,
				p->PhysicalSize,
				p->PhysicalOffset);

		p->PhysicalOffset = p->RVA;	//important!!!
		p->PhysicalSize   = p->VirtualSize;	//petite 2.1 need this
	}
	
// ------------------------------------------
	
	api->Begin_Nest_VMM_Exec();
	// IMPORTANT!
	// Begin/End_Nest_VMM_Exec is a high-level-control functions.
	// When you call Begin_Nest_VMM_Exec, TRW2000 will not capture 
	// any interrupt. It means that you can use SoftICE to debug 
	// your plug-ins or you can call some non-reenter functions  
	// of Win95, e.g: Ring0 FileIO. as below( fopen ):
	// We call this status is "free-debug".
	// After you call Begin_Nest_VMM_Exec, you must call End_Nest_VMM_exec
	// to end "free-debug", or TRW2000 will be crash!
	// 
	// Because API "fopen" is call Win95 ring0 fileio, it's non-reenter,
	// so we must call Begin_Nest_VMM_Exec first.
	
	HANDLE h;
	if( savMakePEFilename ) {
		h=api->fopen(savMakePEFilename,FS_GENERALREPLACE|FS_ACCESS);
		api->free(savMakePEFilename);
		savMakePEFilename=0;
	}
	else
		h=api->fopen("DUMP1.EXE",FS_GENERALREPLACE|FS_ACCESS);
	
	if( DWORD(h)==0) {
		api->End_Nest_VMM_Exec();
		return;
	}	

	oPE->AddressOfEntryPoint = api->pUser->CRS.Client_EIP - base;

	DWORD len=0x80+headlen+nsec*40;
	api->dprintf("Writing DOS head");
  	api->fwrite(h,&DOSEXE,0x80);

	api->dprintf("Writing PE head, from %x, len %x+%x",oPE,headlen,nsec*40);
	api->fwrite(h,oPE,headlen);					//write PE head
	api->fwrite(h,(PSTR)psh,nsec*40);
	DWORD max=0;
    for(i=0;i<nsec;i++ ){
		PObject_Table p;
		(DWORD &)p=psh+i*40;
		DWORD d=p->RVA + p->VirtualSize;
		if( d> max )
			max=d;
	}

	writeOBJ(h,(PBYTE)base+len, max -len );

	api->fclose(h);

	api->End_Nest_VMM_Exec();
}

void	R3_PEdump_Read()
{
	DWORD d=0,Drva=0,psh,headlen;
	d=pw(*(api->pCur_Process_DB) + MTEindex_in_Pdb_2a);
	PIMTE pimte= PM[d];
	d= pd(pimte);

	PmyPE oPE = (PmyPE)pimte->pNTHdr;

#define base oPE->ImageBase
#define nsec oPE->NumberOfSections
#define align oPE->SectionAlignment

// ------------------------------------------

	headlen = oPE->SizeOfOptionalHeader + 24;
	psh = (DWORD)oPE+headlen;

	DWORD len=0x80+headlen+nsec*40;
	R3_read(oPE,headlen);					//write PE head
	R3_read((PSTR)psh,nsec*40);
	DWORD max=0;
    for(int i=0;i<nsec;i++ ){
		PObject_Table p;
		(DWORD &)p=psh+i*40;
		DWORD d=p->RVA + p->VirtualSize;
		if( d> max )
			max=d;
	}	
	R3_read((PSTR)base+len,	max -len );
}
