10 '-----------  REALTIME.BAS by E. W. Schwittek & W. G. Schwittek  -----------
20 '
30 '
40 '---------------------------  Initialization  -----------------------------
50 CLEAR ,20480
60 CLS:KEY OFF
70 DEFINT A-Z:H=20480:K=H/16
80 '
90 '------------------------  Select color adapter  --------------------------
100 DEF SEG=0
110 POKE &H410,(PEEK(&H410)AND &HCF)OR &H10
120 SCREEN 1,0,0,0:SCREEN 0
130 WIDTH 80:LOCATE ,,1,6,7:DEF SEG
140 '
150 '--------------------------  Introduction  -------------------------------
160 LOCATE 4,18:PRINT"REALTIME.BAS by E. W. Schwittek & W. G. Schwittek"
170 LOCATE 6,29:PRINT"Last revision - 06/26/84"
180 LOCATE 9,11:PRINT"This program  records and displays a four-color WEFAX picture"
190 PRINT TAB(11)"in real time. An RGB monitor is used in the medium-resolution"
200 PRINT TAB(11)"mode.  The program allows selection of background and palette"
210 PRINT TAB(11)"colors and  permits storage of  the picture on  disk or  hard"
220 PRINT TAB(11)"copy using the IBM or Epson dot matrix printer."
230 LOCATE 22,29,0:PRINT"Press any key to continue";
240 IF INKEY$=""GOTO 240
250 '
260 '----------------------------Main Menu  ---------------------------------
270 DEF SEG:SCREEN 0:WIDTH 80:CLS:LOCATE 3,5:PRINT"Menu:"
280 PRINT:PRINT TAB(10)"1) Choose colors":PRINT TAB(10)"2) Load saved views from disk"
290 PRINT TAB(10)"3) Record new data":PRINT:PRINT TAB(10)"q) Quit program"
300 LOCATE 14,5:PRINT"Selection: ";
310 S$=INKEY$:IF S$=""GOTO 310
320 IF S$="Q"OR S$="q"GOTO 990
330 S=VAL(S$):IF S<1 OR S>3 THEN SOUND 100,5:GOTO 310
340 LOCATE 14,16:PRINT S$
350 ON S GOTO 380,570,670
360 '
370 ' Selection #1 ---  Select background and palette color  -----------------
380 CLS:LOCATE 3,5:PRINT"Background color (0 to 15):":PRINT
390 PRINT TAB(10)"0: Black"TAB(25)"8: Gray"
400 PRINT TAB(10)"1: Blue"TAB(25)"9: Light Blue"
410 PRINT TAB(10)"2: Green"TAB(24)"10: Light Green"
420 PRINT TAB(10)"3: Cyan"TAB(24)"11: Light Cyan"
430 PRINT TAB(10)"4: Red"TAB(24)"12: Light Red"
440 PRINT TAB(10)"5: Magenta"TAB(24)"13: Light Magenta"
450 PRINT TAB(10)"6: Brown"TAB(24)"14: Yellow"
460 PRINT TAB(10)"7: White"TAB(24)"15: High Intensity White"
470 LOCATE 14,5:INPUT"Type background color selection (0 to 15) and press <ENTER>: ",BK$:BK=VAL(BK$)
480 IF BK<0 OR BK>15 THEN SOUND 100,5:LOCATE 14,5:PRINT SPACE$(74):GOTO 470
490 LOCATE 17,5:PRINT"Palette (0 or 1):":PRINT
500 PRINT TAB(10)"0: Green, Red, and Brown"
510 PRINT TAB(10)"1: Cyan, Magenta, and White"
520 LOCATE 22,5:INPUT"Type palette selection (0 or 1) and press <ENTER>: ",PA$:PA=VAL(PA$)
530 IF PA<0 OR PA>1 THEN SOUND 100,5:LOCATE 22,5:PRINT SPACE$(74):GOTO 520
540 GOTO 270
550 '
560 ' Selection #2  ------  BLOAD graphics screen  ---------------------------
570 CLS:LOCATE 10,5,1:PRINT"Load from which drive (A or B)";
580 D$=INKEY$:IF D$=""GOTO 580
590 IF D$<>"a"AND D$<>"A"AND D$<>"b"AND D$<>"B" THEN SOUND 100,5:GOTO 580
600 D$=D$+":":CLS:FILES D$+"*.vu"
610 PRINT:LOCATE ,20:INPUT"Filename to load (include extension): ",B$
620 B$=D$+B$:SCREEN 1,0:COLOR BK,PA
630 DEF SEG=&HB800:BLOAD B$,0
640 IF INKEY$="" GOTO 640 ELSE 270
650 '
660 ' Selection #3  -----------  Saving picture  -----------------------------
670 CLS:LOCATE 10,10:PRINT"Do you want to save the picture on disk (Y/N)? ";
680 A$=INKEY$:IF A$=""GOTO 680
690 IF A$="N"OR A$="n"GOTO 820
700 IF A$="Y"OR A$="y"GOTO 720
710 BEEP:GOTO 680
720 LOCATE 18,10:PRINT"Save on which drive (A or B)? ";
730 D$=INKEY$:IF D$=""GOTO 730
740 IF D$<>"a"AND D$<>"A"AND D$<>"b"AND D$<>"B" THEN SOUND 100,5:GOTO 720
750 LOCATE 18,40:PRINT D$
760 LOCATE 20,10:INPUT"Filename (8 char max/press <ENTER> to quit): ",B$
770 IF B$=""GOTO 670
780 IF LEN(B$)>8 THEN SOUND 100,5:LOCATE 20,5:PRINT SPACE$(34):GOTO 760
790 B$=D$+":"+B$+".VU"
800 '
810 '---------------------Load machine procedure------------------------------
820 RESTORE
830 FOR F=20480 TO 20719
840 READ G:POKE F,G
850 NEXT F
860 '
870 '----------------------  Call machine procedure  -------------------------
880 CLS:LOCATE 9,13:PRINT"Press ANY KEY to signify that you are ready for picture"
890 PRINT TAB(14)"recording to commence when the next sync pulse occurs."
900 IF INKEY$=""GOTO 900
910 CLS:SCREEN 1,0:COLOR BK,PA
920 CALL H(K)
930 '
940 '-----------------------  Save picture on disk  --------------------------
950 IF A$="Y"OR A$="y"THEN DEF SEG=&HB800:BSAVE B$,0,&H4000
960 IF INKEY$=""GOTO 960 ELSE 270
970 '
980 '---------------------------  Quit program  ------------------------------
990 CLS:LOCATE 20,10:PRINT"== Done ==":KEY ON:END
1000 '
1010 '-----------  Data checking program / N = 240 / SUM = 20324  -------------
1020 CLS:SUM=0:N=0
1030 READ D:IF D=-9999 THEN 1050
1040 N=N+1:SUM=SUM+D:GOTO 1030
1050 IF N<>240 THEN BEEP:LOCATE 10,10:PRINT"Number of data terms not correct.  Check data for errors.":END
1060 IF SUM<>20324 THEN BEEP:LOCATE 10,10:PRINT"Sum of data not correct.  Check data for errors.":END
1070 LOCATE 10,10:PRINT"Sum of data is correct.":END
1080 '
1090 '----------------  Data for machine language procedure  ------------------
1100 DATA &H55,&H8B,&HEC,&H06,&H16,&H1E,&H8B,&H76
1110 DATA &H06,&H8B,&H04,&H8B,&HF0,&H8C,&HC8,&H03
1120 DATA &HC6,&H05,&H0E,&H00,&H8E,&HD8,&HB8,&H00
1130 DATA &HB8,&H8E,&HC0,&H2B,&HC0,&H2B,&HFF,&HBB
1140 DATA &H00,&H00
1150 DATA &HB9,&HFF,&H00,&HBA,&H01,&H02,&HEC
1160 DATA &H3C,&H40,&H73,&HF8,&HE2,&HF6,&HBA,&H01
1170 DATA &H02,&HEC,&HD0,&HD0,&HD0,&H16,&H00,&H00
1180 DATA &HD0,&HD0,&HD0,&H16,&H00,&H00,&HB8,&H3C
1190 DATA &H00,&HA3,&H05,&H00,&HFF,&H0E,&H05,&H00
1200 DATA &H75,&HFA,&HFE,&H0E,&H02,&H00,&H75,&H08
1210 DATA &HC6,&H06,&H02,&H00,&H04,&HEB,&H0F,&H90
1220 DATA &HFF,&H0E,&H09,&H00,&H75,&HFA,&HC7,&H06
1230 DATA &H09,&H00,&H01,&H00,&HEB,&HC8,&HA0,&H00
1240 DATA &H00,&H26,&H88,&H01,&H47,&HFE,&H0E,&H03
1250 DATA &H00,&HC6,&H06,&H00,&H00,&H00,&H75,&HB6
1260 DATA &HC6,&H06,&H03,&H00,&H50,&H80,&H2E,&H01
1270 DATA &H00,&H00,&H75,&H0D,&HBB,&H00,&H20,&HFE
1280 DATA &H06,&H01,&H00,&H83,&HEF,&H50,&HEB,&H0E
1290 DATA &H90,&HBB,&H00,&H00,&HFE,&H0E,&H01,&H00
1300 DATA &H83,&HC7,&H00,&HEB,&H01,&H90,&HB8,&H32
1310 DATA &H3C,&HA3,&H07,&H00,&HFF,&H0E,&H07,&H00
1320 DATA &H75,&HFA,&HA3,&H07,&H00,&HFF,&H0E,&H07
1330 DATA &H00,&H75,&HFA,&HA3,&H07,&H00,&HFF,&H0E
1340 DATA &H07,&H00,&H75,&HFA,&HA3,&H07,&H00,&HFF
1350 DATA &H0E,&H07,&H00,&H75,&HFA,&HFE,&H0E,&H04
1360 DATA &H00,&H74,&H03,&HE9,&H60,&HFF,&H1F,&H17
1370 DATA &H07,&H8B,&HE5,&H5D,&HCA,&H02,&H00,&H00
1380 DATA &H00,&H00,&H00,&H00,&H00,&H00,&H00
1390 DATA &H00,&H00,&H04,&H50,&HC8,&H00,&H00,&H00
1400 DATA &H00,&H01,&H00,&H00,&H00,&H00,&H00,&H00
1410 DATA-9999
