title		MAGSEE.ASM ;derived from SEE_IT.ASM for use in
;			  MAGNIFY.BAS
 
;		by: e. w. schwittek   revised 5/18/84

page ,132

data 		segment
init_es		dw 0 ;initial value of es for data fm SEE_IT.BAS
lines		db 0 ;nr of lines of graphics per seg of data
init_si		dw 0 ;value of init setting of si fm SEE_IT.BAS
samperbyte	dw 0 ;nr of data samples per data byte fm SEE_IT.BAS
skip		dw 0 ;nr of bytes skipped after each graphic line
count_sample	dw ? ;samples/data byte
count_line	db ? ;nr of lines per segment of data
fullbyte	db 0 ;sample collection byte
counter		db 0
holdcount	db 0
count_80	db 80 ;bytes per graphic display line
count_200	db 200 ;lines per picture
counter200	db 0 ;to be set by count_200
data		ends

code		segment
start		proc far
		assume ds:data,cs:code

;this gets init_si,samperbyte,and init_es fm SEE_IT.BAS
		push bp ;save bp
		mov bp,sp ;get current stack position into bp
		mov si,[bp]+12 ;get addr of init_si into si
		mov ax,[si] ;get value of init_si 
		push ax ;put init_si on stack for storage
		mov si,[bp]+10 ;get addr of samperbyte into si
		mov ax,[si] ;get value of samperbyte
		push ax ;put samperbyte on stack for storage
		mov si,[bp]+8 ;get addr of init_es into si
		mov ax,[si] ;get value of init_es
		push ax ;put init_es on stack for storage
		mov si,[bp]+6 ;get addr of para O, offset
		mov ax,[si] ;get value of O
		push ax ;put O on stack for storage

;establish addressability for data segment
		mov ax,cs 
		pop si ;put offset/16 in si
		add ax,si
		add ax,19 ;diff between cs & ds
		mov ds,ax


		pop init_es ;put init_es into data seg
		pop samperbyte ;put samperbyte into data seg
		pop init_si ;put init_si into data seg

;initiate registers and counters
		sub cx,cx
		sub di,di
		sub bx,bx
		mov si,init_si
 
		cmp samperbyte,4
		jz four
		cmp samperbyte,2
		jz two
		cmp samperbyte,1
		jmp one
four:		mov skip,240
		mov lines,200
		mov cl,1
		mov holdcount,1
		jmp together
two:		mov skip,480
		mov lines,100
		mov cl,3
		mov holdcount,2
		jmp together
one:		mov skip,960
		mov lines,50
		mov cl,1
		mov holdcount,4
together:	mov ax,samperbyte
		mov count_sample,ax
 
		mov al,holdcount
		mov counter,al
 
		mov al,count_200
		mov counter200,al
 
		mov al,lines
		mov count_line,al

;begin transfer of data from four segments to graphic memory
begin:     	mov ax,init_es
		mov es,ax ;establish es register

;get proper sample bits from data
newbyte:	mov al,es:[si] ;data byte to al from x000:xxxx
sample:		rcl al,cl ;rotate byte cl places left thru CF
		rcl fullbyte,1 ;bit into fullbyte
		rcl al,1 ;rotate another bit into CF
		rcl fullbyte,1 ;another bit into fullbyte
		dec count_sample ;nr of samples/data byte fm input_2
		jnz sample
		mov ax,samperbyte
		mov count_sample,ax ;reset counter
		inc si ;set si for next data byte
		dec counter ;determine if fullbyte is full
		jnz newbyte
		mov al,holdcount
		mov counter,al

;put fullbyte into graphics memory
		mov ax,0b800h
		mov es,ax ;set es to 0b800h
		mov al,fullbyte
		mov es:[bx+di],al ;puts fullbyte in graphics memory
		inc di ;set di for next fullbyte
		dec count_80 ;creates line of 80 fullbytes
		jnz begin
		mov count_80,80 ;reset counter

;determine which graphics mem area in use
		sub bx,0000h
		jnz upper ;upper area at b800:2000 in use

;lower in use
		mov bx,02000h ;change to upper graphics range
		sub di,80 ;set di to beginning of next line
		jmp joint

;upper in use
upper:		mov bx,0000h ;change to lower graphics range
		add di,0 ;sets di to beginning of next line
		jmp joint

;following related to nr of lines of graphics completed
;and picture area selected in basic program
 
joint:		dec counter200 ;count total picture lines
		jz finish
		
		add si,skip ;skip bytes and lines
 
		dec count_line ;determines data es change
		jnz begin
		mov al,lines
		mov count_line,al
		mov si,init_si ;reset si
		add init_es,01000h ;advance es by 1000h
		;when next jump to begin occurs

		jmp begin

finish:		mov ax,ss
		mov ds,ax ;restore ds
		mov es,ax ;restore es

		pop bp ;restore stack
		ret 8 ;far return to basic
start		endp
code		ends
		end
 
