/*
 *
 *  exo port sweeper v0.4 
 *
 *  1999 by Mixter <mixter@newyorkoffice.com>
 *
 *  Changes by Lez <lezli@alarmix.net>
 *
 */

#include "exo.h"

u32 source;
char nstart[BS], nstop[BS];
unsigned short scantype;
unsigned int range[2];
int delay;
time_t now;
u16 ipid;
FILE *in, *out;

void finish (int);

int
main (int argc, char **argv)
{
  int opt, input = 0;		/* 0: file 2: net */
  char buffer[BS], infile[BS];

  /* set defaults */
  range[0] = 1;
  range[1] = 65535;
  delay = 0;
  in = stdin;
  out = stdout;
  scantype = 0;
  findip (buffer);
  source = inet_addr (buffer);

  while ((opt = getopt (argc, argv, "t:p:i:s:e:o:d:")) != EOF)
    switch (opt)
      {
      case 't':
	scantype = atoi (optarg);
	break;
      case 'p':
	getports (optarg, range);
	if (range[0] + range[1] <= 1)
	  usage (argv[0]);
	fprintf (stderr, "  * Port range: %d-%d\n", range[0], range[1]);
	break;
      case 'i':
	in = fopen (optarg, "r");
	if (in == NULL)
	  usage (argv[0]);
	fprintf (stderr, "  * Input file: %s\n", optarg);
	fclose (in);
	strncpy (infile, optarg, BS);
	break;
      case 's':
	input++;
	if (inet_addr (optarg) == -1)
	  {
	    fprintf (stderr, "Invalid start IP!\n");
	    usage (argv[0]);
	  }
	strncpy (nstart, optarg, BS);
	break;
      case 'e':
	input++;
	if (inet_addr (optarg) == -1)
	  {
	    fprintf (stderr, "Invalid end IP!\n");
	    usage (argv[0]);
	  }
	strncpy (nstop, optarg, BS);
	break;
      case 'o':
	out = fopen (optarg, "a");
	if (out == NULL)
	  usage (argv[0]);
	fprintf (stderr, "  * Log file: %s\n", optarg);
	break;
      case 'd':
	delay = atoi (optarg);
	fprintf (stderr, "  * Delay: %d ms\n", delay);
	break;
      default:
	usage (argv[0]);
	break;
      }

  if ((input != 0) && (input != 2))
    {
      fprintf (stderr, "Invalid IP range selected!\n");
      usage (argv[0]);
    }

  if (scantype && (scantype < 6))
    {
      fprintf (stderr, "  * Initiating %s scan...\n", strscan (scantype, buffer));
    }
  else
    {
      fprintf (stderr, "No valid scan type selected!\n");
      usage (argv[0]);
    }

  now = time (NULL);
  srand (getpid ());
  srandom (now);
  ipid = (u16) random ();

  switch (fork ())
    {
    case -1:
      fprintf (stderr, "fork() failing#@$!\n");
      exit (0);
    case 0:
      if (input == 0)
	{
	  if (in != stdin)
	    in = fopen (infile, "r");
	  transmit ();
	}
      else
	transmit_net ();
      sleep (3);
      exit (0);
      break;
    default:
      signal (SIGCHLD, finish);
      receive ();
      break;
    }

  return (0);
}

void
finish (int signo)
{
  fprintf (stderr, "\n\t -- exo sweep completed (took %ld seconds)\n", time (NULL) - now);
  exit (0);
}
