#include "exo.h"
#define PINGDATA "\x08\x00\xfd\x72\xf0\x06\x00\x00\xea\xc3\x3b\x38\xf6\x86\x03\x00\x08\x09\x0a\x0b\x0c\x0d\x0e\x0f\x10\x11\x12\x13\x14\x15\x16\x17\x18\x19\x1a\x1b\x1c\x1d\x1e\x1f\x20\x21\x22\x23\x24\x25\x26\x27\x28\x29\x2a\x2b\x2c\x2d\x2e\x2f\x30\x31\x32\x33\x34\x35\x36\x37"

char *
ntoa (u32 in)
{
  struct in_addr ad;
  ad.s_addr = in;
  return (inet_ntoa (ad));
}


u16
cksum (unsigned long addr, int count)
// from RFC 1071 (method in RFC1071 contained 2 bugs, fixed by Lez)
{
  register long sum = 0;
  while( count > 1 ) { 
    sum +=  * (unsigned short *) addr;
    addr+=2;
    count-=2;
  }

//    Add left-over byte, if any
//  if( count > 0 )
//    sum += * (unsigned char *) addr;
//    Fold 32-bit sum to 16 bits

  while (sum>>16)
    sum = (sum & 0xffff) + (sum >> 16);
  return (~sum); 
} 

void
match_synack (char *packet, u32 * last)
{
  struct ip *ih = (struct ip *) packet;
  struct tcp *th = (struct tcp *) (packet + sizeof (struct ip));
  if (th->flg != (SYN | ACK))
    return;
  if (ntohs (th->dst) !=(ipid % 31337))
    return;
  if (ih->src != *(last))
    {
      fprintf (out, "\n%s - %d", ntoa (ih->src), ntohs (th->src));
      *(last) = ih->src;
    }
  else
    fprintf (out, " %d", ntohs (th->src));
  fflush (0);
}

void
match_udp (char *packet, u32 * last)
{
  struct ip *ih = (struct ip *) packet;
  struct udp *uh = (struct udp *) (packet + sizeof (struct ip));

  if (ih->src == source)
    return;			/* outgoing traffic, ignore */
  if (ih->src != *(last))
    {
      fprintf (out, "\n%s - %d", ntoa (ih->src), ntohs (uh->src));
      *(last) = ih->src;
    }
  else
    fprintf (out, " %d", ntohs (uh->src));
  fflush (0);
}

void
match_pong (char *packet, u32 * last)
{
  struct ip *ih = (struct ip *) packet;
  struct icmp *ich = (struct icmp *) (packet + sizeof (struct ip));
  if (ich->type)
    return;
  fprintf (out, "%s\n", ntoa (ih->src));
}

void
sendtcp (int sock, u32 dest, int port, u8 flags)
{
  char packet[BS];
  char tmptcp[BS];
  struct ip *ih = (struct ip *) &packet;
  struct tcp *th = (struct tcp *) (packet + sizeof (struct ip));
  int psize = sizeof (struct ip) + sizeof (struct tcp);
  struct sa sin;

  bzero (packet,BS);
  bzero (tmptcp,BS);
  
  sin.fam = PF_INET;
  sin.dp = htons (port);
  sin.add = dest;
  srandom (rand ());
  srand (random ());

  ih->ihl = 5;
  ih->ver = 4;
  ih->tos = 0;
  ih->tl = htons (psize);
  ih->id = random ();
  ih->off = 0;
  ih->ttl = 0xf0;
  ih->pro = TCP;
  ih->sum = 0;			/* kernel fills in */
  ih->src = source;
  ih->dst = dest;

  th->src = htons (ipid % 31337);
  th->dst = htons (port);
  srandom (rand ());
  srand (random ());
  th->seq = random ();
  th->ack = th->seq;
  th->off = sizeof (struct tcp) / 4;
  th->flg = flags;
  th->win = htons (512); /*not htonl*/
  th->sum = 0;
  th->urp = 0;

/*constructing pseudo-tcpheader and count the checksum for it*/
  *(long *)(tmptcp)       =ih->src;
  *(long *)(tmptcp+4)     =ih->dst;
  *(u8 *)(tmptcp+9)    =TCP;
  *(short *)(tmptcp+10)   =htons(psize-20);
  memcpy (tmptcp+12, packet+20,psize-20  );
  th->sum = cksum ( (long)tmptcp, psize  - 20 + 12);

  usleep (50 + delay);
  sendto (sock, packet, psize, 0, (struct sockaddr *) &sin, sizeof (struct sockaddr));
}

void
sendudp (int sock, u32 dest, int port)
{
  char packet[BS];
  struct ip *ih = (struct ip *) packet;
  struct udp *uh = (struct udp *) (packet + sizeof (struct ip));
  int psize = sizeof (struct ip) + sizeof (struct udp) + 1;
  struct sa sin;

  sin.fam = PF_INET;
  sin.dp = htons (port);
  sin.add = dest;
  srandom (rand ());
  srand (random ());
  ih->ihl = 5;
  ih->ver = 4;
  ih->tos = 0;
  ih->tl = htons (psize);
  ih->id = htonl (rand ());
  ih->off = 0;
  ih->ttl = 0xf0;
  ih->pro = UDP;
  ih->sum = 0;			/* kernel fills in */
  ih->src = source;
  ih->dst = dest;
  uh->src = htons (rand ());
  uh->dst = htons (port);
  uh->len = htons (sizeof (struct udp) + 1);
  uh->sum = cksum ((long) uh, sizeof (struct udp) + 1);
  srandom (rand ());
  srand (random ());
  packet[psize] = '.';
  usleep (50 + delay);
  sendto (sock, packet, psize, 0, (struct sockaddr *) &sin, sizeof (struct sockaddr));
}

void
sendicmp (int sock, u32 dest)
{
  char packet[BS];
  struct ip *ih = (struct ip *) packet;
  int psize = sizeof (struct ip) + 64;
  struct sa sin;

  sin.fam = PF_INET;
  sin.dp = htons (0);
  sin.add = dest;
  srandom (rand ());
  srand (random ());
  ih->ihl = 5;
  ih->ver = 4;
  ih->tos = 0;
  ih->tl = htons (psize);
  ih->id = random ();
  ih->off = 0;
  ih->ttl = 0xf0;
  ih->pro = ICMP;
  ih->sum = 0;			/* kernel fills in */
  ih->src = source;
  ih->dst = dest;
  srandom (rand ());
  srand (random ());
  memcpy (packet + sizeof (struct ip), PINGDATA, 64);
  usleep (50 + delay);
  sendto (sock, packet, psize, 0, (struct sockaddr *) &sin, sizeof (struct sockaddr));
}

void
incip (char *ip)
{
  int a, b, c, d;
  sscanf (ip, "%d.%d.%d.%d", &a, &b, &c, &d);
  d++;
  if (a > 224)
    exit (-1);
  if (b > 255)
    {
      b = 0;
      a++;
    }
  if (c > 255)
    {
      c = 0;
      b++;
    }
  if (d > 255)
    {
      d = 0;
      c++;
    }

  sprintf (ip, "%d.%d.%d.%d", a, b, c, d);
}

int
gsocket (void)
{
  switch (scantype)
    {
    case 1:
      return (socket (PF_INET, SOCK_RAW, TCP));
    case 2:
      return (socket (PF_INET, SOCK_RAW, UDP));
    case 3:
      return (socket (PF_INET, SOCK_RAW, ICMP));
    }
  return (0);
}

void
transmit (void)
{
  int port, sock = gsocket ();
  char buffer[BS];
  u32 dest;

  setsockopt (sock, IP, 3, "1", sizeof ("1"));

  while (fgets (buffer, BS, in) != NULL)
    {
      dest = resolve (buffer);

      if (scantype != 3)
	for (port = range[0]; port <= range[1]; port++)
	  switch (scantype)
	    {
	    case 1:
	      sendtcp (sock, dest, port, SYN);
	      break;
	    case 2:
	      sendudp (sock, dest, port);
	      break;
	    }
      else
	sendicmp (sock, dest);

      memset (buffer, 0, BS);
    }
}

void
transmit_net (void)
{
  int port, sock = gsocket ();
  u32 dest;

  setsockopt (sock, IP, 3, "1", sizeof ("1"));

  while (strcmp (nstart, nstop) != 0)
    {
      dest = inet_addr (nstart);

      if (scantype != 3)
	for (port = range[0]; port <= range[1]; port++)
	  switch (scantype)
	    {
	    case 1:
	      sendtcp (sock, dest, port, SYN);
	      break;
	    case 2:
	      sendudp (sock, dest, port);
	      break;
	    }
      else
	sendicmp (sock, dest);

      incip (nstart);
    }
}

void
receive (void)
{
  u32 last;
  char packet[BS];
  int sock = gsocket ();

  setsockopt (sock, IP, 3, "1", sizeof ("1"));

  while (1)
    {
      read (sock, packet, BS);
      switch (scantype)
	{
	case 1:
	  match_synack (packet, &last);
	  break;
	case 2:
	  match_udp (packet, &last);
	  break;
	case 3:
	  match_pong (packet, &last);
	  break;
	}
    }
}
