
#include "exo.h"

void
getports (char *b, unsigned int p[2])
{
  char *c;

  c = strtok (b, "- ");
  if (c == NULL)
    p[0] = 0;
  else
    p[0] = atoi (c);

  c = strtok (NULL, "- ");
  if (c == NULL)
    p[1] = p[0];
  else
    p[1] = atoi (c);

  if (!p[1])
    p[1] = 65535;

  if (p[0] > p[1])
    {
      p[0] = 0;
      p[1] = 0;
    }
}

char *
strscan (unsigned short t, char *b)
{
  switch (t)
    {
    case 1:
      strcpy (b, "tcp syn");
      break;
    case 2:
      strcpy (b, "udp");
      break;
    case 3:
      strcpy (b, "ping");
      break;
    }
  return (b);
}

unsigned long
resolve (char *host)
{
  struct hostent *he;
  struct sa tmp;
  if (inet_addr (host) != -1)
    return (inet_addr (host));
  he = gethostbyname (host);
  if (he)
    {
      memcpy ((caddr_t) & tmp.add, he->h_addr, he->h_length);
    }
  else
    return (0);
  return (tmp.add);
}

void
usage (char *arg)
{
  fprintf (stderr, "Usage: %s -t type [-p ports] [-i file] [-s ip -e ip] [-o logfile] [-d delay]\n", arg);
  fprintf (stderr, "   Types: 1  -  TCP syn            Ports: can be low-high or a single port\n");
  fprintf (stderr, "          2  -  UDP                Input: is either -i file (default: stdin)\n");
  fprintf (stderr, "          3  -  ICMP (Pingsweep)          or -s start-ip -e end-ip\n");
  exit (0);
}

/* just an ugly way to obtain your ip */

void
findip (char *buf)
{
  FILE *script = popen ("ip", "r");
  setenv ("PATH", "/usr/bin:/bin:/usr/local/bin/:/usr/sbin/:/sbin:.", 1);
  fgets (buf, 23, script);
  pclose (script);
  if (strlen (buf) < 7)
    strcpy (buf, "127.0.0.1");
}
