/*
 * fwmail v1.1     Oct 99 (c) Mixter
 *
 * minimal smtp-forwarding agent
 *
 * This program, started via inetd(8), will accept all
 * incoming SMTP traffic to a machine and tunnel it to
 * a real sendmail server, optionally logging smtp
 * activities or shadowing the senders origin.
 * It can be used as a secure replacement for sendmail
 * servers or to forward external SMTP traffic to a LAN.
 */

/* default smtp forwarding server; can be an IP or hostname */
#define MY_MTA		"stmp.domain.com"

/* define this, and the senders address will be copied over with it */
#undef ANON_MAIL	"anonymous@localhost.net"

/* define this, if you don't want the senders IP included in the header */
#undef ANON_IP

/* log successfullly forwarded smtp sessions and errors to syslog */
#define LOGGING

/* if called as root, fwmail will acquire this safe user/group id */
#define NOBODY		65534

/* maximum quota for a mail in lines (or 127 byte-blocks) */
#define MAXSIZE		4096

/* debugging, to be able to start from a tty */
#undef DEBUG

/* end of user definable section */

#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <unistd.h>
#include <time.h>
#include <sys/time.h>
#include <sys/types.h>
#include <sys/socket.h>
#include <netinet/in.h>
#include <arpa/inet.h>
#include <errno.h>
#include <netdb.h>
#ifdef LOGGING
#include <syslog.h>
#endif

#define VERSION "1.1"
#define STDIN	0
#define SBUF 127

enum
  {
    NONE, HELO, FROM, TO, DATA, DONE
  }
STATE;

char *fw_chomp (char *);
char *fw_date (char *, int);
u_long resolve (char *);
void sendmail (struct sockaddr_in *, unsigned int, char **, int);
void readstuff (int);

char sessionid[10];

int
main (int argc, char **argv)
{
  struct sockaddr_in sa;	/* current peer */
  char hostname[SBUF + 1];	/* local host */
  u_long mta;			/* message transfer agent */
  char dbuf[SBUF + 1];		/* timestamp */
  char *p[MAXSIZE];		/* dynamic data buffer */
  int i = 0, j = 0, r = 0;	/* line input index, line output index, retry index */
  unsigned int salen = sizeof (sa);

  if ((argc >= 2) && (resolve (argv[1]) != 0))
    mta = resolve (argv[1]);
  else
    mta = resolve (MY_MTA);

  fw_date (dbuf, SBUF);

  srand(time(NULL));
  snprintf (sessionid, 9, "PAA%ld", ((rand() % 800001)+100000));

  if (!(geteuid () + getuid () + getegid () + getgid ()))
    {
      setreuid (NOBODY, NOBODY);
      setregid (NOBODY, NOBODY);
    }

  if (getpeername (STDIN, (struct sockaddr *) &sa, &salen) < 0)
    {
#ifndef DEBUG
#ifdef LOGGING
      syslog (LOG_PID, "getpeername: %s", strerror (errno));
#endif
      exit (0);
#else
      sa.sin_addr.s_addr = inet_addr("127.0.0.1");
#endif
    }

  gethostname (hostname, SBUF);

  STATE = NONE;
  printf ("220 %s ESMTP SMAIL-FW %s; %s\n", hostname, VERSION, dbuf);
  fflush (NULL);

  p[i] = (char *) malloc (SBUF + 1 * sizeof (char));

  while (fgets (p[i], SBUF, stdin) != NULL)
    {
      if (i+1 > MAXSIZE)
        {
         printf ("500 Sorry, maximum mail quota exceeded\n221 Try again\n");
#ifdef LOGGING
          syslog (LOG_PID, "NOQUEUE: maximum quota exceeded from [%s]", p[i], inet_ntoa (sa.sin_addr));
#endif
         fflush(NULL);
         exit(0);
        }
      if ((strncasecmp (p[i], "helo", 4) == 0) || (strncasecmp (p[i], "ehlo", 4) == 0))
	{
	  if (STATE == NONE)
	    {
	      STATE = HELO;
              snprintf (p[i], SBUF, "EHLO %s\n", hostname);
	      i++;
	      p[i] = (char *) malloc (SBUF + 1 * sizeof (char));
	      printf ("250 %s Hello, [%s], proceed\n", 
                      hostname, inet_ntoa(sa.sin_addr));
	      fflush (NULL);
	      continue;
	    }
	}
      if (strncasecmp (p[i], "mail from: ", 10) == 0)
	{
	  if (STATE == HELO)
	    {
	      if (strlen(p[i]) < 12)
                {
                 printf("550 Invalid sender specified\n");
                 continue;
                }
	      STATE = FROM;
#ifdef ANON_MAIL
	      snprintf (p[i], SBUF, "MAIL FROM: %s", ANON_MAIL);
#endif
	      i++;
	      p[i] = (char *) malloc (SBUF + 1 * sizeof (char));
	      printf ("250 Sender OK\n");
	      fflush (NULL);
	      continue;
	    }
	}
      if (strncasecmp (p[i], "rcpt to:", 8) == 0)
	{
	  if (STATE == FROM)
	    {
	      if (strlen(p[i]) < 10)
                {
                 printf("550 Invalid recipient specified\n");
                 continue;
                }
	      STATE = TO;
	      i++;
	      p[i] = (char *) malloc (SBUF + 1 * sizeof (char));
	      printf ("250 Recipient OK\n");
	      fflush (NULL);
	      continue;
	    }
	}
      if (strncasecmp (p[i], "quit", 4) == 0 && STATE != DATA)
	{
	  printf ("221 Au revoir\n");
	  fflush (NULL);
	  break;
	}
      if (strncasecmp (p[i], "data", 4) == 0)
	{
	  if (STATE == TO)
	    {
	      STATE = DATA;
	      i++;
	      p[i] = (char *) malloc (SBUF + 1 * sizeof (char));
#ifndef ANON_IP
	      snprintf (p[i], SBUF,
              "Received: from %s by fwmail agent %s id %s\n",
		inet_ntoa (sa.sin_addr), VERSION, sessionid);
#else
	      snprintf (p[i], SBUF,
              "Received: from (anonymous) by fwmail agent %s id %s\n",
		VERSION, sessionid);
#endif
	      i++;
	      p[i] = (char *) malloc (SBUF + 1 * sizeof (char));
	      printf ("354 Go ahead\n");
	      fflush (NULL);
	      continue;
	    }
	}
      if (strncasecmp (p[i], ".", 1) == 0)
	{
	  if (STATE == DATA)
	    {
	      STATE = DONE;
	      i++;
	      p[i] = (char *) malloc (SBUF + 1 * sizeof (char));
	      strcpy (p[i], "QUIT\r\n");
	      printf ("250 %s Message accepted\n", sessionid);
	      fflush (NULL);
	      sleep (1);
	      printf ("221 Au revoir\n");
	      fflush (NULL);
	      break;
	    }
	}
      if (STATE != DATA)
	{
	  printf ("500 Unknown command or wrong command state: \"%s\"\n", fw_chomp (p[i]));
	  fflush (NULL);
#ifdef LOGGING
          syslog (LOG_PID, "NOQUEUE: \"%s\" command from [%s]", p[i], inet_ntoa (sa.sin_addr));
#endif
	  continue;
	}
      i++;
      p[i] = (char *) malloc (SBUF + 1 * sizeof (char));
    }

  if (STATE != DONE)
    {
#ifdef LOGGING
      syslog (LOG_PID, "NOQUEUE: Null connection from [%s]", inet_ntoa (sa.sin_addr));
#endif
      exit (0);
    }

  sa.sin_family = AF_INET;
  sa.sin_port = htons (25);
  sa.sin_addr.s_addr = mta;

  for (r = 0; r <= 5; r++)
    {
      sendmail (&sa, salen, p, i);
      alarm (0);
      sleep (10);
    }

  for (j = 0; j <= i; j++)
    {
#ifdef DEBUG
      fprintf (stderr, p[j]);
#endif
      free (p[j]);
    }

  return (0);
}

char *
fw_chomp (char *p)
{
  if (p[strlen (p) - 1] == '\r')
    p[strlen (p) - 1] = '\0';
  if (p[strlen (p) - 1] == '\n')
    p[strlen (p) - 1] = '\0';
  if (p[strlen (p) - 2] == '\r')
    p[strlen (p) - 2] = '\0';
  if (p[strlen (p) - 2] == '\n')
    p[strlen (p) - 2] = '\0';
  return (p);
}

char *
fw_date (char *p, int max)
{
  time_t tp = time (NULL);
  struct tm *ltime;
  char sb[9];

  ltime = localtime (&tp);
  strftime (p, max - 10, "%a %b %d %Y %H:%M:%S ", ltime);
  if (timezone >= 0)
    sprintf (sb, "+%ld", timezone);
  else
    sprintf (sb, "%ld", timezone);

  strcat (p, sb);
  return (p);
}

u_long
resolve (char *host)
{
  struct hostent *he;
  struct sockaddr_in tmp;

  if (inet_addr (host) != -1)
    return (inet_addr (host));

  he = gethostbyname (host);
  if (he)
    memcpy ((caddr_t) & tmp.sin_addr.s_addr, he->h_addr, he->h_length);
  else
    return (0);

  return (tmp.sin_addr.s_addr);
}

void
sendmail (struct sockaddr_in *sa, unsigned int salen, char **line, int li)
{
  int j = 0, s = socket (AF_INET, SOCK_STREAM, 0);
  alarm (90);
  if (connect (s, (struct sockaddr_in *) sa, salen) < 0)
    return;
  for (j = 0; j <= li; j++)
    {
      readstuff (s);
      write (s, line[j], strlen (line[j]));
    }
  alarm (0);
#ifdef LOGGING
  syslog (LOG_PID, "%s: from=%s, to=%s, relay=[%s]",
	  sessionid, line[1]+11, line[2]+9, inet_ntoa (sa->sin_addr));
#endif
  exit (0);
}

void
readstuff (int s)
{
  char buf[SBUF + 1];
  struct timeval tv;
  fd_set rfds;
  FD_ZERO (&rfds);
  FD_SET (s, &rfds);
  tv.tv_sec = 1;
  tv.tv_usec = 0;
  while (select (s + 1, &rfds, NULL, NULL, &tv) > 0)
    read (s, buf, SBUF);
}
