//////////////////////////////////////////
//    Network Security Analysis Tool    //
//          (c) 1999 by Mixter          //
//                                      //
//      auditing class declaration      //
//////////////////////////////////////////

#ifndef AUDITSET_H
#define AUDITSET_H
#pragma interface "auditset"

#include "nsat.h"
#include <X11/Xlib.h>
#include "services.h"

// how to close our sockets
#define SCLOSE(n)       close(n)

class AuditSet
{
 private:

  ofstream log;

 protected:

  struct sockaddr_in sin;       // socket address of peer
  u_int sl;                     // sizeof peer
  u_long target;		// current host
  int timeout;			// connect timeout
  char *Hostname (void);	// get current hostname
  int firstopen;		// open port on the current host

 public:

  void plog (int, char *);	// log a service
  void nstat (int);		// record
  void ftp (int);		// version
  void ssh (int);		// version
  void telnet (int);		// version / os / wingate check
  void smtp (int);		// version / commands check / spamcheck
  void nbind (int);		// iquery test
  void finger (int);		// exploit
  void http (int);		// webscan
  void pop2 (int);		// version
  void pop3 (int);		// version
  void pmap (int);		// rpc scan
  void nntp (int);		// version
  void smb (int);		// smb audit
  void imap (int);		// version
  void bd666 (int);		// try to issue shell cmd
  void bd1524 (int);		// try to issue shell cmd
  void nlps (int);		// exploit
  void ircd (int);		// try to log onto irc
  void xwin (int);		// open display
  void nbname (void);		// get netbios name
  void bo (int);		// send BO ping
  void os (void);		// remote OS fingerprinting
  void snmp (void);		// snmp audit
    AuditSet (void);
   ~AuditSet (void);
};

#endif
