//////////////////////////////////////////
//    Network Security Analysis Tool    //
//          (c) 1999 by Mixter          //
//                                      //
//        default configuration         //
//////////////////////////////////////////
#ifndef CONFIG_H
#define CONFIG_H

/* 9 out of 10 compiling errors prefer Solaris platforms... */
#undef SOLARIS

/* user definable default values */

/* fingerprint data file (FULL PATH) */
#define PRINTS         "/usr/local/bin/nsat.os"
#define PIDFILE        ".nspid"	/* pid file name */
#define PROGRESS_FILE  ".nsrc"	/* recovery file name */
#define BUFSIZE		1024	/* to capture version info, etc. */
#define MAXLIFE		200	/* maximum seconds a child may run */
#define P_TIMER		60	/* update progress each n seconds */
#define FDLIMIT         256	/* max open files per user (linux default),
				   increase on solaris / bsd */
#undef PARANOID_CHECK		/* you should define this in case you
				   plan to make nsat suid root */

/* default options - don't change unless you know what you're doing */

#define TIMEOUT		5	/* timeout in seconds for many operations */
#define PINGONLY        0	/* ping-dependent scanning */
#define VERBOSITY       3	/* verbose reporting */
#define COWARD          0	/* coward mode */
#define IDLETIME	90	/* time span in seconds to wait after
				   last user activity to continue */
#define MAXPROC         FDLIMIT/6

/* some default messages */

#define ENTER "\n"
#define M_LBANNER "* * * * *  "
#define M_RBANNER "  * * * * *\n"
#define M_CLR "                             \r"
#define M_SCANNING "\r* scanning: "
#define M_NOSCANTYPE ": no scantype selected\n"
#define M_RUNNING ": still active\n"
#define M_NORECFILE ": no data\n"

/* anonymous ftp login */

#define FTPUSER "USER anonymous\r\n"
#define FTPPASS "PASS nsat@\r\n"

/* default names for the log files */

#define L_PORTS		"ports.log"
#define L_FTP		"ftp.log"
#define L_SSH		"ssh.log"
#define	L_TELNET	"telnet.log"
#define L_SMTP		"sendmail.log"
#define L_DNS		"dns.log"
#define L_HTTVER	"httpd.log"
#define	L_POP2		"pop2.log"
#define L_POP3		"pop3.log"
#define L_IMAP		"imap.log"
#define L_OS		"os.log"
#define L_UOS		"unknown-os.log"
#define L_FINGER	"finger.log"
#define L_SNMP		"snmp.log"
#define L_SMB		"smb.log"
#define L_NNTP		"nntp.log"
#define L_EXPORTS       "exports.log"
#define L_NETSTAT 	"netstat.log"
#define L_BACKDOOR	"backdoor.log"
#define L_IRCD		"ircd.log"
#define L_XWIN		"xwindows.log"
#define L_NETBIOS	"netbios.log"
#define L_ICMP		"icmp.log"
#define L_RPC		"rpc.log"
#define L_CGI		"cgi.log"
#define L_BO		"bo.log"
#define L_NLPS		"nlps.log"
#ifdef EBUG
#define L_DEBUG		"debug.log"
#endif

#endif
