//////////////////////////////////////////
//    Network Security Analysis Tool    //
//          (c) 1999 by Mixter          //
//////////////////////////////////////////

// osscan, a very slim version of the famous
// os scanner queso by savage@apostols.org

#include "../nsat.h"
#include "fprints.h"

#define FPRINT_TOLERANCE 1	/* allow 1 of 7 packet
				   recognition mismatches */
#define MIN_REPLIES 2		/* less than 2 packets received
                                   means no reply */

extern sigjmp_buf stack;

#ifdef EBUG
extern ofstream dbug;
#endif

int ztp;

struct iphdr_lame
  {
#if __BYTE_ORDER == __LITTLE_ENDIAN
    u_int8_t ihl:4;
    u_int8_t version:4;
#elif __BYTE_ORDER == __BIG_ENDIAN
    u_int8_t version:4;
    u_int8_t ihl:4;
#else
#error  "Please fix <bytesex.h>"
#endif
    u_int8_t tos;
    u_int16_t tot_len;
    u_int16_t id;
    u_int16_t frag_off;
    u_int8_t ttl;
    u_int8_t protocol;
    u_int16_t check;
    u_int32_t saddr;
    u_int32_t daddr;
  };

struct tcphdr_lame
  {
    u_int16_t source;
    u_int16_t dest;
    u_int32_t seq;
    u_int32_t ack_seq;
#ifdef SOLARIS
// our int size is 4 on solaris, so what
    int th_off;
    int th_x2;
#else
#if __BYTE_ORDER == __LITTLE_ENDIAN
    u_int8_t th_x2:4;
    u_int8_t th_off:4;
#endif
#if __BYTE_ORDER == __BIG_ENDIAN
    u_int8_t th_off:4;
    u_int8_t th_x2:4;
#endif
#endif
    u_int8_t th_flags;
    u_int16_t th_win;
    u_int16_t check;
    u_int16_t th_urp;
  };

#define GAYLEN (4 * ih->ihl + sizeof (struct tcphdr_lame))

unsigned short
ip_sum (u_short * addr, int len)
{
  register int nleft = len;
  register u_short *w = addr;
  register int sum = 0;
  u_short answer = 0;
  while (nleft > 1)
    {
      sum += *w++;
      nleft -= 2;
    }
  if (nleft == 1)
    {
      *(u_char *) (&answer) = *(u_char *) w;
      sum += answer;
    }
  if (nleft == 1)
    {
      *(u_char *) (&answer) = *(u_char *) w;
      sum += answer;
    }
  sum = (sum >> 16) + (sum & 0xffff);
  sum += (sum >> 16);
  answer = ~sum;
  return (answer);
}

void
fpmatch (OSRES res, OSRES fpr)
{
  if (!fpr.set) return;  
  if (res.set != fpr.set)
    {
      ztp++;
      return;
    }
  if (res.seq != fpr.seq)
    {
      ztp++;
      return;
    }
  if ((res.ack != fpr.ack) && (res.ack != (fpr.ack + 1000)))
    {
      ztp++;
      return;
    }
  if (res.urg != fpr.urg)
    {
      ztp++;
      return;
    }
  if (res.win != fpr.win)
    {
      ztp++;
      return;
    }
  if (res.flag != fpr.flag)
    {
      ztp++;
      return;
    }
}

void
tcprobe (u_long ip, int port, int timeout)
{
  int r = socket (AF_INET, SOCK_RAW, IPPROTO_RAW), on = 1, start, n = 0,
    x, ts;
  char synb[8192];
  struct sockaddr_in sin;
  struct iphdr_lame *ih = (struct iphdr_lame *) synb;
  struct tcphdr_lame *th = (struct tcphdr_lame *) (synb + sizeof (struct iphdr_lame));
  OSRES rr[7];
  struct in_addr host;
  ofstream flog;
  int ri = sizeof (sin);

  host.s_addr = ip;
  for (n = 0; n <= 6; n++)
    rr[n].set = 0;

  srand (time (NULL) & 0x0000ffff);

  u_long myseq = rand ();
  int sport = (rand () % 26000) + 4000;
  start = sport;

  setsockopt (r, IPPROTO_IP, IP_HDRINCL, (char *) &on, sizeof (on));
  ts = socket (AF_INET, SOCK_RAW, IPPROTO_TCP);
  fcntl (ts, F_SETFL, O_RDWR | O_NONBLOCK);

  sin.sin_family = AF_INET;
  sin.sin_port = htons (port);
  sin.sin_addr.s_addr = ip;

  ih->version = 4;
  ih->ihl = 5;
  ih->tos = 0x00;
  ih->tot_len = htons (40);
  ih->id = htons (31337 + sport);
  ih->frag_off = 0;
  ih->ttl = 255;
  ih->protocol = IPPROTO_TCP;
  ih->check = 0;
  ih->saddr = IPADDR_ANY;
  ih->daddr = ip;
  th->source = 0;
  th->dest = htons (port);
  th->seq = htonl (myseq);
  th->ack_seq = 0;
  th->th_x2 = 0;
  th->th_flags = 0;
  th->th_win = htons (0x1234);
  th->th_off = 5;
  th->check = 0;
  th->th_urp = 0;

/* PACKET 0: SYN */
  th->source = htons (sport++);
  th->th_flags = SYN;
  th->check = ip_sum ((u_short *) synb, (sizeof (struct iphdr) + sizeof (struct tcphdr_lame) + 1) & ~1);
  ih->check = ip_sum ((u_short *) synb, (GAYLEN + 1) & ~1);
  sendto (r, synb, GAYLEN, 0, (struct sockaddr *) &sin, ri);

/* PACKET 1: SYN|ACK */
  th->source = htons (sport++);
  th->th_flags = SYN | ACK;
  th->check = ip_sum ((u_short *) synb, (sizeof (struct iphdr) + sizeof (struct tcphdr_lame) + 1) & ~1);
  ih->check = ip_sum ((u_short *) synb, (GAYLEN + 1) & ~1);
  sendto (r, synb, GAYLEN, 0, (struct sockaddr *) &sin, ri);

/* PACKET 2: FIN */
  th->source = htons (sport++);
  th->th_flags = FIN;
  th->check = ip_sum ((u_short *) synb, (sizeof (struct iphdr) + sizeof (struct tcphdr_lame) + 1) & ~1);
  ih->check = ip_sum ((u_short *) synb, (GAYLEN + 1) & ~1);
  sendto (r, synb, GAYLEN, 0, (struct sockaddr *) &sin, ri);

/* PACKET 3: FIN|ACK */
  th->source = htons (sport++);
  th->th_flags = FIN | ACK;
  th->check = ip_sum ((u_short *) synb, (sizeof (struct iphdr) + sizeof (struct tcphdr_lame) + 1) & ~1);
  ih->check = ip_sum ((u_short *) synb, (GAYLEN + 1) & ~1);
  sendto (r, synb, GAYLEN, 0, (struct sockaddr *) &sin, ri);

/* PACKET 4: SYN|FIN */
  th->source = htons (sport++);
  th->th_flags = SYN | FIN;
  th->check = ip_sum ((u_short *) synb, (sizeof (struct iphdr) + sizeof (struct tcphdr_lame) + 1) & ~1);
  ih->check = ip_sum ((u_short *) synb, (GAYLEN + 1) & ~1);
  sendto (r, synb, GAYLEN, 0, (struct sockaddr *) &sin, ri);

/* PACKET 5: PSH */
  th->source = htons (sport++);
  th->th_flags = PSH;
  th->check = ip_sum ((u_short *) synb, (sizeof (struct iphdr) + sizeof (struct tcphdr_lame) + 1) & ~1);
  ih->check = ip_sum ((u_short *) synb, (GAYLEN + 1) & ~1);
  sendto (r, synb, GAYLEN, 0, (struct sockaddr *) &sin, ri);

/* PACKET 6: SYN|XXX|YYY */
  th->source = htons (sport++);
  th->th_flags = SYN | XXX | YYY;
  th->check = ip_sum ((u_short *) synb, (sizeof (struct iphdr) + sizeof (struct tcphdr_lame) + 1) & ~1);
  ih->check = ip_sum ((u_short *) synb, (GAYLEN + 1) & ~1);
  sendto (r, synb, GAYLEN, 0, (struct sockaddr *) &sin, ri);

  rr[6].set = 0;

  timeout += time (NULL);

  while ((!rr[6].set) && (timeout > time (NULL)))
    {
      if (read (ts, synb, sizeof (synb)) < 0)
	usleep (500);
      if ((ih->protocol == IPPROTO_TCP && ih->saddr == ip) && ntohs (th->source) == port)
	{
	  // the eleat queso analyzation tekneek reeped by meextawr.
	  n = ntohs (th->dest) - start;		// 0 < n < 6 or something is wrong

	  if (rr[n].set == 1)
	    continue;
	  rr[n].seq = (th->seq ? 1 : 0);
	  rr[n].ack = (th->ack_seq ? (ntohl (th->ack_seq) - myseq + 1000) : 0);
	  if (rr[n].ack > 1666)
	    rr[n].ack = 1666;
	  rr[n].win = ntohs (th->th_win);
	  rr[n].flag = th->th_flags;
	  rr[n].set = 1;
	  rr[n].urg = (th->th_urp ? 1 : 0);
	}
    }

  close (r);
  close (ts);

  if ((rr[0].set+rr[1].set+rr[2].set+rr[3].set+rr[4].set+rr[5].set+rr[6].set) < MIN_REPLIES)
    return;

#ifdef PARANOID_CHECK
  struct stat s;
  lstat (PRINTS, &s);
  if (S_ISLNK (s.st_mode) || (s.st_uid + s.st_gid))
    return;
#endif

  Fingerprint fpr;
  FILE *os = fopen (PRINTS, "r");

  if (os == NULL)
    {
#ifdef EBUG
      dbug << "Unable to open fingerprint file " << PRINTS << ", skipping OS scan...\n";
#endif
      return;
    }

  for (x = 0; x <= OSCOUNT; x++)
    {

      ztp = 0;

      scanprint (os, &fpr);
      fpmatch (rr[0], fpr.rr0);
      fpmatch (rr[1], fpr.rr1);
      fpmatch (rr[2], fpr.rr2);
      fpmatch (rr[3], fpr.rr3);
      fpmatch (rr[4], fpr.rr4);
      fpmatch (rr[5], fpr.rr5);
      fpmatch (rr[6], fpr.rr6);

#ifdef EBUG
      dbug << "ztp = " << ztp << " desc = " << fpr.desc << "\n";
#endif

      if (ztp <= FPRINT_TOLERANCE)
	{
	  flog.open (L_OS, 8);
	  flog << inet_ntoa (host) << " - " << fpr.desc << ENTER;
	  flog.close ();
	  return;
	}

    }

  flog.open (L_UOS, 8);
  flog << "Unknown OS (please submit): " << inet_ntoa (host) << ENTER;
  flog << rr[0].set << " " << rr[0].seq << " " << rr[0].ack << " " <<
    rr[0].urg << " " << rr[0].win << " " << rr[0].flag << ENTER;
  flog << rr[1].set << " " << rr[1].seq << " " << rr[1].ack << " " <<
    rr[1].urg << " " << rr[1].win << " " << rr[1].flag << ENTER;
  flog << rr[2].set << " " << rr[2].seq << " " << rr[2].ack << " " <<
    rr[2].urg << " " << rr[2].win << " " << rr[2].flag << ENTER;
  flog << rr[3].set << " " << rr[3].seq << " " << rr[3].ack << " " <<
    rr[3].urg << " " << rr[3].win << " " << rr[3].flag << ENTER;
  flog << rr[4].set << " " << rr[4].seq << " " << rr[4].ack << " " <<
    rr[4].urg << " " << rr[4].win << " " << rr[4].flag << ENTER;
  flog << rr[5].set << " " << rr[5].seq << " " << rr[5].ack << " " <<
    rr[5].urg << " " << rr[5].win << " " << rr[5].flag << ENTER;
  flog << rr[6].set << " " << rr[6].seq << " " << rr[6].ack << " " <<
    rr[6].urg << " " << rr[6].win << " " << rr[6].flag << ENTER;
  flog.close ();

  return;
}
