//////////////////////////////////////////
//    Network Security Analysis Tool    //
//          (c) 1999 by Mixter          //
//////////////////////////////////////////

//   modified version of
// ADMsnmp (c) The ADM Crew

#include "snmp.h"

#ifdef EBUG
extern ofstream dbug;
#endif

struct snmpchex sntab[255];
char oldbanner[1024];

int
getret (u_char * buf, int size, struct snmpchex *sn)
{
  int i;
  for (i = 0; i < size; i++)
    if (buf[i] == '\x04')
      {

	memset ((char *) &sn->name, 0, sizeof (sn->name));

	if (buf[i + 1] < (sizeof (sn->name) - 1))
	  memcpy ((char *) &sn->name, (char *) &buf[i + 2], buf[i + 1]);
	else
	  return (-1);

	i = i + (buf[i + 1] + 1);
	for (; i < size && i + 2 < size; i++)
	  if (buf[i] == 0xa2)
	    {
	      for (; i < size && i + 2 < size; i++)
		if (buf[i] == '\x02')
		  {
		    sn->id = buf[i + 2];
		    for (i = i + (buf[i + 1] + 2); i < size && i + 2 < size; i++)
		      if (buf[i] == '\x02')
			if (buf[i + 1] == '\x01')
			  {
			    sn->ret = buf[i + 2];

			    return (i + 2);
			  }
			else
			  return (-1);
		  }
	    }
      }
  return (-1);
}

int
getreq (u_char * buf, char *name, int longid, u_char id, int set_req)
{
  int i = 0;
  buf[0] = 0x30;
  buf[1] = 0x82;
  buf[2] = 0x00;
  buf[3] = 16 + longid + strlen (name);
  buf[4] = 0x02;
  buf[5] = 0x01;
  buf[6] = 0x00;
  buf[7] = 0x04;
  buf[8] = strlen (name);

  strcpy ((char *) (buf + 9), name);
  i = 9 + strlen (name);
  if (set_req == 0)
    buf[i++] = 0xa0;
  else
    buf[i++] = 0xa3;

  buf[i++] = 9 + longid;
  buf[i++] = 0x02;
  buf[i++] = 0x1;
  buf[i++] = (u_char) id;
  buf[i++] = 0x02;
  buf[i++] = 0x01;
  buf[i++] = 0x00;
  buf[i++] = 0x02;
  buf[i++] = 0x01;
  buf[i++] = 0x00;

  return (20 + strlen (name));
}

int
makepktsnmp (int sock, u_char * sysdec, int sizeofsysdec, char *buf, int sizeofbuf, char *namez, int id, struct sockaddr_in *sin, int set_req)
{
  int i;
  int GETREQ_SYSDEC;
  GETREQ_SYSDEC = sizeofsysdec - 1;
  memset (buf, 0, sizeofbuf);
  i = getreq ((u_char *) buf, namez, GETREQ_SYSDEC, id, set_req);
  memcpy ((buf + i), sysdec, GETREQ_SYSDEC);
  return (sendto (sock, buf, i + GETREQ_SYSDEC, 0, (struct sockaddr *) sin, sizeof (struct sockaddr_in)));
}

int
req_makepktsnmp (int sock, char *buf, int sizeofbuf, char *namez, int id, struct sockaddr_in *sin)
{
  const u_char sysdec[] = "\x30\x10\x30\x82\x0\x0c\x06\x08\x2b\x06\x01\x02\x01\x01\x05\x00\x05\x00";
  return (makepktsnmp (sock, (u_char *) & sysdec, sizeof (sysdec), buf, sizeofbuf, namez, id, sin, 0));
}

int
set_makepktsnmp (int sock, char *buf, int sizeofbuf, char *name,
		 char *namez, int id, struct sockaddr_in *sin)
{
  int i, j;
  u_char *save;
  const u_char sysdec[] = "\x30\x10\x30\x82\x0\x09\x06\x08\x2b\x06\x01\x02\x01\x01\x05\x00";

  save = (u_char *) calloc (1, sizeof (sysdec) + strlen (namez) + 2);

  i = sizeof (sysdec);

  memcpy (save, (u_char *) & sysdec, i);

  i--;

  save[i++] = '\x04';
  save[i++] = strlen (namez);

  memcpy ((save + i), namez, strlen (namez));

  i = strlen (namez) + 3;

  save[1] = save[1] + strlen (namez);
  save[5] = save[5] + i;
  i--;

  j = makepktsnmp (sock, save, sizeof (sysdec) + i, buf, sizeofbuf, name, id, sin, 1);

  free (save);
  return (j);
}

int
snadd (struct snmpchex *sn, int taboff)
{
  int i;

  if (sn->id > 127)
    for (i = 0; i < 255; i++)
      if (strcmp ((char *) &sntab[i].name, sn->name) == 0)
	{
	  sntab[i].rw = 2;
	  return (-2);
	}

  for (i = 0; i < 255; i++)
    if (sntab[i].id == sn->id)
      {
	return (-1);
      }
    else if (strcmp ((char *) &sntab[i].name, sn->name) == 0)
      {
	return (-1);
      }

  strncpy ((char *) &sntab[taboff].name, (char *) &sn->name, 16);
  sntab[taboff].id = sn->id;
  sntab[taboff].ret = sn->ret;
  return (0);
}

int
snmpcheck (u_long ip)
{
  struct snmpchex sn;
  struct sockaddr_in sin;
  int sock;
  int i = 0, x;
  int cname = 0;
  u_char buf[255];
  char namez[24];

  int the_id = 10;
  int nd;
  int sntab_off = 0;
  int manysend = 0;
  struct timeval tv2, tv3;

  sin.sin_family = AF_INET;
  sin.sin_port = htons (161);
  sin.sin_addr.s_addr = ip;

  sock = socket (AF_INET, SOCK_DGRAM, IPPROTO_UDP);

  fcntl (sock, F_SETFL, O_NONBLOCK);

  the_id = 1;
  memset ((u_char *) & buf, 0, sizeof (buf));

  for (cname = 0; cname < SNMP_NAMES; cname++)
    {
      if (the_id > 127)
	the_id = 0;

      memset ((char *) &namez, 0, sizeof (namez));
      strncpy (namez, namelist[cname], 23);

      the_id++;

#ifdef EBUG
      dbug << "SNMP: QUERY (community=" << namez << ", id=" << the_id << ")\n";
#endif
      for (manysend = 0; manysend < SNMP_REPEAT; manysend++)
	{
	  if (the_id > 127)
	    the_id = 0;
	  else
	    the_id++;
	  if (req_makepktsnmp (sock, (char *) &buf, sizeof (buf), namez, the_id, &sin) < 0)
            {
            close(sock);
	    return (0);
            }
	  usleep (SNMP_TIMEOUT * 100);
	}

      usleep (SNMP_TIMEOUT * 100);

      memset ((u_char *) & buf, 0, sizeof (buf));
      x = sizeof (sin);

    awful_trick:
      if (cname == SNMP_NAMES - 1)
	{
	  gettimeofday (&tv3, NULL);
	  if ((tv2.tv_sec + SNMP_TIMEOUT) < tv3.tv_sec)
	    break;
	}
      else
	gettimeofday (&tv2, NULL);

      i = 0;

      if ((i = recvfrom (sock, (char *) &buf, sizeof (buf), 0, (struct sockaddr *) &sin, (u_int *) & x)) > 0)
	{
	  nd = 0;
	  nd = getret ((u_char *) & buf, i, &sn);
#ifdef EBUG
	  dbug << "SNMP: RESP (community=" << sn.name << ", id=" << sn.id <<
	    ", ret=" << sn.ret << ")\n";
#endif
	  if (nd > 0 && sn.ret == 0)
	    {
	      for (; nd < i; nd++)
		if (buf[nd] == 0x04)
		  {
		    if (oldbanner[0] == '\0')
		      for (i = 0; i < buf[nd + 1]; i++)
			{
			  oldbanner[i] = buf[nd + 2 + i];
			}

		    memset ((u_char *) & buf, 0, sizeof (buf));
		    if (snadd (&sn, sntab_off++) == 0)
		      {
#ifdef EBUG
			dbug << "SNMP: SETREQ (community=" << sn.name << ", id=" << sn.id << ")\n";
#endif
			for (manysend = 0; manysend < SNMP_REPEAT; manysend++)
			  {
			    set_makepktsnmp (sock, (char *) &buf, sizeof (buf), (char *) &sn.name, "ADMsnmp", the_id + 127, &sin);
			    usleep (SNMP_TIMEOUT * 100);
			  }
		      }
		  }
	    }
	  memset ((u_char *) & buf, 0, sizeof (buf));
	  i = 0;
	}
      else if (cname == SNMP_NAMES - 1)
	goto awful_trick;
    }

  for (i = 0; i < 255; i++)
    if (sntab[i].id != -666)
      if (sntab[i].rw == 2)
	{
	  set_makepktsnmp (sock, (char *) &buf, sizeof (buf), (char *) &sntab[i].name, (char *) &oldbanner, the_id + 127, &sin);
	  usleep (SNMP_TIMEOUT * 100);
	  set_makepktsnmp (sock, (char *) &buf, sizeof (buf), (char *) &sntab[i].name, (char *) &oldbanner, the_id + 127, &sin);
	  usleep (SNMP_TIMEOUT * 100);
	}

  close (sock);
  return (0);
}

void
snmpwalk (u_long ip)
{
  int i;

  for (i = 0; i < 255; i++)
    {
      memset (sntab[i].name, 0, 16);
      sntab[i].id = -666;
      sntab[i].rw = 0;
      sntab[i].ret = -666;
    }
  memset (oldbanner, 0, sizeof (oldbanner));

  snmpcheck (ip);

  ofstream log;
  log.open (L_SNMP, 8);

  if (strlen (oldbanner) > 0)
    log << ntoa (ip) << " - sys.sysName.0:" << oldbanner << ENTER;

  for (i = 0; i < 255; i++)
    {
      if (sntab[i].id != -666)
	{
	  log << ntoa (ip) << " - community '" <<
	    ((char *) &sntab[i].name) << "' - ";
	  if (sntab[i].rw == 2)
	    log << "NOAUTH WRITE ACCESS\n";
	  else
	    log << "NOAUTH readonly access\n";
	}
    }

  log.close ();
  return;
}
