//////////////////////////////////////////
//    Network Security Analysis Tool    //
//          (c) 1999 by Mixter          //
//////////////////////////////////////////

// based off webscan.c by Mixter

// parts from: whisker (c) .rain.forest.puppy.
// cgiscan (c) [CKS & Fdisk], VoidEye scanner, 
// httpver (c) Shok

#include "../nsat.h"
#include "www.h"

extern char *strchop (char *);
extern ProgressIndicator pi;
extern sigjmp_buf stack;

int count, sock;

char whost[BUFSIZE];

void http_get (const char *, char *, struct sockaddr_in *, int);

void
webscan (int s0ck)
{
  int i, numbytes;
  u_int nl = sizeof (struct sockaddr);
  char buffer[170];
  char *p = NULL;
  struct sockaddr_in sin;
  ofstream f1;

  sock = s0ck;

  if (getpeername (sock, (struct sockaddr *) &sin, &nl) < 0)
    return;

  strncpy (whost, inet_ntoa (sin.sin_addr), BUFSIZE);

  send (sock, "GET / HTTP/1.0\n\n", 16, 0);

  for (i = 0; i < 5; i++)
    {
      bzero (buffer, sizeof (buffer));
      if ((numbytes = recv (sock, buffer, 169, 0)) < 1)
	break;
      p = strstr (buffer, "Server");
      if (p == NULL)
	continue;
      else
	{
	  strchop (p);
	  f1.open (L_HTTVER, 8);
	  f1 << whost << " - " << p + 8 << ENTER;
	  f1.close ();
	}
    }
  close (sock);

  if (!pi.verbose)
    return;

  count = 0;
  while (strstr (www_cgibin[count], "EOF") == NULL)
    {
      http_get (www_cgibin[count], whost, &sin, sizeof (sin));
      count++;
    }

  if (pi.verbose < 2)
    return;

  count = 0;
  while (strstr (www_extensions[count], "EOF") == NULL)
    {
      http_get (www_extensions[count], whost, &sin, sizeof (sin));
      count++;
    }

  if (pi.verbose < 3)
    return;

  count = 0;
  while (strstr (www_winnt[count], "EOF") == NULL)
    {
      http_get (www_winnt[count], whost, &sin, sizeof (sin));
      count++;
    }

}

void 
http_get (const char *file, char *whost, struct sockaddr_in *sin, int slen)
{
  char cgibuff[512];
  const char *foundmsg = "200";
  sock = socket (AF_INET, SOCK_STREAM, 0);
  ofstream f2;

  if (sigsetjmp (stack, 1) == 666)
    {
      close (sock);
      siginterrupt (SIGALRM, 1);
      return;
    }
  snprintf (cgibuff, 510, "GET %s HTTP/1.0\n\n\0", file);
  alarm (pi.timeout);
  connect (sock, (struct sockaddr *) sin, slen);
  alarm (0);
  send (sock, cgibuff, strlen (cgibuff), 0);
  bzero (cgibuff, sizeof (cgibuff));
  recv (sock, cgibuff, sizeof (cgibuff) - 1, 0);
  if (strstr (cgibuff, foundmsg) != NULL)
    {
      f2.open (L_CGI, 8);
      f2 << whost << " - " << file << ENTER;
      f2.close ();
    }
  close (sock);
}
