//////////////////////////////////////////
//    Network Security Analysis Tool    //
//          (c) 1999 by Mixter          //
//                                      //
//          auditing functions          //
//////////////////////////////////////////

#pragma implementation "auditset"
#include "AuditSet.h"
#include "mod/shellcode.h"

extern sigjmp_buf stack;
extern ProgressIndicator pi;

#ifdef EBUG
extern ofstream dbug;
#endif

int len;

AuditSet::AuditSet (void)
{
  firstopen = 0;
  signal (SIGALRM, hook);
  signal (SIGPIPE, hook);
}

AuditSet::~AuditSet (void)
{
  firstopen = 0;
  signal (SIGALRM, SIG_DFL);
  signal (SIGPIPE, SIG_DFL);
}

inline char *AuditSet::Hostname (void)
{
  struct in_addr h;
  h.s_addr = target;
  return (inet_ntoa (h));
}

void AuditSet::plog (int s, char *desc)
{
  SCLOSE (s);
  log.open (L_PORTS, 8);
  log << Hostname () << " - " << desc << ENTER;
  log.close ();
}

void AuditSet::nstat (int s)
{
  log.open (L_PORTS, 8);
  log << Hostname () << " - NETSTAT Service\n";
  log.close ();
  if (pi.verbose > 1)
    {
      SCLOSE (s);
      return;
    }

  log.open (L_NETSTAT, 8);
  log << M_LBANNER << Hostname () << M_RBANNER;
  char b[BUFSIZE];
  memset (b, 0, BUFSIZE);
  alarm (timeout);
  if (sigsetjmp (stack, 1) == 666)
    {
      SCLOSE (s);
      log.close ();
      alarm (0);
      return;
    }
  read (s, b, BUFSIZE - 1);
  alarm (0);
  log << b << ENTER;
  log.close ();
  SCLOSE (s);
}

void AuditSet::ftp (int s)
{
  alarm (timeout * 5);
  if (sigsetjmp (stack, 1) != 666)
    {
      log.open (L_FTP, 8);
      char b[BUFSIZE];
      int l = 1;
      memset (b, 0, BUFSIZE);
      while (strstr (b, ENTER) == NULL && l > 0)
	l = read (s, b + strlen (b), BUFSIZE - strlen (b) - 1);
      log << Hostname () << " - " << b;
      if (pi.verbose > 1)
	ftptest (s, Hostname ());
    }
  siginterrupt (SIGALRM, 1);
  log.close ();
  alarm (0);
  SCLOSE (s);
}

void AuditSet::ssh (int s)
{
  log.open (L_SSH, 8);
  char b[BUFSIZE];
  memset (b, 0, BUFSIZE);
  alarm (timeout);
  if (sigsetjmp (stack, 1) == 666)
    {
      SCLOSE (s);
      alarm (0);
      log.close ();
      return;
    }
  read (s, b, BUFSIZE - 1);
  alarm (0);
  log << Hostname () << " - " << b;
  log.close ();
  SCLOSE (s);
}

void AuditSet::telnet (int s)
{
  log.open (L_TELNET, 8);
  char b[BUFSIZE * 2];

  len = 0;

  if (pi.verbose < 3)
    {
      log << Hostname () << ENTER;
      log.close ();
      SCLOSE (s);
      return;
    }

  alarm (timeout * 10);
  if (sigsetjmp (stack, 1) == 666)
    {
      log.close ();
      SCLOSE (s);
      siginterrupt (SIGALRM, 1);
      return;
    }

  while (len != 1337)
    {
      memset (b, 0, sizeof (b));
      if ((len = read (s, b, 1)) <= 0)
	break;
      if (*b == '\xff')
	{
	  read (s, (b + 1), 2);
	  if (*(b + 1) == '\xfd' && !*(b + 2));
	  else if (*(b + 1) == '\xfd')
	    {
	      *(b + 1) = '\xfc';
	      write (s, b, 3);
	    }
	}
      else
	{
	  if (*b != 0)
	    {
	      memset (b, 0, sizeof (b));
	      read (s, b, sizeof (b));
	      len = 1337;
	    }
	}
    }

  alarm (0);
  SCLOSE (s);
  strnsubst (b, sizeof (b));
  strlower (b);

  if (strlen (b) < 2)
    {
      log << Hostname () << " - ALL:ALL in hosts.deny?\n";
      log.close ();
      return;
    }
  if (strstr (b, "irix"))
    {
      log << Hostname () << " - IRIX\n";
      log.close ();
      return;
    }
  if (strstr (b, "system v"))
    {
      log << Hostname () << " - System V banner\n";
      log.close ();
      return;
    }
  if (strstr (b, "solaris"))
    {
      log << Hostname () << " - Solaris\n";
      log.close ();
      return;
    }
  if (strstr (b, "sunos"))
    {
      log << Hostname () << " - SunOS\n";
      log.close ();
      return;
    }
  if (strstr (b, "wingate"))
    {
      log << Hostname () << " - Open WinGate\n";
      log.close ();
      return;
    }
  if (strstr (b, "red hat"))
    {
      log << Hostname () << " - RedHat Linux\n";
      log.close ();
      return;
    }
  if (strstr (b, "suse"))
    {
      log << Hostname () << " - SuSE Linux\n";
      log.close ();
      return;
    }
  if (strstr (b, "slackware"))
    {
      log << Hostname () << " - Slackware Linux\n";
      log.close ();
      return;
    }
  if (strstr (b, "debian"))
    {
      log << Hostname () << " - Debian Linux\n";
      log.close ();
      return;
    }
  if (strstr (b, "linux"))
    {
      log << Hostname () << " - Linux\n";
      log.close ();
      return;
    }
  if (strstr (b, "freebsd"))
    {
      log << Hostname () << " - FreeBSD\n";
      log.close ();
      return;
    }
  if (strstr (b, "netbsd"))
    {
      log << Hostname () << " - NetBSD\n";
      log.close ();
      return;
    }
  if (strstr (b, "openbsd"))
    {
      log << Hostname () << " - OpenBSD\n";
      log.close ();
      return;
    }
  if (strstr (b, "bsdi"))
    {
      log << Hostname () << " - BSDi\n";
      log.close ();
      return;
    }
  if (strstr (b, "bsd"))
    {
      log << Hostname () << " - BSD\n";
      log.close ();
      return;
    }
  if (strstr (b, "cisco"))
    {
      log << Hostname () << " - CISCO IOS\n";
      log.close ();
      return;
    }
  if (strstr (b, "sco"))
    {
      log << Hostname () << " - SCO UNIX\n";
      log.close ();
      return;
    }
  if (strstr (b, "vms"))
    {
      log << Hostname () << " - OpenVMS/VAX\n";
      log.close ();
      return;
    }
  if (strstr (b, "hp"))
    {
      log << Hostname () << " - HP-UNIX\n";
      log.close ();
      return;
    }
  if (strstr (b, "next"))
    {
      log << Hostname () << " - NeXT\n";
      log.close ();
      return;
    }
  if (strstr (b, "dg"))
    {
      log << Hostname () << " - DG-UNIX\n";
      log.close ();
      return;
    }
  if (strstr (b, "user access"))
    {
      log << Hostname () << " - running radius / router\n";
      log.close ();
      return;
    }
  if (strstr (b, "ascend"))
    {
      log << Hostname () << " - insecure ascend router\n";
      log.close ();
      return;
    }
  if (strstr (b, "cisco"))
    {
      log << Hostname () << " - insecure cisco router\n";
      log.close ();
      return;
    }
  if (strstr (b, "password"))
    {
      log << Hostname () << " - system password (probably router)\n";
      log.close ();
      return;
    }
  if (strstr (b, "telnet"))
    {
      log << Hostname () << " - unknown gateway/proxy\n";
      log.close ();
      return;
    }
  if (strstr (b, "gate"))
    {
      log << Hostname () << " - unknown gateway/proxy\n";
      log.close ();
      return;
    }
  if (strstr (b, "login"))
    {
      log << Hostname () << " - unknown login\n";
      log.close ();
      return;
    }
  log << Hostname () << " - UNKNOWN:\n";
  log << Hostname () << b << ENTER;
  log.close ();
  return;
}

void AuditSet::smtp (int s)
{
  log.open (L_SMTP, 8);
  int siz = BUFSIZE * 5;
  char b[siz + 1];
  if (sigsetjmp (stack, 1) == 666)
    {
      log.close ();
      siginterrupt (SIGALRM, 1);
      SCLOSE (s);
      return;
    }
  alarm ((timeout) * 10);
  memset (b, 0, siz);
  while (strstr (b, ENTER) == NULL)
    read (s, b + strlen (b), siz - strlen (b));
  log << Hostname () << " - " << b;
  memset (b, 0, siz);
  write (s, SMTP_EXPN, strlen (SMTP_EXPN));
  while (strstr (b, ENTER) == NULL)
    read (s, b + strlen (b), siz - strlen (b));
  if (strstr (b, "250"))
    {
      log << Hostname () << " - allows expn / vrfy\n";
      log.flush ();
    }
  else
    {
      write (s, SMTP_VRFY, strlen (SMTP_VRFY));
      memset (b, 0, siz);
      while (strstr (b, ENTER) == NULL)
	read (s, b + strlen (b), siz - strlen (b));
      if (strstr (b, "250"))
	log << Hostname () << " - allows expn / vrfy\n";
      log.flush ();
    }
  write (s, SMTP_HELO, strlen (SMTP_HELO));
  memset (b, 0, siz);
  while (strstr (b, ENTER) == NULL)
    read (s, b + strlen (b), siz - strlen (b));
  write (s, SMTP_FROM, strlen (SMTP_FROM));
  memset (b, 0, siz);
  while (strstr (b, ENTER) == NULL)
    read (s, b + strlen (b), siz - strlen (b));
  write (s, SMTP_TO, strlen (SMTP_TO));
  memset (b, 0, siz);
  while (strstr (b, ENTER) == NULL)
    read (s, b + strlen (b), siz - strlen (b));
  write (s, SMTP_DATA, strlen (SMTP_DATA));
  while (strstr (b, ENTER) == NULL)
    read (s, b + strlen (b), siz - strlen (b));
  write (s, SMTP_END, strlen (SMTP_END));
  while (strstr (b, ENTER) == NULL)
    read (s, b + strlen (b), siz - strlen (b));
  write (s, SMTP_QUIT, strlen (SMTP_QUIT));
  alarm (0);
  if (strstr (b, "354") || strstr (b, "250"))
    log << Hostname () << " - allows fakemail / spam\n";
  log.close ();
  sleep (1);			/* avoid ugly sendmail syslog errors... */
  SCLOSE (s);
}

void AuditSet::nbind (int s)
{
  SCLOSE (s);
  if (sigsetjmp (stack, 1) != 666)
    probe_bind (sin, timeout);
  siginterrupt (SIGALRM, 1);
}

void AuditSet::finger (int s)
{
  if (sigsetjmp (stack, 1) == 666)
    {
      log.close ();
      SCLOSE (s);
      siginterrupt (SIGALRM, 1);
      return;
    }

  if (pi.verbose < 3)
    {
      SCLOSE (s);
      log.open (L_PORTS, 8);
      log << Hostname () << " - finger\n";
      log.close ();
      return;
    }

  alarm (timeout * 3);

  if (write (s, FINGER_HELLCODE, sizeof (FINGER_HELLCODE)) == -1)
    {
#ifdef EBUG
      dbug << "write failed: " << strerror (errno) << ENTER;
#endif
      alarm (0);
      SCLOSE (s);
      return;
    }
  log.open (L_PORTS, 8);
  log << Hostname () << " - finger\n";
  log.close ();
  char b[BUFSIZE * 2];
  memset (b, 0, BUFSIZE * 2);
  read (s, b, (BUFSIZE * 2) - 1);
  alarm (0);
  if (strlen (strnsubst (b, sizeof (b))) > 2)
    {
      log.open (L_FINGER, 8);
      log << M_LBANNER << Hostname () << M_RBANNER;
      log << b << ENTER;
      log.close ();
    }
  SCLOSE (s);
}

void AuditSet::http (int s)
{
  if (sigsetjmp (stack, 1) != 666)
    webscan (s);
  siginterrupt (SIGALRM, 1);
  SCLOSE (s);
}

void AuditSet::pop2 (int s)
{
  alarm (timeout);
  if (sigsetjmp (stack, 1) == 666)
    {
      log.close ();
      SCLOSE (s);
      siginterrupt (SIGALRM, 1);
      return;
    }
  log.open (L_POP2, 8);
  char b[BUFSIZE];
  memset (b, 0, BUFSIZE);
  read (s, b, BUFSIZE - 1);
  alarm (0);
  log << Hostname () << " - " << b << "\n";
  log.close ();
  SCLOSE (s);
}

void AuditSet::pop3 (int s)
{
  alarm (timeout);
  if (sigsetjmp (stack, 1) == 666)
    {
      log.close ();
      SCLOSE (s);
      siginterrupt (SIGALRM, 1);
      return;
    }
  log.open (L_POP3, 8);
  char b[BUFSIZE];
  memset (b, 0, BUFSIZE);
  read (s, b, BUFSIZE - 1);
  alarm (0);
  log << Hostname () << " - " << strchop (b) << "\n";
  log.close ();
  SCLOSE (s);
}

void AuditSet::pmap (int s)
{
  SCLOSE (s);
  log.open (L_PORTS, 8);
  log << Hostname () << " - portmap\n";
  log.close ();
  if (pi.verbose)
    {
      alarm (timeout);
      if (sigsetjmp (stack, 1) == 666)
	{
	  siginterrupt (SIGALRM, 1);
	  return;
	}
      rpccheck (Hostname ());
    }
}

void AuditSet::nntp (int s)
{
  alarm (timeout * 3);
  if (sigsetjmp (stack, 1) == 666)
    {
      log.close ();
      SCLOSE (s);
      siginterrupt (SIGALRM, 1);
      return;
    }
  log.open (L_NNTP, 8);
  char b[BUFSIZE];
  memset (b, 0, BUFSIZE);
  read (s, b, BUFSIZE - 1);
  alarm (0);
  log << Hostname () << " - " << b << "\n";
  log.close ();
  SCLOSE (s);
}

void AuditSet::smb (int s)
{
  SCLOSE (s);
  int pid = fork ();
  if (pid == 0)
    {
      execlp ("smb-ns", "smb-ns", Hostname (), NULL);
      raise (SIGKILL);
    }
  else
    {
      sleep (timeout * 5);
      kill (pid, SIGKILL);
    }
}

void AuditSet::imap (int s)
{
  alarm (timeout * 3);
  if (sigsetjmp (stack, 1) == 666)
    {
      log.close ();
      SCLOSE (s);
      siginterrupt (SIGALRM, 1);
      return;
    }
  log.open (L_IMAP, 8);
  char b[BUFSIZE];
  memset (b, 0, BUFSIZE);
  read (s, b, BUFSIZE - 1);
  alarm (0);
  log << Hostname () << " - " << b << "\n";
  log.close ();
  SCLOSE (s);
}

void AuditSet::bd666 (int s)
{
  alarm (timeout * 2);
  if (sigsetjmp (stack, 1) == 666)
    {
      SCLOSE (s);
      siginterrupt (SIGALRM, 1);
      return;
    }
  if (send (s, ROOTINFO, sizeof (ROOTINFO), 0) == -1)
    {
#ifdef EBUG
      dbug << "send failed: " << strerror (errno) << ENTER;
#endif
      alarm (0);
      SCLOSE (s);
      return;
    }
  log.open (L_PORTS, 8);
  log << Hostname () << " - port 666 (doom server or backdoor)\n";
  log.close ();
  if (pi.verbose > 1)
    {
      SCLOSE (s);
      alarm (0);
      return;
    }
  char b[BUFSIZE];
  memset (b, 0, BUFSIZE);
  recv (s, b, BUFSIZE - 1, 0);
  alarm (0);
  if (strlen (b) > 3)
    {
      log.open (L_BACKDOOR, 8);
      log << M_LBANNER << Hostname () << " port 666" << M_RBANNER;
      log << b << ENTER;
      log.close ();
    }
  SCLOSE (s);
}

void AuditSet::bd1524 (int s)
{
  alarm (timeout * 2);
  if (sigsetjmp (stack, 1) == 666)
    {
      SCLOSE (s);
      siginterrupt (SIGALRM, 1);
      return;
    }
  if (send (s, ROOTINFO, sizeof (ROOTINFO), 0) == -1)
    {
#ifdef EBUG
      dbug << "send failed: " << strerror (errno) << ENTER;
#endif
      alarm (0);
      SCLOSE (s);
      return;
    }
  log.open (L_PORTS, 8);
  log << Hostname () << " - port 1524 (ingreslock server or backdoor)\n";
  log.close ();
  if (pi.verbose > 1)
    {
      SCLOSE (s);
      alarm (0);
      return;
    }
  char b[BUFSIZE];
  memset (b, 0, BUFSIZE);
  recv (s, b, BUFSIZE - 1, 0);
  alarm (0);
  if (strlen (b) > 3)
    {
      log.open (L_BACKDOOR, 8);
      log << M_LBANNER << Hostname () << " port 1524" << M_RBANNER;
      log << b << ENTER;
      log.close ();
    }
  SCLOSE (s);
}

void AuditSet::nlps (int s)
{
  log.open (L_PORTS, 8);
  log << Hostname () << " - 2766 (solaris nlpsd)\n";
  log.close ();
  if (pi.verbose > 2)
    {
      SCLOSE (s);
      return;
    }
  if (sigsetjmp (stack, 1) == 666)
    {
      SCLOSE (s);
      siginterrupt (SIGALRM, 1);
      return;
    }
  alarm (timeout);
  write (s, nlps_x86, sizeof (nlps_x86));
  write (s, ROOTINFO, sizeof (ROOTINFO));
  char b[BUFSIZE];
  memset (b, 0, BUFSIZE);
  read (s, b, BUFSIZE - 1);
  alarm (0);
  if (strlen (b) > 2)
    {
      log.open (L_NLPS, 8);
      log << M_LBANNER << Hostname () << M_RBANNER << b << ENTER;
      log.close ();
    }
  SCLOSE (s);
}

void AuditSet::ircd (int s)
{
  log.open (L_PORTS, 8);
  log << Hostname () << " - ircd\n";
  log.close ();
  if (pi.verbose > 2)
    {
      SCLOSE (s);
      return;
    }
  char b[BUFSIZE * 3];
  if (sigsetjmp (stack, 1) == 666)
    {
      SCLOSE (s);
      siginterrupt (SIGALRM, 1);
      return;
    }
  alarm ((timeout) * 10);
  write (s, IRC_QUERY, sizeof (IRC_QUERY));
  while (!strstr (b, " 351 "))
    {
      memset (b, 0, (BUFSIZE * 3));
      if (!read (s, b, (BUFSIZE * 3) - 1))
	return;
    }
  alarm (0);
  log.open (L_IRCD, 8);
  log << M_LBANNER << Hostname () << M_RBANNER << b << ENTER;
  log.close ();
  SCLOSE (s);
}

void AuditSet::xwin (int s)
{
  log.open (L_PORTS, 8);
  log << Hostname () << " - X windows\n";
  log.close ();
  if (pi.verbose < 2)
    {
      SCLOSE (s);
      return;
    }
  char disp[BUFSIZE];
  snprintf (disp, BUFSIZE - 1, "%s:0", Hostname ());
  struct Display *d;
  if ((d = XOpenDisplay (disp)) != NULL)
    {
      log.open (L_XWIN, 8);
      log << Hostname () << " - dumpable/sniffable\n";
      log.close ();
      XCloseDisplay (d);
    }

  SCLOSE (s);
}

void AuditSet::nbname (void)
{
/* raw nbname session from nbname.c (c) by mynock */
  const char *nbquery =
  "\x03\x00\x00\x00\x00\x01\x00\x00\x00\x00\x00\x00\x20\x43\x4b\x41\x41"
  "\x41\x41\x41\x41\x41\x41\x41\x41\x41\x41\x41\x41\x41\x41\x41\x41\x41"
  "\x41\x41\x41\x41\x41\x41\x41\x41\x41\x41\x41\x00\x00\x21\x00\x00";
  int sockfd, i, n;
  struct sockaddr_in servaddr, myaddr;
  char buf[1024];
  fd_set readfs;
  struct timeval tv;
  bzero (&servaddr, sizeof (struct sockaddr_in));
  servaddr.sin_family = AF_INET;
  servaddr.sin_port = htons (137);
  servaddr.sin_addr.s_addr = target;
  sockfd = socket (AF_INET, SOCK_DGRAM, 0);
  memset (&myaddr, 0, sizeof (myaddr));
  myaddr.sin_family = AF_INET;
  myaddr.sin_port = htons (137);
  myaddr.sin_addr.s_addr = htonl (INADDR_ANY);
  bind (sockfd, (struct sockaddr *) &myaddr, sizeof (myaddr));
  while (1)
    {
      sendto (sockfd, nbquery, 50, 0, (struct sockaddr *) &servaddr, sizeof (struct sockaddr_in));
      FD_ZERO (&readfs);
      FD_SET (sockfd, &readfs);
      tv.tv_sec = 5;
      tv.tv_usec = 0;
      n = select (sockfd + 1, &readfs, NULL, NULL, &tv);
      switch (n)
	{
	case 1:
	  if ((i = recvfrom (sockfd, buf, 800, 0, NULL, NULL)) < 0)
	    {
	      SCLOSE (sockfd);
	      return;
	    }
	  break;
	case 0:
	  SCLOSE (sockfd);
	  return;
	  break;
	default:
	  SCLOSE (sockfd);
	  return;
	  break;
	}
      if (n == 1)
	break;
    }

  if (strlen (buf + 58) < 2)
    {
      SCLOSE (sockfd);
      return;
    }

  log.open (L_NETBIOS, 8);
  log << Hostname () << " - ";
  for (n = 57; (n < i) && (buf[n] != ' '); n++)
    log << buf[n];
  log << ENTER;
  log.close ();

  SCLOSE (sockfd);
  return;
}

void AuditSet::bo (int s)
{
  alarm (timeout * 5);
  if (sigsetjmp (stack, 1) == 666)
    return;

  if (!sendpacket (target, 31337, s))
    getinput (s);
#ifdef EBUG
  else
    dbug << "sendping failed: " << Hostname () << ENTER;
#endif

  SCLOSE (s);
}

void AuditSet::os (void)
{
  alarm (timeout * 5);
  if (sigsetjmp (stack, 1) == 666)
    return;

  if (firstopen)
    tcprobe (target, firstopen, timeout);
  else if (pi.verbose > 2)
    tcprobe (target, 113, timeout);

  alarm (0);
}

void AuditSet::snmp (void)
{
  alarm (timeout * 5);
  if (sigsetjmp (stack, 1) == 666)
    return;
  snmpwalk (target);
  alarm (0);
}
