//////////////////////////////////////////
//    Network Security Analysis Tool    //
//          (c) 1999 by Mixter          //
//                                      //
//          process allocation          //
//////////////////////////////////////////

// these nice easy functions are responsible for core
// process stability and need to succeed every time

#include "pidalloc.h"
#pragma implementation "pidalloc"

#ifdef EBUG
extern ofstream dbug;
#endif

int
alloc_scan (char *host)
{
  int i;

  if (pi.stealth)
    while (!sysidle (pi.idle))
      {
	alloc_purge ();
	sleep (pi.idle);
      }

cheap_trick:
// find a free pid slot
  for (i = 0; i <= pi.maxproc; i++)
    {
      if (pidtable[i] == 0)
	break;
#ifdef EBUG
      dbug << "pidslot " << i << " occupied (" << pidtable[i] << ")...\n";
#endif
    }

  if (i >= pi.maxproc)
    {
#ifdef EBUG
      dbug << "all process slots occupied, purging...\n";
#endif
      sleep (pi.maxlife / 2);
      alloc_purge ();
      goto cheap_trick;
    }

  timetable[i] = pi.tstamp;
  pidtable[i] = safe_fork ();

  if (!pidtable[i])
    {
      scan (host);
      raise (SIGKILL);
      return (0);
    }

  return (pidtable[i]);
}

void
alloc_purge (void)
{
  int i;

  for (i = 0; i <= pi.maxproc; i++)
    if (pidtable[i] != 0)	// unf, purge, unf, purge, unf, purge ...

      {
#ifdef EBUG
	dbug << "pid " << pidtable[i] << " active\n";
#endif
	errno = 0;
	if (kill (pidtable[i], SIGALRM) == -1)
	  pidtable[i] = 0;	// purged (process exited)

	else if ((pi.tstamp - timetable[i]) > pi.maxlife)
	  {
#ifdef EBUG
	    dbug << "pid " << pidtable[i] << " purged: " <<
	      (pi.tstamp - timetable[i]) << "sec \n";
#endif
	    kill (pidtable[i], SIGTERM);
	    usleep (500);
	    kill (pidtable[i], SIGKILL);
	    pidtable[i] = 0;	// purged (process killed)

	  }
      }
  return;
}

void
scan (char *host)
{
#ifdef EBUG
  dbug.close ();
  char buf[256];
  snprintf (buf, 255, "debug.%d.log", getpid ());
  dbug.open (buf, 8);
  dbug << "NewChild " << " scanning " << host << ENTER;
#endif

  SockSet scan;
  if (scan.con (host))
    scan.probe (pi.timeout);

  return;
}
