//////////////////////////////////////////
//    Network Security Analysis Tool    //
//          (c) 1999 by Mixter          //
//                                      //
//     connection class declaration     //
//////////////////////////////////////////

#ifndef SOCKSET_H
#define SOCKSET_H
#pragma interface "sockset"
#include "AuditSet.h"

#define TCount		35
#define MAXCAPLEN	1024
#define SALen		sizeof(struct sockaddr_in)

class SockSet:private AuditSet
{
 private:

  int sflags;			// default socket flags
  int tSet[TCount];		// sockets
  int tTest[TCount];		// connect results
  long SetId;			// random session id

 protected:

  void sCon (int sc, int sn);	// connect
  int check (int ref, fd_set * fdsp);	// is there data to read
  int check (int ref);		// is the connection established

 public:

  int icmptest (int s);
  int con (char *host);		// mass connect
  void probe (int timeout);	// read and evaluate
  SockSet (void);
  ~SockSet (void);
};

#endif
