//////////////////////////////////////////
//    Network Security Analysis Tool    //
//          (c) 1999 by Mixter          //
//                                      //
//    includes, defines, prototypes     //
//////////////////////////////////////////

#ifndef NSAT_H
#define NSAT_H
#define VERSION "1.11"
#define __USE_BSD
#ifdef __cplusplus
#include <iostream.h>
#include <fstream.h>
#endif
#include "config.h"
#include "progress.h"
#include <stdio.h>
#include <string.h>
#include <strings.h>
#include <stdlib.h>
#include <netdb.h>
#include <errno.h>
#include <unistd.h>
#include <fcntl.h>
#include <setjmp.h>
#include <ctype.h>
#include <signal.h>
#include <sys/socket.h>
#include <sys/stat.h>
#include <sys/time.h>
#include <sys/types.h>
#include <sys/signal.h>
#ifdef SOLARIS
typedef u_char u_int8_t;
typedef u_short u_int16_t;
typedef u_long u_int32_t;
#include <sys/stream.h>
#include <sys/dlpi.h>
#include <sys/bufmod.h>
#include <sys/time.h>
#include <sys/file.h>
#include <sys/stropts.h>
#include <sys/param.h>
#include <sys/termios.h>
#include <sys/filio.h>
#include <net/if.h>
#include <netinet/in.h>
#include <netinet/in_systm.h>
#include <netinet/ip.h>
#include <netinet/ip_var.h>
#include <netinet/ip_icmp.h>
#if !defined(iphdr)
struct iphdr
{
  unsigned char version:4, ihl:4, tos;
  unsigned short tot_len, id, frag_off;
  unsigned char ttl, protocol;
  unsigned short check;
  unsigned int saddr, daddr;
};
#endif	/* defined iphdr */
#if !defined(icmphdr)
struct icmphdr
{
  unsigned char type, code;
  unsigned short checksum;
    union
  {
    struct
    {
      u_int16_t id;
      u_int16_t sequence;
    } echo;                     
    u_int32_t   gateway;     
    struct
    {
      u_int16_t __unused;
      u_int16_t mtu;
    } frag;                  
  } un;
};
#endif /* defined icmphdr */
#endif  /* defined s0l4r15 */
#if !defined(u_int8_t) && defined(uint8_t)
#define u_int8_t uint8_t
#endif
#if !defined(u_int16_t) && defined(uint16_t)
#define u_int16_t uint16_t
#endif
#if !defined(u_int32_t) && defined(uint32_t)
#define u_int32_t uint32_t
#endif
#include <netinet/in.h>
#include <netinet/ip_icmp.h>
#include <arpa/inet.h>
#include <sys/ioctl.h>

#define NSAT_BANNER "\tNetwork Security Analysis Tool v"VERSION"\t(c) 1999 Mixter"
#define OSCOUNT 114
#define IPADDR_ANY (long)0
#define getrandom(min, max) ((rand() % (int)(((max)+1) - (min))) + (min))
#define USOCK socket(AF_INET,SOCK_DGRAM,IPPROTO_IP)
#define TSOCK socket(AF_INET,SOCK_STREAM,IPPROTO_TCP)
#define ISOCK socket (AF_INET, SOCK_RAW, IPPROTO_ICMP)

#if __BYTE_ORDER == __BIG_ENDIAN
#define ntohl(x)        (x)
#define ntohs(x)        (x)
#define htonl(x)        (x)
#define htons(x)        (x)
#endif

/* nsat prototypes */
int isip (char *);		// check if string is a numeric ip
int incip (char *);		// increase numeric ip by one
u_long resolve (char *);	// convert hostname or ip to longip
char *strlower (char *);	// convert all ascii to lowercase ascii
char *strchop (char *);		// cut off string at line break
char *strunf (char *);		// convert line breaks to spaces
char *strnsubst (char *, int);	// remove single null's
u_short cksum (u_short *, int);	// BSD ip and tcp checksum
void hook (int);		// timeout sighandler
void doh (int);			// critical sighandler
void ssh (int);			// interruption sighandler
int sysidle (int);		// check for active users
void sigset (void);		// preset sig actions
char *ntoa (u_long);		// without the silly sockaddr_in
int safe_fork (void);		// error and stealth-checking fork
void usage (char *);		// print usage and die
void writepid (int);		// create pid file
int readpid (void);		// read and check pid file

#ifdef PARANOID_CHECK
int nicefile (char *);		// symlink check
#endif

/* mod prototypes */
int ftptest (int, char *);
int probe_bind (struct sockaddr_in, int);
void webscan (int);
int rpccheck (char *);
int sendpacket (unsigned long, int, int);
int getinput (int);
void tcprobe (u_long, int, int);
void snmpwalk (u_long);

#endif
