//////////////////////////////////////////
//    Network Security Analysis Tool    //
//          (c) 1999 by Mixter          //
//                                      //
//   connection management functions    //
//////////////////////////////////////////

#pragma implementation "sockset"
#include "SockSet.h"
#include "services.h"

#ifdef EBUG
extern ofstream dbug;
#endif

extern sigjmp_buf stack;
extern ProgressIndicator pi;

SockSet::SockSet (void)
{
  int opt = MAXCAPLEN, one = 1, i;

  timeout = pi.timeout;
  srandom ((time (NULL) + random ()));
  SetId = random ();

  for (i = 0; i <= TCP_SERV_TOTAL; i++)	// tcp sockets
    {
    poor_trick:
      tSet[i] = TSOCK;
      if (!i)
	sflags = fcntl (tSet[i], F_GETFL, 0);

      if (tSet[i] == -1)
	{
#ifdef EBUG
	  dbug << "socket() failing: " << strerror (errno) << ", waiting to try again...\n";
#endif
	  sleep (pi.timeout * 5);
	  goto poor_trick;
	}

      setsockopt (tSet[i], SOL_SOCKET, SO_RCVBUF, (char *) &opt, sizeof (int));
      ioctl (tSet[i], FIONBIO, &one);
      fcntl (tSet[i], F_SETFL, O_NONBLOCK | O_NDELAY);
    }

  // BO udp socket
  memset (&sin, 0, sizeof (sin));
  sin.sin_family = AF_INET;
  sin.sin_port = htons (0);
  if (pi.verbose)
    {
      tSet[TCP_SERV_TOTAL + 1] = USOCK;
      bind (tSet[TCP_SERV_TOTAL + 1], (struct sockaddr *) &sin, sizeof (sin));
    }

  // icmp socket
  if (pi.verbose)
    if (!geteuid ())
      tSet[TCP_SERV_TOTAL + 2] = ISOCK;

  siginterrupt (SIGALRM, 1);
}

SockSet::~SockSet (void)
{
  int i;
  for (i = 0; i <= TCount; i++)
    close (tSet[i]);
}

int SockSet::check (int ref, fd_set * fdsp)
{
  int s = tSet[ref];

  if (tTest[ref] < 1)
    {
#ifdef EBUG
      dbug << "tTest[" << ref << "] = " << tTest[ref] << ENTER;
#endif
      SCLOSE (s);
      return (0);
    }

  if (!FD_ISSET (s, fdsp))
    {
#ifdef EBUG
      dbug << "check: no data for socket " << s << ENTER;
#endif
      SCLOSE (s);
      return (0);
    }

  return (check (ref));
}

int SockSet::check (int ref)
{
  int s = tSet[ref];
  u_int err, erl;

  if (getsockopt (s, SOL_SOCKET, SO_ERROR, &err, &erl) == 0)
    {
      if (err == 0)
	{
	  int null = 0;
	  ioctl (s, FIONBIO, &null);
	  fcntl (s, F_SETFL, sflags);
#ifdef EBUG
	  dbug << "check OK: " << s << ENTER;
#endif

	  if (getpeername (s, (struct sockaddr *) &sin, &sl) == -1)
	    {
#ifdef EBUG
	      dbug << "getpeername failed: " << strerror (errno) << ENTER;
#endif
	      SCLOSE (s);
	      return (0);
	    }

	  if (!firstopen)
	    firstopen = sin.sin_port;
	  return (1);
	}
#ifdef EBUG
      else
	{
	  dbug << "getsockopt OK, but: " << strerror (err) << ENTER;
	}
    }
  else
    dbug << "getsockopt ERROR: " << " " << strerror (errno) << ENTER;
#else
    }
#endif

  SCLOSE (s);
  return (0);
}

void SockSet::sCon (int sc, int sn)
{
  sin.sin_family = AF_INET;
  sin.sin_port = htons (sn);
  sin.sin_addr.s_addr = target;
  memset (&sin.sin_zero, 0, 8);
  tTest[sc] = connect (tSet[sc], (struct sockaddr *) &sin, SALen);

  if (tTest[sc] == -1)
    switch (errno)
      {
      case EINPROGRESS:
	tTest[sc] = 1;
	break;
      case EINVAL:
      case EBADF:
      case ECONNREFUSED:
      case ETIMEDOUT:
      case ENETUNREACH:
	tTest[sc] = -2;
	SCLOSE (tSet[sc]);
	break;
      case EALREADY:
	tTest[sc] = 2;
	break;
#ifdef EBUG
      default:
	dbug << "Strange: " << tTest[sc] << " (" << strerror (errno) << ")\n";
#endif
      }

  usleep (250);
}

int SockSet::con (char *host)
{
  if (!isip (host))
    target = resolve (host);
  else
    target = inet_addr (host);
  if (!target)
    {				// dahhhh
#ifdef EBUG
      dbug << "Unknown host: " << host << ENTER;
#endif
      return (0);
    }

#ifdef EBUG
  dbug << "Scan of host: " << Hostname () << ENTER;
#endif

  if (pi.verbose)
    {
      if (sigsetjmp (stack, 1) != 666)
	{
	  alarm (timeout * (2 + pi.verbose));
	  if ((icmptest (tSet[TCP_SERV_TOTAL + 2]) == 0) && pi.pingonly)
	    {
	      SCLOSE (tSet[TCP_SERV_TOTAL + 2]);
	      tSet[TCP_SERV_TOTAL + 2] = ISOCK;
	      return (0);
	    }
	  SCLOSE (tSet[TCP_SERV_TOTAL + 2]);
	  alarm (0);
	}
      else if (pi.pingonly)
	{			// alarm, ping timeout
	  SCLOSE (tSet[TCP_SERV_TOTAL + 2]);
	  tSet[TCP_SERV_TOTAL + 2] = ISOCK;
	  return (0);
	}
    }

  siginterrupt (SIGALRM, 1);
  if (pi.verbose > 1)
    sCon (0, S_TCPMUX);
  if (pi.verbose > 1)
    sCon (1, S_ECHO);
  if (pi.verbose)
    sCon (2, S_NSTAT);
  if (pi.verbose)
    sCon (3, S_CGEN);
  if (pi.verbose)
    sCon (4, S_FTP);
  if (pi.verbose)
    sCon (5, S_SSH);
  if (pi.verbose > 1)
    sCon (6, S_TELNET);
  if (pi.verbose)
    sCon (7, S_SMTP);
  if (pi.verbose > 1)
    sCon (8, S_WHOIS);
  sCon (9, S_BIND);
  if (pi.verbose > 1)
    sCon (10, S_LCONF);
  if (pi.verbose > 1)
    sCon (11, S_FINGER);
  sCon (12, S_HTTP);
  if (pi.verbose)
    sCon (13, S_POP2);
  sCon (14, S_POP3);
  sCon (15, S_PMAP);
  if (pi.verbose > 1)
    sCon (16, S_NNTP);
  sCon (17, S_SMB);
  sCon (18, S_IMAP);
  if (pi.verbose > 1)
    sCon (19, S_REXEC);
  if (pi.verbose > 1)
    sCon (20, S_RLOGIN);
  if (pi.verbose > 1)
    sCon (21, S_RSH);
  if (pi.verbose)
    sCon (22, S_LP);
  if (pi.verbose)
    sCon (23, S_BD666);
  if (pi.verbose)
    sCon (24, S_BD1524);
  if (pi.verbose > 1)
    sCon (25, S_NLPS);
  if (pi.verbose > 1)
    sCon (26, S_IRCD);
  if (pi.verbose)
    sCon (27, S_XWIN);
  sCon (28, S_FW1);
  sCon (29, S_SOCKS);
  if (pi.verbose)
    sCon (30, S_MSQL);
  if (pi.verbose > 1)
    sCon (31, S_ORACLE);
  if (pi.verbose > 1)
    sCon (32, S_PROXY);
  if (pi.verbose > 1)
    sCon (33, S_BDTRINOO);
  if (pi.verbose > 2)
    sCon (34, S_CISCO1);
  if (pi.verbose > 2)
    sCon (35, S_CISCO2);

  return (1);
}

int SockSet::icmptest (int s)
{
  fd_set st;
  struct timeval tv =
  {timeout * 2, 0};
  char packet[512];
  struct icmphdr *icmp = (struct icmphdr *) packet;
  struct sockaddr_in sa;
  long ref;

  if (geteuid ())
    return (1);

  memset (packet, 0, 512);
  icmp->type = ICMP_ECHO;
  icmp->un.echo.id = SetId & 0xFFFF;
  icmp->un.echo.sequence = SetId;
  icmp->checksum = 0;
  icmp->checksum = cksum ((u_short *) icmp, (64 >> 1));
  sa.sin_family = AF_INET;
  sa.sin_port = 0;
  sa.sin_addr.s_addr = target;
  FD_ZERO (&st);
  ref = time (NULL);
  sendto (s, packet, 64, 0, (struct sockaddr *) &sa, sizeof (sa));
  FD_SET (s, &st);
  if (!select (s + 1, &st, NULL, NULL, &tv))	// select()+icmp _works_

    {
      ofstream l0g;
      l0g.open (L_ICMP, 8);
      if (pi.verbose > 2)
	l0g << "Ping timeout: " << Hostname () << ENTER;
      l0g.close ();
      return (0);
    }
  else
    {
      u_int slen = sizeof (sa);
      recvfrom (s, &packet, 64, 0, (struct sockaddr *) &sa, &slen);
      ofstream l0g;
      l0g.open (L_ICMP, 8);
      l0g << Hostname () << " - " << (time (NULL) - ref) << "s\n";
      if (pi.verbose < 3)
	{
	  l0g.close ();
	  return (1);
	}
      else
	l0g.flush ();
      /* time stamp, len = 20 */
      tv.tv_sec = timeout * 2;
      tv.tv_usec = 0;
      sa.sin_family = AF_INET;
      sa.sin_port = 0;
      sa.sin_addr.s_addr = target;
      memset (packet, 0, 512);
      icmp->un.echo.sequence = SetId;
      icmp->checksum = 0;
      icmp->type = ICMP_TSTAMP;
      icmp->code = 0;
      gettimeofday ((struct timeval *) (icmp + 8), NULL);
      icmp->checksum = cksum ((u_short *) icmp, (64 >> 1));
      FD_ZERO (&st);
      FD_SET (s, &st);
      /* the recv stuff is not checked, but it works 99% of the time */
      sendto (s, packet, 21, 0, (struct sockaddr *) &sa, sizeof (sa));
      if (!select (s + 1, &st, NULL, NULL, &tv))
	{
	  l0g.close ();
	  return (1);
	}
      recvfrom (s, &packet, 500, 0, (struct sockaddr *) &sa, &slen);
      l0g << Hostname () << " - timestamp reply\n";
      l0g.flush ();

      /* mask request, len = 12 */
      sa.sin_family = AF_INET;
      sa.sin_port = 0;
      sa.sin_addr.s_addr = target;
      memset (packet, 0, 512);
      icmp->un.echo.sequence = SetId;
      icmp->checksum = 0;
      icmp->type = ICMP_MASKREQ;
      icmp->code = 0;
      *((char *) (icmp + 8)) = 255;
      icmp->checksum = cksum ((u_short *) icmp, (64 >> 1));
      FD_ZERO (&st);
      FD_SET (s, &st);
      sendto (s, packet, 13, 0, (struct sockaddr *) &sa, sizeof (sa));
      if (!select (s + 1, &st, NULL, NULL, &tv))
	{
	  l0g.close ();
	  return (1);
	}
      recvfrom (s, &packet, 500, 0, (struct sockaddr *) &sa, &slen);
      l0g << Hostname () << " - addressmask reply\n";
      l0g.close ();
    }
  return (1);
}

void SockSet::probe (int to)
{
#ifdef EBUG
  int i;
  dbug << "Sockets: ";
  for (i = 0; i < TCount; i++)
    dbug << " " << tSet[i];
  dbug << "\nStatus vars: ";
  for (i = 0; i < TCount; i++)
    dbug << " " << tTest[i];
  dbug << ENTER;
#endif

  if (to)
    timeout = to;

// prepare for select()ion

  fd_set wfds;

  FD_ZERO (&wfds);
  FD_SET (tSet[0], &wfds);
  FD_SET (tSet[1], &wfds);
  FD_SET (tSet[2], &wfds);
  FD_SET (tSet[3], &wfds);
  FD_SET (tSet[4], &wfds);
  FD_SET (tSet[5], &wfds);
  FD_SET (tSet[6], &wfds);
  FD_SET (tSet[7], &wfds);
  FD_SET (tSet[8], &wfds);
  FD_SET (tSet[9], &wfds);
  FD_SET (tSet[10], &wfds);
  FD_SET (tSet[11], &wfds);
  FD_SET (tSet[12], &wfds);
  FD_SET (tSet[13], &wfds);
  FD_SET (tSet[14], &wfds);
  FD_SET (tSet[15], &wfds);
  FD_SET (tSet[16], &wfds);
  FD_SET (tSet[17], &wfds);
  FD_SET (tSet[18], &wfds);
  FD_SET (tSet[19], &wfds);
  FD_SET (tSet[20], &wfds);
  FD_SET (tSet[21], &wfds);
  FD_SET (tSet[22], &wfds);
  FD_SET (tSet[23], &wfds);
  FD_SET (tSet[24], &wfds);
  FD_SET (tSet[25], &wfds);
  FD_SET (tSet[26], &wfds);
  FD_SET (tSet[27], &wfds);
  FD_SET (tSet[28], &wfds);
  FD_SET (tSet[29], &wfds);
  FD_SET (tSet[30], &wfds);
  FD_SET (tSet[31], &wfds);
  FD_SET (tSet[32], &wfds);
  FD_SET (tSet[33], &wfds);
  FD_SET (tSet[34], &wfds);
  FD_SET (tSet[35], &wfds);

  struct timeval t = {timeout * 10, 0};

  if (!select (tSet[TCP_SERV_TOTAL] + 1, NULL, &wfds, NULL, &t))
    {
#ifdef EBUG
      dbug << "select() failed: " << strerror (errno) << ENTER;
#endif
      return;
    }

  // inherited AuditSet class functions
  // wave 1 services: logging

  if ((pi.verbose > 1) && check (0))
    plog (tSet[0], "irix (tcpmux)");
  if ((pi.verbose > 1) && check (1))
    plog (tSet[1], "echo");
  if (pi.verbose && check (3, &wfds))
    plog (tSet[3], "chargen");
  if ((pi.verbose > 1) && check (8))
    plog (tSet[8], "whois server");
  if ((pi.verbose > 1) && check (10))
    plog (tSet[10], "linuxconf");
  if ((pi.verbose > 1) && check (19))
    plog (tSet[19], "rexecd");
  if ((pi.verbose > 1) && check (20))
    plog (tSet[20], "rlogind");
  if ((pi.verbose > 1) && check (21))
    plog (tSet[21], "rshd");
  if (pi.verbose && check (22))
    plog (tSet[22], "lpd");
  if (check (28))
    plog (tSet[28], "FW-1 AuthAgent");
  if (check (29))
    plog (tSet[29], "SOCKS server (1080)");
  if (pi.verbose && check (30))
    plog (tSet[30], "mSQL server");
  if ((pi.verbose > 1) && check (31))
    plog (tSet[31], "Oracle SQL server");
  if ((pi.verbose > 1) && check (32))
    plog (tSet[32], "proxy server (8080)");
  if ((pi.verbose > 1) && check (33))
    plog (tSet[33], "trinoo DoS master (BACKDOOR)");

// wave 2 services: read input

  if (check (9))
    nbind (tSet[9]);
  if (pi.verbose && check (2, &wfds))
    nstat (tSet[2]);
  if (pi.verbose && check (5, &wfds))
    ssh (tSet[5]);
  if (pi.verbose && check (13, &wfds))
    pop2 (tSet[13]);
  if (check (14, &wfds))
    pop3 (tSet[14]);
  if ((pi.verbose > 1) && check (16, &wfds))
    nntp (tSet[16]);
  if (check (18, &wfds))
    imap (tSet[18]);

// wave 3 services: active security check

  if (pi.verbose && check (23))
    bd666 (tSet[23]);		// issue cmds
  if (pi.verbose && check (24))
    bd1524 (tSet[24]);		// dito
  if ((pi.verbose > 1) && check (11, &wfds))
    finger (tSet[11]);
  if ((pi.verbose > 1) && check (6, &wfds))
    telnet (tSet[6]);		// also wingate
  if (pi.verbose && check (7, &wfds))
    smtp (tSet[7]);
  if (check (15, &wfds))
    pmap (tSet[15]);		// start rpcscan
  if (check (17))
    smb (tSet[17]);
  if ((pi.verbose > 1) && check (25))
    nlps (tSet[25]);		// try overflow
  if ((pi.verbose > 1) && check (26))
    ircd (tSet[26]);		// iline, version
  if ((pi.verbose) && check (27))
    xwin (tSet[27]);		// sniff test
  if ((pi.verbose > 2) && check (34))
    plog (tSet[34], "Cisco backdoor (1999)");
  if ((pi.verbose > 2) && check (35))
    plog (tSet[35], "Cisco DoS (7161)");
  if (pi.verbose && check (4, &wfds))
    ftp (tSet[4]);
  if (check (12))
    http (tSet[12]);

// wave 4 services: connectionless security check

  if (pi.verbose)
    nbname ();
  if (pi.verbose)
    snmp ();
  if (pi.verbose > 1)
    bo (tSet[TCP_SERV_TOTAL + 1]);

  if (pi.verbose && (!geteuid ()))
    os ();

  return;
}
