//////////////////////////////////////////
//    Network Security Analysis Tool    //
//          (c) 1999 by Mixter          //
//////////////////////////////////////////

// rpccheck, check an individual host for the desired rpc services
// by sk8@lucid-solutions.com

#include "../nsat.h"
#include "../services.h"
#define PORTMAP
#include <rpc/rpc.h>
#include <rpc/clnt.h>
#include <rpcsvc/mount.h>
#include <rpc/pmap_prot.h>
#include <rpc/pmap_clnt.h>
#include "exports.h"

extern sigjmp_buf stack;
extern ProgressIndicator pi;

int searchlist (struct pmaplist *, int);
char *strsvc (int);
char svcbuf[64];

char *
strsvc (int svc)
{
  memset (svcbuf, 0, 64);
  switch (svc)
    {
    case R_STATD:
      strncpy (svcbuf, "statd", 63);
      break;
    case R_NFS:
      strncpy (svcbuf, "nfsd", 63);
      break;
    case R_YPSERV:
      strncpy (svcbuf, "ypserv", 63);
      break;
    case R_MOUNTD:
      strncpy (svcbuf, "mountd", 63);
      break;
    case R_NLOCK:
      strncpy (svcbuf, "nlockmgr", 63);
      break;
    case R_STATUS:
      strncpy (svcbuf, "status", 63);
      break;
    case R_BOOTPD:
      strncpy (svcbuf, "bootparamd", 63);
      break;
    case R_TTDB:
      strncpy (svcbuf, "ttdb", 63);
      break;
    case R_CMSD:
      strncpy (svcbuf, "cmsd", 63);
      break;
    case R_NIS:
      strncpy (svcbuf, "nisserver", 63);
      break;
    case R_AMD:
      strncpy (svcbuf, "amd", 63);
      break;
    case R_WALLD:
      strncpy (svcbuf, "amd", 63);
      break;
    case R_LISTEN:
      strncpy (svcbuf, "listen (backdoor?)", 63);
      break;
    case R_SADMIND:
      strncpy (svcbuf, "sadmind", 63);
      break;
    default:
      snprintf (svcbuf, 63, "%d", svc);
    }
  return (svcbuf);
}

const int procnums[] =
{
  R_STATD,
  R_NFS,
  R_YPSERV,
  R_MOUNTD,
  R_WALLD,
  R_NLOCK,
  R_STATUS,
  R_BOOTPD,
  R_TTDB,
  R_CMSD,
  R_LISTEN,
  R_SADMIND,
  R_NIS,
  R_AMD,
  0
};

int
rpccheck (char *host)
{
  struct sockaddr_in server_addr;
  struct pmaplist *head = NULL;
  int sockett = RPC_ANYSOCK;
  struct timeval minutetimeout;
  register CLIENT *client;
  int found = 0;
  int i = 0;
  int first = 0;
  int foundCur = 0;
  server_addr.sin_addr.s_addr = inet_addr (host);
  server_addr.sin_family = AF_INET;
  server_addr.sin_port = htons (PMAPPORT);
  minutetimeout.tv_sec = 5;
  minutetimeout.tv_usec = 0;

  if ((client = clnttcp_create (&server_addr, PMAPPROG, PMAPVERS, &sockett, 50, 500)) == NULL)
    return 0;
  if (clnt_call (client, PMAPPROC_DUMP, (xdrproc_t) xdr_void, NULL, (xdrproc_t) xdr_pmaplist, (char *) &head, minutetimeout) != RPC_SUCCESS)
    return 0;

  clnt_destroy (client);

  ofstream rl;
  rl.open (L_RPC, 8);

  if (pi.verbose > 2)
    {
      rl << host << " - ";
      for (; head != NULL; head = head->pml_next)
	rl << strsvc (head->pml_map.pm_prog) << " ";
      rl << "\n";
    }
  else
    while (procnums[i])
      {
	foundCur = searchlist (head, procnums[i]);
	if (foundCur && (procnums[i] == R_NFS))
	  nfsscan (server_addr.sin_addr.s_addr);
	found = foundCur || found;
	if ((first == 0) && (found == 1))
	  {
	    first = 1;
	    rl << host << " - " << strsvc (procnums[i]);
	  }
	else if (foundCur)
	  {
	    rl << "," << strsvc (procnums[i]);
	  }
	i++;
      }

  if (found)
    rl << ENTER;
  rl.close ();

  return (found);
}

int
searchlist (struct pmaplist *head, int progid)
{
  if (head == NULL)
    return 0;

  struct pmaplist *list, xlist = *head;

  for (list = &xlist; list != NULL; list = list->pml_next)
    {
     if (list->pml_map.pm_prog == (u_int) progid)
       {
         return 1;
       }
    }

  return 0;
}
