//////////////////////////////////////////
//    Network Security Analysis Tool    //
//          (c) 1999 by Mixter          //
//////////////////////////////////////////

// fingerprint parsing

#ifndef FINGERPRINTS_H
#define FINGERPRINTS_H

/*    flag lookup table:
   A 16                 R 4
   RA 20                RAF 21
   RAP 28               RPA 28
   SA 18                SAXY 210
   SFA 19               SPA 26
   UR 36                URA 52 */

#define YYY 0x80
#define XXX 0x40
#define URG 0x20
#define ACK 0x10
#define PSH 0x08
#define RST 0x04
#define SYN 0x02
#define FIN 0x01
#define A       ACK
#define R       RST
#define RA      RST|ACK
#define RAF     RST|ACK|FIN
#define RAP     RST|ACK|PSH
#define RPA     RST|PSH|ACK
#define SA      SYN|ACK
#define SAXY    SYN|ACK|XXX|YYY
#define SFA     SYN|FIN|ACK
#define SPA     SYN|PSH|ACK
#define UR      URG|RST
#define URA     URG|RST|ACK

typedef struct
  {
    unsigned short set;
    unsigned long seq;
    unsigned long ack;
    unsigned short urg;
    unsigned short win;
    unsigned short flag;
  }
OSRES;

typedef struct
  {
    char desc[256];
    OSRES rr0;
    OSRES rr1;
    OSRES rr2;
    OSRES rr3;
    OSRES rr4;
    OSRES rr5;
    OSRES rr6;
  }
Fingerprint;

void
scanprint (FILE * fp, Fingerprint * pp)
{

  fgets (pp->desc, 254, fp);
  pp->desc[strlen (pp->desc) - 1] = '\0';	/* fuck fgets() :x */

  fscanf (fp, "%d %d %d %d %x %d\n",
	  (int *) &pp->rr0.set,	/* fuck ansi c++ :p */
	  (int *) &pp->rr0.seq,
	  (int *) &pp->rr0.ack,
	  (int *) &pp->rr0.urg,
	  (int *) &pp->rr0.win,
	  (int *) &pp->rr0.flag);
  fscanf (fp, "%d %d %d %d %x %d\n",
	  (int *) &pp->rr1.set,
	  (int *) &pp->rr1.seq,
	  (int *) &pp->rr1.ack,
	  (int *) &pp->rr1.urg,
	  (int *) &pp->rr1.win,
	  (int *) &pp->rr1.flag);
  fscanf (fp, "%d %d %d %d %x %d\n",
	  (int *) &pp->rr2.set,
	  (int *) &pp->rr2.seq,
	  (int *) &pp->rr2.ack,
	  (int *) &pp->rr2.urg,
	  (int *) &pp->rr2.win,
	  (int *) &pp->rr2.flag);
  fscanf (fp, "%d %d %d %d %x %d\n",
	  (int *) &pp->rr3.set,
	  (int *) &pp->rr3.seq,
	  (int *) &pp->rr3.ack,
	  (int *) &pp->rr3.urg,
	  (int *) &pp->rr3.win,
	  (int *) &pp->rr3.flag);
  fscanf (fp, "%d %d %d %d %x %d\n",
	  (int *) &pp->rr4.set,
	  (int *) &pp->rr4.seq,
	  (int *) &pp->rr4.ack,
	  (int *) &pp->rr4.urg,
	  (int *) &pp->rr4.win,
	  (int *) &pp->rr4.flag);
  fscanf (fp, "%d %d %d %d %x %d\n",
	  (int *) &pp->rr5.set,
	  (int *) &pp->rr5.seq,
	  (int *) &pp->rr5.ack,
	  (int *) &pp->rr5.urg,
	  (int *) &pp->rr5.win,
	  (int *) &pp->rr5.flag);
  fscanf (fp, "%d %d %d %d %x %d\n",
	  (int *) &pp->rr6.set,
	  (int *) &pp->rr6.seq,
	  (int *) &pp->rr6.ack,
	  (int *) &pp->rr6.urg,
	  (int *) &pp->rr6.win,
	  (int *) &pp->rr6.flag);

  return;
}

#endif
