//////////////////////////////////////////
//    Network Security Analysis Tool    //
//          (c) 1999 by Mixter          //
//                                      //
//         options and recovery         //
//////////////////////////////////////////

#pragma implementation "progress"
#include "progress.h"

#ifdef EBUG
extern ofstream dbug;
#endif

extern char *ntoa (u_long);
extern void alloc_purge (void);

ProgressIndicator::ProgressIndicator (void)
{
  fname = new char[SMALLB + 1];
  tstamp = time (NULL);
  timeout = TIMEOUT;
  pingonly = PINGONLY;
  verbose = VERBOSITY;
  stealth = COWARD;
  idle = IDLETIME;
  fscan = -1;
  maxproc = MAXPROC;
  maxlife = MAXLIFE;
  ipcur = 0;
  ipend = 0;
  fpos = 0;
  strcpy (fname, ("null"));
}

ProgressIndicator::~ProgressIndicator (void)
{
  delete fname;
}

void ProgressIndicator::update (long p)
{
  long now = time (NULL);
  if (fscan)
    fpos = p;
  else
    ipcur = p;
#ifdef EBUG
  dbug << "update. last store " << (now - tstamp) << "s ago\n";
#endif

  if (now - tstamp >= P_TIMER)
    {
      tstamp = now;
#ifdef EBUG
      dbug << "writing progress file...\n";
#endif
      store ();
      alloc_purge ();
    }
}

int ProgressIndicator::store (void)
{
  FILE *fd;

#ifdef PARANOID_CHECK
  if (nicefile (PROGRESS_FILE))
    return (0);
#endif
  fd = fopen (PROGRESS_FILE, "w");
  if (fd == NULL)
    {
#ifdef EBUG
      dbug << "cannot write progress file: " << strerror (errno) << ENTER;
#endif
      return (0);
    }
  fprintf (fd, "%d\n%d\n%d\n%d\n%d\n%d\n%d\n%d\n%d\n",
	   tstamp, timeout, pingonly, verbose, stealth,
	   idle, fscan, maxproc, maxlife);
  fprintf (fd, "%ld\n%ld\n%ld\n%s\n", ipcur, ipend, fpos, fname);
  fclose (fd);
  return (1);
}

int ProgressIndicator::restore (void)
{
  FILE *fd;

#ifdef PARANOID_CHECK
  if (nicefile (PROGRESS_FILE))
    return (0);
#endif

  fd = fopen (PROGRESS_FILE, "r");
  if (fd == NULL)
    {
      return (0);
    }
  fscanf (fd, "%d\n%d\n%d\n%d\n%d\n%d\n%d\n%d\n%d\n",
	  &tstamp, &timeout, &pingonly, &verbose, &stealth,
	  &idle, &fscan, &maxproc, &maxlife);
  fscanf (fd, "%ld\n%ld\n%ld\n", &ipcur, &ipend, &fpos);
  fgets (fname, SMALLB, fd);
  strchop (fname);
  fclose (fd);
  return (1);
}

void ProgressIndicator::status (void)
{
  cout << "\n\t       verbosity:\t" << verbose << ENTER;
  cout << "\t      stealth mode:\t" << (stealth ? "Y\n" : "N\n");
  cout << "\t    ping-dependent:\t" << (pingonly ? "Y\n" : "N\n");
  cout << "\t   connect timeout:\t" << timeout << "s\n";
  cout << "\t     min idle time:\t" << idle << "s\n";
  cout << "\t         scan type:\t" << (fscan ? "file\n" : "ip range\n");
  cout << "\t     max processes:\t" << maxproc << ENTER;
  cout << "\t  maximum lifetime:\t" << maxlife << "s\n";
  if (fscan)
    cout << "\t    input filename:\t" << fname << ENTER;
  else
    {
      cout << "\t        current ip:\t" << ntoa (ipcur) << ENTER;
      cout << "\t            end ip:\t" << ntoa (ipend) << ENTER;
    }
  cout << "\t       last update:\t" << time (NULL) - tstamp << "s ago\n\n";

  if (geteuid ())
    cout << "\n\trunning as non-root (os scans and pings are disabled)\n";
}
