//////////////////////////////////////////////////////////////////////////////
//                                                                          //
//                  Network Security Analysis Tool                          //
//             SockSet.h - connection class declaration                     //
//                                                                          //
//   Copyright (C) 1999-2000 by Mixter and 2xs ltd. <mixter@2xs.co.il>      //
//                                                                          //
// This program is free software; you can redistribute it and/or modify     //
// it under the terms of the GNU General Public License as published by     //
// the Free Software Foundation; either version 2 of the License, or        //
// (at your option) any later version.                                      //
//                                                                          //
// This program is distributed in the hope that it will be useful,          //
// but WITHOUT ANY WARRANTY; without even the implied warranty of           //
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the            //
// GNU General Public License for more details.                             //
//                                                                          //
// You should have received a copy of the GNU General Public License        //
// along with this program; if not, write to the Free Software              //
// Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307 USA //
//                                                                          //
//////////////////////////////////////////////////////////////////////////////

#ifndef SOCKSET_H
#define SOCKSET_H
#pragma interface "sockset"
#include "AuditSet.h"

#define SetSize		10000
#define MAXCAPLEN	1024
#define SALen		sizeof(struct sockaddr_in)

class SockSet:private AuditSet
{
  private:
  int sflags;			// default socket flags

  int highest_fd;		// highest fd for select()

  fd_set sfds;			// FD set

  unsigned short tSet[SetSize];	// sockets

  int sInit(void);		// "allocate" a socket

  void sCon(int sc, unsigned short sn);		// connect

  int check(int ref, fd_set * fdsp);	// is there data to read

  int check(int ref);		// is the connection established

    public:

  void con(char *host);		// mass connect

  void probe(int timeout);	// read and evaluate

    SockSet(void);
   ~SockSet(void);
};

#endif
