#if 0
//////////////////////////////////////////////////////////////////////////////
//                                                                          //
//                  Network Security Analysis Tool                          //
//                lang.h - messages, file names, etc.                       //
//                                                                          //
//   Copyright (C) 1999-2000 by Mixter and 2xs ltd. <mixter@2xs.co.il>      //
//                                                                          //
// This program is free software; you can redistribute it and/or modify     //
// it under the terms of the GNU General Public License as published by     //
// the Free Software Foundation; either version 2 of the License, or        //
// (at your option) any later version.                                      //
//                                                                          //
// This program is distributed in the hope that it will be useful,          //
// but WITHOUT ANY WARRANTY; without even the implied warranty of           //
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the            //
// GNU General Public License for more details.                             //
//                                                                          //
// You should have received a copy of the GNU General Public License        //
// along with this program; if not, write to the Free Software              //
// Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307 USA //
//                                                                          //
//////////////////////////////////////////////////////////////////////////////
#endif

#ifndef LANG_H
#define LANG_H

#define CONFIG_FILE    "/usr/local/share/nsat/nsat.conf"	/* scan options */
#define PRINTS         "/usr/local/share/nsat/nsat.os"		/* os fingerprints */
#define CGI_FILE       "/usr/local/share/nsat/nsat.cgi"		/* cgi list */
#define PIDFILE        ".nspid"					/* pid file name */
#define PROGRESS_FILE  ".nsrc"					/* recovery file name */

/* some default messages */

#define ENTER "\n"
#define M_LBANNER " [*]  [*]  "
#define M_RBANNER "  [*]  [*]\n"
#define M_CLR "                             \r"
#define M_SCANNING "\r [*] scanning: "
#define M_NOSCANTYPE ": no scantype selected\n"
#define M_RUNNING ": still active\n"
#define M_NORECFILE ": no recovery file found\n"
#define M_VULNERABLE "VULNERABLE"
#define M_DANGEROUS_SVC " (dangerous)"
#define NSAT_BANNER "\t\tNetwork Security Analysis Tool v"VERSION"\n\t\t   (c) 1999-2000 by Mixter, 2xs ltd.\n"

/* anonymous ftp login */

#define FTPUSER "USER anonymous\r\n"
#define FTPPASS "PASS nsat@\r\n"
#define WEBGET  "GET "
#define WEBVER  " HTTP/1.0\n\n"

/* default names for the log files */

#define L_PORTS		"ports.log"
#define L_FTP		"ftp.log"
#define L_SSH		"ssh.log"
#define	L_TELNET	"telnet.log"
#define L_SMTP		"sendmail.log"
#define L_DNS		"dns.log"
#define L_HTTVER	"httpd.log"
#define	L_POP2		"pop2.log"
#define L_POP3		"pop3.log"
#define L_IMAP		"imap.log"
#define L_OS		"os.log"
#define L_UOS		"unknown-os.log"
#define L_FINGER	"finger.log"
#define L_SNMP		"snmp.log"
#define L_SMB		"smb.log"
#define L_NNTP		"nntp.log"
#define L_EXPORTS       "exports.log"
#define L_NETSTAT 	"netstat.log"
#define L_BACKDOOR	"backdoor.log"
#define L_IRCD		"ircd.log"
#define L_XWIN		"xwindows.log"
#define L_NETBIOS	"netbios.log"
#define L_ICMP		"icmp.log"
#define L_RPC		"rpc.log"
#define L_CGI		"cgi.log"
#define L_BO		"bo.log"
#define L_NLPS		"nlps.log"
#ifdef EBUG
#define L_DEBUG		"debug.log"
#endif

/* all the config file option names crap */

#define C_BD 		"backdoorscan"
#define C_BO 		"backorificescan"
#define C_BIND1 	"bindversionscan"
#define C_BIND2 	"bindversionscanall"
#define C_CF 		"cgifile"
#define C_CT 		"connecttimeout"
#define C_FP 		"fingerprintfile"
#define C_FING1		"fingerscan"
#define C_FING2		"fingerexploit"
#define C_FORE		"foregroundscanreport"
#define C_FTP1 		"ftpscan"
#define C_FTP2		"ftpscananonymous"
#define C_FTP3 		"ftpscanwritable"
#define C_ICMP1		"icmpping"
#define C_ICMP2		"icmpverbosetest"
#define C_IMS 		"imapscan"
#define C_INPUT		"inputfilename"
#define C_IRC1 		"ircdscan"
#define C_IRC2 		"ircdverbosescan"
#define C_LS 		"localstealth"
#define C_LSI 		"localstealthidleseconds"
#define C_MLIFE		"maxchildlifetime"
#define C_MPROC		"maximumprocesses"
#define C_NETBS		"netbiosscan"
#define C_NSTAT1	"netstatscan"
#define C_NSTAT2	"netstatscanverbose"
#define C_NLPS1		"nlpsscan"
#define C_NLPS2		"nlpsexploit"
#define C_NNTPS		"nntpscan"
#define C_OS 		"osfingerprinting"
#define C_PIDF 		"pidfile"
#define C_PINGD		"pingdependence"
#define C_POP2 		"pop2scan"
#define C_POP3 		"pop3scan"
#define C_PORTR		"portrange"
#define C_PORT		"portscan"
#define C_PROGRESS	"progressfile"
#define C_RPC1		"rpcportmap"
#define C_RPC2 		"rpcportmapdump"
#define C_RPC3 		"rpcverbosescan"
#define C_RPC4		"rpcnfsexportscheck"
#define C_SMBS 		"smbscan"
#define C_SMTP1		"smtpscan"
#define C_SMTP2		"smtpinfocheck"
#define C_SMTP3		"smtpfakemail"
#define C_SMTP4		"smtp89remote"
#define C_SNMPS		"snmpscan"
#define C_SSHS 		"sshscan"
#define C_TELNET1	"telnetscan"
#define C_TELNET2	"telnetreadbanner"
#define C_TELNET3	"telnetdumpbanner"
#define C_OLDVERB	"verbosity"
#define C_VHOST		"vhostip"
#define C_WEB1 		"webscan"
#define C_WEB2 		"webscancgi"
#define C_WEB3 		"webscanidsevasion"
#define C_XWIN1		"xwinscan"
#define C_XWIN2		"xwindisplaycheck"

/* miscellaneous weird internal stuff */

#define I_SMBEXEC	"smb-ns"
#define I_S		" - "
#define I_VBIND		"\007version\004bind\000"
#define I_BINDIP	"1.2.3.4"
#define I_IQUERY	" (iquery)\n"
#define I_PORT		" port "
#define I_ANON		" - anonymous login"
#define I_WRITE		" - world-writable: "
#define I_UOS		"Unknown OS (please submit): "
#define I_NFS1		" - WORLD WRITABLE NFS EXPORT - "
#define I_NFS2		" - nfs export to "
#define I_SYSNAME	" - sys.sysName.0:"
#define I_COMMUNITY	" - community: "
#define I_SNMP1		"NOAUTH WRITE ACCESS\n"
#define I_SNMP2		"NOAUTH readonly access\n"
#define I_HTGET		"GET / HTTP/1.0\n\n"
#define I_HTGET2	"GET %s HTTP/1.0\n\n"
#define I_PINGOUT	"Ping timeout: "
#define I_ICTIME	" - timestamp reply\n"
#define I_ICMASK	" - addressmask reply\n"
#define I_NETSTAT	" - netstat\n"
#define I_UNKNOWN	" - UNKNOWN\n"
#define I_EXPN		" - allows expn\n"
#define I_VRFY		" - allows vrfy\n"
#define I_FAKEMAIL	" - allows fakemail\n"
#define I_SPAM		" - allows spam\n"
#define I_RPMMAIL	" - sendmail 8.9 vulnerable to remote rpmmail exploit!\n"
#define I_FINGER	" - finger\n"
#define I_PMAP		" - portmap\n"
#define I_NLPS		" - 2766 (solaris nlpsd)\n"
#define I_IRCD		" - ircd\n"
#define I_XWIN		" - X windows\n"
#define I_XWIN2		" - dumpable/sniffable\n"
#define I_OLDV		" [*] Using old verbosity scanlevel "
#define I_SMBUN		" - UNPROTECTED\n"
#define I_SMBPR		" - protected\n"
#define I_ICMP		" [icmp]     "
#define I_BIND		" [bind]     "
#define I_BO		" [bo]       "
#define I_FTP		" [ftp]      "
#define I_RPC		" [rpc]      "
#define I_SMB		" [smb]      "
#define I_SNMP		" [snmp]     "
#define I_TELNET	" [telnet]   "
#define I_WWW		" [http]     "
#define I_NSTAT		" [netstat]  "
#define I_PORTL		" [port]     "
#define I_FTP		" [ftp]      "
#define I_SSH		" [ssh]      "
#define I_SMTP		" [smtp]     "
#define I_FING		" [finger]   "
#define I_POP2		" [pop2]     "
#define I_POP3		" [pop3]     "
#define I_NNTP		" [nntp]     "
#define I_IMAP		" [imap]     "
#define I_BACKDOOR	" [backdoor] "
#define I_NLPL		" [nlps]     "
#define I_IRC		" [irc]      "
#define I_XWINL		" [xwin]     "
#define I_NBIOS		" [netbios]  "
#define I_OS		" [os]       "
#endif
