//////////////////////////////////////////////////////////////////////////////
//                                                                          //
//                  Network Security Analysis Tool                          //
//                  binfo.cpp - bind version query                          //
//                                                                          //
//   Copyright (C) 1999-2000 by Mixter and 2xs ltd. <mixter@2xs.co.il>      //
//                                                                          //
// This program is free software; you can redistribute it and/or modify     //
// it under the terms of the GNU General Public License as published by     //
// the Free Software Foundation; either version 2 of the License, or        //
// (at your option) any later version.                                      //
//                                                                          //
// This program is distributed in the hope that it will be useful,          //
// but WITHOUT ANY WARRANTY; without even the implied warranty of           //
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the            //
// GNU General Public License for more details.                             //
//                                                                          //
// You should have received a copy of the GNU General Public License        //
// along with this program; if not, write to the Free Software              //
// Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307 USA //
//                                                                          //
//////////////////////////////////////////////////////////////////////////////

// this was taken from binfo-udp.c written by Joshua James Drake

#include "../nsat.h"
#include <setjmp.h>
#if !defined(BSD44) || defined(OBSD)
#include <arpa/nameser.h>
#else
#include "./nameser.h"          /* some moron defined a variable "class"... */
#endif

#ifdef HAVE_SOLARIS		/* crap-o-laris =P */
#undef T_UNSPEC
#endif

extern sigjmp_buf stack;
extern ProgressIndicator pi;

int talk(int sd, char *pkt, int pktl, char opc);
int make_keypkt(char *pktbuf, char opc);
void print_ver(char *host, int vul, char *buf);

int
probe_bind(struct sockaddr_in ra, int timeout)
{
  int sd;
  char iquery[512], vquery[512], rname[256];
  HEADER *dh = (HEADER *) iquery;

  memset(vquery, 0, sizeof(vquery));
  memset(iquery, 0, sizeof(iquery));
  if (sigsetjmp(stack, 1) == 666)
    {
      siginterrupt(SIGALRM, 1);
      return (0);
    }
  alarm(timeout);
  if (((sd = socket(AF_INET, SOCK_DGRAM, 0)) == -1) ||
      (connect(sd, (struct sockaddr *) &ra, sizeof(ra)) == -1))
    return (-1);
  sprintf(rname, "%s", inet_ntoa(ra.sin_addr));
  if (!talk(sd, iquery, sizeof(iquery), IQUERY))
    return (-1);
  if (!talk(sd, vquery, sizeof(vquery), QUERY))
    return (-1);
  alarm(0);
  close(sd);
  print_ver(rname, dh->rcode == 0, vquery);
  return (1);
}

int
talk(int sd, char *pkt, int pktl, char opc)
{
  int pktlen;

  pktlen = make_keypkt(pkt, opc);
  if (!write(sd, pkt, pktlen))
    {
      close(sd);
      return 0;
    }
  pktlen = read(sd, pkt, pktl);
  if (pktlen <= 0)
    {
      close(sd);
      return 0;
    }
  return 1;
}

int
make_keypkt(char *pktbuf, char opc)
{
  HEADER *dnsh;
  char *ptr = pktbuf;
  int pktlen = 0;

  dnsh = (HEADER *) ptr;
  dnsh->id = htons(getrandom(0, 65535));
  dnsh->opcode = opc;
  dnsh->rd = 1;
  dnsh->ra = 1;
  if (opc == IQUERY)
    dnsh->ancount = htons(1);
  else if (opc == QUERY)
    dnsh->qdcount = htons(1);
  pktlen += sizeof(HEADER);
  ptr += sizeof(HEADER);
  if (opc == QUERY)
    {
      const char *qstr = I_VBIND;
      int qlen = strlen(qstr) + 1;

      memcpy(ptr, qstr, qlen);
      ptr += qlen;
      pktlen += qlen;
      PUTSHORT(T_TXT, ptr);
      PUTSHORT(C_CHAOS, ptr);
      pktlen += sizeof(short) * 2;
    }
  else if (opc == IQUERY)
    {
      unsigned long addr = inet_addr(I_BINDIP);
      unsigned long ttl = 31337;
      unsigned short addrlen = 4;

      *(ptr++) = '\0';
      pktlen++;
      PUTSHORT(T_A, ptr);
      PUTSHORT(C_IN, ptr);
      PUTLONG(ttl, ptr);
      PUTSHORT(addrlen, ptr);
      PUTLONG(addr, ptr);
      pktlen += (sizeof(short) * 3) + (sizeof(long) * 2);
    }
  return pktlen;
}

void
print_ver(char *host, int vul, char *buf)
{
  HEADER *dnsh = (HEADER *) buf;
  char *ptr, *verstr;
  int len;

  if ((!vul) && (pi.ScanBind < 2))
    return;

  if (dnsh->rcode != 0)
    return;
  ptr = (buf + sizeof(HEADER));
  while (*ptr != '\0')
    ptr++;
  ptr += 1 + (sizeof(short) * 2);

  while (*ptr != '\0')
    ptr++;
  ptr += 1 + (sizeof(long) + (sizeof(short) * 2));

  GETSHORT(len, ptr);
  ptr++;
  verstr = new char[len];

  memset(verstr, 0, len);
  memcpy(verstr, ptr, len - 1);
  for (ptr = verstr; ptr - verstr != len - 1; ptr++)
    if (!isprint(*ptr) && !isspace(*ptr))
      *ptr = '.';

  ofstream l;

  l.open(L_DNS, 8);
  if (vul)
    {
      l << host << I_S << verstr << I_IQUERY;
      if (pi.Foreground)
	cout << I_BIND << host << I_S << verstr << I_IQUERY;
    }
  else
    {
      l << host << I_S << verstr << ENTER;
      if (pi.Foreground)
	cout << I_BIND << host << I_S << verstr << ENTER;
    }
  l.close();

  delete verstr;

  return;
}

