//////////////////////////////////////////////////////////////////////////////
//                                                                          //
//                  Network Security Analysis Tool                          //
//               bo.cpp - remote back orifice detection                     //
//                                                                          //
//   Copyright (C) 1999-2000 by Mixter and 2xs ltd. <mixter@2xs.co.il>      //
//                                                                          //
// This program is free software; you can redistribute it and/or modify     //
// it under the terms of the GNU General Public License as published by     //
// the Free Software Foundation; either version 2 of the License, or        //
// (at your option) any later version.                                      //
//                                                                          //
// This program is distributed in the hope that it will be useful,          //
// but WITHOUT ANY WARRANTY; without even the implied warranty of           //
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the            //
// GNU General Public License for more details.                             //
//                                                                          //
// You should have received a copy of the GNU General Public License        //
// along with this program; if not, write to the Free Software              //
// Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307 USA //
//                                                                          //
//////////////////////////////////////////////////////////////////////////////

// taken from the back orifice client for unix by Sir Dystic/cDc

#include "../nsat.h"

extern sigjmp_buf stack;
extern ProgressIndicator pi;

#ifdef EBUG
extern ofstream dbug;

#endif

#define BUFFSIZE 1024
#define MAGICSTRING "*!*QWTY?"
#define MAGICSTRINGLEN 8
#define PARTIAL_PACKET 0x80
#define CONTINUED_PACKET 0x40
#define TYPE_PING 0x01

#ifdef WORDS_BIGENDIAN
#define __EL_LONG(x) ((((x) >> 24) & 0x000000FF) | \
                     (((x) >> 8) & 0x0000FF00)  | \
                     (((x) << 8) & 0x00FF0000)  | \
                     (((x) << 24) & 0xFF000000))
#else
#define __EL_LONG(x) (x)
#endif

char g_password[256];
unsigned long g_lastpongip;
int g_lastpongport;

static long holdrand = 1L;

int
mrand(void)
{
  return (((holdrand = holdrand * 214013L + 2531011L) >> 16) & 0x7fff);
}

void
msrand(unsigned int seed)
{
  holdrand = (long) seed;
}

unsigned int
getkey()
{
  int x, y;
  unsigned int z;

  y = strlen(g_password);
  if (!y)
    return 31337;
  else
    {
      z = 0;
      for (x = 0; x < y; x++)
	z += g_password[x];

      for (x = 0; x < y; x++)
	{
	  if (x % 2)
	    z -= g_password[x] * (y - x + 1);
	  else
	    z += g_password[x] * (y - x + 1);
	  z = z % RAND_MAX;
	}
      z = (z * y) % RAND_MAX;
      return z;
    }
}

void
BOcrypt(unsigned char *buff, int len)
{
  int y;

  if (!len)
    return;

  msrand(getkey());
  for (y = 0; y < len; y++)
    buff[y] = buff[y] ^ (mrand() % 256);
}

int
getinput(int sock)
{
  struct sockaddr_in host;
  char buff[BUFFSIZE];
  int hostsize, x, sel;
  unsigned long *pdw;
  unsigned char *ptr;
  unsigned long packetsize;
  unsigned long oldestpack, lastpacket, packetid;
  unsigned char type;
  struct timeval tv;
  fd_set fds;
  ofstream bolog;

  FD_ZERO(&fds);
  FD_SET(sock, &fds);
  tv.tv_sec = 10;
  tv.tv_usec = 0;
  hostsize = sizeof(host);

  while ((sel = select(sock + 1, &fds, NULL, NULL, &tv)) > 0)
    {
      tv.tv_sec = 10;
      tv.tv_usec = 0;

      if ((x = recvfrom(sock, buff, BUFFSIZE, 0, (struct sockaddr *) &host, (unsigned int *) &hostsize)) <= 0)
	continue;

      BOcrypt((unsigned char *) buff, x);
      if (strncmp(buff, MAGICSTRING, MAGICSTRINGLEN) != 0)
	continue;

      pdw = (unsigned long *) buff;
      pdw += 2;
      packetsize = *pdw++;
      packetsize = __EL_LONG(packetsize);
      packetid = *pdw++;
      packetid = __EL_LONG(packetid);
      ptr = (unsigned char *) pdw;
      type = *ptr++;

      bolog.open(L_BO, 8);

      if (!(type & PARTIAL_PACKET) && !(type & CONTINUED_PACKET))
	{

	  bolog << M_LBANNER <<
	    inet_ntoa(host.sin_addr) << I_PORT <<
	    (int) ntohs(host.sin_port) << M_RBANNER << ptr << ENTER;
	  if (pi.Foreground)
	    cout << I_BO << M_LBANNER <<
	      inet_ntoa(host.sin_addr) << I_PORT <<
	      (int) ntohs(host.sin_port) << M_RBANNER << ptr << ENTER;
	  bolog.close();
	  return (0);
	}

      if (!(type & CONTINUED_PACKET))
	{
	  oldestpack = packetid;
	  bolog << M_LBANNER << inet_ntoa(host.sin_addr) << I_PORT <<
	    (int) ntohs(host.sin_port) << M_RBANNER;
	  if (pi.Foreground)
	    cout << I_BO << M_LBANNER << inet_ntoa(host.sin_addr) << I_PORT <<
	      (int) ntohs(host.sin_port) << M_RBANNER;
	}

      if (type & CONTINUED_PACKET)
	lastpacket = packetid;

      bolog << ptr;
      if (pi.Foreground)
	cout << ptr;

      if (!(type & PARTIAL_PACKET))
	{
	  bolog << ENTER;
	  if (pi.Foreground)
	    cout << ENTER;
	  bolog.close();
	  return (0);
	}
      bolog.flush();
    }

  bolog.close();

#ifdef EBUG
  if (sel == 0)
    dbug << "BO timeout...\n";
  else if (sel < 0)
    dbug << "BO select error: " << strerror(errno) << ENTER;
#endif

  return (1);			/* error */
}

int
sendpacket(unsigned long dest, int port, int sock)
{
  unsigned char *ptr;
  unsigned long *pdw;
  unsigned long size;
  struct sockaddr_in host;
  const char *str1 = "", *str2 = "";
  char buff[BUFFSIZE];
  struct linger linger;

  linger.l_onoff = 0;
  setsockopt(sock, SOL_SOCKET, SO_LINGER, (void *) &linger, sizeof(linger));

  size = MAGICSTRINGLEN + (sizeof(long) * 2) + 3 + strlen(str1) + strlen(str2);

  strcpy(buff, MAGICSTRING);
  pdw = (unsigned long *) (buff + MAGICSTRINGLEN);
  *pdw++ = __EL_LONG(size);
  *pdw++ = __EL_LONG(0);
  ptr = (unsigned char *) pdw;
  *ptr++ = (unsigned char) TYPE_PING;
  strcpy((char *) ptr, str1);
  ptr += strlen(str1) + 1;
  strcpy((char *) ptr, str2);

  BOcrypt((unsigned char *) buff, (int) size);

  host.sin_family = AF_INET;
  host.sin_port = htons((unsigned short) port);
  host.sin_addr.s_addr = dest;

  if ((sendto(sock, buff, size, 0, (struct sockaddr *) &host, sizeof(host))) != (int) size)
    return (1);

  return 0;
}
