//////////////////////////////////////////////////////////////////////////////
//                                                                          //
//                  Network Security Analysis Tool                          //
//          osscan.cpp - remote operating system detection                  //
//                                                                          //
//   Copyright (C) 1999-2000 by Mixter and 2xs ltd. <mixter@2xs.co.il>      //
//                                                                          //
// This program is free software; you can redistribute it and/or modify     //
// it under the terms of the GNU General Public License as published by     //
// the Free Software Foundation; either version 2 of the License, or        //
// (at your option) any later version.                                      //
//                                                                          //
// This program is distributed in the hope that it will be useful,          //
// but WITHOUT ANY WARRANTY; without even the implied warranty of           //
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the            //
// GNU General Public License for more details.                             //
//                                                                          //
// You should have received a copy of the GNU General Public License        //
// along with this program; if not, write to the Free Software              //
// Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307 USA //
//                                                                          //
//////////////////////////////////////////////////////////////////////////////

// osscan, a very slim version of the famous
// os scanner queso by savage@apostols.org

#include "../nsat.h"
#include "osscan.h"

#define MIN_REPLIES 2		/* less than 2 packets received
				   means no reply */

extern sigjmp_buf stack;
extern ProgressIndicator pi;

#ifdef EBUG
extern ofstream dbug;

#endif

int ztp;

void
scanprint(FILE * fp, Fingerprint * pp)
{

  fgets(pp->desc, 254, fp);
  pp->desc[strlen(pp->desc) - 1] = '\0';

  fscanf(fp, "%d %d %d %d %x %d\n",
	 (int *) &pp->rr0.set,
	 (int *) &pp->rr0.seq,
	 (int *) &pp->rr0.ack,
	 (int *) &pp->rr0.urg,
	 (int *) &pp->rr0.win,
	 (int *) &pp->rr0.flag);
  fscanf(fp, "%d %d %d %d %x %d\n",
	 (int *) &pp->rr1.set,
	 (int *) &pp->rr1.seq,
	 (int *) &pp->rr1.ack,
	 (int *) &pp->rr1.urg,
	 (int *) &pp->rr1.win,
	 (int *) &pp->rr1.flag);
  fscanf(fp, "%d %d %d %d %x %d\n",
	 (int *) &pp->rr2.set,
	 (int *) &pp->rr2.seq,
	 (int *) &pp->rr2.ack,
	 (int *) &pp->rr2.urg,
	 (int *) &pp->rr2.win,
	 (int *) &pp->rr2.flag);
  fscanf(fp, "%d %d %d %d %x %d\n",
	 (int *) &pp->rr3.set,
	 (int *) &pp->rr3.seq,
	 (int *) &pp->rr3.ack,
	 (int *) &pp->rr3.urg,
	 (int *) &pp->rr3.win,
	 (int *) &pp->rr3.flag);
  fscanf(fp, "%d %d %d %d %x %d\n",
	 (int *) &pp->rr4.set,
	 (int *) &pp->rr4.seq,
	 (int *) &pp->rr4.ack,
	 (int *) &pp->rr4.urg,
	 (int *) &pp->rr4.win,
	 (int *) &pp->rr4.flag);
  fscanf(fp, "%d %d %d %d %x %d\n",
	 (int *) &pp->rr5.set,
	 (int *) &pp->rr5.seq,
	 (int *) &pp->rr5.ack,
	 (int *) &pp->rr5.urg,
	 (int *) &pp->rr5.win,
	 (int *) &pp->rr5.flag);
  fscanf(fp, "%d %d %d %d %x %d\n",
	 (int *) &pp->rr6.set,
	 (int *) &pp->rr6.seq,
	 (int *) &pp->rr6.ack,
	 (int *) &pp->rr6.urg,
	 (int *) &pp->rr6.win,
	 (int *) &pp->rr6.flag);

}

void
fpmatch(OSRES res, OSRES fpr)
{
  if (res.set != fpr.set)
    {
      if (res.set)
	ztp++;
      return;
    }
  if (res.seq != fpr.seq)
    {
      ztp++;
      return;
    }
  if ((res.ack != fpr.ack) && (res.ack != (fpr.ack + 1000)))
    {
      ztp++;
      return;
    }
  if (res.urg != fpr.urg)
    {
      ztp++;
      return;
    }
  if (res.win != fpr.win)
    {
      ztp++;
      return;
    }
  if (res.flag != fpr.flag)
    {
      ztp++;
      return;
    }
}

void
tcprobe(unsigned int ipad, int port, int timeout)
{
  int r = rawsock(IPPROTO_RAW), start, n = 0, x, ts;
  char synb[8192];
  struct sockaddr_in sin;
  struct ip *ih = (struct ip *) synb;
  struct tcp *th = (struct tcp *) (synb + sizeof(struct ip));
  OSRES rr[7];
  struct in_addr host;
  ofstream flog;
  int ri = sizeof(sin);

  host.s_addr = ipad;
  for (n = 0; n <= 6; n++)
    rr[n].set = 0;

  unsigned long myseq = (getrandom(0, 65535) + (getrandom(0, 65535) << 8));
  int sport = (getrandom(4000, 26400));

  start = sport;

  ts = socket(AF_INET, SOCK_RAW, IPPROTO_TCP);
  fcntl(ts, F_SETFL, O_RDWR | O_NONBLOCK);

  sin.sin_family = AF_INET;
  sin.sin_port = htons(port);
  sin.sin_addr.s_addr = ipad;

  ih->ver = 4;
  ih->ihl = 5;
  ih->tos = 0x00;
  ih->tl = htons(40);
  ih->id = htons(31337 + sport);
  ih->off = 0;
  ih->ttl = 255;
  ih->pro = IPPROTO_TCP;
  ih->sum = 0;
  ih->src = INADDR_ANY;
  ih->dst = ipad;
  th->src = 0;
  th->dst = htons(port);
  th->seq = htonl(myseq);
  th->ack = 0;
  th->x2 = 0;
  th->flg = 0;
  th->win = htons(0x1234);
  th->off = 5;
  th->sum = 0;
  th->urp = 0;

/* PACKET 0: SYN */
  th->src = htons(sport++);
  th->flg = SYN;
  th->sum = sum((unsigned short *) synb, (sizeof(struct ip) + sizeof(struct tcp) + 1) & ~1);

  ih->sum = sum((unsigned short *) synb, (GAYLEN + 1) & ~1);
  sendto(r, synb, GAYLEN, 0, (struct sockaddr *) &sin, ri);
  usleep(100);

/* PACKET 1: SYN|ACK */
  th->src = htons(sport++);
  th->flg = SYN | ACK;
  th->sum = sum((unsigned short *) synb, (sizeof(struct ip) + sizeof(struct tcp) + 1) & ~1);

  ih->sum = sum((unsigned short *) synb, (GAYLEN + 1) & ~1);
  sendto(r, synb, GAYLEN, 0, (struct sockaddr *) &sin, ri);
  usleep(100);

/* PACKET 2: FIN */
  th->src = htons(sport++);
  th->flg = FIN;
  th->sum = sum((unsigned short *) synb, (sizeof(struct ip) + sizeof(struct tcp) + 1) & ~1);

  ih->sum = sum((unsigned short *) synb, (GAYLEN + 1) & ~1);
  sendto(r, synb, GAYLEN, 0, (struct sockaddr *) &sin, ri);
  usleep(100);

/* PACKET 3: FIN|ACK */
  th->src = htons(sport++);
  th->flg = FIN | ACK;
  th->sum = sum((unsigned short *) synb, (sizeof(struct ip) + sizeof(struct tcp) + 1) & ~1);

  ih->sum = sum((unsigned short *) synb, (GAYLEN + 1) & ~1);
  sendto(r, synb, GAYLEN, 0, (struct sockaddr *) &sin, ri);
  usleep(100);

/* PACKET 4: SYN|FIN */
  th->src = htons(sport++);
  th->flg = SYN | FIN;
  th->sum = sum((unsigned short *) synb, (sizeof(struct ip) + sizeof(struct tcp) + 1) & ~1);

  ih->sum = sum((unsigned short *) synb, (GAYLEN + 1) & ~1);
  sendto(r, synb, GAYLEN, 0, (struct sockaddr *) &sin, ri);
  usleep(100);

/* PACKET 5: PSH */
  th->src = htons(sport++);
  th->flg = PSH;
  th->sum = sum((unsigned short *) synb, (sizeof(struct ip) + sizeof(struct tcp) + 1) & ~1);

  ih->sum = sum((unsigned short *) synb, (GAYLEN + 1) & ~1);
  sendto(r, synb, GAYLEN, 0, (struct sockaddr *) &sin, ri);
  usleep(100);

/* PACKET 6: SYN|XXX|YYY */
  th->src = htons(sport++);
  th->flg = SYN | XXX | YYY;
  th->sum = sum((unsigned short *) synb, (sizeof(struct ip) + sizeof(struct tcp) + 1) & ~1);

  ih->sum = sum((unsigned short *) synb, (GAYLEN + 1) & ~1);
  sendto(r, synb, GAYLEN, 0, (struct sockaddr *) &sin, ri);
  usleep(100);

  rr[6].set = 0;

  timeout += time(NULL);

  while ((!rr[6].set) && (timeout > time(NULL)))
    {
      if (read(ts, synb, sizeof(synb)) < 0)
	usleep(500);
      if ((ih->pro == IPPROTO_TCP && ih->src == ipad) && ntohs(th->src) == port)
	{
	  // the eleat queso analyzation tekneek reeped by meextawr.
	  n = ntohs(th->dst) - start;	// 0 < n < 6 or something is wrong

	  if (rr[n].set == 1)
	    continue;
	  rr[n].set = 1;
	  rr[n].seq = (th->seq ? 1 : 0);
	  rr[n].ack = (th->ack ? (ntohl(th->ack) - myseq + 1000) : 0);
	  if (rr[n].ack > 1666)
	    rr[n].ack = 1666;
	  rr[n].win = ntohs(th->win);
	  rr[n].flag = th->flg;
	  rr[n].urg = (th->urp ? 1 : 0);
	}
    }

  close(r);
  close(ts);

  if ((rr[0].set + rr[1].set + rr[2].set + rr[3].set + rr[4].set + rr[5].set + rr[6].set) < MIN_REPLIES)
    return;

#ifdef PARANOID_CHECK
  struct stat s;

  lstat(PRINTS, &s);
  if (S_ISLNK(s.st_mode) || (s.st_uid + s.st_gid))
    return;
#endif

  Fingerprint fpr;
  FILE *os = fopen(PRINTS, "r");

  if (os == NULL)
    {
#ifdef EBUG
      dbug << "Unable to open fingerprint file " << PRINTS << ", skipping OS scan...\n";
#endif
      return;
    }

  for (x = 0; x <= OSCOUNT; x++)
    {
      ztp = 0;

      scanprint(os, &fpr);
      fpmatch(rr[0], fpr.rr0);
      fpmatch(rr[1], fpr.rr1);
      fpmatch(rr[2], fpr.rr2);
      fpmatch(rr[3], fpr.rr3);
      fpmatch(rr[4], fpr.rr4);
      fpmatch(rr[5], fpr.rr5);
      fpmatch(rr[6], fpr.rr6);

#ifdef EBUG
      dbug << "ztp = " << ztp << " desc = " << fpr.desc << ENTER;
#endif

      // allow x of 7 packet recognition mismatches
      if (ztp <= pi.ScanOS)
	{
	  flog.open(L_OS, 8);
	  flog << inet_ntoa(host) << I_S << fpr.desc << ENTER;
	  if (pi.Foreground)
	    cout << I_OS << inet_ntoa(host) << I_S << fpr.desc << ENTER;
	  flog.close();
	  return;
	}

    }

  flog.open(L_UOS, 8);
  flog << I_UOS << inet_ntoa(host) << ENTER;
  flog << rr[0].set << " " << rr[0].seq << " " << rr[0].ack << " " <<
    rr[0].urg << " " << rr[0].win << " " << rr[0].flag << ENTER;
  flog << rr[1].set << " " << rr[1].seq << " " << rr[1].ack << " " <<
    rr[1].urg << " " << rr[1].win << " " << rr[1].flag << ENTER;
  flog << rr[2].set << " " << rr[2].seq << " " << rr[2].ack << " " <<
    rr[2].urg << " " << rr[2].win << " " << rr[2].flag << ENTER;
  flog << rr[3].set << " " << rr[3].seq << " " << rr[3].ack << " " <<
    rr[3].urg << " " << rr[3].win << " " << rr[3].flag << ENTER;
  flog << rr[4].set << " " << rr[4].seq << " " << rr[4].ack << " " <<
    rr[4].urg << " " << rr[4].win << " " << rr[4].flag << ENTER;
  flog << rr[5].set << " " << rr[5].seq << " " << rr[5].ack << " " <<
    rr[5].urg << " " << rr[5].win << " " << rr[5].flag << ENTER;
  flog << rr[6].set << " " << rr[6].seq << " " << rr[6].ack << " " <<
    rr[6].urg << " " << rr[6].win << " " << rr[6].flag << ENTER;
  flog.close();

  return;
}
