//////////////////////////////////////////////////////////////////////////////
//                                                                          //
//                  Network Security Analysis Tool                          //
//             osscan.h - fingerprint database parsing                      //
//                                                                          //
//   Copyright (C) 1999-2000 by Mixter and 2xs ltd. <mixter@2xs.co.il>      //
//                                                                          //
// This program is free software; you can redistribute it and/or modify     //
// it under the terms of the GNU General Public License as published by     //
// the Free Software Foundation; either version 2 of the License, or        //
// (at your option) any later version.                                      //
//                                                                          //
// This program is distributed in the hope that it will be useful,          //
// but WITHOUT ANY WARRANTY; without even the implied warranty of           //
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the            //
// GNU General Public License for more details.                             //
//                                                                          //
// You should have received a copy of the GNU General Public License        //
// along with this program; if not, write to the Free Software              //
// Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307 USA //
//                                                                          //
//////////////////////////////////////////////////////////////////////////////

#ifndef FINGERPRINTS_H
#define FINGERPRINTS_H

/*    flag lookup table:
   A 16                 R 4
   RA 20                RAF 21
   RAP 28               RPA 28
   SA 18                SAXY 210
   SFA 19               SPA 26
   UR 36                URA 52 */

#define YYY 0x80
#define XXX 0x40
#define URG 0x20
#define ACK 0x10
#define PSH 0x08
#define RST 0x04
#define SYN 0x02
#define FIN 0x01
#define A       ACK
#define R       RST
#define RA      RST|ACK
#define RAF     RST|ACK|FIN
#define RAP     RST|ACK|PSH
#define RPA     RST|PSH|ACK
#define SA      SYN|ACK
#define SAXY    SYN|ACK|XXX|YYY
#define SFA     SYN|FIN|ACK
#define SPA     SYN|PSH|ACK
#define UR      URG|RST
#define URA     URG|RST|ACK

typedef struct
  {
    unsigned short set;
    unsigned long seq;
    unsigned long ack;
    unsigned short urg;
    unsigned short win;
    unsigned short flag;
  }
OSRES;

typedef struct
  {
    char desc[256];
    OSRES rr0;
    OSRES rr1;
    OSRES rr2;
    OSRES rr3;
    OSRES rr4;
    OSRES rr5;
    OSRES rr6;
  }
Fingerprint;

#define GAYLEN (4 * ih->ihl + sizeof (struct tcp))

#endif
