//////////////////////////////////////////////////////////////////////////////
//                                                                          //
//                  Network Security Analysis Tool                          //
//              www.cpp - http version and cgi scanning                     //
//                                                                          //
//   Copyright (C) 1999-2000 by Mixter and 2xs ltd. <mixter@2xs.co.il>      //
//                                                                          //
// This program is free software; you can redistribute it and/or modify     //
// it under the terms of the GNU General Public License as published by     //
// the Free Software Foundation; either version 2 of the License, or        //
// (at your option) any later version.                                      //
//                                                                          //
// This program is distributed in the hope that it will be useful,          //
// but WITHOUT ANY WARRANTY; without even the implied warranty of           //
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the            //
// GNU General Public License for more details.                             //
//                                                                          //
// You should have received a copy of the GNU General Public License        //
// along with this program; if not, write to the Free Software              //
// Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307 USA //
//                                                                          //
//////////////////////////////////////////////////////////////////////////////

// based off webscan.c by Mixter
// parts from: whisker (c) .rain.forest.puppy.,
// cgiscan (c) [CKS & Fdisk], VoidEye scanner, 
// httpver (c) Shok and buffer0verfl0w security's list

#include "../nsat.h"
#include "www.h"

extern ProgressIndicator pi;
extern sigjmp_buf stack;

#ifdef EBUG
extern ofstream dbug;

#endif

int count, sock;
char whost[BUFSIZE];

void http_get(const char *, char *, struct sockaddr_in *, int);
int y2ksucks(char *);

void
webscan(int s0ck)
{
  int i, numbytes;
  unsigned int nl = sizeof(struct sockaddr);
  char buffer[170];
  char *p = NULL;
  struct sockaddr_in sin;
  ofstream f1;

  sock = s0ck;

  if (getpeername(sock, (struct sockaddr *) &sin, &nl) < 0)
    return;

  strncpy(whost, inet_ntoa(sin.sin_addr), BUFSIZE);

  send(sock, I_HTGET, 16, 0);

  for (i = 0; i < 5; i++)
    {
      bzero(buffer, sizeof(buffer));
      if ((numbytes = recv(sock, buffer, 169, 0)) < 1)
	break;
      p = strstr(buffer, "Server");
      if (p == NULL)
	continue;
      else
	{
	  strchop(p);
	  f1.open(L_HTTVER, 8);
	  f1 << whost << I_S << p + 8 << ENTER;
	  if (pi.Foreground)
	    cout << I_WWW << whost << I_S << p + 8 << ENTER;
	  f1.close();
	}
    }
  close(sock);

  if (pi.ScanWeb < 2)
    return;

  FILE *effdee;

  if ((!strlen(pi.WebCgiFile)) || ((effdee = fopen(pi.WebCgiFile, "r")) == NULL))
    {
      count = 0;
      while (strstr(www_cgibin[count], "EOF") == NULL)
	{
	  http_get(www_cgibin[count], whost, &sin, sizeof(sin));
	  count++;
	}
    }
  else
    {
      char cgibuf[BUFSIZE];

      while (fgets(cgibuf, BUFSIZE, effdee) != NULL)
	{
	  if ((cgibuf[0] != '#') && (cgibuf[0] != ' ') && (isprint(cgibuf[0])))
	    {
	      cgibuf[strlen(cgibuf) - 1] = '\0';
	      http_get(cgibuf, whost, &sin, sizeof(sin));
	    }
	  memset(cgibuf, 0, BUFSIZE);
	}
      fclose(effdee);
    }
  return;
}

void
http_get(const char *file, char *whost, struct sockaddr_in *sin, int slen)
{
  char cgibuff[BUFSIZE * 3];

  memset(cgibuff, 0, BUFSIZE * 3);
  sock = socket(AF_INET, SOCK_STREAM, 0);
  ofstream f2;

#ifdef EBUG
  dbug << "http_get: '" << file << "'\n";
#endif

  if (sigsetjmp(stack, 1) == 666)
    {
      close(sock);
      siginterrupt(SIGALRM, 1);
      return;
    }

  if (pi.ScanWeb == 3)
    {
      char evasion[BUFSIZE * 3];

      memset(evasion, 0, sizeof(evasion));
      strncpy(evasion, WEBGET, 4);
      for (unsigned int i = 0; i < strlen(file); i++)
	{
	  char etmp[8];

	  // begin intrusion detection systems evasion
	  // just the basic substitution stuph for maximum compatibility
	  if (((isalpha(file[i])) || (isspace(file[i]))))
	    sprintf(etmp, "%%%x", file[i]);
	  else
	    sprintf(etmp, "%c", file[i]);
	  strcat(evasion, etmp);
	}
      strcat(evasion, WEBVER);
      strncpy(cgibuff, evasion, BUFSIZE * 3);
    }
  else
    snprintf(cgibuff, BUFSIZE * 3, I_HTGET2, file);

  alarm(pi.timeout * 2);
  connect(sock, (struct sockaddr *) sin, slen);
  send(sock, cgibuff, strlen(cgibuff), 0);
  bzero(cgibuff, sizeof(cgibuff));
  recv(sock, cgibuff, sizeof(cgibuff) - 1, 0);
  alarm(0);

  if (y2ksucks(cgibuff))
    {
      f2.open(L_CGI, 8);
      f2 << whost << I_S << file << ENTER;
      if (pi.Foreground)
	cout << I_WWW << whost << I_S << file << ENTER;
      f2.close();
    }
  close(sock);
}

int
y2ksucks(char *buf)
{
  if (strstr(buf, "404 "))
    return 0;
  if (strstr(buf, "400 "))
    return 0;
  if (strstr(buf, "Bad Request"))
    return 0;
  if (strstr(buf, "Not Found"))
    return 0;

  for (int i = 2; i <= (int) strlen(buf); i++)
    if ((buf[i] == '0') && (buf[i - 1] == '0') &&
	(buf[i - 2] == '2') && (buf[i + 1] != '0'))
      return 1;

  return 0;
}
