//////////////////////////////////////////////////////////////////////////////
//                                                                          //
//                  Network Security Analysis Tool                          //
//                     nsat.cpp - main function                             //
//                                                                          //
//   Copyright (C) 1999-2000 by Mixter and 2xs ltd. <mixter@2xs.co.il>      //
//                                                                          //
// This program is free software; you can redistribute it and/or modify     //
// it under the terms of the GNU General Public License as published by     //
// the Free Software Foundation; either version 2 of the License, or        //
// (at your option) any later version.                                      //
//                                                                          //
// This program is distributed in the hope that it will be useful,          //
// but WITHOUT ANY WARRANTY; without even the implied warranty of           //
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the            //
// GNU General Public License for more details.                             //
//                                                                          //
// You should have received a copy of the GNU General Public License        //
// along with this program; if not, write to the Free Software              //
// Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307 USA //
//                                                                          //
//////////////////////////////////////////////////////////////////////////////

#include "nsat.h"
#include "pidalloc.h"
#include "SockSet.h"

#ifdef EBUG
ofstream dbug;

#endif

sigjmp_buf stack;		// stack pointer (to return from timeouts)
ProgressIndicator pi;		// options and recovery information
int *pidtable;			// process id table pointer
long *timetable;		// timestamp id table pointer

void
single_scan(char *host)
{
  cout << " [*] single scan mode engaged\n";
  cout << " [*] scanning " << optarg << "...";
  cout.flush();
  SockSet single;

  single.con(host);
  cout << " done\n";
  exit(0);
}

int
main(int argc, char **argv)
{
  int opt = 0, conf = 0, pid = 1;
  FILE *gfp = NULL;

#ifdef EBUG
  dbug.open(L_DEBUG, 8);
  dbug << "new process: " << getpid() << ENTER;
#endif

  if (readpid())
    {
      cerr << argv[0] << M_RUNNING;
      exit(-1);
    }

  if (argc == 1)
    {
      if (!pi.restore())
	{
	  cerr << argv[0] << M_NORECFILE;
	  exit(-1);
	}
      if (!pi.stealth)
	{
	  puts(NSAT_BANNER);
#ifdef EBUG
	  cout << " [***] DEBUG mode enabled.\n";
#endif
	  cout << " [*] resuming scan at " << (pi.fscan ? "position " : "ip ");

	  if (pi.fscan)
	    cout << pi.fpos << ENTER;	// impossible here to use

	  else			// ?-operator, thanks, c++ :/

	    cout << (ntoa(pi.ipcur)) << ENTER;

	  cout.flush();
	}
      if (pi.fscan)
	{
	  gfp = fopen(pi.fname, "r");
	  if (gfp == NULL)
	    {
	      if (!pi.stealth)
		cout << "...error opening file\n";
	      cout.flush();
	      usage(argv[0]);
	    }
	}
      goto lame_trick;
    }

  puts(NSAT_BANNER);
#ifdef EBUG
  cout << "*** DEBUG mode enabled.\n";
#endif

  while ((opt = getopt(argc, argv, "c:e:f:h:i:l:m:np:s:t:v:C:V:")) != EOF)
    switch (opt)
      {
      case 'c':
	pi.stealth = atoi(optarg);
	cout << " [*] coward mode " << (pi.stealth ? "on\n" : "off\n");
	cout.flush();
	break;
      case 'e':
	if (!pi.ipcur)
	  usage(argv[0]);
	pi.ipend = inet_addr(optarg);
	if (pi.ipend == -1)
	  {
	    cout << "...error parsing ip\n";
	    cout.flush();
	    usage(argv[0]);
	  }
	pi.fscan = 0;
	cout << "engaged\n";
	cout.flush();
	break;
      case 'f':
	cout << " [*] file scan mode ";
	cout.flush();
	pi.fscan = 1;
	strcpy(pi.fname, optarg);
	gfp = fopen(pi.fname, "r");
	if (gfp == NULL)
	  {
	    cout << "...error opening file\n";
	    cout.flush();
	    usage(argv[0]);
	  }
	cout << "engaged\n";
	cout.flush();
	break;
      case 'h':
	if (!conf)
	  {
	    cout << " [*] reading default config file: " << CONFIG_FILE << ENTER;
	    pi.readconf(CONFIG_FILE);
	  }
	if (!pi.stealth)
	  pi.status();
	single_scan(optarg);
	break;
      case 'i':
	pi.idle = atoi(optarg);
	if (!pi.idle)
	  usage(argv[0]);
	cout << " [*] system idle time set to " << pi.idle << " seconds\n";
	cout.flush();
	break;
      case 'l':
	pi.maxlife = atoi(optarg);
	if (!pi.maxlife)
	  usage(argv[0]);
	cout << " [*] maximum process lifetime set to " << pi.maxlife << " seconds\n";
	cout.flush();
	break;
      case 'm':
	pi.maxproc = atoi(optarg);
	if (!pi.maxproc)
	  usage(argv[0]);
	cout << " [*] maximum process count set to " << pi.maxproc << ENTER;
	cout.flush();
	break;
      case 'n':
	cout << " [*] console mode engaged, displaying status information...\n";
	cout.flush();
	pi.Foreground = 1;
	break;
      case 'p':
	pi.pingonly = atoi(optarg);
	cout << " [*] ping dependent scanning " << (pi.pingonly ? "on\n" : "off\n");
	cout.flush();
	break;
      case 's':
	pi.ipcur = inet_addr(optarg);
	if (pi.ipcur == -1)
	  usage(argv[0]);
	cout << " [*] range scan mode ";
	cout.flush();
	break;
      case 't':
	pi.timeout = atoi(optarg);
	if (!pi.timeout)
	  usage(argv[0]);
	cout << " [*] timeout set to " << pi.timeout << " seconds\n";
	cout.flush();
	break;
      case 'v':
	pi.OldVerboseLevel(atoi(optarg));
	cout << " [*] simulating old-style scan level:" << atoi(optarg);
	cout.flush();
	break;
      case 'C':
	pi.readconf(optarg);
	cout << " [*] using config file: " << optarg << ENTER;
	conf++;
	cout.flush();
	break;
      case 'V':
	pi.vhostip = resolve(optarg);
	if (!pi.vhostip)
	  cout << " [*] cannot resolve vhost " << optarg << ", disabling vhost\n";
	else
	  cout << " [*] scanning from virtual host " << optarg << ENTER;
	cout.flush();
	break;
      default:
	usage(argv[0]);
	break;
      }

  if (!conf)
    {
      cout << " [*] reading default config file: " << CONFIG_FILE << ENTER;
      pi.readconf(CONFIG_FILE);
    }

  if (!getuid())
    fdmax();

  sigset(); // lets see if it works
  rlmax();

  if (pi.fscan == -1)
    {
      cerr << argv[0] << M_NOSCANTYPE;
      cerr.flush();
      usage(argv[0]);
    }

  if ((!pi.ScanIcmp) && (pi.pingonly))
    {
      cerr << argv[0] << ": non-ping and ping-dependent scan at a time makes no sense\n";
      cerr.flush();
      usage(argv[0]);
    }

lame_trick:
#ifdef PARANOID_CHECK
  {
    int para = 0;

    para = nicefile(pi.fname) + nicefile(PIDFILE) + nicefile(PROGRESS_FILE);
    para += nicefile(L_PORTS) + nicefile(L_NETSTAT) + nicefile(L_FTP);
    para += nicefile(L_SSH) + nicefile(L_TELNET) + nicefile(L_SMTP);
    para += nicefile(L_DNS) + nicefile(L_FINGER) + nicefile(L_POP2);
    para += nicefile(L_POP3) + nicefile(L_NNTP) + nicefile(L_SMB);
    para += nicefile(L_IMAP) + nicefile(L_BACKDOOR) + nicefile(L_NLPS);
    para += nicefile(L_IRCD) + nicefile(L_XWIN) + nicefile(L_NETBIOS);
    para += nicefile(L_ICMP) + nicefile(L_RPC) + nicefile(L_HTTVER);
    para += nicefile(L_CGI) + nicefile(L_BO);
    if (para)
      {
	if (!pi.stealth)
	  cerr << " [*] Integrity check failed. One or more files are non-relative or symlinks!\n";
	exit(-1);
      }
  }
#endif

  if (!pi.stealth)
    pi.status();

  if (!pi.Foreground)
    {
      if (pi.stealth)
	{
	  for (opt = 0; opt < argc; opt++)
	    memset(argv[opt], 0, strlen(argv[opt]));
	}

      pid = safe_fork();
      if (pid == -1)
	{
	  cout << " [*] fatal: unable to fork: " << strerror(errno) << ENTER;
	  exit(-1);
	}
      if (pid)
	{
	  if (!pi.stealth)
	    cout << "\t[***] going into the background (pid: " << pid << ")\n\n";
	  writepid(pid);
	  exit(0);
	}
      sleep(1);
    }

  if (pi.stealth)
    while (!sysidle(pi.idle))
      sleep(pi.idle);

#ifndef EBUG
  if (!pi.Foreground)
    {
      close(0);
      close(1);
      close(2);
    }
#else
  dbug.close();
  dbug.open(L_DEBUG, 8);
#endif

  pidtable = new int[pi.maxproc + 1];

  for (opt = 0; opt <= pi.maxproc; opt++)
    pidtable[opt] = 0;

  timetable = new long[pi.maxproc + 1];

  for (opt = 0; opt <= pi.maxproc; opt++)
    timetable[opt] = 0;

  pi.store();

  char buffer[BUFSIZE];

  if (pi.fscan)
    {				// file scan

      memset(buffer, 0, BUFSIZE);
      while (fgets(buffer, BUFSIZE, gfp) != NULL)
	{
	  strchop(buffer);
	  if (pi.Foreground)
	    {
	      cout << M_CLR;
	      cout << M_SCANNING << buffer;
	      cout.flush();
	      cout << M_CLR;
	    }
	  pi.update(ftell(gfp));
#ifdef EBUG
	  dbug << "pid " << getpid() << " spawning alloc_scan(" << buffer << ");\n";
#endif
	  alloc_scan(buffer);
	  memset(buffer, 0, BUFSIZE);
	  usleep(500000);
	}
      fclose(gfp);
    }
  else
    {				// ip range scan

      memset(buffer, 0, BUFSIZE);
      strcpy(buffer, ntoa(pi.ipcur));
      do
	{
	  if (strcmp(ntoa(pi.ipend), buffer) == 0)
	    break;
	  if (pi.Foreground)
	    {
	      cout << M_CLR;
	      cout << M_SCANNING << buffer;
	      cout.flush();
	      cout << M_CLR;
	    }
	  pi.update(inet_addr(buffer));
#ifdef EBUG
	  dbug << "alloc_scan(" << buffer << ");\n";
#endif
	  alloc_scan(buffer);
	  usleep(500000);
	}
      while (incip(buffer));
    }

  if (pi.Foreground)
    {
      cout << " [*] waiting for all childs to finish, please be patient...\n";
      cout.flush();
    }

  for (opt = 0; opt <= pi.maxproc; opt++)
    if (pidtable[opt])
      {
	sleep(pi.maxlife / 2);
	alloc_purge();
      }

  for (opt = 0; opt <= pi.maxproc; opt++)
    if (pidtable[opt])
      kill(pidtable[opt], SIGKILL);

  if (pi.Foreground)
    cout << "\n [*] scanning process successfully completed\n";
  else
    {
      unlink(PIDFILE);
      unlink(PROGRESS_FILE);
    }

  delete pidtable;
  delete timetable;

#ifdef EBUG
  dbug << "process " << getpid() << " exiting\n";
  dbug.close();
#endif
  return (0);
}
