//////////////////////////////////////////////////////////////////////////////
//                                                                          //
//                  Network Security Analysis Tool                          //
//                pidalloc.cpp - process allocation                         //
//                                                                          //
//   Copyright (C) 1999-2000 by Mixter and 2xs ltd. <mixter@2xs.co.il>      //
//                                                                          //
// This program is free software; you can redistribute it and/or modify     //
// it under the terms of the GNU General Public License as published by     //
// the Free Software Foundation; either version 2 of the License, or        //
// (at your option) any later version.                                      //
//                                                                          //
// This program is distributed in the hope that it will be useful,          //
// but WITHOUT ANY WARRANTY; without even the implied warranty of           //
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the            //
// GNU General Public License for more details.                             //
//                                                                          //
// You should have received a copy of the GNU General Public License        //
// along with this program; if not, write to the Free Software              //
// Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307 USA //
//                                                                          //
//////////////////////////////////////////////////////////////////////////////

// these nice easy functions are responsible for core
// process stability and need to succeed every time

#include "pidalloc.h"
#pragma implementation "pidalloc"

#ifdef EBUG
extern ofstream dbug;

#endif

int
alloc_scan(char *host)
{
  int i;

  if (pi.stealth)
    while (!sysidle(pi.idle))
      {
	alloc_purge();
	sleep(pi.idle);
      }

cheap_trick:
// find a free pid slot
  for (i = 0; i <= pi.maxproc; i++)
    {
      if (pidtable[i] == 0)
	break;
#ifdef EBUG
      dbug << "pidslot " << i << " occupied (" << pidtable[i] << ")...\n";
#endif
    }

  if (i >= pi.maxproc)
    {
#ifdef EBUG
      dbug << "all process slots occupied, purging...\n";
#endif
      sleep(pi.maxlife / 2);
      alloc_purge();
      goto cheap_trick;
    }

  timetable[i] = pi.tstamp;
  pidtable[i] = safe_fork();

  if (!pidtable[i])
    {
      rlmax();
      scan(host);
      raise(SIGKILL);
      return (0);
    }

  return (pidtable[i]);
}

void
alloc_purge(void)
{
  int i;

  for (i = 0; i <= pi.maxproc; i++)
    if (pidtable[i] != 0)	// unf, purge, unf, purge, unf, purge ...

      {
#ifdef EBUG
	dbug << "pid " << pidtable[i] << " active\n";
#endif
	errno = 0;
	if (kill(pidtable[i], SIGALRM) == -1)
	  pidtable[i] = 0;	// purged (process exited)

	else if ((pi.tstamp - timetable[i]) > pi.maxlife)
	  {
#ifdef EBUG
	    dbug << "pid " << pidtable[i] << " purged: " <<
	      (pi.tstamp - timetable[i]) << "sec \n";
#endif
	    kill(pidtable[i], SIGTERM);
	    usleep(500);
	    kill(pidtable[i], SIGKILL);
	    pidtable[i] = 0;	// purged (process killed)

	  }
      }
  return;
}

void
scan(char *host)
{
#ifdef EBUG
  dbug.close();
  char buf[256];

  snprintf(buf, 255, "debug.%d.log", getpid());
  dbug.open(buf, 8);
  dbug << "NewChild " << " scanning " << host << ENTER;
#endif

  SockSet scan;

  scan.con(host);

  return;
}
