//////////////////////////////////////////////////////////////////////////////
//                                                                          //
//                  Network Security Analysis Tool                          //
//               progress.h - scan options and recovery                     //
//                                                                          //
//   Copyright (C) 1999-2000 by Mixter and 2xs ltd. <mixter@2xs.co.il>      //
//                                                                          //
// This program is free software; you can redistribute it and/or modify     //
// it under the terms of the GNU General Public License as published by     //
// the Free Software Foundation; either version 2 of the License, or        //
// (at your option) any later version.                                      //
//                                                                          //
// This program is distributed in the hope that it will be useful,          //
// but WITHOUT ANY WARRANTY; without even the implied warranty of           //
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the            //
// GNU General Public License for more details.                             //
//                                                                          //
// You should have received a copy of the GNU General Public License        //
// along with this program; if not, write to the Free Software              //
// Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307 USA //
//                                                                          //
//////////////////////////////////////////////////////////////////////////////

#ifndef PROGRESS_H
#define PROGRESS_H
#pragma interface "progress"
#include "nsat.h"

#define SMALLB		 256
#define P_TIMER		  60	// update progress each n seconds

class ProgressIndicator
{
  public:
  int tstamp;			/* time()... */
  int fscan;			/* file scan (1) or range scan (0) */
  long ipcur;			/* current ip */
  long ipend;			/* last ip */
  long fpos;			/* ftell()... */
  int timeout;
  int pingonly;			/* option: dont scan if icmp test fails */
  int stealth;			/* hide a lot */
  int idle;			/* sysidle time */
  int maxproc;
  int maxlife;
  int Foreground;
  char confname[SMALLB];	/* config file */
  char fname[SMALLB];		/* input file name */
  char fprints[SMALLB];		// set to default in class init
  char pidfile[SMALLB];		// set to default in class init
  char progressfile[SMALLB];	// set to default in class init
  char WebCgiFile[SMALLB];	// if inaccessible, use (minimal) defaults
  unsigned long vhostip;
  short VerboseLogging;
  short ScanBackdoor;
  short ScanIcmp;		// 1 yes 2 verbose
  short ScanNetstat;		// 1 yes 2 log output
  short ScanFtp;		// 1 yes 2 anonymous 3 writable
  short ScanSsh;
  short ScanTelnet;		// 1 yes 2 readbanner 3 dumpbanner
  short ScanSmtp;		// 1 yes 2 info 3 fakemail 4 remote-exploit
  short ScanBind;		// 1 iquery 2 all
  short ScanFinger;		// 1 yes 2 remote-exploit
  short ScanPop2;
  short ScanPop3;
  short ScanRpc;		// 1 portmap 2 yes 3 verbose 4 exports check
  short ScanNntp;
  short ScanSmb;
  short ScanImap;
  short ScanNlps;		// 1 yes 2 remote-exploit
  short ScanIrcd;		// 1 yes 2 verbose
  short ScanXWin;		// 1 yes 2 display check
  short ScanNetBios;
  short ScanBackOrifice;
  short ScanOS;			// !0 yes (this is also fprint_tolerance)
  short ScanSnmp;
  short ScanWeb;		// 1 yes 2 cgi 3 ids evasion

  unsigned short Ports[SMALLB];
  unsigned short PortRange[2];
    ProgressIndicator();
   ~ProgressIndicator();
  int readconf(char *);
  void OldVerboseLevel(int);
  void update(long p);
  int restore(void);
  int store(void);
  void status(void);
};

#endif
