// pcheck (c) Mixter - check the nsat fingerprinting
// file structure by parsing its contents into
// the Fingerprint structure and printing it out

#include "../src/nsat.h"
#include "../src/mod/osscan.h"

void
scanprint (FILE * fp, Fingerprint * pp)
{

  fgets (pp->desc, 254, fp);
  pp->desc[strlen (pp->desc) - 1] = '\0';

  fscanf (fp, "%d %d %d %d %x %d\n",
	  (int *) &pp->rr0.set,
	  (int *) &pp->rr0.seq,
	  (int *) &pp->rr0.ack,
	  (int *) &pp->rr0.urg,
	  (int *) &pp->rr0.win,
	  (int *) &pp->rr0.flag);
  fscanf (fp, "%d %d %d %d %x %d\n",
	  (int *) &pp->rr1.set,
	  (int *) &pp->rr1.seq,
	  (int *) &pp->rr1.ack,
	  (int *) &pp->rr1.urg,
	  (int *) &pp->rr1.win,
	  (int *) &pp->rr1.flag);
  fscanf (fp, "%d %d %d %d %x %d\n",
	  (int *) &pp->rr2.set,
	  (int *) &pp->rr2.seq,
	  (int *) &pp->rr2.ack,
	  (int *) &pp->rr2.urg,
	  (int *) &pp->rr2.win,
	  (int *) &pp->rr2.flag);
  fscanf (fp, "%d %d %d %d %x %d\n",
	  (int *) &pp->rr3.set,
	  (int *) &pp->rr3.seq,
	  (int *) &pp->rr3.ack,
	  (int *) &pp->rr3.urg,
	  (int *) &pp->rr3.win,
	  (int *) &pp->rr3.flag);
  fscanf (fp, "%d %d %d %d %x %d\n",
	  (int *) &pp->rr4.set,
	  (int *) &pp->rr4.seq,
	  (int *) &pp->rr4.ack,
	  (int *) &pp->rr4.urg,
	  (int *) &pp->rr4.win,
	  (int *) &pp->rr4.flag);
  fscanf (fp, "%d %d %d %d %x %d\n",
	  (int *) &pp->rr5.set,
	  (int *) &pp->rr5.seq,
	  (int *) &pp->rr5.ack,
	  (int *) &pp->rr5.urg,
	  (int *) &pp->rr5.win,
	  (int *) &pp->rr5.flag);
  fscanf (fp, "%d %d %d %d %x %d\n",
	  (int *) &pp->rr6.set,
	  (int *) &pp->rr6.seq,
	  (int *) &pp->rr6.ack,
	  (int *) &pp->rr6.urg,
	  (int *) &pp->rr6.win,
	  (int *) &pp->rr6.flag);

}

int main(void)
{
FILE *fp = fopen(PRINTS,"r");
Fingerprint p;
int i;

if(fp==NULL) {
cerr << "unable to open " << PRINTS << ENTER;
exit(-1);
}

for(i=0;i<=OSCOUNT;i++)
{
scanprint(fp,&p);
  cout << "#" << i << ": " << p.desc << ENTER;
  cout << p.rr0.set << " " << p.rr0.seq << " " << p.rr0.ack << " " <<
    p.rr0.urg << " " << p.rr0.win << " " << p.rr0.flag << ENTER;
  cout << p.rr1.set << " " << p.rr1.seq << " " << p.rr1.ack << " " <<
    p.rr1.urg << " " << p.rr1.win << " " << p.rr1.flag << ENTER;
  cout << p.rr2.set << " " << p.rr2.seq << " " << p.rr2.ack << " " <<
    p.rr2.urg << " " << p.rr2.win << " " << p.rr2.flag << ENTER;
  cout << p.rr3.set << " " << p.rr3.seq << " " << p.rr3.ack << " " <<
    p.rr3.urg << " " << p.rr3.win << " " << p.rr3.flag << ENTER;
  cout << p.rr4.set << " " << p.rr4.seq << " " << p.rr4.ack << " " <<
    p.rr4.urg << " " << p.rr4.win << " " << p.rr4.flag << ENTER;
  cout << p.rr5.set << " " << p.rr5.seq << " " << p.rr5.ack << " " <<
    p.rr5.urg << " " << p.rr5.win << " " << p.rr5.flag << ENTER;
  cout << p.rr6.set << " " << p.rr6.seq << " " << p.rr6.ack << " " <<
    p.rr6.urg << " " << p.rr6.win << " " << p.rr6.flag << ENTER;
  cout << ENTER;
  cout.flush();
}
return(0);
}
