#ifndef PAT_H
#define PAT_H

#include <signal.h>
#include <stdio.h>
#include <netdb.h>
#include <string.h>
#include <stdlib.h>
#include <unistd.h>
#include <fcntl.h>
#include <signal.h>
#include <getopt.h>
#include <sys/socket.h>
#include <sys/types.h>
#include <sys/time.h>
#include <netinet/in.h>
#include <arpa/inet.h>

long
getrandom(int min, int max)
{
  srandom(getpid() ^ time(NULL) ^ random());
  return ((random() % (int) (((max) + 1) - (min))) + (min));
}

int
validip(char *ip)
{
  int a, b, c, d, *x;

  sscanf(ip, "%d.%d.%d.%d", &a, &b, &c, &d);
  x = &a;
  if (*x < 0)
    return 0;
  if (*x > 255)
    return 0;
  x = &b;
  if (*x < 0)
    return 0;
  if (*x > 255)
    return 0;
  x = &c;
  if (*x < 0)
    return 0;
  if (*x > 255)
    return 0;
  x = &d;
  if (*x < 0)
    return 0;
  if (*x > 255)
    return 0;
  sprintf(ip, "%d.%d.%d.%d", a, b, c, d);
  return 1;
}

int
truncip(char *ip, int how)
{
  int a, b, c, d, *x;

  sscanf(ip, "%d.%d.%d.%d", &a, &b, &c, &d);
  x = &a;
  if (*x < 0)
    return 0;
  if (*x > 255)
    return 0;
  x = &b;
  if (*x < 0)
    return 0;
  if (*x > 255)
    return 0;
  x = &c;
  if (*x < 0)
    return 0;
  if (*x > 255)
    return 0;
  x = &d;
  if (*x < 0)
    return 0;
  if (*x > 255)
    return 0;
  if (how == 0)
    sprintf(ip, "%d.%d.%d.0", a, b, c);
  else
    sprintf(ip, "%d.%d.%d.255", a, b, c);

  return 1;
}

int
incip(char *ip)
{
  int a, b, c, d;

  sscanf(ip, "%d.%d.%d.%d", &a, &b, &c, &d);

  d++;

  if (a >= 255)
    exit(-1);
  if (b > 255)
    {
      b = 0;
      a++;
    }
  if (c > 255)
    {
      c = 0;
      b++;
    }
  if (d > 255)
    {
      d = 0;
      c++;
    }

  sprintf(ip, "%d.%d.%d.%d", a, b, c, d);

  return 1;
}

u_short
cksum(u_short * buf, int nwords)
{
  unsigned long sum;

  for (sum = 0; nwords > 0; nwords--)
    sum += *buf++;
  sum = (sum >> 16) + (sum & 0xffff);
  sum += (sum >> 16);
  return ~sum;
}

void
error(char *huh)
{
  fprintf(stderr, huh);
  fflush(stderr);
  exit(1);
}

#ifndef INADDR_ANY
#define INADDR_ANY              ((unsigned) 0x00000000)
#endif

typedef char s8;
typedef unsigned char u8;
typedef short int s16;
typedef unsigned short int u16;
typedef int s32;
typedef unsigned int u32;

#if defined(WORDS_BIGENDIAN) && !defined(htons) && !defined(htonl)
#define ntohl(x)        (x)
#define ntohs(x)        (x)
#define htonl(x)        (x)
#define htons(x)        (x)
#endif

struct ip
  {
#ifndef WORDS_BIGENDIAN
    u8 ihl:4, ver:4;
#else
    u8 ver:4, ihl:4;
#endif
    u8 tos;
    u16 tl, id, off;
    u8 ttl, pro;
    u16 sum;
    u32 src, dst;
  };

struct tcp
  {
    u16 src, dst;
    u32 seq, ack;
#ifndef WORDS_BIGENDIAN
    u8 x2:4, off:4;
#else
    u8 off:4, x2:4;
#endif
    u8 flg;			/* flag1 | flag2 */
    u16 win, sum, urp;
  };

#define ICMP_ECHO 8

struct icmp
  {
    u8 type, code;
    u16 sum;
    u16 id, seq;
  };

#endif
