/*
   pat.c - ping analysis tool / ping sender
   (c) 1999,200 by Mixter
 */

#include "pat.h"

int sawcket;
struct sockaddr_in pothead;
struct in_addr my;

void icmp(u_long);
void lawg(char *file);
unsigned int inet_local(void);

void 
usage(void)
{
  error("usage:\n pat <-l logfile> [<-i input file>] [<-s start ip> <-e end ip>] [-d delay in ms]\n");
}

int
main(int argc, char **argv)
{
  short mkay = 0;		/* Mmm'kay? */
  int eleet, delay = 100;
  char ip1[512], ip2[512], opt, *logfile = NULL, *hostfile = NULL;
  struct in_addr sip1, sip2;
  FILE *instream = NULL;

  while ((opt = getopt(argc, argv, "l:i:s:e:d:")) != EOF)
    switch (opt)
      {
      case 'l':
	logfile = optarg;
	break;
      case 'i':
	hostfile = optarg;
	mkay = 3;
	break;
      case 's':
	strncpy(ip1, optarg, 128);
	mkay = 1;
	break;
      case 'e':
	if (mkay != 1)
	  usage();
	strncpy(ip2, optarg, 128);
	mkay = 2;
	break;
      case 'd':
	delay = atoi(optarg);
	break;
      }

  if ((mkay < 2) || (logfile == NULL))
    usage();

  if (mkay == 2)
    {
      if (!validip(ip1))
	error("INVALID start ip\n");
      if (!validip(ip2))
	error("INVALID end ip\n");
    }

  my.s_addr = inet_local();
  if (!my.s_addr)
    error("Cannot determine your hostname, try again!\n");

  printf("[1;35mPing Analysis Tool II by [5mMixter[0m\n\n");
  printf("[0;35m\tLogfile     : %s[0m\n", logfile);
  printf("[0;35m\tLocal IP    : %s[0m\n", inet_ntoa(my));
  printf("[0;35m\tDelay in ms : %d[0m\n", delay);

  if (mkay == 2)
    {
      printf("[0;35m\tStart block : %s[0m\n", ip1);
      printf("[0;35m\tEnd block   : %s[0m\n", ip2);
      sip1.s_addr = inet_addr(ip1);
      sip2.s_addr = inet_addr(ip2);
    }
  else if (mkay == 3)
    {
      printf("[0;35m\tInput file  : %s[0m\n", hostfile);
      instream = fopen(hostfile, "r");
      if (!instream)
	error("Cannot open your input file!\n");
    }
  signal(SIGHUP, SIG_IGN);
  signal(SIGTERM, SIG_IGN);
  signal(SIGCHLD, SIG_IGN);

  switch (eleet = fork())	/* fork iz eleet ! */
    {
    case 0:
      break;
    default:
      printf("\n[0;35mGoing into background (pid %d)...[0m\n", eleet);
      exit(-1);
    }

  switch (eleet = fork())	/* fork iz eleet ! */
    {
    case 0:
      sleep (1);
      break;
    default:
      lawg(logfile);
    }

  sawcket = socket(AF_INET, SOCK_RAW, IPPROTO_RAW);
  setsockopt(sawcket, IPPROTO_IP, IP_HDRINCL, "1", sizeof("1"));

  if (mkay == 2)
    while (strcmp(ip1, ip2) != 0)
      {
	incip(ip1);
	icmp(inet_addr(ip1));
	usleep(delay);
      }
  else if (mkay == 3)
    while (fgets(ip1, 512, instream) != NULL)
      {
	ip1[strlen(ip1) - 1] = '\0';
	icmp(inet_addr(ip1));
	usleep(delay);
      }

  kill(eleet, 9);
  return 0;
}

void
icmp(u_long subnet)
{
  struct ip *iph;
  struct icmp *icmph;
  char *packet;
  int pktsize = sizeof(struct ip) + sizeof(struct icmp) + 56;

  packet = malloc(pktsize);
  iph = (struct ip *) packet;
  icmph = (struct icmp *) (packet + sizeof(struct ip));

  memset(packet, 0, pktsize);
  iph->ver = 4;
  iph->ihl = 5;
  iph->tos = 0;
  iph->tl = htons(pktsize);
  iph->id = htons(getpid());
  iph->off = 0;
  iph->ttl = 0xff;
  iph->pro = IPPROTO_ICMP;
  iph->sum = 0;
  iph->src = my.s_addr;
  iph->dst = subnet;
  icmph->type = ICMP_ECHO;
  icmph->code = 0;
  icmph->sum = htons(~(ICMP_ECHO << 8));

  pothead.sin_addr.s_addr = subnet;
  sendto(sawcket, packet, pktsize, 0, (struct sockaddr *) &pothead, sizeof(struct sockaddr));

  free(packet);
}

void
lawg(char *file)
{
  char buf[8192];
  struct ip *iph = (struct ip *) buf;
  struct icmp *icmph = (struct icmp *) (buf + sizeof(struct ip));
  int lsock, i;
  struct in_addr pinger;
  FILE *f = fopen(file, "a");

  if (geteuid())
    exit(-1);
  lsock = socket(AF_INET, SOCK_RAW, 1);

  signal(SIGHUP, SIG_IGN);
  signal(SIGTERM, SIG_IGN);
  signal(SIGCHLD, SIG_IGN);

  while (1)
    {
      i = read(lsock, buf, 8192);
      if ((i) && (iph->pro == 1) && (icmph->type == 0))
	{
	  pinger.s_addr = iph->src;
	  fprintf(f, "%s\n", inet_ntoa(pinger));
          fflush(f);
	}
    }
}

unsigned int
inet_local(void)
{
  int fd, rfd = socket(PF_INET, SOCK_PACKET, htons(0x0003));
  int one = 1, myport = getrandom(0, 65535), pid = 0, i = 0;
  unsigned int myhost = getrandom(0, 65535) + (getrandom(0, 65535) << 8);
  char packet[8192];
  struct sockaddr_in s;
  struct ip *ih = (struct ip *) (packet + 14);
  struct tcp *th = (struct tcp *) (packet + 34);

  if (!(pid = fork()))
    {
      fd = socket(AF_INET, SOCK_STREAM, 0);
      s.sin_family = AF_INET;
      s.sin_port = htons(myport);
      s.sin_addr.s_addr = myhost;
      sleep(1);
      alarm(30);
      (void) connect(fd, (struct sockaddr *) &s, sizeof(s));
      close(fd);
      sleep(1);
      exit(0);
      raise(9);
    }

  for (i = 0; i < 100; i++)
    {
      memset(packet, 0, 8192);
      if ((one = read(rfd, packet, 8192)) > 0)
	{
	  if ((myhost == ih->dst) && (myport == ntohs(th->dst)))
	    {
	      kill(pid, 9);
	      return ih->src;
	    }
	}
    }

  sleep (1);
  kill(pid, 9);
  return 0;
}
