/*      pot.c - ping observation tool / ping sender
   (c) Jul 10 1999 by Mixter

  $$$$$$$$$$      O ( w3rd 1 th33nk my br41n )
 | (@)  (@) |   O   ( 1z g0n3 3y3 n33d t3w   )
 |    o     | o     ( sk4n ph0r br04dk45t2   )
  (        )
   ( ---- )
    \____/      <--- w33d sm0k1n p4ck3t l4m4h
 */

#include "pot.h"

u_long myip;			/* network byte order me */
int sawcket;
struct sockaddr_in pothead;

void icmp (u_long);

int
main (int argc, char **argv)
{
  FILE *sh3llz = popen ("./ip", "r");
  int eleet, delay = 100;
  char blah[123], ip1[123], ip2[123];
  struct in_addr sip1, sip2;

  fgets (blah, 120, sh3llz);
  pclose (sh3llz);

  blah[strlen (blah) - 1] = '\0';	/* thanks YounGoat */
  if (!validip (blah))
    error ("ERROR finding your hostname\n");
  if (argc < 4)
    error ("usage: pot <logfile> <start ip> <end ip> [delay in ms]\n");
  if (argc == 5)
    delay = atoi (argv[4]);
  strncpy (ip1, argv[2], 120);
  strncpy (ip2, argv[3], 120);
  if (!truncip (ip1, 0))
    error ("INVALID start block\n");
  if (!truncip (ip2, 255))
    error ("INVALID end block\n");
  printf ("[1;35mPing Observation Tool by [5mMixter[0m\n\n");
  printf ("[0;35m\tLogfile     : %s[0m\n", argv[1]);
  printf ("[0;35m\tLocal IP    : %s[0m\n", blah);
  printf ("[0;35m\tDelay in ms : %d[0m\n", delay);
  printf ("[0;35m\tStart block : %s[0m\n", ip1);
  printf ("[0;35m\tEnd block   : %s[0m\n", ip2);
  sip1.s_addr = inet_addr (ip1);
  sip2.s_addr = inet_addr (ip2);

  myip = inet_addr (blah);

  switch (eleet = fork ())	/* fork iz eleet ! */
    {
    case 0:
      break;
    default:
      printf ("\n[0;35mMake sure '420' is recording the pings.[0m\n");
      printf ("[0;35mGoing into background (pid %d)...[0m\n", eleet);
      exit (-1);
    }

  snprintf (blah, 120, "./420 >> %s &", argv[1]);
  system (blah);

  sawcket = socket (AF_INET, SOCK_RAW, IPPROTO_RAW);
  setsockopt (sawcket, IPPROTO_IP, IP_HDRINCL, "1", sizeof ("1"));
  pothead.sin_port = htons (0);
  pothead.sin_family = AF_INET;
  pothead.sin_addr.s_addr = htonl (myip);

  while (strcmp (ip1, ip2) != 0)
    {
      incip (ip1);
      icmp (inet_addr (ip1));
      truncip (ip1, 1);
      icmp (inet_addr (ip1));
      usleep (delay);
    }

  system ("killall -q -9 420");
  return 0;
}

void
icmp (u_long subnet)
{
  struct iphdr *ip;
  struct icmphdr *icmp;
  char *packet;
  int pktsize = sizeof (struct iphdr) + sizeof (struct icmphdr) + 64;
  packet = malloc (pktsize);
  ip = (struct iphdr *) packet;
  icmp = (struct icmphdr *) (packet + sizeof (struct iphdr));
  memset (packet, 0, pktsize);
  ip->version = 4;
  ip->ihl = 5;
  ip->tos = 0;
  ip->tot_len = htons (pktsize);
  ip->id = htons (getpid ());
  ip->frag_off = 0;
  ip->ttl = 0xff;
  ip->protocol = IPPROTO_ICMP;
  ip->check = 0;
  ip->saddr = myip;
  ip->daddr = subnet;
  icmp->type = ICMP_ECHO;
  icmp->code = 0;
  icmp->checksum = htons (~(ICMP_ECHO << 8));
  sendto (sawcket, packet, pktsize, 0, (struct sockaddr *) &pothead, sizeof (struct sockaddr));
  free (packet);
}
