#ifndef POT_H
#define POT_H

#define __FAVOR_BSD
#include <signal.h>
#include <stdio.h>
#include <netdb.h>
#include <string.h>
#include <stdlib.h>
#include <unistd.h>
#include <fcntl.h>
#include <signal.h>
#include <sys/socket.h>
#include <sys/types.h>
#include <sys/time.h>
#include <netinet/in.h>
#include <netinet/ip.h>
#include <netinet/ip_icmp.h>
#include <netinet/udp.h>
#include <netinet/tcp.h>
#include <arpa/inet.h>

#define getrandom(min, max) ((rand() % (int)(((max)+1) - (min))) + (min))

struct smurf_t
{
    struct sockaddr_in sin;
    int s;
    int udp, icmp;
    int rnd;
    int psize;
    int num;
    int delay;
    u_short dstport[25+1];
    u_short srcport;
    char *padding;
};

u_short cksum (u_short *, int);

int
validip (char *ip)
{
  int a, b, c, d, *x;
  sscanf (ip, "%d.%d.%d.%d", &a, &b, &c, &d);
  x = &a;
  if (*x < 0)
    return 0;
  if (*x > 255)
    return 0;
  x = &b;
  if (*x < 0)
    return 0;
  if (*x > 255)
    return 0;
  x = &c;
  if (*x < 0)
    return 0;
  if (*x > 255)
    return 0;
  x = &d;
  if (*x < 0)
    return 0;
  if (*x > 255)
    return 0;
  sprintf (ip, "%d.%d.%d.%d", a, b, c, d);
  return 1;
}

int
truncip (char *ip, int how)
{
  int a, b, c, d, *x;
  sscanf (ip, "%d.%d.%d.%d", &a, &b, &c, &d);
  x = &a;
  if (*x < 0)
    return 0;
  if (*x > 255)
    return 0;
  x = &b;
  if (*x < 0)
    return 0;
  if (*x > 255)
    return 0;
  x = &c;
  if (*x < 0)
    return 0;
  if (*x > 255)
    return 0;
  x = &d;
  if (*x < 0)
    return 0;
  if (*x > 255)
    return 0;
  if (how == 0)
    sprintf (ip, "%d.%d.%d.0", a, b, c);
  else
    sprintf (ip, "%d.%d.%d.255", a, b, c);

  return 1;
}

int
incip (char *ip)
{
  int a, b, c, d;
  sscanf (ip, "%d.%d.%d.%d", &a, &b, &c, &d);

  c++;

  if (a >= 255) exit(-1);
  if (b >= 255) { b = 0; a++; }
  if (c >= 255) { c = 0; b++; }

  sprintf (ip, "%d.%d.%d.0", a, b, c);

  return 1;
}

u_short
cksum (u_short * buf, int nwords)
{
  unsigned long sum;
  for (sum = 0; nwords > 0; nwords--)
    sum += *buf++;
  sum = (sum >> 16) + (sum & 0xffff);
  sum += (sum >> 16);
  return ~sum;
}

void error (char *huh)
{
fprintf(stderr,huh);
fflush(stderr);
exit(1);
}

#endif
