/*
 * SpiderNet - remote host-based intrusion detection
 * 12/99 by Mixter <mixter@newyorkoffice.com>
 *
 * nic.c - perform simple promiscuous mode test on network interfaces
 * 
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 */
 
#include "spider.h"
#include <sys/stat.h>
#include <sys/socket.h>
#include <sys/ioctl.h>
#include <net/if.h>

#ifndef SIOCGIFFLAGS
#include <stropts.h>
#include <sys/sockio.h>
#endif

void fatal (char *);

int
SpiderNICTest (void)
{
  char buf[8192];
  char *cp, *cplim;
  struct ifreq ifreq, *ifr;
  struct ifconf ifcnf;
  int head = 0, device_got_flags = 0;

  if ((head = socket (PF_INET, SOCK_DGRAM, 0)) < 0)
    fatal ("cannot perform network interface test");

  ifcnf.ifc_len = 8191;
  ifcnf.ifc_buf = buf;

  if (ioctl (head, SIOCGIFCONF, (char *) &ifcnf) < 0)
    fatal ("cannot perform network interface test");

  ifr = ifcnf.ifc_req;
  cplim = buf + ifcnf.ifc_len;
  for (cp = buf; cp < cplim; cp += sizeof (ifr->ifr_name) + sizeof (ifr->ifr_addr))
    {
      ifr = (struct ifreq *) cp;
      ifreq = *ifr;
      ioctl (head, SIOCGIFFLAGS, (char *) &ifreq);
      device_got_flags = 0;
      device_got_flags = ifreq.ifr_flags;
      if ((device_got_flags & IFF_PROMISC) != 0)
	return 1;
    }

  if (head)
    close (head);

  return 0;
}
