/*
 * SpiderNet - remote host-based intrusion detection
 * 12/99 by Mixter <mixter@newyorkoffice.com>
 *
 * spider.h - default configuration, includes & prototypes
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 */

/* USER DEFINABLE VALUES, PLEASE CUSTOMIZE */

#define EMAIL_NOTIFY    "root"		/* IF you define this, alerts/warnings
                                        will be issued to this email address */
#define SPIDER_PORT     1250		/* tcp port for spiderd to listen to */
#define TCB		"/etc/tcb.conf"		/* config file for spiderd's */
#define SPIDER		"/etc/spidermon.conf"	/* config file for spidermon */
#define MAX_HOSTS       250		/* max hosts to monitor */
#define MIN_TIME        60		/* time in seconds to re-check hosts */

/* end of user definable values */

#include <stdio.h>
#include <unistd.h>
#include <stdlib.h>
#include <syslog.h>
#include <string.h>
#include <netdb.h>
#include <time.h>
#include <signal.h>
#include <errno.h>
#include <sys/socket.h>
#include <netinet/in.h>
#include <arpa/inet.h>

#define SVER	"1.2"

#define MD      5
#include "md5/global.h"
#include "md5/md5.h"

void TrimBuf (char *);
unsigned long resolve (char *);
void log (char *, char *);
char *ntoa (unsigned long);
int SpiderNICTest (void);
