/*
 * SpiderNet - remote host-based intrusion detection
 * 12/99 by Mixter <mixter@newyorkoffice.com>
 *
 * spiderd.c - host-based file/network monitoring daemon
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 */

#include "spider.h"
#include "aes.h"

void FileAddMd5 (const char *, FILE *);
char *MyMd5File (const char *filename);
int SpiderDaemon ();
void fatal (char *);
void usage (char *);

char sum[35];

int
main (int argc, char **argv)
{
  char buf[512], cbuf[512], *tempfile = NULL;
  unsigned long loghost = 0;
  int opt = 0, daemon = 0, ethcheck = 1, output = 1;
  FILE *temp = NULL, *conf;

  while ((opt = getopt (argc, argv, "isn")) != EOF)
    switch (opt)
      {
      case 'i':
	fprintf (stderr, "Add this line to %s on your log host running spidermon:\n", SPIDER);
	daemon = -1;
	break;
      case 's':
	fprintf (stderr, "spidernet daemon v%s starting\n", SVER);
	signal (SIGCHLD, SIG_IGN);
	daemon++;
	break;
      case 'n':
	ethcheck--;
	break;
      default:
	usage (argv[0]);
      }

  if (daemon > 0)
    if (fork ())
      exit (0);

  if (daemon > 0)
    output = SpiderDaemon ();

  if ((conf = fopen (TCB, "r")) == NULL)
    fatal ("unable to open files");

  tempfile = tmpnam (NULL);
  temp = fopen (tempfile, "w");

  while (fgets (buf, 512, conf) != NULL)
    {
      if (buf[0] == '#')
	continue;
      if (buf[0] == '\n')
	continue;
      if (buf[0] == '\r')
	continue;
      TrimBuf (buf);
      if (buf[0] == '@')
	loghost = resolve (buf + 1);
      else
	FileAddMd5 (buf, temp);
      memset (buf, 0, 512);
    }

  fclose (temp);

  if (daemon < 0)
    {
      gethostname (cbuf, 500);
      fprintf (stderr, "%s %s\n", cbuf, MyMd5File (tempfile));
      exit (0);
    }

  if (loghost)
    {
      struct sockaddr_in sin;
      int namelen = sizeof (sin);
      if (getpeername (output, (struct sockaddr *) &sin, &namelen) < 0)
	{
	  sprintf (buf, "getpeername: %s", strerror (errno));
	  fatal (buf);
	}
      if (sin.sin_addr.s_addr != loghost)
	{
	  sprintf (buf, "unauthorized connection from host %s\n", ntoa (sin.sin_addr.s_addr));
	  close (output);
	  fatal (buf);
	}
    }

  if (ethcheck)
    sprintf (buf, "%ld\n%d\n%s\n", time (NULL), SpiderNICTest (), MyMd5File (tempfile));
  else
    sprintf (buf, "%ld\n%d\n%s\n", time (NULL), 0, MyMd5File (tempfile));

  aes_setkey (MyMd5File (tempfile));
  encode64 (buf, cbuf, strlen (buf));
  write (output, cbuf, strlen (cbuf));

  unlink (tempfile);
  return 0;
}

void
fatal (char *reason)
{
  log ("spiderd", reason);
  exit (0);
}

void
usage (char *arg)
{
  fprintf (stderr, "usage: %s [-n] [-s] [-i]\n", arg);
  fprintf (stderr, "\t-i: print configuration line for loghost\n");
  fprintf (stderr, "\t-n: do not perform promisc detection\n");
  fprintf (stderr, "\t-s: standalone daemon (default: inetd mode)\n");
  exit (0);
}

void
FileAddMd5 (const char *filename, FILE * temp)
{
  FILE *file;
  MD5_CTX context;
  int len, i;
  unsigned char buffer[1024], digest[16];
  if ((file = fopen (filename, "rb")) == NULL)
    return;
  MD5Init (&context);
  while ((len = fread (buffer, 1, 1024, file)))
    MD5Update (&context, buffer, len);
  MD5Final (digest, &context);

  fclose (file);
  for (i = 0; i < 16; i++)
    fprintf (temp, "%02x", digest[i]);
  fprintf (temp, " ");
}

char *
MyMd5File (const char *filename)
{
  FILE *file;
  MD5_CTX context;
  int len, i;
  unsigned char buffer[1024], digest[16];
  char *p = sum;
  if ((file = fopen (filename, "rb")) == NULL)
    return "ERROR";

  MD5Init (&context);
  while ((len = fread (buffer, 1, 1024, file)))
    MD5Update (&context, buffer, len);
  MD5Final (digest, &context);

  fclose (file);

  for (i = 0; i < 16; i++)
    {
      sprintf (p, "%02x", digest[i]);
      p += 2;
    }

  return sum;
}

int
SpiderDaemon (void)
{
  int s = socket (AF_INET, SOCK_STREAM, 0), a, addrlen;
  struct sockaddr_in sin;

  sin.sin_family = AF_INET;
  sin.sin_port = htons (SPIDER_PORT);
  sin.sin_addr.s_addr = INADDR_ANY;
  addrlen = sizeof (sin);

  if (bind (s, (struct sockaddr *) &sin, sizeof (struct sockaddr)) < 0)
      fatal ("unable to bind to designated port");

  (void) listen (s, 1);

accept_loop:

  while ((a = accept (s, (struct sockaddr *) &sin, &addrlen)) >= 0)
    {
      if (fork ())
	continue;
      else
	return a;
    }

  /* Without this, daemon could be brought down by syn/rst flooding */
  if (errno == ECONNRESET)
    goto accept_loop;

  fatal ("socket error");
  return -1;
}
