/*
 * SpiderNet - remote host-based intrusion detection
 * 12/99 by Mixter <mixter@newyorkoffice.com>
 *
 * util.c - misc. stuff
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 */

#include "spider.h"

char *
ntoa (unsigned long ip)
{
  struct in_addr in;
  in.s_addr = ip;
  return (inet_ntoa (in));
}

unsigned long
resolve (char *host)
{
  struct hostent *he;
  unsigned long tmp = 0;
  if (inet_addr (host) != -1)
    return (inet_addr (host));

  he = gethostbyname (host);
  if (he)
    memcpy (&tmp, he->h_addr, 4);
  else
    return (0);
  return (tmp);
}

void
TrimBuf (char *buf)
{
  int i = 0;
  for (i = 0; i < strlen (buf); i++)
    if ((buf[i] == '\n') || (buf[i] == '\r'))
      buf[i] = '\0';
}

void
log (char *ident, char *msg)
{
  openlog (ident, LOG_PID, LOG_AUTH);
  syslog (LOG_ALERT, msg);
  closelog ();
}
