/*
 *  $Id: libipg_init.c,v 1.2 2003/12/31 20:18:51 mike Exp $
 *
 *  libipgeo
 *  libipgeo_init.c - initilization routines
 *
 *  Copyright (c) 1998 - 2005 Mike D. Schiffman <stolencreditcard@gmail.com>
 *  All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 *
 * THIS SOFTWARE IS PROVIDED BY THE AUTHOR AND CONTRIBUTORS ``AS IS'' AND
 * ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
 * ARE DISCLAIMED.  IN NO EVENT SHALL THE AUTHOR OR CONTRIBUTORS BE LIABLE
 * FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
 * DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS
 * OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
 * HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT
 * LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY
 * OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF
 * SUCH DAMAGE.
 *
 */

/**
 * @file libipgeo_init.c
 * @ingroup sourcefiles
 * 
 * @author Mike Schiffman 
 *
 * @brief ipgeo initialization routines
 */

#if (HAVE_CONFIG_H)
#include "../include/config.h"
#endif

#include "./libipgeo.h"

ipgeo_t *
ipgeo_init(char *file, u_int8_t flags, char *err_buf)
{
    ipgeo_t *ipg = NULL;

    ipg = (ipgeo_t *)malloc(sizeof (ipgeo_t));
    if (ipg == NULL)
    {
        snprintf(err_buf, IPGEO_ERRBUF_SIZE, "malloc(): %s\n", strerror(errno));
        goto bad;
    }

    memset(ipg, 0, sizeof (ipg));

    ipg->db = fopen(file, "r");
    if (ipg->db == NULL)
    {
        snprintf(err_buf, IPGEO_ERRBUF_SIZE, "fopen() (%s): %s\n", file, 
                strerror(errno));
        goto bad;
    }

    /** only CSV db type currently supported */
    ipg->dbt = 6;

    /** control flags are currently undefined */
    ipg->flags = flags;

    return (ipg);

bad:
    if (ipg)
    {
        if (ipg->db)
        {
            fclose(ipg->db);
        }
        free (ipg);
    }
    return (NULL);
}

void
ipgeo_destroy(ipgeo_t *ipg)
{
    if (ipg)
    {
        if (ipg->db)
        {
            fclose(ipg->db);
        }
        free (ipg);
    }
}

char *
ipgeo_geterror(ipgeo_t *ipg)
{
    return (ipg->err_buf);
}

int
ipgeo_getdbt(ipgeo_t *ipg)
{
    if (ipg == NULL || ipg->db == NULL)
    {
        return (-1);
    }
    return (ipg->dbt);
}

u_int32_t
ipgeo_getcomps(ipgeo_t *ipg)
{
    return (ipg->comparisons);
}

int
ipgeo_getfd(ipgeo_t *ipg)
{
    if (ipg == NULL || ipg->db == NULL)
    {
        return (-1);
    }

    /**
     * we should not return -1 here since any error should be caught during
     * initialization
     */ 
    return (fileno(ipg->db));
}

/* EOF */
